/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.alloc.input.AllocDataParameter;

public abstract class AllocFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -547462364191130911L;
    private static final int MAP_INITIAL_CAPACITY = 16;
    protected AllocDataParameter para;
    protected RowMeta resultMeta = null;

    public void setPara(AllocDataParameter para) {
        this.para = para;
    }

    public void setResultRowMeta(RowMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public RowMeta getResultRowMeta() {
        if (this.resultMeta != null) {
            return this.resultMeta;
        }
        return this.getRowMeta();
    }

    public RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("id", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("costcenter", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType), new Field("expenseitem", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("amount", (DataType)DataType.BigDecimalType), new Field("amtprecision", (DataType)DataType.IntegerType)};
        return new RowMeta(fields);
    }

    public void reduce(Iterable<RowX> arg0, Collector collector) {
        for (RowX rowX : arg0) {
            this.doAlloc(rowX, collector);
        }
    }

    public abstract void doAlloc(RowX var1, Collector var2);

    /*
     * WARNING - void declaration
     */
    private void doMfgAlloc(RowX rowX) {
        BigDecimal totalAmt = rowX.getBigDecimal(7);
        int precision = rowX.getInteger(8);
        Long costdriverId = 0L;
        Set<Object> costcenterScope = new HashSet<String>();
        if (this.para.getCollDataMap() != null) {
            Map<Long, Set<String>> allocStdScopeMap = this.para.getCollDataMap().get(rowX.get(0));
            if (allocStdScopeMap == null) {
                return;
            }
            for (Map.Entry<Long, Set<String>> entry : allocStdScopeMap.entrySet()) {
                costdriverId = entry.getKey();
                Set<String> value = entry.getValue();
                if (value == null) continue;
                costcenterScope = value;
            }
        }
        if (this.para.getCollSocpeMap().get(rowX.get(0)) != null) {
            for (String costCenterId : this.para.getCollSocpeMap().get(rowX.get(0))) {
                costcenterScope.add(costCenterId);
            }
        }
        Map<String, BigDecimal> allocStdValueMap = null;
        HashMap effectAllocStdValueMap = new HashMap();
        BigDecimal totalValue = BigDecimal.ZERO;
        if (this.para.getAllocStdValueColls() != null && this.para.getAllocStdValueColls().size() > 0 && this.para.getAllocStdValueColls().containsKey(costdriverId.toString())) {
            allocStdValueMap = this.para.getAllocStdValueColls().get(costdriverId.toString());
            for (Map.Entry entry : allocStdValueMap.entrySet()) {
                String[] keyinfos = ((String)entry.getKey()).split("@");
                if (costcenterScope.size() >= 1) {
                    if (!costcenterScope.contains(keyinfos[1])) continue;
                    totalValue = totalValue.add((BigDecimal)entry.getValue());
                    effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                totalValue = totalValue.add((BigDecimal)entry.getValue());
                effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
            }
        }
        BigDecimal allocTotalAmt = BigDecimal.ZERO;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Long maxCostCenterId = 0L;
        HashMap<Long, BigDecimal> allocRsMap = new HashMap<Long, BigDecimal>(16);
        HashMap allocValuesMap = new HashMap(16);
        if (effectAllocStdValueMap.size() < 1) {
            return;
        }
        for (Map.Entry entry : effectAllocStdValueMap.entrySet()) {
            void var10_12;
            String[] orgAndcostCenter = ((String)entry.getKey()).split("@");
            if (var10_12.compareTo((BigDecimal)entry.getValue()) < 0) {
                BigDecimal bigDecimal2 = (BigDecimal)entry.getValue();
                maxCostCenterId = Long.valueOf(orgAndcostCenter[1]);
            }
            BigDecimal allocAmt = totalAmt.multiply((BigDecimal)entry.getValue()).divide(totalValue, precision, 4);
            allocTotalAmt = allocTotalAmt.add(allocAmt);
            allocRsMap.put(Long.valueOf(orgAndcostCenter[1]), allocAmt);
            allocValuesMap.put(Long.valueOf(orgAndcostCenter[1]), entry.getValue());
        }
        BigDecimal diffAmt = totalAmt.subtract(allocTotalAmt);
        if (diffAmt.abs().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal currAllocAmt = (BigDecimal)allocRsMap.get(maxCostCenterId);
            allocRsMap.put(maxCostCenterId, currAllocAmt.add(diffAmt));
        }
        DynamicObject allocData = BusinessDataServiceHelper.loadSingle((Object)rowX.getLong(0), (String)"sca_mfgfeealloc");
        allocData.set("costdriver", (Object)costdriverId);
        this.setBaseUnit(allocData, costdriverId);
        allocData.set("allocstatus", (Object)this.para.getAllocStatus());
        allocData.set("alloctype", (Object)1);
        allocData.set("usetype", (Object)1);
        allocData.set("alloctime", (Object)new Date());
        allocData.set("allocor", (Object)this.para.getAllocor());
        DynamicObjectCollection entrys = allocData.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 0;
        for (Map.Entry allocRsMapEntry : allocRsMap.entrySet()) {
            DynamicObject entry = entrys.addNew();
            entry.set("seq", (Object)seq);
            entry.set("subelement", rowX.get(6));
            entry.set("element", rowX.get(9));
            entry.set("benefcostcenter", allocRsMapEntry.getKey());
            entry.set("allocamt", allocRsMapEntry.getValue());
            entry.set("allocvalue", allocValuesMap.get(allocRsMapEntry.getKey()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocData});
    }

    private void setBaseUnit(DynamicObject allocData, Object costdriverId) {
        DynamicObject costDriver = BusinessDataServiceHelper.loadSingle((Object)costdriverId, (String)"cad_costdriver");
        allocData.set("baseunit", costDriver.getDynamicObject("unit").getPkValue());
    }
}

