/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.utils.DatSetXUtils;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectCalculateFunction
extends GroupReduceFunction {
    protected static final Log logger = LogFactory.getLog(CostObjectCalculateFunction.class);
    private static final long serialVersionUID = 1L;
    private static final String MAT_QUOTA_Id = "1554353182669544448";
    private static final String OPERATOR = "+-*/()";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String MATERIAL = "MATERIAL";
    private static final String DIGITAL = "DIGITAL";
    private static final String ENTITY_DIYCOSTDRIVER = "sca_diycostdriver";
    private static final String FIRST_MUL_VALUE = "(case when (firstValue * value) != null then (firstValue * value) else 0 end) as value";
    private static final String FIRST_DIV_VALUE = "(case when value != 0 and (firstValue / value) != null then (firstValue / value) else 0 end) as value";
    private static final String DIV_VALUE = "(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;
    private boolean isMatGroupCal = true;

    public CostObjectCalculateFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, null, this.rowMeta);
        List postfixExp = (List)this.paramMap.get("exp");
        boolean isMaterialGroup = (Boolean)this.paramMap.get("isMaterialGroup");
        List materialGroup = (List)this.paramMap.get("materialGroup");
        List materials = (List)this.paramMap.get("material");
        long orgId = (Long)this.paramMap.get("orgId");
        long costAccountId = (Long)this.paramMap.get("costAccountId");
        long periodId = (Long)this.paramMap.get("periodId");
        String appId = (String)this.paramMap.get("appId");
        long simulCostTypeId = this.paramMap.get("simulCostTypeId") == null ? 0L : (Long)this.paramMap.get("simulCostTypeId");
        boolean isConSiAux = (Boolean)this.paramMap.get("isConSiAux");
        Stack<DataSet> opDsStack = new Stack<DataSet>();
        Stack opTypeAndNumberStack = new Stack();
        DataSet opResult = null;
        for (String number : postfixExp) {
            ArrayList<QFilter> filters;
            DataSet diyCostDriverDs;
            if (OPERATOR.indexOf(number) >= 0) {
                String firstType = "";
                String secondType = "";
                if (opDsStack.size() < 2) {
                    return;
                }
                DataSet secondDs = (DataSet)opDsStack.pop();
                Map secondTypeMap = (Map)opTypeAndNumberStack.pop();
                double secondValue = 0.0;
                for (Map.Entry entry : secondTypeMap.entrySet()) {
                    secondType = (String)entry.getKey();
                    secondValue = (Double)entry.getValue();
                }
                DataSet firstDs = (DataSet)opDsStack.pop();
                Map firstTypeMap = (Map)opTypeAndNumberStack.pop();
                double firstValue = 0.0;
                for (Map.Entry entry : firstTypeMap.entrySet()) {
                    firstType = (String)entry.getKey();
                    firstValue = (Double)entry.getValue();
                    switch (firstType) {
                        case "COSTCENTER": {
                            firstDs = firstDs.executeSql("select org,costcenter,benefcostcenter,value as firstValue");
                            break;
                        }
                        case "COSTOBJECT": {
                            firstDs = firstDs.executeSql("select org,costcenter,costobject,materialgroup,material,materialauxpty,submaterial,value as firstValue");
                            break;
                        }
                        case "MATERIAL": {
                            firstDs = firstDs.executeSql("select org,costcenter,material,materialauxpty,submaterial,value as firstValue");
                            break;
                        }
                        case "MATERIALGROUP": {
                            firstDs = firstDs.executeSql("select org,materialgroup,value as firstValue");
                            break;
                        }
                    }
                }
                Map<Object, Object> opResultTypeMap = new HashMap(16);
                block18 : switch (number) {
                    case "+": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = CostObjectCalculateFunction.doAddOnCostCenter(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break block18;
                            }
                            case "COSTOBJECT": {
                                opResult = CostObjectCalculateFunction.doAddOnCostObject(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break block18;
                            }
                            case "MATERIAL": {
                                opResult = CostObjectCalculateFunction.doAddOnMaterial(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break block18;
                            }
                        }
                        break;
                    }
                    case "-": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = CostObjectCalculateFunction.doSubtractOnCostCenter(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break block18;
                            }
                            case "COSTOBJECT": {
                                opResult = CostObjectCalculateFunction.doSubtractOnCostObject(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break block18;
                            }
                            case "MATERIAL": {
                                opResult = CostObjectCalculateFunction.doSubtractOnMaterial(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break block18;
                            }
                        }
                        break;
                    }
                    case "*": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnCostCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                    break block18;
                                }
                                case "COSTOBJECT": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnCostObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                    break block18;
                                }
                                case "MATERIAL": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                    break block18;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToCenter(secondDs, firstDs, true);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostCenter(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToCenter(firstDs, secondDs, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (MATERIALGROUP.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToMaterialGroup(firstDs, secondDs, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostObject(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToMaterial(secondDs, firstDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break;
                            }
                            case "MATERIALGROUP": {
                                if (!COSTOBJECT.equals(secondType)) break;
                                opResult = this.doMulOnCostObjectToMaterialGroup(secondDs, firstDs, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "DIGITAL": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostCenter(secondDs, firstValue, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                }
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostObject(secondDs, firstValue, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!MATERIAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(secondDs, firstValue, false);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break;
                            }
                        }
                        break;
                    }
                    case "/": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = CostObjectCalculateFunction.doDivideOnCostCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                    break block18;
                                }
                                case "COSTOBJECT": {
                                    opResult = CostObjectCalculateFunction.doDivisideOnCostObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                    break block18;
                                }
                                case "MATERIAL": {
                                    opResult = CostObjectCalculateFunction.doDivisideOnMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                    break block18;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostCenterToObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToCostCenter(firstDs, secondValue);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToMaterial(firstDs, secondDs, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (DIGITAL.equals(secondType)) {
                                    opResult = this.doDivideOnDigToCostObject(firstDs, secondValue);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!MATERIALGROUP.equals(secondType)) break;
                                opResult = this.doDivOnCostObjectToMaterialGroup(firstDs, secondDs, false);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToMaterial(secondDs, firstDs, true);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToMaterial(firstDs, secondValue);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break;
                            }
                            case "MATERIALGROUP": {
                                if (!COSTOBJECT.equals(secondType)) break;
                                opResult = this.doDivOnCostObjectToMaterialGroup(secondDs, firstDs, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                        }
                        break;
                    }
                }
                if (opResult == null) continue;
                opDsStack.push(opResult);
                opTypeAndNumberStack.add(opResultTypeMap);
                continue;
            }
            Map<String, Double> typeMap = new HashMap<String, Double>(16);
            String algoKey = "kd.macc.aca.algox.alloc.function.CostObjectCalculateFunction.reduce";
            if (String.valueOf(CostDriverIdConstant.STANDARD_COST_ACA).equals(number)) {
                QFilter costTypeFilter = new QFilter("costtype", "in", (Object)simulCostTypeId);
                QFilter dateFilter = AcaMatAllocHelper.getEffectDateFilter(periodId);
                diyCostDriverDs = QueryServiceHelper.queryDataSet((String)"getmatcostinfo", (String)"cad_matcostinfo", (String)"material,auxpty as materialauxpty,entryentity.standardcost value", (QFilter[])new QFilter[]{costTypeFilter, dateFilter}, null);
                diyCostDriverDs = diyCostDriverDs.select(CostDriverIdConstant.STANDARD_COST_ACA + " as costdriver," + orgId + " as org,0L as costcenter,material,materialauxpty,0L as submaterial,value");
                typeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
            } else if (CostObjectCalculateFunction.isInteger(number) && materials.contains(number)) {
                if (MAT_QUOTA_Id.equals(number)) {
                    Object material;
                    Object costType = this.paramMap.get("costtype");
                    if (this.paramMap == null || (material = this.paramMap.get("subMat")) == null) continue;
                    Long matId = Long.parseLong(String.valueOf(material));
                    long auxptyId = 0L;
                    Object auxpty = this.paramMap.get("subAuxpty");
                    if (auxpty != null) {
                        auxptyId = Long.parseLong(String.valueOf(auxpty));
                    }
                    long costTypeId = 0L;
                    if (costType != null) {
                        costTypeId = Long.parseLong(String.valueOf(costType));
                    }
                    if (CadEmptyUtils.isEmpty((Long)costTypeId)) continue;
                    Date date = (Date)this.paramMap.get("enddate") == null ? new Date() : (Date)this.paramMap.get("enddate");
                    List<Object[]> dataTable = this.getBomDataTable(orgId, costTypeId, matId, auxptyId, isConSiAux, date);
                    diyCostDriverDs = this.createBomRsDs(algoKey, dataTable);
                    diyCostDriverDs = diyCostDriverDs.addFields(new String[]{"0L", String.valueOf(material)}, new String[]{"costcenter", "submaterial"});
                    typeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                } else {
                    filters = new ArrayList(10);
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    filters.add(orgFilter);
                    filters.add(new QFilter("appnum", "=", (Object)appId));
                    filters.add(new QFilter("costdriver.id", "=", (Object)Long.parseLong(number)));
                    filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                    filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                    filters.add(AcaMatAllocHelper.getEffectDateFilter(periodId));
                    diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,org,costcenter,entryentity.matnum as material,entryentity.matauxpty as materialauxpty,0L as submaterial,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
                    diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,costcenter,material,materialauxpty,submaterial,sum(value) value group by costdriver,org,costcenter,material,materialauxpty,submaterial");
                    typeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                }
            } else if (CostObjectCalculateFunction.isInteger(number) && materialGroup.contains(number)) {
                filters = new ArrayList<QFilter>(10);
                filters.add(new QFilter("org", "=", (Object)orgId));
                filters.add(new QFilter("appnum", "=", (Object)appId));
                filters.add(new QFilter("costdriver.id", "=", (Object)Long.parseLong(number)));
                filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                filters.add(AcaMatAllocHelper.getEffectDateFilter(periodId));
                diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,org,entryentity.materialgroup as materialgroup,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null).distinct();
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,materialgroup,sum(value) value group by costdriver,org,materialgroup");
                if (this.paramMap.get(number) != null) {
                    this.isMatGroupCal = (Boolean)this.paramMap.get(number);
                }
                typeMap = CostObjectCalculateFunction.buildResultType(MATERIALGROUP);
            } else {
                diyCostDriverDs = ds.copy().filter("costdriver = " + number);
                boolean isExist = false;
                if (CostObjectCalculateFunction.isInteger(number)) {
                    isExist = QueryServiceHelper.exists((String)"cad_costdriver", (Object)Long.parseLong(number));
                }
                if (isExist) {
                    QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(number));
                    DynamicObject costDriverObject = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"allocclass", (QFilter[])qFilter.toArray());
                    if (costDriverObject != null) {
                        String allocClass = costDriverObject.getString("allocclass");
                        typeMap = CostObjectCalculateFunction.buildResultType(allocClass);
                    }
                } else if (CostObjectCalculateFunction.isNumeric(number)) {
                    typeMap.put(DIGITAL, Double.parseDouble(number));
                }
            }
            opTypeAndNumberStack.push(typeMap);
            opDsStack.push(diyCostDriverDs);
        }
        if (opResult != null) {
            List<String> fieldNames = Arrays.asList(opResult.getRowMeta().getFieldNames());
            for (Row row : opResult) {
                RowX targetRow = new RowX(this.rowMeta.getFieldCount());
                targetRow.set(this.rowMeta.getFieldIndex("org"), row.get("org"));
                targetRow.set(this.rowMeta.getFieldIndex("costcenter"), row.get("costcenter"));
                targetRow.set(this.rowMeta.getFieldIndex("costobject"), row.get("costobject"));
                targetRow.set(this.rowMeta.getFieldIndex("materialgroup"), isMaterialGroup ? row.get("materialgroup") : Long.valueOf(0L));
                targetRow.set(this.rowMeta.getFieldIndex("material"), row.get("material"));
                Object subMaterial = 0L;
                if (fieldNames.contains("submaterial")) {
                    subMaterial = row.get("submaterial");
                }
                targetRow.set(this.rowMeta.getFieldIndex("submaterial"), subMaterial);
                targetRow.set(this.rowMeta.getFieldIndex("value"), (Object)(row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value")));
                collector.collect(targetRow);
            }
        }
    }

    private DataSet createBomRsDs(String algoKey, List<Object[]> dataTable) {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(new Field("costdriver", (DataType)DataType.LongType));
        fields.add(new Field("org", (DataType)DataType.LongType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        fields.add(new Field("materialauxpty", (DataType)DataType.LongType));
        fields.add(new Field("value", (DataType)DataType.BigDecimalType));
        return Algo.create((String)algoKey).createDataSet(dataTable.iterator(), new RowMeta(fields.toArray(new Field[0])));
    }

    private List<Object[]> getBomDataTable(Long orgId, Long costTypeId, Long matId, Long auxptyId, Boolean isConSiAux, Date endDate) {
        Set<Long> bomIds = this.getBomIdScope(costTypeId);
        HashMap<String, BigDecimal> jumpMatQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, List<Object[]>> jumpMatUpLevelMap = new HashMap<String, List<Object[]>>(16);
        this.dealJumpLevelMatBom(orgId, costTypeId, bomIds, endDate, jumpMatQtyMap, jumpMatUpLevelMap, isConSiAux);
        ArrayList<Object[]> dataTable = new ArrayList<Object[]>();
        QFilter orgQfilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter entryMatQf = new QFilter("entry.entrymaterial", "=", (Object)matId);
        QFilter entryAuxptyQf = new QFilter("entry.entryauxproperty", "=", (Object)auxptyId);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        DataSet bomDs = QueryServiceHelper.queryDataSet((String)"getBomDataTable#1", (String)"cad_costbom", (String)"id,number,material,material.name matName,auxproperty auxpty,entry.entrymaterial subMaterialId,entry.entrymaterial.name subMatName,entry.entryauxproperty subauxpty,entry.entryqtynumerator fz,entry.entryqtydenominator fm,entry.entryfixscrap gdshl,entry.entryscraprate bdshl,entry.entryvaliddate effectDate,entry.entryinvaliddate validDate,entry.entryqtytype qtytype,entry.entryisjumplevel jumplevel", (QFilter[])new QFilter[]{orgQfilter, entryMatQf, entryAuxptyQf, enableQf, statusQf}, null);
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        for (Row bom : bomDs.copy()) {
            bomIdSet.add(bom.getLong("id"));
        }
        if (bomIdSet.isEmpty()) {
            return dataTable;
        }
        QFilter costTypeQFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter bomQFilter = new QFilter("bom", "in", bomIdSet);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DataSet bomSettingDs = QueryServiceHelper.queryDataSet((String)"getBomDataTable#2", (String)"cad_bomsetting", (String)"costtype,material,auxprop,bom,considersubmaterialloss subMatLoss,lossrateformula,considervalidperiod validPeriod", (QFilter[])new QFilter[]{costTypeQFilter, bomQFilter, qfStatus, qfEnable}, (String)"id desc");
        DataSet middleDs = bomSettingDs.join(bomDs, JoinType.INNER).on("bom", "id").select(new String[]{"costtype", "subMatLoss", "lossrateformula", "validPeriod"}, new String[]{"number", "material", "matName", "auxpty", "subMaterialId", "subMatName", "subauxpty", "fz", "fm", "gdshl", "bdshl", "effectDate", "validDate", "qtytype"}).finish();
        if (middleDs == null) {
            return dataTable;
        }
        for (Row row : middleDs) {
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty((Long)material)) continue;
            Long materialAuxpty = isConSiAux != false ? row.getLong("auxpty") : 0L;
            Boolean subMatLoss = row.getBoolean("subMatLoss");
            Boolean validPeriod = row.getBoolean("validPeriod");
            String lossRateFormula = row.getString("lossrateformula");
            Date effectDate = row.getDate("effectDate");
            Date validDate = row.getDate("validDate");
            String qtyType = row.getString("qtytype");
            BigDecimal fz = row.getBigDecimal("fz");
            BigDecimal fm = row.getBigDecimal("fm");
            BigDecimal gdshl = row.getBigDecimal("gdshl");
            BigDecimal bdshl = row.getBigDecimal("bdshl");
            if (BigDecimal.ZERO.compareTo(fm) == 0) continue;
            BigDecimal unitQty = fz.divide(fm, 10, 4);
            if (subMatLoss.booleanValue()) {
                if ("A".equals(qtyType)) {
                    unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(bdshl), 10, 4) : unitQty.multiply(BigDecimal.ONE.add(bdshl)).setScale(10, 4);
                } else if ("B".equals(qtyType)) {
                    unitQty = unitQty.add(gdshl);
                } else if ("C".equals(qtyType)) {
                    unitQty = unitQty.add(gdshl);
                }
            }
            if (validPeriod.booleanValue()) {
                boolean afterEffect = endDate.after(effectDate);
                boolean beforeValid = endDate.before(validDate);
                if (!afterEffect || !beforeValid) continue;
            }
            Object[] columns = new Object[]{MAT_QUOTA_Id, orgId, material, materialAuxpty, unitQty};
            String key = material + "@" + auxptyId;
            if (jumpMatQtyMap.containsKey(key)) {
                BigDecimal qty = jumpMatQtyMap.getOrDefault(key, BigDecimal.ZERO);
                this.getDataColumnsList(key, qty, jumpMatQtyMap, jumpMatUpLevelMap, dataTable);
                continue;
            }
            dataTable.add(columns);
        }
        return dataTable;
    }

    private void getDataColumnsList(String matKey, BigDecimal qty, Map<String, BigDecimal> jumpMatQtyMap, Map<String, List<Object[]>> jumpMatUpLevelMap, List<Object[]> results) {
        if (!jumpMatUpLevelMap.containsKey(matKey)) {
            return;
        }
        List<Object[]> upLevelMats = jumpMatUpLevelMap.get(matKey);
        if (upLevelMats == null) {
            return;
        }
        for (Object[] upLevelMat : upLevelMats) {
            if (CadEmptyUtils.isEmpty((Object[])upLevelMat)) continue;
            String key = upLevelMat[2] + "@" + upLevelMat[3];
            if (jumpMatQtyMap.containsKey(key)) {
                BigDecimal jumpQty = jumpMatQtyMap.getOrDefault(key, BigDecimal.ZERO);
                BigDecimal newQty = qty.multiply(jumpQty);
                this.getDataColumnsList(key, newQty, jumpMatQtyMap, jumpMatUpLevelMap, results);
                continue;
            }
            Object[] columns = (Object[])upLevelMat.clone();
            columns[4] = qty.multiply((BigDecimal)columns[4]);
            results.add(columns);
        }
    }

    private void dealJumpLevelMatBom(Long orgId, Long costTypeId, Set<Long> bomIds, Date endDate, Map<String, BigDecimal> jumpMatQtyMap, Map<String, List<Object[]>> jumpMatUpLevelMap, Boolean isConSiAux) {
        if (CadEmptyUtils.isEmpty(bomIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", bomIds);
        filter.and(new QFilter("entry.entryisjumplevel", "=", (Object)Boolean.TRUE));
        DataSet bomDs = QueryServiceHelper.queryDataSet((String)"dealJumpLevelMatBom#1", (String)"cad_costbom", (String)"id,material,auxproperty auxpty,entry.entrymaterial subMaterialId,entry.entryauxproperty subauxpty,entry.entryqtynumerator fz,entry.entryqtydenominator fm,entry.entryfixscrap gdshl,entry.entryscraprate bdshl,entry.entryvaliddate effectDate,entry.entryinvaliddate validDate,entry.entryqtytype qtytype", (QFilter[])new QFilter[]{filter}, null);
        QFilter costTypeQFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter bomQFilter = new QFilter("bom", "in", bomIds);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DataSet bomSettingDs = QueryServiceHelper.queryDataSet((String)"dealJumpLevelMatBom#2", (String)"cad_bomsetting", (String)"costtype,material,auxprop,bom,considersubmaterialloss subMatLoss,lossrateformula,considervalidperiod validPeriod", (QFilter[])new QFilter[]{costTypeQFilter, bomQFilter, qfStatus, qfEnable}, (String)"id desc");
        DataSet middleDs = bomSettingDs.join(bomDs, JoinType.INNER).on("bom", "id").select(new String[]{"costtype", "subMatLoss", "lossrateformula", "validPeriod"}, new String[]{"material", "auxpty", "subMaterialId", "subauxpty", "fz", "fm", "gdshl", "bdshl", "effectDate", "validDate", "qtytype"}).finish();
        while (middleDs.hasNext()) {
            Row row = middleDs.next();
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty((Long)material)) continue;
            Long auxpty = isConSiAux != false ? row.getLong("auxpty") : 0L;
            Boolean subMatLoss = row.getBoolean("subMatLoss");
            Boolean validPeriod = row.getBoolean("validPeriod");
            String lossRateFormula = row.getString("lossrateformula");
            Date effectDate = row.getDate("effectDate");
            Date validDate = row.getDate("validDate");
            String qtyType = row.getString("qtytype");
            BigDecimal fz = row.getBigDecimal("fz");
            BigDecimal fm = row.getBigDecimal("fm");
            BigDecimal gdshl = row.getBigDecimal("gdshl");
            BigDecimal bdshl = row.getBigDecimal("bdshl");
            if (BigDecimal.ZERO.compareTo(fm) == 0) continue;
            BigDecimal unitQty = fz.divide(fm, 10, 4);
            if (subMatLoss.booleanValue()) {
                if ("A".equals(qtyType)) {
                    unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(bdshl), 10, 4) : unitQty.multiply(BigDecimal.ONE.add(bdshl)).setScale(10, 4);
                } else if ("B".equals(qtyType)) {
                    unitQty = unitQty.add(gdshl);
                } else if ("C".equals(qtyType)) {
                    unitQty = unitQty.add(gdshl);
                }
            }
            Long subMaterialId = row.getLong("subMaterialId");
            Long subAuxpty = isConSiAux != false ? row.getLong("subauxpty") : 0L;
            String key = subMaterialId + "@" + subAuxpty;
            jumpMatQtyMap.put(key, unitQty);
            if (validPeriod.booleanValue()) {
                boolean afterEffect = endDate.after(effectDate);
                boolean beforeValid = endDate.before(validDate);
                if (!afterEffect || !beforeValid) continue;
            }
            Object[] columns = new Object[]{MAT_QUOTA_Id, orgId, material, auxpty, unitQty};
            jumpMatUpLevelMap.computeIfAbsent(key, p -> new ArrayList()).add(columns);
        }
    }

    private Set<Long> getBomIdScope(Long costTypeId) {
        QFilter costTypeQf = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        DataSet bomDs = QueryServiceHelper.queryDataSet((String)"getBomIdScope", (String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{costTypeQf, enableQf, statusQf}, null);
        HashSet<Long> bomIds = new HashSet<Long>(10);
        while (bomDs.hasNext()) {
            Row row = bomDs.next();
            Long bom = row.getLong("bom");
            if (CadEmptyUtils.isEmpty((Long)bom)) continue;
            bomIds.add(bom);
        }
        return bomIds;
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean isSameType(String firstType, String secondType) {
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{firstType, secondType})) {
            return StringUtils.equals((CharSequence)firstType, (CharSequence)secondType);
        }
        return false;
    }

    private static Map<String, Double> buildResultType(String type) {
        HashMap<String, Double> resultType = new HashMap<String, Double>();
        switch (type) {
            case "COSTCENTER": {
                resultType.put(COSTCENTER, 0.0);
                break;
            }
            case "COSTOBJECT": {
                resultType.put(COSTOBJECT, 0.0);
                break;
            }
            case "MATERIALGROUP": {
                resultType.put(MATERIALGROUP, 0.0);
                break;
            }
            case "MATERIAL": {
                resultType.put(MATERIAL, 0.0);
                break;
            }
        }
        return resultType;
    }

    private DataSet doDivideOnDigToMaterial(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org,costcenter,material,materialauxpty,submaterial,firstValue / " + opValue + " as value") : opDs.executeSql("select org,costcenter,material,materialauxpty,submaterial,0 as value");
        return opResult;
    }

    private DataSet doDivideOnDigToCostObject(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, costcenter, costobject, material,materialauxpty,submaterial,materialgroup, firstValue / " + opValue + " as value") : opDs.executeSql("select org, costcenter, costobject, material,materialauxpty,submaterial,materialgroup, 0 as value");
        return opResult;
    }

    private DataSet doDivideOnDigToCostCenter(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, costcenter, benefcostcenter,firstValue / " + opValue + " as value") : opDs.executeSql("select org, costcenter, benefcostcenter,0 as value");
        return opResult;
    }

    private DataSet doMulOnDigToMaterial(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org,costcenter,material,materialauxpty,submaterial," + opValue + " * firstValue as value" : "select org,costcenter,material,materialauxpty,submaterial," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostObject(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, costcenter, costobject, material,materialauxpty,submaterial,materialgroup," + opValue + " * firstValue as value" : "select org, costcenter, costobject, material,materialauxpty,submaterial,materialgroup," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostCenter(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, costcenter, benefcostcenter," + opValue + " * firstValue as value" : "select org, costcenter, benefcostcenter," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private static DataSet doMultiplyOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMultiplyOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doSubtractOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doSubtractOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doAddOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", "firstValue + value as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doAddOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", "firstValue + value as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMulOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet opResult;
        try {
            firstDs = firstDs.removeFields(new String[]{"submaterial"});
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        String value = "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value";
        boolean isNewAllocType = CostObjectCalculateFunction.isNewAllocType();
        if (isNewAllocType) {
            DataSet notCostCenterDs = secondDs.copy().filter("costcenter is null or costcenter = 0");
            if (notCostCenterDs.isEmpty()) {
                opResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", value}).finish();
            } else {
                DataSet costCenterResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", value}).finish();
                firstDs = firstDs.leftJoin(costCenterResult).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish();
                DataSet materialDealDs = firstDs.filter("diycostcenter is null or diycostcenter = 0");
                DataSet materialResult = materialDealDs.join(notCostCenterDs, JoinType.INNER).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", value}).finish();
                opResult = costCenterResult.union(materialResult);
            }
        } else {
            DataSet dealDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish().distinct();
            DataSet costCenterDealDs = dealDs.filter("diycostcenter is not null and diycostcenter != 0");
            DataSet materialDealDs = dealDs.filter("diycostcenter is null or diycostcenter = 0");
            DataSet costCenterResult = costCenterDealDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", value}).finish();
            DataSet emptyCostCenterDiyDs = secondDs.filter("costcenter is null or costcenter = 0");
            DataSet materialResult = materialDealDs.join(emptyCostCenterDiyDs, JoinType.INNER).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", value}).finish();
            opResult = costCenterResult.union(materialResult);
        }
        return opResult;
    }

    private DataSet doMulOnCostObjectToMaterialGroup(DataSet firstDs, DataSet secondDs, boolean isReverse) {
        DataSet opResult;
        String totalValue;
        String selectFiled;
        String sumValue;
        if (isReverse) {
            sumValue = "value";
            selectFiled = "org,costcenter,materialgroup,value as totalValue";
            totalValue = "(case when (totalValue != 0) and (value / totalValue) != null then (value / totalValue) else 0 end) as value";
        } else {
            sumValue = "firstValue";
            selectFiled = "org,costcenter,materialgroup,firstValue as totalValue";
            totalValue = "(case when (totalValue != 0) and (firstValue / totalValue) != null then (firstValue / totalValue) else 0 end) as firstValue";
        }
        if (this.isMatGroupCal) {
            DataSet totalDs = firstDs.groupBy(new String[]{"org", "costcenter", "materialgroup"}).sum(sumValue).finish();
            totalDs = totalDs.select(selectFiled);
            firstDs = firstDs.join(totalDs, JoinType.INNER).on("materialgroup", "materialgroup").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", totalValue}).finish();
            opResult = firstDs.leftJoin(secondDs).on("materialgroup", "materialgroup").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value"}).finish();
        } else {
            opResult = firstDs.leftJoin(secondDs).on("materialgroup", "materialgroup").select(new String[]{"org", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "submaterial", "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value"}).finish();
        }
        return opResult;
    }

    private static DataSet doMulOnCostObjectToCenter(DataSet firstDs, DataSet secondDs, boolean isSwitch) {
        String value = "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value";
        String sumStr = isSwitch ? "firstValue" : "value";
        secondDs = secondDs.groupBy(new String[]{"org", "benefcostcenter"}).sum(sumStr).finish();
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", value}).finish();
        return opResult;
    }

    private static DataSet doDivOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs, boolean isSwitch) {
        if (isSwitch) {
            firstDs = firstDs.executeSql("select org,costcenter,costobject,material,materialauxpty,submaterial,materialgroup,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        } else {
            secondDs = secondDs.executeSql("select org,costcenter,material,materialauxpty,submaterial,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        }
        return CostObjectCalculateFunction.doMulOnCostObjectToMaterial(firstDs, secondDs);
    }

    private DataSet doDivOnCostObjectToMaterialGroup(DataSet firstDs, DataSet secondDs, boolean isSwitch) {
        if (isSwitch) {
            firstDs = firstDs.executeSql("select org,costcenter,costobject,materialgroup,material,materialauxpty,submaterial,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        } else {
            secondDs = secondDs.executeSql("select org,materialgroup,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        }
        return this.doMulOnCostObjectToMaterialGroup(firstDs, secondDs, isSwitch);
    }

    private static DataSet doDivOnCostObjectToCenter(DataSet firstDs, DataSet secondDs) {
        secondDs = secondDs.executeSql("select org,costcenter,benefcostcenter,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        return CostObjectCalculateFunction.doMulOnCostObjectToCenter(firstDs, secondDs, false);
    }

    private static DataSet doDivOnCostCenterToObject(DataSet firstDs, DataSet secondDs) {
        secondDs = secondDs.executeSql("select org,costcenter,costobject,material,materialauxpty,submaterial,materialgroup,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        return CostObjectCalculateFunction.doMulOnCostObjectToCenter(secondDs, firstDs, true);
    }

    private static DataSet doDivisideOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", FIRST_DIV_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "material", "materialauxpty", "submaterial", FIRST_DIV_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doDivisideOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", FIRST_DIV_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "submaterial", "materialgroup", FIRST_DIV_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doSubtractOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doAddOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "firstValue + value  as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMultiplyOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doDivideOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_DIV_VALUE}).finish();
        return opResult;
    }

    public static boolean isNewAllocType() {
        String newAllocType = CadBgParamUtils.getCadBgParamForString((String)"newAllocType", (String)"1");
        return "1".equals(newAllocType);
    }
}

