/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.alloc.input;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;

public class CalcDataArgs
implements Serializable {
    private static final long serialVersionUID = 7415085582189550562L;
    private Object orgId;
    private Object costAcctId;
    private Object periodId;
    private Date startDate;
    private Date endDate;
    private Object currencyId;
    private List<Object> costCenterIds;
    private Object costTypeId;
    private Boolean isCalc = Boolean.TRUE;
    private Object cacheData = null;
    private Boolean includSettledObject = Boolean.TRUE;
    private String entity = "sca_calcresult";
    private Set<Object> costObjects;
    private long time;
    private int successCcCount;
    private Long successCoCount = 0L;
    private int failCcCount;
    private int checkfailCount;
    private Long checkResultId;
    private String finishPageTitle;
    private Map<String, Long> ccAndCoInfos;
    private String matCalType;
    private String mfgCalType;
    private String calcReportId;
    private BigDecimal maxDiffRate;
    private BigDecimal minDiffRate;

    public String getMatCalType() {
        return this.matCalType;
    }

    public void setMatCalType(String matCalType) {
        this.matCalType = matCalType;
    }

    public String getMfgCalType() {
        return this.mfgCalType;
    }

    public void setMfgCalType(String mfgCalType) {
        this.mfgCalType = mfgCalType;
    }

    public String getFinishPageTitle() {
        return this.finishPageTitle;
    }

    public void setFinishPageTitle(String finishPageTitle) {
        this.finishPageTitle = finishPageTitle;
    }

    public Object getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Object orgId) {
        this.orgId = orgId;
    }

    public Object getCostAcctId() {
        return this.costAcctId;
    }

    public void setCostAcctId(Object costAcctId) {
        this.costAcctId = costAcctId;
    }

    public Object getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Object periodId) {
        this.periodId = periodId;
    }

    public Date getStartDate() {
        return this.startDate == null ? new Date() : this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate == null ? new Date() : this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Object getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Object currencyId) {
        this.currencyId = currencyId;
    }

    public void setCostCenterIds(List<Object> costCenterIds) {
        this.costCenterIds = costCenterIds;
    }

    public List<Object> getCostCenterIds() {
        return this.costCenterIds;
    }

    public Object getCacheData() {
        return this.cacheData;
    }

    public void setCacheData(Object chacheData) {
        this.cacheData = chacheData;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getSuccessCcCount() {
        return this.successCcCount;
    }

    public void setSuccessCcCount(int successCcCount) {
        this.successCcCount = successCcCount;
    }

    public Long getSuccessCoCount() {
        return this.successCoCount;
    }

    public void setSuccessCoCount(Long successCoCount) {
        this.successCoCount = successCoCount;
    }

    public int getFailCcCount() {
        return this.failCcCount;
    }

    public void setFailCcCount(int failCcCount) {
        this.failCcCount = failCcCount;
    }

    public int getCheckfailCount() {
        return this.checkfailCount;
    }

    public void setCheckfailCount(int checkfailCount) {
        this.checkfailCount = checkfailCount;
    }

    public static long getSerialversionuid() {
        return 7415085582189550562L;
    }

    public Long getCheckResultId() {
        return this.checkResultId;
    }

    public void setCheckResultId(Long checkResultId) {
        this.checkResultId = checkResultId;
    }

    public Object getCostTypeId() {
        return this.costTypeId;
    }

    public void setCostTypeId(Object costTypeId) {
        this.costTypeId = costTypeId;
    }

    public Map<String, Long> getCcAndCoInfos() {
        return this.ccAndCoInfos;
    }

    public void setCcAndCoInfos(Map<String, Long> ccAndCoInfos) {
        this.ccAndCoInfos = ccAndCoInfos;
    }

    public String getCalcReportId() {
        return this.calcReportId;
    }

    public void setCalcReportId(String calcReportId) {
        this.calcReportId = calcReportId;
    }

    public BigDecimal getMaxDiffRate() {
        return this.maxDiffRate;
    }

    public void setMaxDiffRate(BigDecimal maxDiffRate) {
        this.maxDiffRate = maxDiffRate;
    }

    public BigDecimal getMinDiffRate() {
        return this.minDiffRate;
    }

    public void setMinDiffRate(BigDecimal minDiffRate) {
        this.minDiffRate = minDiffRate;
    }

    public Boolean getIncludSettledObject() {
        return this.includSettledObject;
    }

    public void setIncludSettledObject(Boolean includSettledObject) {
        this.includSettledObject = includSettledObject;
    }

    public Set<Object> getCostObjects() {
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(this.costObjects)) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            this.warpQFilter4BizDate(filters, "accountorg", false);
            filters.add(QFilter.of((String)"qty > 0 and costobject.bizstatus = 'A' and billstatus = 'C'", (Object[])new Object[0]));
            DataSet planDataSet = QueryServiceHelper.queryDataSet((String)"MatCalcProcessor.getCostObjectsBy", (String)"cad_plannedoutputbill", (String)"costobject", (QFilter[])filters.toArray(new QFilter[0]), null);
            ArrayList<QFilter> filterCals = new ArrayList<QFilter>();
            this.warpQFilter4BizDate(filterCals, "org", true);
            filterCals.add(QFilter.of((String)"entryentity.pdendqty > 0 and costobject.bizstatus = 'A'", (Object[])new Object[0]));
            DataSet calDataSet = QueryServiceHelper.queryDataSet((String)"MatCalcProcessor.getCostObjectsBy", (String)"sca_calcresult", (String)"costobject", (QFilter[])filterCals.toArray(new QFilter[0]), null);
            DataSet dataSet = planDataSet.union(calDataSet).select("costobject").groupBy(new String[]{"costobject"}).finish();
            HashSet<Object> set = new HashSet<Object>();
            for (Row row : dataSet) {
                set.add(row.get("costobject"));
            }
            this.setCostObjects(set);
        }
        return this.costObjects;
    }

    public Boolean isCalc() {
        return this.isCalc;
    }

    public void setIsCalc(Boolean calc) {
        this.isCalc = calc;
    }

    public void setCostObjects(Set<Object> costObjects) {
        this.costObjects = costObjects;
    }

    public void warpQFilter4Org(List<QFilter> filters, String orgFields) {
        filters.add(new QFilter(orgFields, "=", this.getOrgId()));
        filters.add(new QFilter("costaccount", "=", this.getCostAcctId()));
        List<Object> costCenters = this.getCostCenterIds();
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenters)) {
            filters.add(new QFilter("costcenter", "in", costCenters));
        }
    }

    public void warpQFilter4OrgNoAcct(List<QFilter> filters, String orgFields) {
        filters.add(new QFilter(orgFields, "=", this.getOrgId()));
        List<Object> costCenters = this.getCostCenterIds();
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenters)) {
            filters.add(new QFilter("costcenter", "in", costCenters));
        }
    }

    public void warpQFilter4BizDate(List<QFilter> filters, String orgFields, boolean hasAcct) {
        if (hasAcct) {
            this.warpQFilter4Org(filters, orgFields);
        } else {
            this.warpQFilter4OrgNoAcct(filters, orgFields);
        }
        filters.add(new QFilter("bizdate", ">=", (Object)this.getStartDate()));
        filters.add(new QFilter("bizdate", "<=", (Object)this.getEndDate()));
    }

    public void warpQFilter4Period(List<QFilter> filters, String orgFields, boolean hasAcct) {
        if (hasAcct) {
            this.warpQFilter4Org(filters, orgFields);
        } else {
            this.warpQFilter4OrgNoAcct(filters, orgFields);
        }
        filters.add(new QFilter("period", "=", this.getPeriodId()));
    }

    public void wrapQFilter4CostObjects(List<QFilter> filters, String filed) {
        Set<Object> costObjects = this.getCostObjects();
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costObjects)) {
            filters.add(new QFilter(filed, "in", costObjects));
        }
    }

    public void clearNotRequestData() {
        this.cacheData = null;
        this.costObjects = null;
        this.endDate = null;
        this.startDate = null;
        this.matCalType = null;
        this.mfgCalType = null;
        this.maxDiffRate = null;
        this.minDiffRate = null;
        this.includSettledObject = null;
    }

    public boolean isNullReqField() {
        return this.orgId == null || this.costAcctId == null || this.periodId == null;
    }
}

