/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.action.ActCalcAction;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class ActCostCalcDataInputFactory {
    private static final String ALGOKEY_PRE = "ActCostCalcInput-";
    private static final String INSERT_CONVDETAIL_ENTRY_SQL = "INSERT INTO t_aca_calcresultconventry (FId,FEntryId,fseq,fconvsrcbillid,fconvsrcbillentryid,fconvcostobjectid,fconvproducttype,fconvelementid,fconvsubelementid,fconvoutsourcetype,fconvsubmatid,fconvsubmatverid,fconvsubauxptyid,fconvproqty,fconvqty,fconvamt,fconvgroupfield,fconvgroupcategoryid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_INVENTRY_ENTRY_SQL = "insert into t_aca_calcresultinventry (fid, fentryid, fsourcebillentryid, fsourcebillid, finventoryamount, finventoryqty, finventorysubeleid, finvcostobjectid, finvproducttype, finvoutsourcetype, fgroupfield, fgroupcategoryid, fcarrytype) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final Log logger = LogFactory.getLog(ActCalcAction.class);

    public DataSet getMainJoinSideCostobjDsFromMainId(Long orgId, Set<Long> mainCostobjectIds, String[] productTypes) {
        QFilter filter = new QFilter("id", "in", mainCostobjectIds);
        DataSet mainCostobjectDs = QueryServiceHelper.queryDataSet((String)"CalCadCostobject", (String)"cad_costobject", (String)"costcenter,costcenter mainCostCenterId,id mainCostObjectId,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource", (QFilter[])filter.toArray(), null);
        DataSet mainJoinSideDs = null;
        mainJoinSideDs = Arrays.asList(productTypes).contains("C") ? mainCostobjectDs.copy().filter("productgroup>0") : mainCostobjectDs.filter("productgroup>0");
        HashSet productgroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet poNos = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : mainJoinSideDs.copy()) {
            productgroupIds.add(row.getLong("productgroup"));
            poNos.add(row.getString("srcbillnumber"));
        }
        DataSet relaCostobjectDs = null;
        if (productgroupIds.isEmpty() && poNos.isEmpty()) {
            relaCostobjectDs = mainJoinSideDs;
        } else {
            ArrayList<String> productTypeList = new ArrayList<String>();
            productTypeList.addAll(Arrays.asList(productTypes));
            productTypeList.remove("C");
            QFilter relaFilter = new QFilter("org", "=", (Object)orgId);
            relaFilter.and("productgroup", "in", (Object)productgroupIds);
            relaFilter.and("srcbillnumber", "in", (Object)poNos);
            relaFilter.and("producttype", "in", productTypeList);
            relaCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"cad_costobject", (String)"biztype,costcenter,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource,mainproobj", (QFilter[])relaFilter.toArray(), null);
            DataSet notHasRelaMainDs = relaCostobjectDs.copy().filter("mainproobj=0");
            if (!notHasRelaMainDs.isEmpty()) {
                notHasRelaMainDs = mainJoinSideDs.join(notHasRelaMainDs).on("productgroup", "productgroup").on("srcbillnumber", "srcbillnumber").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource", "biztype"}).finish();
                notHasRelaMainDs = notHasRelaMainDs.filter("biztype<>'FL' or mainCostCenterId=costcenter").removeFields(new String[]{"biztype"});
            } else {
                notHasRelaMainDs = null;
            }
            relaCostobjectDs = mainJoinSideDs.join(relaCostobjectDs).on("mainCostObjectId", "mainproobj").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource"}).finish();
            if (notHasRelaMainDs != null) {
                relaCostobjectDs = relaCostobjectDs.union(notHasRelaMainDs);
            }
        }
        if (Arrays.asList(productTypes).contains("C")) {
            relaCostobjectDs = DataSetHelper.union(relaCostobjectDs, mainCostobjectDs);
        }
        return relaCostobjectDs;
    }

    public Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    public DataSet buildCloseStatus(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("accountorg", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("closedatetime", "<=", (Object)DateUtils.getDayEndTime((Date)args.getEndDate()));
        filter.and("closestatu", "=", (Object)Boolean.TRUE);
        filter.and("costobject.biztype", "=", (Object)"RO");
        filter.and("billstatus", "=", (Object)"C");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "costobject as costObjectId,closestatu as closestatus";
        DataSet planned = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-planclose", (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null).distinct();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u83b7\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5173\u95ed\u72b6\u6001\u53d6\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_16", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return planned;
    }

    public DataSet buildPlannedoutputDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("accountorg", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("bizdate", ">=", (Object)args.getStartDate());
        filter.and("bizdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "billno,costobject.costcenter as costCenterId,costobject as costObjectId,qty as proPlanQty,0.00 as proFinQty";
        DataSet planned = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-plan", (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        planned = planned.groupBy(new String[]{"costCenterId", "costObjectId"}).sum("proPlanQty").sum("proFinQty").finish();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_6", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return planned;
    }

    public DataSet buildFactnedoutputDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<String> secFields) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("entryentity.costobject", "in", calcCostObjectSet);
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "sourcebill as srcBillId,sourcebillentry as srcEntryId,entryentity.costobject.srcbillnumber as mftOrderNo,entryentity.costobject.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId,material as matId,entryentity.costobject.bomversion as matVerId,entryentity.costobject.auxpty as matAuxId,0.00 as proPlanQty,entryentity.qty as proFinQty,srcauxpty as auxpty,invtype,gradeprodgroup,costcenter as factedCostCenterId,warehouse factwarehouse";
        String groupField = "srcBillId,srcEntryId,productType,groupId,mftOrderNo,costCenterId,costObjectId,matId,matVerId,matAuxId,auxpty,invtype,gradeprodgroup,factedCostCenterId,factwarehouse";
        if (secFields != null && !secFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (String secField : secFields) {
                joiner.add(secField);
            }
            String field = joiner.toString();
            selectFields = selectFields + "," + field;
            groupField = groupField + "," + field;
        }
        DataSet factned = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        factned = factned.groupBy(groupField.split(",")).sum("proPlanQty").sum("proFinQty").finish();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_7", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return factned;
    }

    public DataSet buildFactnedoutputInEntryIdDs(ActCostCalcArgs args, Set<Long> factedEntryId) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("sourcebillentry", "in", factedEntryId);
        String selectFields = "sourcebill as srcBillId,sourcebillentry as srcEntryId,costcenter,entryentity.costobject as costObjectId,entryentity.costobject.name as costObjectName,entryentity.costobject.producttype as productType,entryentity.qty as proFinQty";
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet buildSideFactnedoutputDataSet(ActCostCalcArgs args, Set<String> secFields) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.costobject.producttype", "=", (Object)"B");
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "sourcebill as srcBillId,sourcebillentry as srcEntryId,entryentity.costobject.srcbillnumber as mftOrderNo,entryentity.costobject.isoutsource isoutsource,entryentity.costobject.manuorg manuorgId,entryentity.costobject.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId,material as matId,entryentity.costobject.bomversion as matVerId,entryentity.costobject.auxpty as matAuxId,entryentity.qty as proFinQty,srcauxpty as auxpty,invtype,gradeprodgroup,costcenter as factedCostCenterId";
        String groupField = "srcBillId,srcEntryId,isoutsource,manuorgId,productType,groupId,mftOrderNo,costCenterId,costObjectId,matId,matVerId,matAuxId,auxpty,invtype,gradeprodgroup,factedCostCenterId";
        if (secFields != null && !secFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (String secField : secFields) {
                joiner.add(secField);
            }
            String field = joiner.toString();
            selectFields = selectFields + "," + field;
            groupField = groupField + "," + field;
        }
        DataSet factned = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        factned = factned.groupBy(groupField.split(",")).sum("proFinQty").finish();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u526f\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_8", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return factned;
    }

    public void buildMaterialAllocReworkSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<Long> reWorkPoMatSet, Set<Long> reWorkPoSubMatSet, Set<Long> reWorkNotPoSubMatSet, Set<Long> reWorkCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobejctentry", "in", calcCostObjectSet);
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("isreturnitem", "=", (Object)true);
        String selectFields = "entryentity.costobejctentry as costObjectId,entryentity.costobejctentry.isrework as isrework,entryentity.costobejctentry.material as matId,material as subMatId";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u3011\u8fd4\u5de5\u6570\u636e\u67e5\u8be2\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_9", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        for (Row row : dataset) {
            if (row.getBoolean("isrework").booleanValue()) {
                reWorkPoMatSet.add(row.getLong("matId"));
                reWorkPoSubMatSet.add(row.getLong("subMatId"));
                reWorkCostObjectSet.add(row.getLong("costObjectId"));
                continue;
            }
            reWorkNotPoSubMatSet.add(row.getLong("subMatId"));
        }
    }

    public DataSet buildMaterialAllocDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobejctentry", "in", calcCostObjectSet);
        String selectFields = "id,entryentity.id as entryId,entryentity.costobejctentry.costcenter as costCenterId,entryentity.costobejctentry as costObjectId,entryentity.costobejctentry.producttype as productType,entryentity.costobejctentry.productgroup.id as groupId,entryentity.costobejctentry.srcbillnumber as mftOrderNo,entryentity.costobejctentry.material as matId,entryentity.costobejctentry.material.baseunit.precision as matUnitPrecision,entryentity.costobejctentry.bomversion as matVerId,entryentity.costobejctentry.auxpty as matAuxId,material as subMatId,matversion as subMatVerId,auxpty as subMatAuxId,material.baseunit.precision as subMatUnitPrecision,entryentity.elemententry as elementId,entryentity.subelemententry as subElementId,entryentity.qty as qty,entryentity.amount as amount,isreturnitem as isReturn,0 as isMfg,case when entryentity.costobejctentry.isoutsource ='1' then 'D' else ' ' end as outsourcetype,calckeycol";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_10", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return dataset;
    }

    public OrmInput buildMaterialAllocSubDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobejctentry", "in", calcCostObjectSet);
        String selectFields = "entryentity.costobejctentry as costObjectId,entryentity.costobejctentry as relaCostObjectId,entryentity.subelemententry as subelement,material as subMatId,matversion as subMatVerId,auxpty as subMatAuxId,calckeycol,entryentity.subentryentity.element selement,entryentity.subentryentity.subelement ssubelement,entryentity.subentryentity.standardamt spdcurramt";
        return new OrmInput("ActCostCalcInput-matAlloc", "aca_matalloc", selectFields, filter.toArray());
    }

    public DataSet buildMfgFeeAllocDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobject", "in", calcCostObjectSet);
        String selectFields = "entryentity.costobject.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId,entryentity.costobject.srcbillnumber as mftOrderNo,entryentity.costobject.material as matId,entryentity.costobject.bomversion as matVerId,entryentity.costobject.auxpty as matAuxId,entryentity.costobject.material.baseunit.precision as matUnitPrecision,0L as subMatId,0L as subMatVerId,0L as subMatAuxId,0 as subMatUnitPrecision,element as elementId,subelement as subElementId,entryentity.allocamt as amount,1 as isMfg,entryentity.outsourcetype as outsourcetype";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mfgAllocCo", (String)"cad_mfgfeeallocco", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_11", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return dataset;
    }

    public Map<String, Object> buildCalcInCostParam(ActCostCalcArgs args, DataSet calcInDataSet) {
        HashMap result = Maps.newHashMap();
        HashMap tmpMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : calcInDataSet) {
            Long srcEntryId = row.getLong("srcEntryId");
            Long subElementId = row.getLong("subElementId");
            String outSourceType = row.getString("outsourcetype");
            BigDecimal cost = row.getBigDecimal("cost");
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outsourcetype", outSourceType);
            map.put("costsubelement", subElementId);
            map.put("cost", cost);
            tmpMap.computeIfAbsent(srcEntryId, t -> Lists.newArrayList()).add(map);
        }
        ArrayList calcParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mapEntry : tmpMap.entrySet()) {
            Long srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("costaccount", args.getCostAccountId());
            map.put("bizbillentryid", srcEntryId);
            map.put("costinfo", list);
            calcParamList.add(map);
        }
        result.put("calcParamList", calcParamList);
        return result;
    }

    public Map<String, Object> buildCalcInCostParam(ActCostCalcArgs args, DataSet calcInDataSet, Map<Long, Long> calcResultMap, Set<Long> hasUpdateFactedEntryIds) {
        HashMap result = Maps.newHashMap();
        int batch = CadBgParamUtils.getCadParamForInt((String)"calcInCostParamBat", (int)2000);
        HashMap tmpMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<Object[]> addResultEntryIds = new ArrayList<Object[]>(128);
        for (Row row : calcInDataSet) {
            List<HashMap> list;
            String carrytype = row.getString("carrytype");
            Long srcBillId = row.getLong("srcBillId");
            Long srcEntryId = row.getLong("srcEntryId");
            hasUpdateFactedEntryIds.add(srcEntryId);
            Long subElementId = row.getLong("subElementId");
            String outSourceType = row.getString("outsourcetype");
            Long costObjectId = row.getLong("costObjectId");
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            String productType = row.getString("productType");
            BigDecimal finQty = row.getBigDecimal("proFinQty");
            BigDecimal cost = row.getBigDecimal("cost");
            if (cost != null) {
                cost = cost.setScale(args.getAmtScale(), RoundingMode.HALF_UP);
            }
            String groupField = row.getString("groupfield");
            Long groupCategoryid = row.getLong("groupcategoryid");
            Long calcResultId = calcResultMap.get(mainCostObjectId);
            if (calcResultId != null) {
                addResultEntryIds.add(new Object[]{calcResultId, ID.genLongId(), srcEntryId, srcBillId, cost, finQty, subElementId, costObjectId, productType, outSourceType, groupField, groupCategoryid, carrytype});
                if (addResultEntryIds.size() > batch) {
                    this.executeBatch(DBRoute.of((String)"cal"), INSERT_INVENTRY_ENTRY_SQL, addResultEntryIds);
                    addResultEntryIds.clear();
                }
            } else {
                logger.error("\u5165\u5e93\u4fe1\u606f\u672a\u627e\u5230\u8ba1\u7b97\u7ed3\u679c\u5355\uff1a{}", (Object)mainCostObjectId);
            }
            if (args.isCalbyCostElement() && "A".equals(carrytype)) continue;
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outsourcetype", outSourceType);
            map.put("costsubelement", subElementId);
            map.put("cost", cost);
            if (tmpMap.get(srcEntryId) == null) {
                list = Lists.newArrayList();
                tmpMap.put(srcEntryId, list);
            }
            list = (List)tmpMap.get(srcEntryId);
            list.add(map);
        }
        if (!addResultEntryIds.isEmpty()) {
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_INVENTRY_ENTRY_SQL, addResultEntryIds);
            addResultEntryIds.clear();
        }
        ArrayList calcParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mapEntry : tmpMap.entrySet()) {
            Long srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("costaccount", args.getCostAccountId());
            map.put("bizbillentryid", srcEntryId);
            map.put("costinfo", list);
            calcParamList.add(map);
        }
        result.put("calcParamList", calcParamList);
        return result;
    }

    public Map<String, Object> buildCalcInCostParamNoSave(ActCostCalcArgs args, DataSet calcInDataSet, Map<Long, Long> calcResultMap, Set<Long> hasUpdateFactedEntryIds) {
        Long srcEntryId;
        HashMap result = Maps.newHashMap();
        HashMap tmpMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : calcInDataSet) {
            List<HashMap> list;
            String carrytype = row.getString("carrytype");
            srcEntryId = row.getLong("srcEntryId");
            hasUpdateFactedEntryIds.add(srcEntryId);
            Long subElementId = row.getLong("subElementId");
            String outSourceType = row.getString("outsourcetype");
            BigDecimal cost = row.getBigDecimal("cost");
            if (cost != null) {
                cost = cost.setScale(args.getAmtScale(), RoundingMode.HALF_UP);
            }
            if (args.isCalbyCostElement() && "A".equals(carrytype)) continue;
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outsourcetype", outSourceType);
            map.put("costsubelement", subElementId);
            map.put("cost", cost);
            if (tmpMap.get(srcEntryId) == null) {
                list = Lists.newArrayList();
                tmpMap.put(srcEntryId, list);
            }
            list = (List)tmpMap.get(srcEntryId);
            list.add(map);
        }
        ArrayList calcParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mapEntry : tmpMap.entrySet()) {
            srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("costaccount", args.getCostAccountId());
            map.put("bizbillentryid", srcEntryId);
            map.put("costinfo", list);
            calcParamList.add(map);
        }
        result.put("calcParamList", calcParamList);
        return result;
    }

    public void buildCalcConversionDetail(DataSet calcConversionDetailDataSet, Map<Long, Long> calcResultMap) {
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        for (Row row : calcConversionDetailDataSet) {
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            Long calcResultId = calcResultMap.get(mainCostObjectId);
            if (calcResultId != null) {
                Object[] entry = new Object[]{calcResultId, ID.genLongId(), 1, row.getLong("srcBillId"), row.getLong("srcEntryId"), row.getLong("costObjectId"), row.getString("productType"), row.getLong("elementId"), row.getLong("subElementId"), row.getString("outsourcetype"), row.getLong("subMatId") == null ? Long.valueOf(0L) : row.getLong("subMatId"), row.getLong("subMatVerId") == null ? Long.valueOf(0L) : row.getLong("subMatVerId"), row.getLong("subMatAuxId") == null ? Long.valueOf(0L) : row.getLong("subMatAuxId"), BigDecimalUtil.getOrZero(row.getBigDecimal("proFinQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finAmt")), row.getString("groupfield"), row.getLong("groupcategoryid")};
                entrys.add(entry);
                if (entrys.size() < 500) continue;
                this.executeBatch(DBRoute.of((String)"cal"), INSERT_CONVDETAIL_ENTRY_SQL, entrys);
                entrys.clear();
                continue;
            }
            logger.error("\u5b50\u7269\u6599\u5206\u9879\u4fe1\u606f\u672a\u627e\u5230\u8ba1\u7b97\u7ed3\u679c\u5355\uff1a{}", (Object)mainCostObjectId);
        }
        if (!CollectionUtils.isEmpty(entrys)) {
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_CONVDETAIL_ENTRY_SQL, entrys);
        }
    }

    private void executeBatch(DBRoute route, String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)route, (String)sql, entrys);
    }

    public List<Map<String, Object>> buildCalcOutCostParam(ActCostCalcArgs args, Set<Long> matSet) {
        ArrayList<Map<String, Object>> bizParamList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> bizParam = new HashMap<String, Object>();
        bizParam.put("costaccount", args.getCostAccountId());
        bizParam.put("calscheme", args.getCalSchemeId());
        bizParam.put("materials", matSet);
        bizParamList.add(bizParam);
        return bizParamList;
    }

    public Map<String, Object> buildCalcOutCostCommonParam(String matConditionType, boolean isConcurrencyMode) {
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("checkSaveState", Boolean.TRUE);
        commonParam.put("checkSubmitState", Boolean.TRUE);
        commonParam.put("checkBillCost", Boolean.TRUE);
        commonParam.put("checkVoucher", Boolean.TRUE);
        commonParam.put("writeErrRpt", Boolean.FALSE);
        commonParam.put("matConditionType", matConditionType);
        commonParam.put("writeRpt", Boolean.TRUE);
        commonParam.put("isConcurrency", isConcurrencyMode);
        return commonParam;
    }

    public DataSet buildProallocstdDataSet(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("effectstatus", "=", (Object)"1");
        String selectFields = " allocentry.costcenter as costCenterId,allocentry.costdriver as costdriver,allocentry.costagent as costagent,allocentry.calmethod as calmethod,allocentry.productsubentry.element as elementId,allocentry.productsubentry.subelement as subElementId,allocentry.productsubentry.costdriverdetail as costdriverdetail,allocentry.productsubentry.costagentdetail as costagentdetail,allocentry.productsubentry.calmethoddetail as calmethoddetail,allocentry.productsubentry.costtype as costtype";
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-proAllocStd", (String)"aca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public Map<String, String> buildProallocstdMap(ActCostCalcArgs args) {
        DataSet proallocstdDataSet = this.buildProallocstdDataSet(args);
        HashMap proallocstdMap = Maps.newHashMapWithExpectedSize((int)50);
        for (Row row : proallocstdDataSet) {
            String costCenterId = row.getString("costCenterId");
            String costdriver = row.getString("costdriver");
            String costagent = row.getString("costagent");
            String calmethod = row.getString("calmethod");
            String costdriverVal = String.format("%s@%s@%s", costdriver, costagent, calmethod);
            if (CadEmptyUtils.isEmpty((String)costCenterId)) {
                proallocstdMap.put(String.valueOf(args.getCostAccountId()), costdriverVal);
            } else {
                proallocstdMap.put(String.format("%s@%s", args.getCostAccountId(), costCenterId), costdriverVal);
            }
            String costdriverDetail = row.getString("costdriverdetail");
            String costagentdetail = row.getString("costagentdetail");
            String calmethoddetail = row.getString("calmethoddetail");
            String costdriverDetailVal = String.format("%s@%s@%s", costdriverDetail, costagentdetail, calmethoddetail);
            Long costType = row.getLong("costtype");
            if (costdriverDetail == null || !StringUtils.isNotEmpty((String)costdriverDetail)) continue;
            if (costdriverDetail.equals("3") && StringUtils.isNotEmpty((String)costCenterId)) {
                args.getAssemblyCostCenterSet().add(Long.parseLong(costCenterId));
            }
            if ("5".equals(costdriverDetail) && StringUtils.isNotEmpty((String)costCenterId)) {
                args.getBomCostCenterSet().add(Long.parseLong(costCenterId));
                args.getCostTypeSet().add(costType);
            }
            String subElementId = row.getString("subElementId");
            String key = args.getCostAccountId() + "@" + costCenterId + "@" + subElementId;
            proallocstdMap.put(key, costdriverDetailVal);
        }
        return proallocstdMap;
    }

    public DataSet buildEquivalentDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "billno,period as periodId,entryentity.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.totalvalen as totalvalen,entryentity.entryentitydetail.element as elementId,entryentity.entryentitydetail.subelement as subElementId,entryentity.entryentitydetail.detailvalen as detailvalen";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-equivalent", (String)"aca_equivalent", (String)selectFields, (QFilter[])filter.toArray(), (String)"period asc");
        return resultDs;
    }

    public Map<String, BigDecimal> getEquivalentMap(ActCostCalcArgs args, Set<Long> calcCostObjectSet, int index, DebugInfoMsgHandler msgHander) {
        HashMap equivalentMap = Maps.newHashMapWithExpectedSize((int)2000);
        DataSet equDataSet = this.buildEquivalentDataSet(args, calcCostObjectSet);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(equDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%1$s:index:%2$s:\u7ea6\u5f53\u7cfb\u6570\u6570\u636e\uff1a", (String)"ActCostCalcDataInputFactory_12", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey(), index), msgHander);
        }
        Long costAccountId = args.getCostAccountId();
        for (Row row : equDataSet) {
            String costCenterId = row.getString("costCenterId");
            String costObjectId = row.getString("costObjectId");
            BigDecimal totalvalen = row.getBigDecimal("totalvalen");
            String key = "";
            key = !CadEmptyUtils.isEmpty((String)costObjectId) ? String.format("%s@%s@%s", costAccountId, costCenterId, costObjectId) : (!CadEmptyUtils.isEmpty((String)costCenterId) ? String.format("%s@%s", costAccountId, costCenterId) : String.format("%s", costAccountId));
            equivalentMap.put(key, totalvalen);
            BigDecimal detailvalen = row.getBigDecimal("detailvalen");
            if (detailvalen == null) continue;
            String subElementId = row.getString("subElementId");
            key = !CadEmptyUtils.isEmpty((String)costObjectId) ? String.format("%s@%s@%s@%s", costAccountId, costCenterId, costObjectId, subElementId) : (!CadEmptyUtils.isEmpty((String)costCenterId) ? String.format("%s@%s@%s", costAccountId, costCenterId, subElementId) : String.format("%s@%s", costAccountId, subElementId));
            equivalentMap.put(key, detailvalen);
        }
        return equivalentMap;
    }

    public Set<Long> buildNestCalcResultIds(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        HashSet nestCalResultIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet resultIds = Sets.newHashSetWithExpectedSize((int)16);
        nestCalResultIds.addAll(calcCostObjectSet);
        nestCalResultIds.retainAll(args.getCacheNestCalResultCostObjects());
        if (!CollectionUtils.isEmpty((Collection)nestCalResultIds)) {
            QFilter nestFilter = new QFilter("org", "=", (Object)args.getOrgId());
            nestFilter.and("costaccount", "=", (Object)args.getCostAccountId());
            nestFilter.and("period", "<", (Object)args.getPrePeriodId());
            nestFilter.and("costobject", "in", (Object)nestCalResultIds);
            String selectFields = "id,period,costobject as costObjectId";
            DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])nestFilter.toArray(), null);
            DataSet netCalcResultIdDataSet = resultDs.groupBy(new String[]{"costObjectId"}).maxP("period", "id").finish();
            for (Row row : netCalcResultIdDataSet) {
                resultIds.add(row.getLong("id"));
            }
        }
        return resultIds;
    }

    public DataSet buildFinalPreCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<Long> resultIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        String selectFields = "costcenter  as costCenterId, costobject as mainCostObjectId,entryentity.relacostobject costobjectId,entryentity.relacostobject.material as matId,entryentity.relacostobject.bomversion as matVerId,entryentity.relacostobject.auxpty.id as matAuxId,entryentity.relaproducttype as productType,entryentity.pdendqty + entryentity.endadjqty as pdStartQty, entryentity.pdendamount + entryentity.endadjamt as pdStartAmt,entryentity.pdsumqty as pdSumQty,entryentity.pdsumamount as pdSumAmt,entryentity.sumcomqty as sumComQty,entryentity.sumcomamount as sumComAmt,entryentity.yearpdsumqty as yearSumInputQty,entryentity.yearpdsumamount as yearSumInputAmt,entryentity.yearsumcomqty as yearSumFinishQty,entryentity.yearsumcomamount as yearSumFinishAmt";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        if (!CollectionUtils.isEmpty(resultIds)) {
            QFilter nestCalcResultFilter = new QFilter("id", "in", resultIds);
            nestCalcResultFilter.and("entryentity.type", "=", (Object)"finalResult");
            DataSet nestCalcResultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])nestCalcResultFilter.toArray(), null);
            resultDs = resultDs.union(nestCalcResultDs);
        }
        resultDs = resultDs.groupBy(new String[]{"costobjectId"}).sum("pdStartQty").sum("pdStartAmt").sum("pdSumQty").sum("pdSumAmt").sum("sumComQty").sum("sumComAmt").sum("yearSumInputQty").sum("yearSumInputAmt").sum("yearSumFinishQty").sum("yearSumFinishAmt").finish();
        return resultDs;
    }

    public DataSet buildDetailPreCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<Long> resultIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"detail");
        filter.and("entryentity.relaproducttype", "=", (Object)"C");
        String selectFields = "costobject.costcenter  as costCenterId, costobject as costObjectId,costobject.producttype as productType,costobject.productgroup.id as groupId,costobject.srcbillnumber as mftOrderNo,costobject.material as matId,costobject.bomversion as matVerId,costobject.auxpty.id as matAuxId,costobject.material.baseunit.precision as matUnitPrecision,entryentity.element as elementId,entryentity.subelement as subElementId,entryentity.feetype feetype,entryentity.submaterial as subMatId,entryentity.submatversion as subMatVerId,entryentity.subauxpty as subMatAuxId,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.pdendqty + entryentity.endadjqty as pdStartQty, entryentity.pdendamount + entryentity.endadjamt as pdStartAmt,entryentity.pdsumqty as pdSumQty,entryentity.pdsumamount as pdSumAmt,entryentity.sumcomqty as sumComQty,entryentity.sumcomamount as sumComAmt,entryentity.yearpdsumqty as yearSumInputQty,entryentity.yearpdsumamount as yearSumInputAmt,entryentity.yearsumcomqty as yearSumFinishQty,entryentity.yearsumcomamount as yearSumFinishAmt,entryentity.outsourcetype as outsourcetype,entryentity.calckeycol as calckeycol";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        if (!CollectionUtils.isEmpty(resultIds)) {
            QFilter nestCalcResultFilter = new QFilter("id", "in", resultIds);
            nestCalcResultFilter.and("entryentity.type", "=", (Object)"detail");
            nestCalcResultFilter.and("entryentity.relaproducttype", "=", (Object)"C");
            DataSet nestCalcResultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])nestCalcResultFilter.toArray(), null);
            resultDs = resultDs.union(nestCalcResultDs);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.remove("feetype");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        fieldNames.add("case when feetype='materialFee' or subMatId>0  then 0 else 1 end as isMfg");
        resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        return resultDs;
    }

    public DataSet buildJoinSideDetailPreCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<Long> resultIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"detail");
        filter.and("entryentity.relaproducttype", "in", (Object)new String[]{"A", "B"});
        String selectFields = "costcenter  as costCenterId,costobject as mainCostObjectId, entryentity.relacostobject as costObjectId,entryentity.relacostobject.producttype as productType,entryentity.relacostobject.productgroup.id as groupId,entryentity.relacostobject.srcbillnumber as mftOrderNo,entryentity.relacostobject.material as matId,entryentity.relacostobject.bomversion as matVerId,entryentity.relacostobject.auxpty.id as matAuxId,entryentity.relacostobject.material.baseunit.precision as matUnitPrecision,entryentity.element as elementId,entryentity.subelement as subElementId,entryentity.feetype feetype,entryentity.submaterial as subMatId,entryentity.submatversion as subMatVerId,entryentity.subauxpty as subMatAuxId,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.pdsumqty as pdSumQty,entryentity.pdsumamount as pdSumAmt,entryentity.sumcomqty as sumComQty,entryentity.sumcomamount as sumComAmt,entryentity.yearpdsumqty as yearSumInputQty,entryentity.yearpdsumamount as yearSumInputAmt,entryentity.yearsumcomqty as yearSumFinishQty,entryentity.yearsumcomamount as yearSumFinishAmt,entryentity.outsourcetype as outsourcetype,entryentity.calckeycol as calckeycol";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        if (!CollectionUtils.isEmpty(resultIds)) {
            QFilter nestCalcResultFilter = new QFilter("id", "in", resultIds);
            nestCalcResultFilter.and("entryentity.type", "=", (Object)"detail");
            nestCalcResultFilter.and("entryentity.relaproducttype", "in", (Object)new String[]{"A", "B"});
            DataSet nestCalcResultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])nestCalcResultFilter.toArray(), null);
            resultDs = resultDs.union(nestCalcResultDs);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.remove("feetype");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        fieldNames.add("case when feetype='materialFee' or subMatId>0  then 0 else 1 end as isMfg");
        resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        return resultDs;
    }

    public DataSet buildDetailPreSubCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Set<Long> resultIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"detail");
        String selectFields = "costobject as costObjectId,costobject as relaCostObjectId,entryentity.subelement as subelement,entryentity.submaterial as subMatId,entryentity.submatversion as subMatVerId,entryentity.subauxpty as subMatAuxId,entryentity.calckeycol as calckeycol,entryentity.subdetail.selement selement,entryentity.subdetail.ssubelement ssubelement,entryentity.subdetail.spdendamt+entryentity.subdetail.spdendadjamt spdstartamt,entryentity.subdetail.spdyearsumamt spdyearsumamt,entryentity.subdetail.spdsumamt spdsumamt,entryentity.subdetail.spdyearcomamt spdyearcomamt,entryentity.subdetail.spdsumcomamt spdsumcomamt";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        if (!CollectionUtils.isEmpty(resultIds)) {
            QFilter nestCalcResultFilter = new QFilter("id", "in", resultIds);
            nestCalcResultFilter.and("entryentity.type", "=", (Object)"detail");
            DataSet nestCalcResultDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])nestCalcResultFilter.toArray(), null);
            resultDs = resultDs.union(nestCalcResultDs);
        }
        return resultDs;
    }

    public DataSet buildAdjustDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = "costcenter as costCenterId, costobject as costObjectId,case when adjusttype = 'START' then adjustqty else 0 end startadjqty,case when adjusttype = 'END' then adjustqty else 0 end endadjqty";
        DataSet adjDataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-wipAdjustBill", (String)"aca_wipadjustbill", (String)selectFields, (QFilter[])filter.toArray(), null).groupBy(new String[]{"costCenterId", "costObjectId"}).sum("startadjqty").sum("endadjqty").finish();
        return adjDataSet;
    }

    public DataSet buildAdjustCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "costobject.costcenter as costCenterId, costobject as costObjectId,costobject.producttype as productType,costobject.productgroup.id as groupId,costobject.srcbillnumber as mftOrderNo,costobject.material as matId,costobject.bomversion as matVerId,costobject.auxpty.id as matAuxId,costobject.material.baseunit.precision as matUnitPrecision,entryentity.outsourcetype as outsourcetype,entryentity.element as elementId,entryentity.subelement as subElementId,case when adjusttype = 'START' then entryentity.adjustamt else 0 end startProAdjamt,case when adjusttype = 'END' then entryentity.adjustamt else 0 end endProAdjamt,entryentity.subentryentity.submaterial as subMatId,entryentity.subentryentity.version as subMatVerId,entryentity.subentryentity.auxpty as subMatAuxId,entryentity.subentryentity.submaterial.baseunit.precision as subMatUnitPrecision,case when adjusttype = 'START' then entryentity.subentryentity.submatadjqty else null end startadjqty,case when adjusttype = 'START' then entryentity.subentryentity.submatadjamt else null end startadjamt,case when adjusttype = 'END' then entryentity.subentryentity.submatadjqty else null end endadjqty,case when adjusttype = 'END' then entryentity.subentryentity.submatadjamt else null end endadjamt,entryentity.subentryentity.calckeycol as calckeycol";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-wipAdjustBill", (String)"aca_wipadjustbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDataSet.getRowMeta().getFieldNames()));
        fieldNames.remove("startadjamt");
        fieldNames.remove("endadjamt");
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.add("case when endadjamt is not null then endadjamt else endProAdjamt end as endadjamt");
        fieldNames.add("case when startadjamt is not null then startadjamt else startProAdjamt end as startadjamt");
        fieldNames.add("case when subMatId>0 then 0 else 1 end as isMfg");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        resultDataSet = resultDataSet.select(fieldNames.toArray(new String[0]));
        resultDataSet = resultDataSet.groupBy(new String[]{"costCenterId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "subMatId", "subMatVerId", "subMatAuxId", "elementId", "subElementId", "matUnitPrecision", "subMatUnitPrecision", "isMfg", "outsourcetype", "calckeycol"}).sum("startadjqty").sum("startadjamt").sum("endadjqty").sum("endadjamt").finish();
        return resultDataSet;
    }

    public DataSet buildWipInDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.id", ">", (Object)0L);
        String selectFields = "costobject.costcenter as costCenterId, costobject as costObjectId,costobject.producttype as productType,costobject.productgroup.id as groupId,costobject.srcbillnumber as mftOrderNo,costobject.material as matId,costobject.bomversion as matVerId,costobject.auxpty.id as matAuxId,costobject.material.baseunit.precision as matUnitPrecision,entryentity.outsourcetype as outsourcetype,entryentity.element as elementId,entryentity.subelement as subElementId,entryentity.amount inAdjAmt,entryentity.subentryentity.submateriel as subMatId,entryentity.subentryentity.submatversion as subMatVerId,entryentity.subentryentity.subauxpty as subMatAuxId,entryentity.subentryentity.submateriel.baseunit.precision as subMatUnitPrecision,entryentity.subentryentity.subqty inSubAdjQty,entryentity.subentryentity.subamount inSubAdjAmt,entryentity.subentryentity.calckeycol as calckeycol";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-wipAdjustBill", (String)"aca_ewipenter", (String)selectFields, (QFilter[])filter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDataSet.getRowMeta().getFieldNames()));
        fieldNames.remove("inSubAdjAmt");
        fieldNames.remove("inAdjAmt");
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.add("case when inSubAdjAmt is not null then inSubAdjAmt else inAdjAmt end as inSubAdjAmt");
        fieldNames.add("case when subMatId>0 then 0 else 1 end as isMfg");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        resultDataSet = resultDataSet.select(fieldNames.toArray(new String[0]));
        resultDataSet = resultDataSet.groupBy(new String[]{"costCenterId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "subMatId", "subMatVerId", "subMatAuxId", "elementId", "subElementId", "matUnitPrecision", "subMatUnitPrecision", "isMfg", "outsourcetype", "calckeycol"}).sum("inSubAdjQty").sum("inSubAdjAmt").finish();
        return resultDataSet;
    }

    public OrmInput buildAdjustSubCalcResultDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.subentryentity.id", ">", (Object)0L);
        String selectFields = "costobject as costObjectId,costobject as relaCostObjectId,entryentity.subelement as subelement,entryentity.subentryentity.submaterial as subMatId,entryentity.subentryentity.version as subMatVerId,entryentity.subentryentity.auxpty as subMatAuxId,entryentity.subentryentity.calckeycol as calckeycol,adjusttype,entryentity.subentryentity.subitemjson_tag subitemjson_tag";
        return new OrmInput("ActCostCalcInput-wipAdjustBill", "aca_wipadjustbill", selectFields, filter.toArray());
    }

    public Map<Long, Long> buildCostobjectResultIdMap(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("entryentity.relacostobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-calcResultId", (String)"aca_calcresult", (String)"entryentity.relacostobject costobject,id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            result.put(row.getLong("costobject"), row.getLong("id"));
        }
        return result;
    }

    public Map<Long, Long> buildCalcResultIdMap(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        DataSet calsResultDs = QueryServiceHelper.queryDataSet((String)"acaCalc_calcresult", (String)"aca_calcresult", (String)"costobject,id", (QFilter[])filter.toArray(), null);
        for (Row row : calsResultDs) {
            result.put(row.getLong("costobject"), row.getLong("id"));
        }
        return result;
    }

    public DataSet buildRelatedDataSet(ActCostCalcArgs args, Set<Long> groupIds) {
        QFilter filter = new QFilter("id", "in", groupIds);
        filter.and("entryentity.producttype", "in", (Object)new String[]{"A", "C"});
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-productGroup", (String)"cad_productintogroup", (String)"id as groupId,entryentity.material.id as matId,entryentity.matversion as matVerId,entryentity.auxpty as matAuxId,entryentity.producttype as productType,entryentity.alloctype as jointAllocType,entryentity.weight as jointWeight,entryentity.weightentry.element as elementId,entryentity.weightentry.subelement as subElementId,entryentity.weightentry.allocweight as allocWeight,entryentity.weightentry.fixedamt as fixedamt", (QFilter[])filter.toArray(), null);
    }

    public void buildMainJoinGroupMap(ActCostCalcArgs args, Set<Long> productGroupIds, Map<String, BigDecimal[]> weightMap, Map<String, String> allocTypeMap) {
        DataSet productDataSet = this.buildRelatedDataSet(args, productGroupIds);
        for (Row row : productDataSet) {
            String key = row.getString("groupId") + "@" + row.get("matId") + "@" + row.get("matVerId") + "@" + row.get("matAuxId");
            String jointAllocType = row.getString("jointAllocType");
            BigDecimal jointWeight = row.getBigDecimal("jointWeight");
            weightMap.put(key, new BigDecimal[]{jointWeight, BigDecimal.ZERO});
            allocTypeMap.put(key, jointAllocType);
            BigDecimal allocWeight = row.getBigDecimal("allocWeight");
            BigDecimal fixedAmt = row.getBigDecimal("fixedamt");
            if (allocWeight == null) continue;
            String subElementkey = key + "@" + row.getString("subElementId");
            weightMap.put(subElementkey, new BigDecimal[]{allocWeight, BigDecimalUtil.getOrZero(fixedAmt)});
        }
    }

    public Set<Long> getProductIdsByCoIds(Set<Long> coIdSet) {
        QFilter filter = new QFilter("id", "in", coIdSet);
        filter.and("producttype", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-costobject", (String)"cad_costobject", (String)"id as costObjectId,material.id as matId", (QFilter[])filter.toArray(), null);
        HashSet result = Sets.newHashSet();
        for (Row row : dataSet) {
            result.add(row.getLong("matId"));
        }
        return result;
    }

    public Map<String, BigDecimal> buildInProdAllocStdVal(ActCostCalcArgs args, Set<Long> costobjectIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        if (costobjectIds == null) {
            filter.and("costobject", "=", (Object)0L);
        } else {
            filter.and("costobject", "in", costobjectIds);
        }
        DataSet completionDs = QueryServiceHelper.queryDataSet((String)"allocstdval", (String)"cad_inproallocstdval", (String)"costdriver,costcenter,costobject,allocvalue", (QFilter[])filter.toArray(), null);
        HashMap costdriverValueMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : completionDs) {
            Long costagent = this.getDefaultLongVal(row.getLong("costdriver"));
            Long costcenter = this.getDefaultLongVal(row.getLong("costcenter"));
            Long costobject = this.getDefaultLongVal(row.getLong("costobject"));
            BigDecimal allocvalue = BigDecimalUtil.getOrZero(row.getBigDecimal("allocvalue"));
            String key = String.format("%s@%s@%s", costagent, costcenter, costobject);
            costdriverValueMap.put(key, allocvalue);
        }
        return costdriverValueMap;
    }

    public Long getDefaultLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }

    public Map<String, List<ProextraPriceVo>> buildProextraPriceDataSet(ActCostCalcArgs args, Set<Long> sideProductIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("startdate", "<", (Object)args.getEndDate());
        filter.and("enddate", ">", (Object)args.getEndDate());
        filter.and("material.id", "in", sideProductIds);
        DynamicObject[] dyoColl = BusinessDataServiceHelper.load((String)"aca_proextraprice", (String)"material.id,matversion,auxpty.id,manuorg.id,costcenter.id,entryentity.id,entryentity.element,entryentity.subelement,entryentity.subelement.type,entryentity.price", (QFilter[])filter.toArray());
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyo : dyoColl) {
            String matId = dyo.getString("material.id");
            String matversion = dyo.getString("matversion");
            String auxptyId = dyo.getString("auxpty.id");
            String manuorgId = dyo.getString("manuorg.id");
            String costcenterId = dyo.getString("costcenter.id");
            matversion = matversion == null ? "0" : matversion;
            auxptyId = auxptyId == null ? "0" : auxptyId;
            manuorgId = manuorgId == null ? "0" : manuorgId;
            costcenterId = costcenterId == null ? "0" : costcenterId;
            ArrayList<ProextraPriceVo> entryValue = new ArrayList<ProextraPriceVo>(10);
            DynamicObjectCollection dynEntrys = dyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynEntry : dynEntrys) {
                ProextraPriceVo vo = new ProextraPriceVo();
                vo.setElement(dynEntry.getLong("element.id"));
                vo.setSubelement(dynEntry.getLong("subelement.id"));
                vo.setSubelementType(dynEntry.getString("subelement.type"));
                vo.setPrice(dynEntry.getBigDecimal("price"));
                entryValue.add(vo);
            }
            result.put(matId + "@" + matversion + "@" + auxptyId + "@" + manuorgId + "@" + costcenterId, entryValue);
        }
        return result;
    }

    public DataSet buildCostObjectWeightDataSet(ActCostCalcArgs args, Set<Long> allCostObjectIds) {
        QFilter filter = new QFilter("id", "in", allCostObjectIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-costobject", (String)"cad_costobject", (String)"id as costObjectId,weight as costObjectWeight,manuorg as manuorgId", (QFilter[])filter.toArray(), null);
        return dataSet;
    }

    public Map<Long, BigDecimal> buildWipCostCheckDataMap(ActCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-wipCostCheckSave", (String)"aca_wipcostchecksave", (String)"costobject,checknum", (QFilter[])filter.toArray(), (String)"modifytime");
        HashMap<Long, BigDecimal> wipCostCheckDataMap = new HashMap<Long, BigDecimal>(256);
        for (Row row : dataSet) {
            wipCostCheckDataMap.put(row.getLong("costobject"), row.getBigDecimal("checknum"));
        }
        return wipCostCheckDataMap;
    }

    public DataSet buildWipCostCheckDataDs(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-wipCostCheckSave", (String)"aca_wipcostchecksave", (String)"costobject costObjectId,finadjustqty finAdjustQty,checknum pdEndCheckQty,modifytime", (QFilter[])filter.toArray(), null);
        return dataSet.groupBy(new String[]{"costObjectId"}).maxP("modifytime", "pdEndCheckQty").maxP("modifytime", "finAdjustQty").finish();
    }

    public Set<String> buildMaterialNumberSetByMaterialIdSet(Set<Long> allMaterialIdSet) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-material", (String)"bd_material", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", allMaterialIdSet)}, null);
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : matDs) {
            result.add(row.getString("number"));
        }
        matDs.close();
        return result;
    }

    public Map<Long, String> buildFactEntryNumberMap(ActCostCalcArgs args, Set<Long> entryIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("sourcebillentry", "in", entryIds);
        String selectFields = "sourcebillentry as srcEntryId,billno";
        DataSet factned = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : factned) {
            map.put(row.getLong("srcEntryId"), row.getString("billno"));
        }
        return map;
    }

    public Map<Long, String> buildCostObjectNameMap(Set<Long> costObjectIds) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-costObjectNumber", (String)"cad_costobject", (String)"id,billno,name", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : matDs) {
            map.put(row.getLong("id"), row.getString("name"));
        }
        matDs.close();
        return map;
    }

    public Map<Long, Set<String>> buildCostObjectNumberSet(Set<Long> costObjectIds) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-costObjectNumber", (String)"cad_costobject", (String)"id,costcenter,billno,name", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : matDs) {
            Long costcenterId = row.getLong("costcenter");
            Set costobjectNums = map.computeIfAbsent(costcenterId, t -> Sets.newHashSetWithExpectedSize((int)10));
            costobjectNums.add(row.getString("name"));
        }
        return map;
    }

    public DataSet getCostObjectProIds(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("id", "in", calcCostObjectSet);
        filter.and("biztype", "=", (Object)"RO");
        filter.and("billstatus", "=", (Object)"C");
        Set<Long> assemblyCostCenterSet = args.getAssemblyCostCenterSet();
        if (!assemblyCostCenterSet.isEmpty()) {
            filter.and("costcenter", "in", assemblyCostCenterSet);
        }
        return QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE, (String)"cad_costobject", (String)"id costObjectId,probill,isoutsource", (QFilter[])new QFilter[]{filter}, null);
    }

    public DataSet buildBomSettingDataSet(ActCostCalcArgs args, DataSet bomMainJoinCostObjectDs) {
        if (bomMainJoinCostObjectDs == null || bomMainJoinCostObjectDs.isEmpty()) {
            return null;
        }
        HashSet<Long> mainMatSet = new HashSet<Long>(16);
        HashSet<Long> mainAuxptySet = new HashSet<Long>(16);
        for (Row row : bomMainJoinCostObjectDs.copy()) {
            Long material = row.getLong("material");
            Long auxpty = row.getLong("auxpty");
            mainMatSet.add(material);
            mainAuxptySet.add(auxpty);
        }
        Set<Long> costTypeSet = args.getCostTypeSet();
        DataSet bomDataSet = this.buildBomDataSet(args, costTypeSet, mainMatSet, mainAuxptySet);
        if (bomDataSet != null) {
            return bomDataSet.join(bomMainJoinCostObjectDs).on("material", "material").on("auxpty", "auxpty").select(bomDataSet.getRowMeta().getFieldNames(), new String[]{"costObjectId"}).finish();
        }
        return null;
    }

    private DataSet buildBomDataSet(ActCostCalcArgs args, Set<Long> costTypeSet, Set<Long> mainMatSet, Set<Long> mainAuxptySet) {
        QFilter costTypeQf = new QFilter("costtype", "in", costTypeSet);
        QFilter materialQf = new QFilter("material", "in", mainMatSet);
        QFilter auxptyQf = new QFilter("auxprop", "in", mainAuxptySet);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        DataSet bomSettingDs = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE.concat("bomsetting"), (String)"cad_bomsetting", (String)"costtype,material,auxprop,bom,considersubmaterialloss subMatLoss,lossrateformula,considervalidperiod validPeriod", (QFilter[])new QFilter[]{costTypeQf, materialQf, auxptyQf, enableQf, statusQf}, (String)"id desc");
        if (bomSettingDs != null && !bomSettingDs.isEmpty()) {
            HashSet<Long> bomSet = new HashSet<Long>(16);
            DataSet bomSettings = bomSettingDs.copy();
            for (Row bomSetting : bomSettings) {
                long bom = bomSetting.getLong("bom");
                bomSet.add(bom);
            }
            if (!bomSet.isEmpty()) {
                QFilter idQf = new QFilter("id", "in", bomSet);
                DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE.concat("bom"), (String)"cad_costbom", (String)"id,number,material,material.name matName,auxproperty auxpty,entry.entrymaterial subMaterialId,entry.entrymaterial.name subMatName,entry.entryauxproperty subauxpty,entry.entryqtynumerator fz,entry.entryqtydenominator fm,entry.entryfixscrap gdshl,entry.entryscraprate bdshl,entry.entryvaliddate effectDate,entry.entryinvaliddate validDate,entry.entryqtytype qtytype", (QFilter[])new QFilter[]{idQf}, (String)"id desc");
                DataSet middleDs = bomSettingDs.join(bomDataSet, JoinType.INNER).on("bom", "id").select(new String[]{"costtype", "subMatLoss", "lossrateformula", "validPeriod"}, new String[]{"number", "material", "matName", "auxpty", "subMaterialId", "subMatName", "subauxpty", "fz", "fm", "gdshl", "bdshl", "effectDate", "validDate", "qtytype"}).finish();
                if (middleDs != null && !middleDs.isEmpty()) {
                    Date endDate = args.getEndDate();
                    ArrayList<Object[]> dataTable = new ArrayList<Object[]>();
                    for (Row row : middleDs) {
                        Object[] columns = new Object[6];
                        columns[0] = row.getLong("costtype");
                        columns[1] = row.getLong("material");
                        columns[2] = row.getLong("auxpty");
                        columns[3] = row.getLong("subMaterialId");
                        columns[4] = row.getLong("subauxpty");
                        Boolean subMatLoss = row.getBoolean("subMatLoss");
                        Boolean validPeriod = row.getBoolean("validPeriod");
                        String lossRateFormula = row.getString("lossrateformula");
                        Date effectDate = row.getDate("effectDate");
                        Date validDate = row.getDate("validDate");
                        String qtyType = row.getString("qtytype");
                        BigDecimal fz = row.getBigDecimal("fz");
                        BigDecimal fm = row.getBigDecimal("fm");
                        BigDecimal gdshl = row.getBigDecimal("gdshl");
                        BigDecimal bdshl = row.getBigDecimal("bdshl");
                        if (BigDecimal.ZERO.compareTo(fm) == 0) {
                            String errStr = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b50\u7269\u6599\u5355\u4f4d\u8017\u7528\u91cf\u5931\u8d25\uff0c\u6210\u672cBOM\u201c%1$s\u201d\u7ec4\u4ef6\u7269\u6599\u201c%2$s\u201d\u5206\u6bcd\u8bbe\u7f6e\u4e3a\u96f6\u3002", (String)"ActCostCalcDataInputFactory_13", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("number"), row.getString("subMatName"));
                            ActCalcFunctionHelper.insertCalcErrorInfo(args.getLevelEntryId(), (Long)0L, errStr);
                            continue;
                        }
                        BigDecimal unitQty = fz.divide(fm, 10, 4);
                        if (subMatLoss.booleanValue()) {
                            if ("A".equals(qtyType)) {
                                unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(bdshl), 10, 4) : unitQty.multiply(BigDecimal.ONE.add(bdshl)).setScale(10, 4);
                            } else if ("B".equals(qtyType)) {
                                unitQty = unitQty.add(gdshl);
                            } else if ("C".equals(qtyType)) {
                                unitQty = unitQty.add(gdshl);
                            }
                        }
                        columns[5] = unitQty;
                        if (validPeriod.booleanValue()) {
                            boolean afterEffect = endDate.after(effectDate);
                            boolean beforeValid = endDate.before(validDate);
                            if (!afterEffect || !beforeValid) {
                                logger.info("\u6210\u672cBOM\u7f16\u53f7{}\u7ec4\u4ef6\u7269\u6599{}\u751f\u6548\u671f\u4e0d\u5305\u542b\u6210\u672c\u8d26\u7c3f\u5f53\u671f\u671f\u95f4\u7684\u7ed3\u675f\u65f6\u95f4,\u8df3\u8fc7\u3002", (Object)row.getString("number"), (Object)row.getString("subMatName"));
                                continue;
                            }
                        }
                        dataTable.add(columns);
                    }
                    return this.createBomRsDs(dataTable);
                }
            }
        }
        return null;
    }

    private Map<String, String> getAcaSubElementByOrg(Long orgId, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>> matInformationSet) {
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{orgId, matInformationSet, "0"});
        return matIdToPairMap;
    }

    private DataSet createBomRsDs(List<Object[]> dataTable) {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(new Field("costtype", (DataType)DataType.LongType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        fields.add(new Field("auxpty", (DataType)DataType.LongType));
        fields.add(new Field("subMaterialId", (DataType)DataType.LongType));
        fields.add(new Field("subauxpty", (DataType)DataType.LongType));
        fields.add(new Field("unitQty", (DataType)DataType.BigDecimalType));
        return Algo.create((String)ALGOKEY_PRE.concat("bomRs")).createDataSet(dataTable.iterator(), new RowMeta(fields.toArray(new Field[0]))).groupBy(new String[]{"costtype", "material", "auxpty", "subMaterialId", "subauxpty"}).sum("unitQty").finish();
    }

    public DataSet buildAssemblyDataSet(ActCostCalcArgs args, DataSet mainJoinSideCostobjectCopyDs) {
        if (mainJoinSideCostobjectCopyDs == null || mainJoinSideCostobjectCopyDs.isEmpty()) {
            return null;
        }
        HashSet proBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proOmBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proMainAndJoinBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proOmMainAndJoinBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        DataSet costobjectProIdCopyDs = mainJoinSideCostobjectCopyDs.copy();
        for (Row row : costobjectProIdCopyDs) {
            Long probill = row.getLong("probill");
            if (Boolean.FALSE.equals(row.getBoolean("isoutsource"))) {
                if ("C".equals(row.getString("producttype"))) {
                    proBillEntrySet.add(probill);
                }
                proMainAndJoinBillEntrySet.add(probill);
                continue;
            }
            if ("C".equals(row.getString("producttype"))) {
                proOmBillEntrySet.add(probill);
            }
            proOmMainAndJoinBillEntrySet.add(probill);
        }
        DataSet proComDataSet = this.buildComAssemblyDataSet(proMainAndJoinBillEntrySet, proOmMainAndJoinBillEntrySet);
        DataSet proDetailDataSet = this.buildDetailAssemblyDataSet(proBillEntrySet, proOmBillEntrySet);
        if (proDetailDataSet == null || proComDataSet == null) {
            return null;
        }
        DataSet mainCostobjectDs = mainJoinSideCostobjectCopyDs.copy().filter("producttype='C'");
        DataSet mftOrderStockDs = mainJoinSideCostobjectCopyDs.leftJoin(proComDataSet).on("probill", "entryid").select(mainJoinSideCostobjectCopyDs.getRowMeta().getFieldNames(), new String[]{"stockqty"}).finish().groupBy(new String[]{"mainCostobjectId"}).sum("stockqty").finish();
        DataSet mainJoinSideCostobjectStockDs = mainCostobjectDs.leftJoin(mftOrderStockDs).on("mainCostobjectId", "mainCostobjectId").select(new String[]{"mainCostobjectId", "probill"}, new String[]{"stockqty"}).finish();
        Set materialIds = Sets.newConcurrentHashSet();
        DataSet proCopyDataSet = proDetailDataSet.copy();
        for (Row row : proCopyDataSet) {
            Long subMaterialId = row.getLong("subMaterialId");
            if (CadEmptyUtils.isEmpty((Long)subMaterialId)) continue;
            materialIds.add(subMaterialId);
        }
        DataSet auxAffectMatDs = this.getAffectPriceDs(materialIds);
        proDetailDataSet = proDetailDataSet.leftJoin(auxAffectMatDs).on("subMaterialId", "effectpricemat").select(new String[]{"orderentryid", "subMaterialId", "useqty", "case when effectpricemat>0 then subauxpty else 0L end subauxpty"}).finish().groupBy(new String[]{"orderentryid", "subMaterialId", "subauxpty"}).sum("useqty").finish();
        return mainJoinSideCostobjectStockDs.join(proDetailDataSet).on("probill", "orderentryid").select(new String[]{"mainCostobjectId costObjectId", "stockqty", "subMaterialId", "subauxpty", "useqty"}).finish();
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mat", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    public DataSet buildComAssemblyDataSet(Set<Long> proBillEntrySet, Set<Long> proOmBillEntrySet) {
        QFilter entryIdQf;
        DataSet mftStockDs = null;
        DataSet mftOmStockDs = null;
        if (!proBillEntrySet.isEmpty()) {
            entryIdQf = new QFilter("treeentryentity.id", "in", proBillEntrySet);
            mftStockDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mftOrder", (String)"pom_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty", (QFilter[])new QFilter[]{entryIdQf}, null);
        }
        if (!proOmBillEntrySet.isEmpty()) {
            entryIdQf = new QFilter("treeentryentity.id", "in", proOmBillEntrySet);
            mftOmStockDs = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mftOrder", (String)"om_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty", (QFilter[])new QFilter[]{entryIdQf}, null);
        }
        if (mftStockDs == null || mftOmStockDs == null) {
            if (mftStockDs != null) {
                return mftStockDs;
            }
            if (mftOmStockDs != null) {
                return mftOmStockDs;
            }
            return null;
        }
        return DataSetHelper.union(mftStockDs, mftOmStockDs);
    }

    public DataSet buildDetailAssemblyDataSet(Set<Long> proBillEntrySet, Set<Long> proOmBillEntrySet) {
        DataSet assemblyDataSet = null;
        DataSet omAssemblyDataSet = null;
        if (!proBillEntrySet.isEmpty()) {
            QFilter orderEntryQf = new QFilter("orderentryid", "in", proBillEntrySet);
            String selectSql = "orderentryid,stockentry.materielmasterid AS subMaterialId,stockentry.childauxpropertyid subauxpty,stockentry.demandqty AS useqty";
            boolean ne = this.isContainsProperty("pom_mftstock", "iscannegative");
            if (ne) {
                selectSql = selectSql + ",stockentry.iscannegative iscannegative";
            }
            assemblyDataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mftStock", (String)"pom_mftstock", (String)selectSql, (QFilter[])new QFilter[]{orderEntryQf}, null);
            if (ne) {
                assemblyDataSet = this.dealNegativeQty(assemblyDataSet);
            }
        }
        if (!proOmBillEntrySet.isEmpty()) {
            String selectSql = "orderentryid,stockentry.materielmasterid AS subMaterialId,stockentry.childauxpropertyid subauxpty,stockentry.demandqty AS useqty";
            boolean ne = this.isContainsProperty("om_mftstock", "iscannegative");
            if (ne) {
                selectSql = selectSql + ",stockentry.iscannegative iscannegative";
            }
            QFilter orderEntryQf = new QFilter("orderentryid", "in", proOmBillEntrySet);
            omAssemblyDataSet = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mftStock", (String)"om_mftstock", (String)selectSql, (QFilter[])new QFilter[]{orderEntryQf}, null);
            if (ne) {
                omAssemblyDataSet = this.dealNegativeQty(omAssemblyDataSet);
            }
        }
        if (assemblyDataSet == null || omAssemblyDataSet == null) {
            if (assemblyDataSet != null) {
                return assemblyDataSet;
            }
            if (omAssemblyDataSet != null) {
                return omAssemblyDataSet;
            }
            return null;
        }
        return DataSetHelper.union(assemblyDataSet, omAssemblyDataSet);
    }

    private boolean isContainsProperty(String meta, String property) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)meta);
        IDataEntityProperty per = mainEntityType.findProperty(property);
        return per != null;
    }

    private DataSet dealNegativeQty(DataSet ds) {
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        fieldNames.remove("useqty");
        fieldNames.remove("iscannegative");
        fieldNames.add("case when iscannegative=true then -useqty else useqty end as useqty");
        return ds.select(fieldNames.toArray(new String[0]));
    }

    public DataSet buildSubElementTypeDataSet() {
        QFilter qfType = new QFilter("type", "in", (Object)new String[]{"001", "002"});
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-SubElementTypeDataSet", (String)"cad_subelement", (String)"id,type as subElementType", (QFilter[])new QFilter[]{qfType}, null);
    }

    public DynamicObjectCollection getGradeProductsByIds(Set<Long> gradeGroupIds) {
        Date nowTime = new Date();
        QFilter filter = new QFilter("id", "in", gradeGroupIds);
        filter.and("grouptype", "=", (Object)"2");
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)true);
        filter.and("effectdate", "<=", (Object)nowTime);
        filter.and("expdate", ">", (Object)nowTime);
        return QueryServiceHelper.query((String)"cad_productintogroup", (String)"id,groupfield,srcfield,entryentity.material as matid,entryentity.groupcategory as groupcategory,entryentity.auxpty as auxpty,entryentity.weight as weight", (QFilter[])new QFilter[]{filter});
    }

    public void buildGradeProductByGroupIds(Set<Long> gradeGroupIds, Map<Long, String> matGroFieMap, Map<String, BigDecimal> matCateMap, Map<String, String> srcFieldMap) {
        DynamicObjectCollection dynamicObjects = this.getGradeProductsByIds(gradeGroupIds);
        if (!dynamicObjects.isEmpty()) {
            srcFieldMap.put("bd_auxproperty", "auxpty");
            srcFieldMap.put("bd_invtype", "invtype");
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long matId = dynamicObject.getLong("matid");
                String groupField = dynamicObject.getString("groupfield");
                String srcField = dynamicObject.getString("srcfield");
                long groupCategoryId = dynamicObject.getLong("groupcategory");
                long auxId = dynamicObject.getLong("auxpty");
                BigDecimal weight = dynamicObject.getBigDecimal("weight");
                if (!srcFieldMap.containsKey(groupField) && !CadEmptyUtils.isEmpty((String)srcField)) {
                    srcFieldMap.put(groupField, srcField);
                }
                matGroFieMap.put(matId, groupField);
                if (groupField.equals("bd_auxproperty")) {
                    matCateMap.put(matId + "@" + auxId, weight);
                    continue;
                }
                matCateMap.put(matId + "@" + groupCategoryId, weight);
            }
        }
    }

    public boolean getCalcConcurrencyMode() {
        try {
            int val = CadBgParamUtils.getCadParamForInt((String)"acaCalcOutParallel", (int)0);
            if (val == 1) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return false;
    }

    public DynamicObjectCollection getCategoryNameByIds(String entityName, Set<Long> ids) {
        return QueryServiceHelper.query((String)entityName, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public String getInventoryMode(ActCostCalcArgs args) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)args.getOrgId())};
        DynamicObject dyCheckSetting = QueryServiceHelper.queryOne((String)"aca_checksetting", (String)"checktype", (QFilter[])filters);
        return dyCheckSetting != null ? dyCheckSetting.getString("checktype") : "qty";
    }

    public DataSet buildInventoryAllocData(ActCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)args.getOrgId()), new QFilter("costaccount", "=", (Object)args.getCostAccountId()), new QFilter("period", "=", (Object)args.getPeriodId()), new QFilter("costobject", "in", calcCostObjectSet)};
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE, (String)"aca_terminalwipmatallco", (String)"costobject.costcenter costCenterId,costobject costObjectId,material matId,auxpty,calqty inventValue", (QFilter[])filters, null);
        ds = ds.groupBy(new String[]{"costCenterId", "costObjectId", "matId", "auxpty"}).sum("inventValue").finish();
        return ds;
    }

    public Set<String> getSecondDevGradeField(ActCostCalcArgs args) {
        HashSet<String> set = new HashSet<String>(3);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("grouptype", "=", (Object)"2");
        filter.and("groupfield", "not in", (Object)Sets.newHashSet((Object[])new String[]{"bd_invtype", "bd_auxproperty"}));
        filter.and("effectdate", "<", (Object)new Date());
        filter.and("expdate", ">=", (Object)new Date());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_productintogroup", (String)"srcfield", (QFilter[])new QFilter[]{filter});
        if (!dynamicObjects.isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill");
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicProperty property;
                String srcField = dynamicObject.getString("srcfield");
                if (CadEmptyUtils.isEmpty((String)srcField) || (property = mainEntityType.getProperty(srcField)) == null) continue;
                set.add(srcField);
            }
        }
        return set;
    }

    public DataSet buildOnlySideFactAllocDs(Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap) {
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry<Long, Map<Long, AcaResultFinalResultVO>> entry : calcCostobjectFinalResultMap.entrySet()) {
            boolean isOnlySideFactned = ActCalcFunctionHelper.isOnlySideFactned(entry.getValue());
            if (!isOnlySideFactned) continue;
            costobjectIds.add(entry.getKey());
        }
        if (costobjectIds.isEmpty()) {
            return null;
        }
        QFilter mainFilter = new QFilter("id", "in", (Object)costobjectIds);
        String selectMainFields = "costcenter as costCenterId,id as costObjectId,producttype as productType,productgroup.id as groupId,srcbillnumber as mftOrderNo,material as matId,bomversion as matVerId,auxpty as matAuxId,material.baseunit.precision as matUnitPrecision,0L as subMatId,0L as subMatVerId,0L as subMatAuxId,0 as subMatUnitPrecision,0L as elementId,0L as subElementId,0.0 as amount,1 as isMfg,'' as outsourcetype";
        return QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mfgMainAllocCo", (String)"cad_costobject", (String)selectMainFields, (QFilter[])mainFilter.toArray(), null);
    }

    public DataSet buildMfgJoinByFeeAllocDataSet(ActCostCalcArgs args, Set<Long> calcCostObjectSet, Map<Long, Long> joinByMainMap) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobject", "in", calcCostObjectSet);
        String selectFields = "entryentity.costobject as costObjectId,0L as subMatId,0L as subMatVerId,0L as subMatAuxId,0 as subMatUnitPrecision,element as elementId,subelement as subElementId,entryentity.allocamt as amount,1 as isMfg,entryentity.outsourcetype as outsourcetype";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mfgJoinByAllocCo", (String)"cad_mfgfeeallocco", (String)selectFields, (QFilter[])filter.toArray(), null);
        if (dataset.isEmpty()) {
            return null;
        }
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u6761\u4ef6:%s", (String)"ActCostCalcDataInputFactory_11", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        ArrayList lists = Lists.newArrayList();
        joinByMainMap.forEach((x, y) -> lists.add(new Object[]{x, y}));
        DataSet dataSetJM = Algo.create((String)"macc.sca.ActCostCalcDataInputFactory").createDataSet(lists.iterator(), new RowMeta(new Field[]{new Field("costObjectJoinId", (DataType)DataType.LongType), new Field("costObjectMainId", (DataType)DataType.LongType)}));
        QFilter mainFilter = new QFilter("id", "in", new HashSet<Long>(joinByMainMap.values()));
        String selectMainFields = "costcenter as costCenterId,id as costObjectId,producttype as productType,productgroup.id as groupId,srcbillnumber as mftOrderNo,material as matId,bomversion as matVerId,auxpty as matAuxId,material.baseunit.precision as matUnitPrecision";
        DataSet mainDataset = QueryServiceHelper.queryDataSet((String)"ActCostCalcInput-mfgMainAllocCo", (String)"cad_costobject", (String)selectMainFields, (QFilter[])mainFilter.toArray(), null);
        DataSet joinReCosDS = dataset.join(dataSetJM, JoinType.INNER).on("costObjectId", "costObjectJoinId").select(new String[]{"subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "elementId", "subElementId", "amount", "isMfg", "outsourcetype"}, new String[]{"costObjectMainId as costObjectId"}).finish();
        DataSet joinReMainDS = joinReCosDS.join(mainDataset, JoinType.INNER).on("costObjectId", "costObjectId").select(joinReCosDS.getRowMeta().getFieldNames(), new String[]{"costCenterId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "matUnitPrecision"}).finish();
        DataSet resultDS = joinReMainDS.select(new String[]{"costCenterId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "matUnitPrecision", "subMatId", "subMatVerId", "subMatAuxId", "subMatUnitPrecision", "elementId", "subElementId", "amount", "isMfg", "outsourcetype"});
        return resultDS;
    }
}

