/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.macc.aca.algox.constants.TerminalCalcCheck;
import kd.macc.aca.algox.costcalc.ActCalcTaskType;
import kd.macc.aca.algox.costcalc.ActCostCalcContext;
import kd.macc.aca.algox.costcalc.ActCostCalcResultManager;
import kd.macc.aca.algox.costcalc.action.ActCalcCallCalOutException;
import kd.macc.aca.algox.costcalc.action.ActCalcExtAfterExecAction;
import kd.macc.aca.algox.costcalc.action.ActCalcExtBeforeExecAction;
import kd.macc.aca.algox.costcalc.action.IActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ActCostCalcResult;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.algox.utils.CalcReportHelper;
import kd.sdk.macc.aca.extpoint.IActCostCalcPlugin;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ActCostCalcEngine {
    private static final Log logger = LogFactory.getLog(ActCostCalcEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActCostCalcResult actPeriodEndCalc(ActCostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("ActPeriodEndCalc", costCalcArgs));
        ActCostCalcContext context = new ActCostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(ActCalcTaskType.PeriodEndCalc);
        context.setTaskConfigId(TerminalCalcCheck.CALCTASKID);
        ActCostCalcResultManager resultManager = new ActCostCalcResultManager();
        try {
            long start = System.currentTimeMillis();
            logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u5f00\u59cb\uff1a");
            ActCostCalcResult result = this.doCalculate(context, resultManager);
            logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            ActCostCalcResult actCostCalcResult = result;
            return actCostCalcResult;
        }
        catch (ActCalcCallCalOutException e) {
            logger.error("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u51fa\u5e93\u6838\u7b97\u63a5\u53e3\u62a5\u9519\uff1a", (Throwable)((Object)e));
            this.writeErroToTaskRecordForActCalcCallCalOutException(costCalcArgs.getTaskRecordId(), e, costCalcArgs);
            ActCostCalcResult actCostCalcResult = this.getCalcResult(context, resultManager, false);
            return actCostCalcResult;
        }
        catch (Exception e) {
            logger.error("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u62a5\u9519\uff1a", (Throwable)e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e, costCalcArgs);
            ActCostCalcResult actCostCalcResult = this.getCalcResult(context, resultManager, false);
            return actCostCalcResult;
        }
        finally {
            logger.info("ActPeriodEndCalc-\u91ca\u653e\u7f51\u63a7");
            if (costCalcArgs.getManuOrgId() == null) {
                costCalcArgs.setManuOrgId(0L);
            }
            ThreadPools.executeOnce((String)"ActDeleteExpiredCalcResultAction.deleteCalcResult", () -> {
                try (TXHandle h = TX.requiresNew();){
                    this.deleteCalcResult();
                }
            });
            AcaMutexHelper.releaseMutex(AcaMutexEnum.CALC_CALCULATE, costCalcArgs.getCostAccountId());
            DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)costCalcArgs.getTaskRecordId(), (String)"sca_taskrecord");
            if (taskRecord != null) {
                CalcReportHelper.updateCalcRreport(costCalcArgs.getCalcReportId(), taskRecord);
            }
        }
    }

    private void deleteCalcResult() {
        QFilter filter = new QFilter("org", "=", (Object)999999);
        int x = DeleteServiceHelper.delete((String)"aca_calcresult", (QFilter[])filter.toArray());
        logger.info("\u3010\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\u3011\u5df2\u5220\u9664 {} \u6761\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)x);
    }

    public ActCostCalcResult actPeriodEndCalcCheck(ActCostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("ActPeriodEndCalcCheck", costCalcArgs));
        costCalcArgs.setCheckWay(0);
        costCalcArgs.setCalc(false);
        ActCostCalcContext context = new ActCostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(ActCalcTaskType.PeriodEndCalcCheck);
        context.setTaskConfigId(TerminalCalcCheck.CALCTASKID);
        ActCostCalcResultManager resultManager = new ActCostCalcResultManager();
        try {
            return this.doCalculate(context, resultManager);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e, costCalcArgs);
            return this.getCalcResult(context, resultManager, false);
        }
    }

    private ActCostCalcResult doCalculate(ActCostCalcContext context, ActCostCalcResultManager resultManager) {
        PluginProxy pluginProxy = null;
        if (context.getTaskType() == ActCalcTaskType.PeriodEndCalc) {
            pluginProxy = PluginProxy.create(null, IActCostCalcPlugin.class, (String)"MACC_ACA_COSTCALC", null);
            logger.info("\u6210\u672c\u8ba1\u7b97\u6269\u5c55\u63d2\u4ef6\uff0cpluginList\uff1a{}", (Object)pluginProxy.getPlugins());
        }
        logger.info("context.getTaskType() " + (Object)((Object)context.getTaskType()));
        List<IActCalcAction> actions = IActCalcAction.create(context.getTaskType(), context.getInputArgs().isOnlycheckresult());
        logger.info("context.getTaskType() " + actions.size());
        for (IActCalcAction action : actions) {
            action.setContext(context);
            action.setResultManager(resultManager);
            if (action instanceof ActCalcExtAfterExecAction) {
                ((ActCalcExtAfterExecAction)action).setPluginProXy((PluginProxy<IActCostCalcPlugin>)pluginProxy);
            } else if (action instanceof ActCalcExtBeforeExecAction) {
                ((ActCalcExtBeforeExecAction)action).setPluginProXy((PluginProxy<IActCostCalcPlugin>)pluginProxy);
            }
            logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97doAction\uff1a{}\uff0c\u5f00\u59cb", action.getClass());
            long start = System.currentTimeMillis();
            action.execute();
            logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97doAction\u7ed3\u675f\uff1a{}\uff0c\u7ed3\u675f\uff1a\u8017\u65f6\uff1a{}", action.getClass(), (Object)(System.currentTimeMillis() - start));
            if (!resultManager.isSkipNextAction()) continue;
            break;
        }
        return this.getCalcResult(context, resultManager, true);
    }

    private ActCostCalcResult getCalcResult(ActCostCalcContext context, ActCostCalcResultManager resultManager, boolean isSuccess) {
        ActCostCalcResult result = resultManager.buildResult();
        result.setAllSuccess(isSuccess);
        if (context.getTaskType() == ActCalcTaskType.PeriodEndCalcCheck) {
            String checkSattus = "4";
            if (context.getCheckNoPassCount() > 0) {
                checkSattus = "3";
            } else if (context.getCheckRemaindCount() > 0) {
                checkSattus = "5";
            }
            result.setCalcStatus(checkSattus);
        } else {
            result.setCalcStatus(resultManager.getTaskRecorder().getTaskRecord().getStatus());
        }
        result.setCalcReportId(context.getInputArgs().getCalcReportId());
        result.setCheckResultId(context.getInputArgs().getCheckResultId());
        result.setTaskRecordId(context.getInputArgs().getTaskRecordId());
        return result;
    }

    private void writeErroToTaskRecordForActCalcCallCalOutException(Long taskRecordId, ActCalcCallCalOutException ex, ActCostCalcArgs args) {
        if (taskRecordId == null || ex == null) {
            return;
        }
        Map<Long, Map<String, String>> failMatInfosMap = ex.getFailMatInfosMap();
        String error = String.format(ResManager.loadKDString((String)"\u5171\u6709  %s \u4e2a\u7269\u6599\u51fa\u5e93\u6838\u7b97\u5931\u8d25\uff0c\u8bf7\u8054\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u3002", (String)"ActCostCalcEngine_9", (String)"macc-aca-algox", (Object[])new Object[0]), failMatInfosMap.size());
        JSONObject params = new JSONObject();
        Date startTime = ex.getStartTime();
        Date endTime = ex.getEndTime();
        params.accumulate("startTime", (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(startTime));
        params.accumulate("endTime", (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(endTime));
        params.accumulate("orgId", (Object)args.getOrgId());
        params.accumulate("costaccountId", (Object)args.getCostAccountId());
        String jsonStr = params.toString();
        logger.info("writeErroToTaskRecordForActCalcCallCalOutException:" + jsonStr);
        this.writeErrorTaskRecordByParam(taskRecordId, args, error, jsonStr, "cal_calculateoutrpt");
    }

    private void writeErroToTaskRecord(Long taskRecordId, Exception ex, ActCostCalcArgs args) {
        if (taskRecordId == null || ex == null) {
            return;
        }
        String errormsg = ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458\u3002", (String)"ActCostCalcEngine_10", (String)"macc-aca-algox", (Object[])new Object[0]);
        String errInfo = this.wrapExceptionErrorInfo(ex);
        if (ex instanceof KDBizException) {
            if (!kd.bos.util.StringUtils.isEmpty((String)ex.getMessage())) {
                errormsg = ex.getMessage();
                errInfo = ex.getMessage();
            }
        } else if (ex instanceof AlgoException) {
            int i = 5;
            Throwable th = ex;
            while (th.getCause() != null && !((th = th.getCause()) instanceof KDBizException) && --i >= 0) {
            }
            if (th instanceof KDBizException && !kd.bos.util.StringUtils.isEmpty((String)th.getMessage())) {
                errormsg = th.getMessage();
                errInfo = th.getMessage();
            }
        }
        this.writeErrorTaskRecordByParam(taskRecordId, args, errormsg, errInfo, null);
    }

    private void writeErrorTaskRecordByParam(Long taskRecordId, ActCostCalcArgs args, String errInfo, String subParam, String subNextEntity) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)taskRecordId, (String)"sca_taskrecord", (String)"id,progress,time,starttime,status,nextpagepara,entryentity.seq,entryentity.subname,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subnextentity,entryentity.subparam,entryentity.subparam_tag");
        if (record == null) {
            return;
        }
        Long time = AcaAlgoxTimeUtils.getSecond(record.getDate("starttime"), new Date());
        if (Long.compare(0L, time) == 0) {
            time = 1L;
        }
        record.set("progress", (Object)100);
        record.set("time", (Object)time);
        record.set("status", (Object)"3");
        if (args != null) {
            JSONObject pagePara = new JSONObject();
            pagePara.accumulate("orgId", (Object)args.getOrgId());
            pagePara.accumulate("costAccountId", (Object)args.getCostAccountId());
            pagePara.accumulate("periodId", (Object)args.getPeriodId());
            pagePara.accumulate("manuorgId", args.getManuOrgId() == null ? 0L : args.getManuOrgId());
            pagePara.accumulate("time", (Object)time);
            pagePara.accumulate("checkFailCount", 0);
            pagePara.accumulate("failCcCount", 0);
            pagePara.accumulate("successCcCount", 0);
            pagePara.accumulate("successCoCount", 0);
            pagePara.accumulate("checkResultId", (Object)args.getCheckResultId());
            pagePara.accumulate("calcReportId", (Object)args.getCalcReportId());
            record.set("nextpagepara", (Object)pagePara.toString());
        }
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        DynamicObject doingEntry = null;
        for (DynamicObject entry : entrys) {
            if ("2".equals(entry.getString("substatus"))) {
                doingEntry = entry;
                break;
            }
            if (doingEntry != null || !"1".equals(entry.getString("substatus"))) continue;
            doingEntry = entry;
        }
        if (doingEntry == null) {
            if (!entrys.isEmpty()) {
                doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
            } else {
                doingEntry = entrys.addNew();
                doingEntry.set("subname", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"ActCostCalcEngine_11", (String)"macc-aca-algox", (Object[])new Object[0]));
                doingEntry.set("seq", (Object)(entrys.size() + 1));
            }
        }
        if (doingEntry != null) {
            if (doingEntry.getInt("subtime") == 0) {
                doingEntry.set("substarttime", (Object)new Date());
                doingEntry.set("subtime", (Object)"1");
            }
            doingEntry.set("substatus", (Object)"3");
            doingEntry.set("detail", (Object)(errInfo.length() > 255 ? errInfo.substring(0, 255) : errInfo));
            if (kd.bos.util.StringUtils.isNotEmpty((String)subNextEntity)) {
                doingEntry.set("subnextentity", (Object)subNextEntity);
            }
            String infoMsg = doingEntry.getString("subparam_tag");
            infoMsg = kd.bos.util.StringUtils.isNotEmpty((String)subNextEntity) && "cal_calculateoutrpt".equals(subNextEntity) ? subParam : infoMsg + subParam;
            if (errInfo.contains(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38", (String)"ActCostCalcEngine_13", (String)"macc-aca-algox", (Object[])new Object[0]))) {
                doingEntry.set("subparam", (Object)ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u53f3\u8fb9\u6309\u94ae\u67e5\u770b\u8be6\u60c5\u3002", (String)"ActCostCalcEngine_14", (String)"macc-aca-algox", (Object[])new Object[0]));
            } else {
                doingEntry.set("subparam", (Object)"");
            }
            doingEntry.set("subparam_tag", (Object)StringUtils.substring((String)infoMsg, (int)0, (int)2000000));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    public String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        erroStr.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        return erroStr.toString();
    }

    private String buildLogMessage(String mothedName, ActCostCalcArgs costCalcArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-", (String)"ActCostCalcEngine_12", (String)"macc-aca-algox", (Object[])new Object[0])).append(mothedName).append(": ");
        sb.append("isCalc=").append(costCalcArgs.getCalc()).append(", ");
        sb.append("checkResult=").append(costCalcArgs.getCheckResultId()).append(", ");
        sb.append("org=").append(costCalcArgs.getOrgId()).append(", ");
        sb.append("costAcct=").append(costCalcArgs.getCostAccountId()).append(", ");
        sb.append("period=").append(costCalcArgs.getPeriodId()).append(", ");
        return sb.toString();
    }
}

