/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.ActCalcTaskType;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.AcaAlgoxCurrencyHelper;
import kd.macc.aca.algox.utils.AcaDebugHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class ActInitializeAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActInitializeAction.class);
    private static final String CARRYNOTINAMT = "carrynotinamt";
    private static final String WIPCOSTIN_BIND_CUSTOM = "wipcostinbindcustom";
    private static final String WIPCOSTIN_ALLOC = "wipcostinalloc";
    private ActCostCalcArgs args;
    private DynamicObject costAcctObj;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        if (this.args.getCostAccountId() == null || Long.compare(0L, this.args.getCostAccountId()) == 0) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6210\u672c\u8d26\u7c3f\u53c2\u6570\u503c\u3002", (String)"ActInitializeAction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("calorg");
        selectFields.add("costtype");
        selectFields.add("calpolicy");
        selectFields.add("calpolicy.calbycostelement");
        MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
        this.costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.args.getCostAccountId(), (DynamicObjectType)subCostAcctType);
        this.checkAndInitOrg();
        this.checkAndInitPeriod();
        this.checkAndInitCurrency();
        this.checkAndInitCostType();
        this.initCheckWay();
        this.initCalByCostElement();
        if (this.getContext().getTaskType() == ActCalcTaskType.PeriodEndCalc) {
            this.initCalcCheck();
            String debugString = AcaDebugHelper.getDebugKeyword("aca_periodendcalc");
            try {
                if (StringUtils.isNotEmpty((String)debugString)) {
                    this.args.setDebugKeyword(debugString);
                    String[] ss = debugString.split("=");
                    this.args.setDebugColName(ss[0]);
                    this.args.setDebugColVal(ss[1]);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            this.setInitParam();
        }
        if (this.args.getNestmatcheck() <= 0 || this.args.getNestmatcheck() > 1000000) {
            this.args.setNestmatcheck(2000);
        }
    }

    private void setInitParam() {
        String carrynotinamt = CadBgParamUtils.getCadBgParamForString((String)CARRYNOTINAMT, (String)"true");
        this.getContext().setCarryNotInAmtCalc("true".equals(carrynotinamt));
        String wipcostBindCustom = CadBgParamUtils.getCadBgParamForString((String)WIPCOSTIN_BIND_CUSTOM, (String)"true");
        this.getContext().setWipcostinBindCustom("true".equals(wipcostBindCustom));
        String wipcostinalloc = CadBgParamUtils.getCadBgParamForString((String)WIPCOSTIN_ALLOC, (String)"0");
        this.getContext().setWipcostinAlloc(wipcostinalloc);
        if ("0".equals(wipcostinalloc)) {
            QFilter filter = new QFilter("org", "=", (Object)this.args.getOrgId());
            filter.and("costaccount", "=", (Object)this.args.getCostAccountId());
            filter.and("period", "=", (Object)this.args.getPeriodId());
            filter.and("billstatus", "=", (Object)"C");
            if (QueryServiceHelper.exists((String)"aca_ewipenter", (QFilter[])filter.toArray())) {
                this.getContext().setWipcostinExistOrg(true);
            }
        }
    }

    private void initCalcCheck() {
        QFilter filter = new QFilter("caltype", "=", (Object)"aca_terminalcalwizards_in");
        filter.and("entryentity.isenable", "=", (Object)Boolean.TRUE);
        filter.and("appnum", "=", (Object)"aca");
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"checktask", (String)"cad_checktask", (String)"entryentity.checkitem.number as checkitemnum,entryentity.level as level", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : resultDs) {
            this.getContext().getCalcCheckWarnLevelMap().put(row.getString("checkitemnum"), row.getString("level"));
        }
    }

    private void checkAndInitOrg() {
        logger.info("ActInitializeAction");
        Long calOrgId = this.costAcctObj == null ? 0L : this.costAcctObj.getLong("calorg.id");
        if (calOrgId == null || Long.compare(0L, calOrgId) == 0) {
            if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c\u3002", (String)"ActInitializeAction_1", (String)"macc-aca-algox", (Object[])new Object[0]));
            }
            return;
        }
        if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
            this.args.setOrgId(calOrgId);
        } else if (Long.compare(this.args.getOrgId(), calOrgId) != 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u4f20\u5165\u7684\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c%1$s\uff0c\u548c\u8d26\u7c3f\u7684\u6838\u7b97\u7ec4\u7ec7%2$s\u4e0d\u4e00\u81f4\u3002", (String)"ActInitializeAction_3", (String)"macc-aca-algox", (Object[])new Object[0]), this.args.getOrgId(), calOrgId));
        }
    }

    private void checkAndInitPeriod() {
        QFilter qfCostAccount;
        QFilter qfOrg;
        DynamicObject sysCtrlEntity;
        if ((this.args.getPeriodId() == null || Long.compare(0L, this.args.getPeriodId()) == 0) && (sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg = new QFilter("org", "=", (Object)this.args.getOrgId()), qfCostAccount = new QFilter("entry.costaccount", "=", (Object)this.args.getCostAccountId())})) != null) {
            this.args.setPeriodId(sysCtrlEntity.getLong("currentperiod"));
        }
        DynamicObject period = PeriodHelper.getPeriod(this.args.getPeriodId());
        this.args.setStartDate(period.getDate("begindate"));
        this.args.setEndDate(period.getDate("enddate"));
        this.args.setNextPeriodId(PeriodHelper.getNextPeriodId(this.args.getPeriodId()));
        this.args.setPrePeriodId(PeriodHelper.getPrePeriodId(this.args.getPeriodId()));
    }

    private void checkAndInitCurrency() {
        if (this.args.getCurrencyId() == null || Long.compare(0L, this.args.getCurrencyId()) == 0) {
            Long calpolicy = this.costAcctObj.getLong("calpolicy.id");
            if (calpolicy == null || Long.compare(0L, calpolicy) == 0) {
                return;
            }
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
            this.args.setCurrencyId(result.getLong("currency"));
        }
        if (this.args.getCurrencyId() != null) {
            DynamicObject dyo = AcaAlgoxCurrencyHelper.getCurrency(this.args.getCurrencyId());
            this.args.setAmtScale(dyo.getInt("amtprecision"));
            this.args.setPriceScale(dyo.getInt("priceprecision"));
        }
    }

    private void checkAndInitCostType() {
        Long costTypeId = this.costAcctObj.getLong("costtype.masterid");
        this.args.setCostTypeId(costTypeId);
    }

    private void initCheckWay() {
        if (this.getContext().getTaskType() == ActCalcTaskType.PeriodEndCalcCheck) {
            this.args.setCheckWay(0);
        } else {
            this.args.setCheckWay(1);
        }
    }

    private void initCalByCostElement() {
        if (this.costAcctObj != null) {
            this.args.setCalbyCostElement(this.costAcctObj.getBoolean("calpolicy.calbycostelement"));
        }
    }
}

