/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.ActCostCalcDataInputFactory;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.MatNestModel;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class ActNestMatAutoReworkAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(ActNestMatAutoReworkAction.class);

    @Override
    protected void doExecute() {
        if (!this.getContext().getInputArgs().isNestmatautorework()) {
            return;
        }
        ActCostCalcArgs args = this.getContext().getInputArgs();
        DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(args.getTaskRecordId(), 1);
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u5d4c\u5957\u7269\u6599\u81ea\u52a8\u8fd4\u5de5\uff1a\u5f00\u59cb!");
        msgHander.dealInfoMsg(String.format(ResManager.loadKDString((String)"\u5d4c\u5957\u7269\u6599\u81ea\u52a8\u8fd4\u5de5\u5904\u7406\u5f00\u59cb\uff1a%s", (String)"ActNestMatAutoReworkAction_0", (String)"macc-aca-algox", (Object[])new Object[0]), DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")));
        DataSet cacheMatallocDataSet = this.getMatAllocDs(args);
        List<Set<Long>> mainSideGroups = this.getMainJoinGroupfromDs(cacheMatallocDataSet.copy().filter("productgroup>0"));
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u5d4c\u5957\u7269\u6599\u81ea\u52a8\u8fd4\u5de5-\u4e3b\u8054\u4ea7\u54c1\u7ec4\uff1a{}", mainSideGroups);
        HashSet billIds = Sets.newHashSetWithExpectedSize((int)10);
        HashMap matMap = Maps.newHashMapWithExpectedSize((int)10);
        this.buildMatGroupData(cacheMatallocDataSet, matMap, mainSideGroups, billIds);
        logger.info("\u9886\u6599\u5b9e\u4f53\u8282\u70b9\u6570\uff1a{}", (Object)matMap.size());
        Map<String, String> nestMatTreePaths = this.nestPathCheck(matMap);
        StringBuilder pathStrSb = new StringBuilder();
        pathStrSb.append(String.format(ResManager.loadKDString((String)"\u5d4c\u5957\u8def\u5f84\uff1a%s", (String)"ActNestMatAutoReworkAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"))).append("\n");
        for (String path : nestMatTreePaths.values()) {
            pathStrSb.append(path).append("\n");
        }
        msgHander.dealInfoMsg(pathStrSb.toString());
        long start = System.currentTimeMillis();
        Set<String> nextTreePath = nestMatTreePaths.keySet();
        while (nextTreePath != null && !nextTreePath.isEmpty()) {
            nextTreePath = this.loopBreakNestMat(nextTreePath, matMap, billIds, 0);
        }
        logger.info("\u5d4c\u5957\u6253\u65ad\u8017\u65f6\uff1a{}\uff0c\u603b\u5355\u636e\u6570\uff1a{}", (Object)((System.currentTimeMillis() - start) / 1000L), (Object)billIds.size());
        if (billIds.isEmpty()) {
            return;
        }
        LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u5d4c\u5957\u6253\u65ad\u7684\u5355\u636e", (String)"ActNestMatAutoReworkAction_3", (String)"macc-aca-algox", (Object[])new Object[0]), billIds);
        this.updateBillRework(args, billIds, msgHander);
    }

    private List<Set<Long>> getMainJoinGroupfromDs(DataSet cacheMatallocDataSet) {
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        ArrayList<Set<Long>> mainSideGroups = null;
        if (cacheMatallocDataSet.isEmpty()) {
            return mainSideGroups;
        }
        HashMap productgroupMatMap = Maps.newHashMapWithExpectedSize((int)10);
        if ("0".equals(CadBgParamUtils.getCadBgParamForString((String)"acaNestMatGroupAll", (String)"0"))) {
            for (Row row : cacheMatallocDataSet) {
                Long groupId = row.getLong("productgroup");
                Long materialId = row.getLong("material");
                productgroupMatMap.computeIfAbsent(groupId, t -> Sets.newHashSetWithExpectedSize((int)10)).add(materialId);
                costobjectIds.add(row.getLong("costobject"));
            }
            ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
            DataSet relaCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(this.getContext().getInputArgs().getOrgId(), costobjectIds, new String[]{"A"});
            for (Row row : relaCostobjectDs) {
                Long groupId = row.getLong("productgroup");
                Long materialId = row.getLong("material");
                productgroupMatMap.computeIfAbsent(groupId, t -> Sets.newHashSetWithExpectedSize((int)10)).add(materialId);
            }
        } else {
            for (Row row : cacheMatallocDataSet) {
                Long groupId = row.getLong("productgroup");
                Long materialId = row.getLong("material");
                productgroupMatMap.computeIfAbsent(groupId, t -> Sets.newHashSetWithExpectedSize((int)10)).add(materialId);
            }
            QFilter filter = new QFilter("id", "in", productgroupMatMap.keySet());
            filter.and("entryentity.producttype", "!=", (Object)"B");
            filter.and("grouptype", "=", (Object)"1");
            DataSet pgDs = QueryServiceHelper.queryDataSet((String)"AcaMatAllocHelper", (String)"cad_productintogroup", (String)"id productgroup,entryentity.material material", (QFilter[])filter.toArray(), null);
            if (pgDs != null && !pgDs.isEmpty()) {
                for (Row row : pgDs) {
                    Long productgroup = row.getLong("productgroup");
                    Long material = row.getLong("material");
                    productgroupMatMap.computeIfAbsent(productgroup, t -> Sets.newHashSetWithExpectedSize((int)10)).add(material);
                }
            }
        }
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u5d4c\u5957\u7269\u6599\u81ea\u52a8\u8fd4\u5de5-groupIds\uff1a{}", productgroupMatMap.keySet());
        mainSideGroups = new ArrayList<Set<Long>>(productgroupMatMap.values());
        logger.info("\u5b9e\u9645\u6210\u672c\u8ba1\u7b97-\u5d4c\u5957\u7269\u6599\u81ea\u52a8\u8fd4\u5de5-materialIds\uff1a{}", mainSideGroups);
        this.netGroupMerge(mainSideGroups);
        return mainSideGroups;
    }

    private void netGroupMerge(List<Set<Long>> mainSideGroups) {
        boolean isContains = true;
        while (isContains) {
            isContains = false;
            Set<Long> a1 = null;
            Set<Long> a2 = null;
            Iterator<Set<Long>> iterator = mainSideGroups.iterator();
            while (iterator.hasNext()) {
                Set<Long> netGroup;
                a1 = netGroup = iterator.next();
                for (Set<Long> netGroup1 : mainSideGroups) {
                    if (netGroup == netGroup1) continue;
                    for (Long mat : netGroup1) {
                        if (!netGroup.contains(mat)) continue;
                        isContains = true;
                        a2 = netGroup1;
                        break;
                    }
                    if (!isContains) continue;
                    break;
                }
                if (!isContains) continue;
                break;
            }
            if (!isContains || a2 == null || a1 == null) continue;
            a1.addAll(a2);
            mainSideGroups.remove(a2);
        }
    }

    private void updateBillRework(ActCostCalcArgs args, Set<Long> billIds, DebugInfoMsgHandler msgHander) {
        DataSet allocDs = this.getMatAllocCollectDs(args, billIds);
        ArrayList<Long> matAllocIds = new ArrayList<Long>(billIds.size());
        ArrayList<String> matAllocBillNos = new ArrayList<String>(billIds.size());
        for (Row row : allocDs) {
            matAllocIds.add(row.getLong("matcollect"));
            matAllocBillNos.add(row.getString("billno"));
        }
        msgHander.dealInfoMsg(String.format(ResManager.loadKDString((String)"\u9700\u8981\u66f4\u65b0\u7684\u5355\u636e\u5217\u8868\uff1a%s", (String)"ActNestMatAutoReworkAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")) + "\n" + matAllocBillNos);
        DataSet matCollectDataSet = this.getMatCollectDs(matAllocIds);
        HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)128);
        for (Row row : matCollectDataSet) {
            sourceBillEntryIds.add(row.getLong("srcEntryId"));
        }
        DataSet costRecordDs = this.getCalCostRecordDs(args, sourceBillEntryIds);
        Set<Long> costRecordEntryIds = this.getLongIdSetFromDs(costRecordDs, "billentryId", false);
        DBRoute route = new DBRoute("cal");
        try (TXHandle handle = TX.requiresNew();){
            String updateSql = "update t_sca_matalloc set fisreturnitem='1'  where fid in(%s) ";
            this.updateData(updateSql, new ArrayList<Long>(billIds), route);
            String updateCostRecordSql = "update t_cal_calcostrecordentry set fisrework='1'  where fentryid in(%s) ";
            this.updateData(updateCostRecordSql, new ArrayList<Long>(costRecordEntryIds), route);
        }
    }

    public Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    private void updateData(String sqlFmt, List<Long> billIds, DBRoute route) {
        List splitLists = Lists.partition(new ArrayList<Long>(billIds), (int)2000);
        for (List ids : splitLists) {
            String sql = String.format(sqlFmt, this.getUpdateInSql(ids));
            this.executeBatch(sql, route);
        }
    }

    protected void executeBatch(String sql, DBRoute route) {
        DB.execute((DBRoute)route, (String)sql);
    }

    private String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }

    private DataSet getMatAllocDs(ActCostCalcArgs args) {
        QFilter filter = new QFilter("allocstatus", "=", (Object)"2");
        filter.and("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("isreturnitem", "=", (Object)false);
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("material.id AS submaterial,material.number AS submaterialnumber");
        selectFields.append(",entryentity.costobejctentry.material AS material");
        selectFields.append(",entryentity.costobejctentry.material.number AS materialnumber");
        selectFields.append(",id");
        selectFields.append(",entryentity.costobejctentry costobject");
        selectFields.append(",entryentity.costobejctentry.productgroup productgroup");
        return QueryServiceHelper.queryDataSet((String)"aca_matalloc", (String)"aca_matalloc", (String)selectFields.toString(), (QFilter[])filter.toArray(), null);
    }

    private DataSet getMatAllocCollectDs(ActCostCalcArgs args, Set<Long> billIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("id", "in", billIds);
        String selectFields = "id,billno,matcollect";
        return QueryServiceHelper.queryDataSet((String)"matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private DataSet getMatCollectDs(List<Long> matColIds) {
        QFilter filter = new QFilter("entryentity.id", "in", matColIds);
        return QueryServiceHelper.queryDataSet((String)"matUseCollect", (String)"aca_matusecollect", (String)"sourcebillid as srcBillId,entryentity.sourcebillentryid as srcEntryId,entryentity.id as entryId,entryentity.material.id as matId", (QFilter[])filter.toArray(), null);
    }

    private DataSet getCalCostRecordDs(ActCostCalcArgs args, Set<Long> sourceBillEntryIds) {
        QFilter filter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("entry.bizbillentryid", "in", sourceBillEntryIds);
        filter.and("entry.isrework", "=", (Object)false);
        String selectFields = "entry.id billentryId";
        return QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private Set<String> loopBreakNestMat(Set<String> nestMatTreePaths, Map<String, MatNestModel> matMap, Set<Long> billNos, int index) {
        String needPath = null;
        logger.info("\u672c\u6b21\u5d4c\u5957\u8def\u5f84\uff1a\u5d4c\u5957\u6570{}", (Object)nestMatTreePaths.size());
        long start = System.currentTimeMillis();
        for (String path : nestMatTreePaths) {
            if (needPath != null) continue;
            needPath = path;
            break;
        }
        if (needPath == null) {
            return null;
        }
        String[] pathArr = needPath.split("-");
        ArrayList<MatNestModel> nestModels = new ArrayList<MatNestModel>(10);
        for (int i = 1; i < pathArr.length; ++i) {
            String key = String.format("%s@%s", pathArr[i - 1], pathArr[i]);
            MatNestModel model = matMap.get(key);
            if (model == null) continue;
            nestModels.add(model);
        }
        MatNestModel opMatModel = null;
        Set<String> nextTreePath = null;
        if (index == 1) {
            int size = Integer.MAX_VALUE;
            MatNestModel lastMatModel = null;
            for (MatNestModel model : nestModels) {
                if (lastMatModel != null) {
                    matMap.put(lastMatModel.getMaterialKey(), lastMatModel);
                }
                lastMatModel = matMap.remove(model.getMaterialKey());
                nestMatTreePaths = this.nestPathCheck(matMap).keySet();
                if (size <= nestMatTreePaths.size()) continue;
                size = nestMatTreePaths.size();
                opMatModel = model;
                nextTreePath = nestMatTreePaths;
            }
            if (lastMatModel != null) {
                matMap.put(lastMatModel.getMaterialKey(), lastMatModel);
            }
        } else if (index == 2) {
            for (MatNestModel model : nestModels) {
                if (opMatModel != null && opMatModel.getBillNos().size() <= model.getBillNos().size()) continue;
                opMatModel = model;
            }
            if (opMatModel != null) {
                matMap.remove(opMatModel.getMaterialKey());
            }
            nextTreePath = this.nestPathCheck(matMap).keySet();
        } else {
            opMatModel = (MatNestModel)nestModels.get(nestModels.size() - 1);
            matMap.remove(opMatModel.getMaterialKey());
            nextTreePath = this.nestPathCheck(matMap).keySet();
        }
        if (opMatModel != null) {
            matMap.remove(opMatModel.getMaterialKey());
            billNos.addAll(opMatModel.getBillNos());
            logger.info(String.format("\u5904\u7406\u8def\u5f84\uff1a%s\uff0c\u6253\u65ad\u8282\u70b9\uff1a%s\uff0c\u603b\u8282\u70b9\u6570\uff1a%s\uff0c\u5f53\u524d\u5904\u7406\u8017\u65f6\uff1a%s", needPath, opMatModel.getMaterialKey(), matMap.size(), (System.currentTimeMillis() - start) / 1000L));
        }
        return nextTreePath;
    }

    private Map<Long, List<MatNestModel>> getKeyParentValSubListMap(Collection<MatNestModel> matModels) {
        HashMap keyParentValSubListMap = Maps.newHashMapWithExpectedSize((int)10);
        for (MatNestModel matModel : matModels) {
            keyParentValSubListMap.computeIfAbsent(matModel.getParentId(), p -> Lists.newArrayList()).add(matModel);
        }
        return keyParentValSubListMap;
    }

    private Map<String, String> nestPathCheck(Map<String, MatNestModel> matMap) {
        HashMap nestMatTreePaths = Maps.newHashMapWithExpectedSize((int)10);
        HashSet nestMatIds = Sets.newHashSetWithExpectedSize((int)10);
        HashSet checkMatIds = Sets.newHashSetWithExpectedSize((int)10);
        Map<Long, List<MatNestModel>> keyParentValSubListMap = this.getKeyParentValSubListMap(matMap.values());
        for (MatNestModel calcMat : matMap.values()) {
            if (!keyParentValSubListMap.containsKey(calcMat.getMaterialId())) continue;
            calcMat.setPath(String.format("-%s-%s-", calcMat.getParentId(), calcMat.getMaterialId()));
            calcMat.setNumberPath(String.format("%s---%s", calcMat.getParentNum(), calcMat.getMaterinalNum()));
            if (calcMat.getMaterialId().equals(calcMat.getParentId())) continue;
            this.concatPath(calcMat, keyParentValSubListMap, nestMatTreePaths, nestMatIds, checkMatIds);
            checkMatIds.add(calcMat.getMaterialId());
            calcMat.setPath(null);
        }
        return nestMatTreePaths;
    }

    private void buildMatGroupData(DataSet cacheMatallocDataSet, Map<String, MatNestModel> matMap, List<Set<Long>> mainSideGroups, Set<Long> billIds) {
        for (Row row : cacheMatallocDataSet) {
            Long pid = row.getLong("material");
            Long mid = row.getLong("submaterial");
            Long id = row.getLong("id");
            if (pid.equals(mid)) {
                billIds.add(id);
                continue;
            }
            if (!CadEmptyUtils.isEmpty(mainSideGroups)) {
                boolean isContains = false;
                for (Set<Long> netGroup : mainSideGroups) {
                    if (!netGroup.contains(pid) || !netGroup.contains(mid)) continue;
                    isContains = true;
                    break;
                }
                if (isContains) {
                    billIds.add(id);
                    continue;
                }
            }
            String pnum = row.getString("materialnumber");
            String mnum = row.getString("submaterialnumber");
            String key = String.format("%s@%s", pid, mid);
            if (billIds.contains(id)) continue;
            matMap.computeIfAbsent(key, t -> {
                MatNestModel model = new MatNestModel();
                model.setMaterialId(mid);
                model.setMaterinalNum(mnum);
                model.setParentId(pid);
                model.setParentNum(pnum);
                return model;
            }).getBillNos().add(id);
        }
    }

    private void concatPath(MatNestModel parentMat, Map<Long, List<MatNestModel>> materialsMap, Map<String, String> errorMatMap, Set<Long> nestMatIds, Set<Long> checkMatIds) {
        List<MatNestModel> subMatList = materialsMap.get(parentMat.getMaterialId());
        if (subMatList == null) {
            return;
        }
        for (MatNestModel curMat : subMatList) {
            if (nestMatIds.contains(curMat.getMaterialId())) break;
            curMat.setPath(parentMat.getPath() + curMat.getMaterialId() + "-");
            curMat.setNumberPath(parentMat.getNumberPath() + "---" + curMat.getMaterinalNum());
            int index = parentMat.getPath().indexOf("-" + curMat.getMaterialId() + "-");
            if (index > -1) {
                String epath = "-" + curMat.getPath().substring(index);
                errorMatMap.putIfAbsent(epath, curMat.getNumberPath());
                nestMatIds.add(curMat.getMaterialId());
                continue;
            }
            if (curMat.getMaterialId().equals(parentMat.getParentId()) && parentMat.getParentId().equals(curMat.getMaterialId()) || checkMatIds.contains(curMat.getMaterialId())) continue;
            this.concatPath(curMat, materialsMap, errorMatMap, nestMatIds, checkMatIds);
        }
        parentMat.setPath(null);
        parentMat.setNumberPath(null);
    }
}

