/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostObjectHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjectAllFeeCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long manuOrgId = context.getManuOrgId();
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfOrg = new QFilter("org", "=", (Object)context.getOrgId());
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)context.getPeriodStartDate());
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)context.getPeriodEndDate());
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfManuOrg = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuOrgId)) {
            qfManuOrg = new QFilter("manuorg", "=", (Object)manuOrgId);
        }
        HashMap<Long, String> costObjectInfoMap = new HashMap<Long, String>(16);
        DataSet completionCollection = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)"id,entryentity.costobject costobject,entryentity.costobject.billno costobjectbillno,entryentity.costobject.name costobjectname,entryentity.costobject.costcenter costcenter", (QFilter[])new QFilter[]{qfOrg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum, qfManuOrg}, null);
        HashSet costObjectIds = Sets.newHashSet();
        for (Object row : completionCollection) {
            costObjectIds.add(row.getLong("costobject"));
        }
        DataSet mainCostObjectDs = CostObjectHelper.getMainCostObject(costObjectIds, context.getOrgId());
        for (Row row : mainCostObjectDs) {
            costObjectInfoMap.put(row.getLong("id"), row.getString("billno") + "/" + row.getString("name") + "@" + row.getString("costcenter"));
        }
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(costObjectInfoMap)) {
            return;
        }
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%1$s\u201d\u603b\u6295\u5165\u8d39\u7528\u5c0f\u4e8e0\uff0c\u672c\u671f\u5b8c\u5de5\u6210\u672c\u53ef\u80fd\u5b58\u5728\u5f02\u5e38\u3002", (String)"CostObjectAllFeeCheckAction_6", (String)"macc-aca-algox", (Object[])new Object[0]);
        HashSet<Long> costObjectForFeeLessZero = new HashSet<Long>(200);
        DataSet matDs = this.getMatAlloc(costObjectInfoMap.keySet());
        DataSet mfgDs = this.getMfgAlloc(costObjectInfoMap.keySet());
        DataSet preDs = this.getPreAlloc(costObjectInfoMap.keySet());
        DataSet resultDataSet = matDs.union(mfgDs).union(preDs);
        if (!(resultDataSet = resultDataSet.groupBy(new String[]{"costobject"}).sum("qty").sum("allocamt").finish()).isEmpty()) {
            while (resultDataSet.hasNext()) {
                Long costobjectId;
                String costobject;
                Row row = resultDataSet.next();
                BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal("qty"));
                BigDecimal amt = BigDecimalUtil.getOrZero(row.getBigDecimal("allocamt"));
                boolean qtyZero = qty.compareTo(BigDecimal.ZERO) == 0;
                boolean amtZero = amt.compareTo(BigDecimal.ZERO) == 0;
                boolean qtyLqZero = qty.compareTo(BigDecimal.ZERO) < 0;
                boolean amtLqZero = amt.compareTo(BigDecimal.ZERO) < 0;
                boolean isFail = true;
                if (qtyZero && amtLqZero || amtZero && qtyLqZero || qtyLqZero && amtLqZero) {
                    isFail = false;
                }
                if (isFail || (costobject = (String)costObjectInfoMap.get(costobjectId = row.getLong("costobject"))) == null) continue;
                String[] coStr = costobject.split("@");
                String[] split = coStr[0].split("/");
                String costcenter = coStr[1];
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCostCenter(Long.valueOf(Long.parseLong(costcenter)));
                info.setCheckDetailResult(String.format(detailDesc, split[0], split[1]));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
                costObjectForFeeLessZero.add(costobjectId);
            }
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"%s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u603b\u6295\u5165\u8d39\u7528\u5c0f\u4e8e0\u3002", (String)"CostObjectAllFeeCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), costObjectForFeeLessZero.size());
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private DataSet getMatAlloc(Set<Long> costobjectIds) {
        QFilter filter = new QFilter("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)this.getContext().getOrgId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobejctentry", "in", costobjectIds);
        filter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("period", "=", (Object)this.getContext().getPeriodId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(this.getContext().getManuOrgId())) {
            filter.and("manuorg", "=", (Object)this.getContext().getManuOrgId());
        }
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"sca_matalloc", (String)"entryentity.costobejctentry as costobject,entryentity.qty qty,0 allocamt", (QFilter[])filter.toArray(), null);
    }

    private DataSet getMfgAlloc(Set<Long> costobjectIds) {
        QFilter filter = new QFilter("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)this.getContext().getOrgId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobject", "in", costobjectIds);
        filter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("period", "=", (Object)this.getContext().getPeriodId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(this.getContext().getManuOrgId())) {
            filter.and("entryentity.costobject.manuorg", "=", (Object)this.getContext().getManuOrgId());
        }
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_mfgfeeallocco", (String)"entryentity.costobject AS costobject,0 qty,entryentity.allocamt allocamt", (QFilter[])filter.toArray(), null);
    }

    private DataSet getPreAlloc(Set<Long> costobjectIds) {
        QFilter baseFilter = new QFilter("org", "=", (Object)this.getContext().getOrgId());
        baseFilter.and("costobject", "in", costobjectIds);
        baseFilter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        baseFilter.and("entryentity.type", "=", (Object)"finalResult");
        if (this.getContext().getManuOrgId() != null && this.getContext().getManuOrgId() > 0L) {
            baseFilter.and("costobject.manuorg.id", "=", (Object)this.getContext().getManuOrgId());
        }
        QFilter preFilter = new QFilter("period", "=", (Object)PeriodHelper.getPrePeriodId(this.getContext().getPeriodId()));
        preFilter.and(baseFilter);
        DataSet preDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_calcresult", (String)"costobject,0 qty,entryentity.pdendamount + entryentity.endadjamt AS allocamt", (QFilter[])preFilter.toArray(), null);
        QFilter curFilter = new QFilter("period", "=", (Object)this.getContext().getPeriodId());
        curFilter.and(baseFilter);
        DataSet curDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_calcresult", (String)"costobject,0 qty,entryentity.startadjamt AS allocamt", (QFilter[])curFilter.toArray(), null);
        return preDs.union(curDs);
    }
}

