/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FinishHasVoucherCheckAction
extends AbstractSingleCalcCheckAction {
    private final Log logger = LogFactory.getLog(FinishHasVoucherCheckAction.class);

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long manuOrgId = context.getManuOrgId();
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfOrg = new QFilter("org", "=", (Object)context.getOrgId());
        QFilter qfStartDate = new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate());
        QFilter qfEndDate = new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate());
        QFilter qfSourceBill = new QFilter("sourcebill", ">", (Object)0L);
        QFilter qfManuOrg = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuOrgId)) {
            qfManuOrg = new QFilter("manuorg", "=", (Object)manuOrgId);
        }
        String selectFields = "sourcebill";
        DataSet factned = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfOrg, qfStartDate, qfEndDate, qfSourceBill, qfAppNum, qfManuOrg}, null);
        HashSet allIds = Sets.newHashSetWithExpectedSize((int)32);
        for (Row row : factned) {
            allIds.add(row.getLong("sourcebill"));
        }
        if (allIds.isEmpty()) {
            this.logger.info("\u672a\u627e\u5230\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6\u5355\uff0c\u68c0\u67e5\u901a\u8fc7");
            return;
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)2);
        qFilterList.add(new QFilter("bizbillid", "in", (Object)allIds));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("isvoucher", "=", (Object)"1"));
        qFilterList.add(new QFilter("costaccount", "=", (Object)context.getCostAccountId()));
        qFilterList.add(new QFilter("period", "=", (Object)context.getPeriodId()));
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cal_costrecord_subentity", (String)"bizbillid,billno", (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        HashSet voucherSourceBills = Sets.newHashSetWithExpectedSize((int)128);
        if (!costRecordDataSet.isEmpty()) {
            for (Object row : costRecordDataSet) {
                voucherSourceBills.add(row.getString("billno"));
            }
        }
        String detailDesc = ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8ba1\u7b97\u7684\u4ea7\u54c1\u5165\u5e93\u6210\u672c\u4e0e\u5355\u636e\u4e0a\u91d1\u989d\u4e0d\u4e00\u81f4\u65f6\uff0c\u4f1a\u751f\u6210\u6210\u672c\u8c03\u6574\u5355\uff0c\u5efa\u8bae\u4ea7\u54c1\u5165\u5e93\u5355\u5728\u5b8c\u6210\u6210\u672c\u8ba1\u7b97\u4e4b\u540e\u518d\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinishHasVoucherCheckAction_0", (String)"macc-aca-algox", (Object[])new Object[0]);
        if (!voucherSourceBills.isEmpty()) {
            for (String billNo : voucherSourceBills) {
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(String.format(detailDesc, billNo));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        QFilter finishCostFilter = new QFilter("costaccount", "=", (Object)context.getCostAccountId());
        finishCostFilter.and(new QFilter("period", "=", (Object)context.getPeriodId()));
        finishCostFilter.and(new QFilter("sourcevoucher", "=", (Object)false));
        finishCostFilter.and(new QFilter("creatvoucher", "=", (Object)true));
        DataSet finishCostDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"aca_finishcosttranfer", (String)"billno", (QFilter[])new QFilter[]{finishCostFilter}, null);
        String detailDesc1 = ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4f1a\u5f71\u54cd\u671f\u672b\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\uff0c\u5efa\u8bae\u5220\u9664\u8be5\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u51ed\u8bc1\u3002", (String)"FinishHasVoucherCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        if (!finishCostDataSet.isEmpty()) {
            while (finishCostDataSet.hasNext()) {
                Row row = finishCostDataSet.next();
                String billno = row.getString("billno");
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(String.format(detailDesc1, billno));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"%s\u5f20\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinishHasVoucherCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), this.getSingleCheckContext().getCheckDetailResult().size());
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }
}

