/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InproallocstdValCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        Map<Long, Set<Long>> customCostcenters = this.queryProAllocStd(this.getContext().getOrgId(), this.getContext().getCostAccountId());
        if (customCostcenters.isEmpty()) {
            return;
        }
        DataSet inProdAllocStdValDs = this.getInProdAllocStdValDs();
        String tip = ResManager.loadKDString((String)"\u6210\u672c\u52a8\u56e0\u3010%s\u3011\u5bf9\u5e94\u6210\u672c\u4e2d\u5fc3\u7684\u5206\u914d\u6807\u51c6\u503c\u4e0d\u5728[0,1]\u4e4b\u95f4\u3002", (String)"InproallocstdValCheckAction_0", (String)"macc-aca-algox", (Object[])new Object[0]);
        String tipCb = ResManager.loadKDString((String)"\u6210\u672c\u52a8\u56e0\u3010%1$s\u3011\u5bf9\u5e94\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\u7684\u5206\u914d\u6807\u51c6\u503c\u4e0d\u5728[0,1]\u4e4b\u95f4\u3002", (String)"InproallocstdValCheckAction_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        for (Row row : inProdAllocStdValDs) {
            Long costcenter = row.getLong("costcenter");
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(costcenter);
            Long costobject = row.getLong("costobject");
            String costdriverName = String.format("%s/%s", row.getString("costagentnum"), row.getString("costagentname"));
            if (CadEmptyUtils.isEmpty((Long)costobject)) {
                info.setCheckDetailResult(String.format(tip, costdriverName));
            } else {
                String costobjectName = String.format("%s/%s", row.getString("costobjectnum"), row.getString("costobjectname"));
                info.setCheckDetailResult(String.format(tipCb, costdriverName, costobjectName));
            }
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        if (!this.getSingleCheckContext().getCheckDetailResult().isEmpty()) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u201c\u6bd4\u4f8b\u201d\uff0c0\u2264\u5206\u914d\u6807\u51c6\u503c\u5728\u22641\u3002", (String)"InproallocstdValCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
    }

    private Map<Long, String> getCostobjectMap(Set<Long> costobjectSet) {
        HashMap costdriverMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("id", "in", costobjectSet);
        DataSet costCenterDriverDs = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"id,billno,name", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDriverDs) {
            costdriverMap.put(row.getLong("id"), String.format("%s/%s", row.getString("billno"), row.getString("name")));
        }
        return costdriverMap;
    }

    private Map<Long, String> getCostcenterMap(Set<Long> costcenterSet) {
        HashMap costdriverMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("id", "in", costcenterSet);
        DataSet costCenterDriverDs = QueryServiceHelper.queryDataSet((String)"costdriver", (String)"bos_costcenter", (String)"id,number,name", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDriverDs) {
            costdriverMap.put(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
        }
        return costdriverMap;
    }

    private Map<Long, Tuple<String, String>> getCostdriverInfo(Set<Long> costdriverSet) {
        HashMap costdriverMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("id", "in", costdriverSet);
        DataSet costCenterDriverDs = QueryServiceHelper.queryDataSet((String)"costdriver", (String)"cad_costdriver", (String)"id,number,name,allocclass", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDriverDs) {
            costdriverMap.put(row.getLong("id"), new Tuple((Object)String.format("%s/%s", row.getString("number"), row.getString("name")), (Object)row.getString("allocclass")));
        }
        return costdriverMap;
    }

    private Map<String, BigDecimal> getInProdAllocStdValMap() {
        QFilter filter = new QFilter("org", "=", (Object)this.getContext().getOrgId());
        filter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("period", "=", (Object)this.getContext().getPeriodId());
        DataSet completionDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_inproallocstdval", (String)"costdriver,costcenter,costobject,allocvalue", (QFilter[])filter.toArray(), null);
        HashMap costdriverValueMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : completionDs) {
            Long costagent = this.getDefaultLongVal(row.getLong("costdriver"));
            Long costcenter = this.getDefaultLongVal(row.getLong("costcenter"));
            Long costobject = this.getDefaultLongVal(row.getLong("costobject"));
            BigDecimal allocvalue = BigDecimalUtil.getOrZero(row.getBigDecimal("allocvalue"));
            String key = String.format("%s@%s@%s", costagent, costcenter, costobject);
            costdriverValueMap.put(key, allocvalue);
        }
        return costdriverValueMap;
    }

    private DataSet getInProdAllocStdValDs() {
        QFilter filter = new QFilter("org", "=", (Object)this.getContext().getOrgId());
        filter.and("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("period", "=", (Object)this.getContext().getPeriodId());
        filter.and("calmethod", "=", (Object)"0");
        QFilter valFilter = new QFilter("allocvalue", "<", (Object)0);
        valFilter.or("allocvalue", ">", (Object)1);
        filter.and(valFilter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_inproallocstdval", (String)"costdriver.number costagentnum,costdriver.name costagentname,costcenter,costobject,costobject.billno costobjectnum,costobject.name costobjectname,allocvalue", (QFilter[])filter.toArray(), null);
        return ds.orderBy(new String[]{"costagentnum asc", "costobjectnum asc", "costcenter"});
    }

    public Long getDefaultLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }

    private Map<Long, Set<Long>> getFactCostobject() {
        QFilter filter = new QFilter("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)this.getContext().getOrgId());
        filter.and("bizdate", ">=", (Object)this.getContext().getPeriodStartDate());
        filter.and("bizdate", "<=", (Object)this.getContext().getPeriodEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(this.getContext().getManuOrgId())) {
            filter.and("manuorg", "=", (Object)this.getContext().getManuOrgId());
        }
        DataSet completionCollection = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_factnedoutputbill", (String)"entryentity.costobject.costcenter costcenter,entryentity.costobject costobject", (QFilter[])filter.toArray(), null);
        HashMap costcenterObjMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : completionCollection) {
            costcenterObjMap.computeIfAbsent(row.getLong("costcenter"), t -> new HashSet()).add(row.getLong("costobject"));
        }
        return costcenterObjMap;
    }

    private Map<Long, Set<Long>> queryProAllocStd(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"proallocstd", (String)"aca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver,allocentry.costagent costagent,allocentry.productsubentry.costdriverdetail costdriverdetail,allocentry.productsubentry.costagentdetail costagentdetail", (QFilter[])filter.toArray(), null);
        HashSet hasStdCostcenters = Sets.newHashSetWithExpectedSize((int)10);
        HashMap customCostcenters = Maps.newHashMapWithExpectedSize((int)10);
        Long zero = 0L;
        for (Row row : ds) {
            Long costagentdetail;
            Long costagent;
            Long costcenter = row.getLong("costcenter");
            if (costcenter == null) {
                costcenter = zero;
            }
            if (!CadEmptyUtils.isEmpty((Long)costcenter)) {
                hasStdCostcenters.add(costcenter);
            }
            String costdriver = row.getString("costdriver");
            String costdriverdetail = row.getString("costdriverdetail");
            if ("6".equals(costdriver) && !CadEmptyUtils.isEmpty((Long)(costagent = row.getLong("costagent")))) {
                customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagent);
            }
            if (!"6".equals(costdriverdetail) || CadEmptyUtils.isEmpty((Long)(costagentdetail = row.getLong("costagentdetail")))) continue;
            customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagentdetail);
        }
        if (customCostcenters.containsKey(zero)) {
            List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)orgId, (Long[])new Long[]{4L});
            Set costValue = (Set)customCostcenters.remove(zero);
            costCenterIds.removeAll(hasStdCostcenters);
            for (Long costcenter : costCenterIds) {
                customCostcenters.put(costcenter, costValue);
            }
        }
        return customCostcenters;
    }
}

