/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.common.ActCalcMaterial;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ManuMatExistsMovingAvgCheckAction
extends AbstractSingleCalcCheckAction {
    private Map<String, String> accountTypeMatMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, String> accountTypeMatGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, String> matIdNumMap = Maps.newHashMapWithExpectedSize((int)16);

    protected void doCheck() {
        List matLvl;
        CalcCheckContext context = this.getContext();
        List<ThreeTuple<Long, String, String>> calRangeList = this.queryCalRangeList();
        if (calRangeList == null || calRangeList.isEmpty()) {
            return;
        }
        List list = matLvl = context.getParams().get("MatLvlList") == null ? null : (List)context.getParams().get("MatLvlList");
        if (matLvl != null && matLvl.size() > 0) {
            Object calRangeNum;
            Set<Long> calcMatIdSet = this.getCalcMatIdSet(matLvl);
            this.queryAccountTypeDataSet(calRangeList, calcMatIdSet);
            String tip = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\uff1a%1$s \u5b58\u5728\u81ea\u5236\u7269\u6599:%2$s \u8ba1\u4ef7\u65b9\u6cd5\u5b9e\u65f6\u6cd5\uff0c\u4f1a\u5bfc\u81f4\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"ManuMatExistsMovingAvgCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
            ArrayList errorAccountTypeList = Lists.newArrayList();
            HashSet matIdNameSet = Sets.newHashSetWithExpectedSize((int)256);
            HashMap matIdNameMap = Maps.newHashMapWithExpectedSize((int)256);
            HashMap calRangeMatErrorMap = Maps.newHashMapWithExpectedSize((int)128);
            HashMap calRangeMatGroupErrorMap = Maps.newHashMapWithExpectedSize((int)128);
            for (ThreeTuple<Long, String, String> threeTuple : calRangeList) {
                calRangeNum = (String)threeTuple.item2;
                HashSet diff = Sets.newHashSetWithExpectedSize((int)32);
                for (Long matId : calcMatIdSet) {
                    String accountType = this.accountTypeMatMap.get(((String)calRangeNum).concat("_").concat(matId.toString()));
                    if (StringUtils.isEmpty((Object)accountType)) {
                        diff.add(matId);
                        continue;
                    }
                    if (!"C".equals(accountType) && !"D".equals(accountType) && !"E".equals(accountType)) continue;
                    errorAccountTypeList.add(new Tuple(calRangeNum, (Object)this.matIdNumMap.get(matId)));
                }
                if (diff.isEmpty()) continue;
                QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
                q.and("material", "in", (Object)diff);
                DynamicObjectCollection matGroupCollection = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"id,material,group.number,group.longnumber", (QFilter[])q.toArray());
                if (AcaAlgoxEmptyOrZeroUtils.isEmpty(matGroupCollection)) {
                    if (((String)threeTuple.item3).equals("C") || ((String)threeTuple.item3).equals("D") || ((String)threeTuple.item3).equals("E")) {
                        calRangeMatErrorMap.put(calRangeNum, diff);
                        matIdNameSet.addAll(diff);
                    }
                } else {
                    HashSet errorMatGroup = Sets.newHashSetWithExpectedSize((int)16);
                    for (DynamicObject matGroup : matGroupCollection) {
                        if (matGroup == null) continue;
                        Long material = matGroup.getLong("material");
                        String groupLongNum = matGroup.getString("group.longnumber");
                        String groupNumber = matGroup.getString("group.number");
                        String accountType = "";
                        if (!StringUtils.isEmpty((Object)groupLongNum)) {
                            String[] groupNums = groupLongNum.split("!");
                            for (int i = groupNums.length - 1; i >= 0; --i) {
                                String groupNum = groupNums[i];
                                if (!this.accountTypeMatGroupMap.containsKey((String)calRangeNum + "_" + groupNum)) continue;
                                accountType = this.accountTypeMatGroupMap.get((String)calRangeNum + "_" + groupNum);
                                break;
                            }
                        }
                        if (!StringUtils.isEmpty((Object)accountType) && ("C".equals(accountType) || "D".equals(accountType) || "E".equals(accountType))) {
                            errorMatGroup.add(groupNumber);
                        }
                        diff.remove(material);
                    }
                    if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(errorMatGroup)) {
                        calRangeMatGroupErrorMap.put(calRangeNum, errorMatGroup);
                    }
                }
                if (diff.isEmpty() || !((String)threeTuple.item3).equals("C") && !((String)threeTuple.item3).equals("D") && !((String)threeTuple.item3).equals("E")) continue;
                calRangeMatErrorMap.put(calRangeNum, diff);
                matIdNameSet.addAll(diff);
            }
            if (!matIdNameSet.isEmpty()) {
                QFilter idQf = new QFilter("id", "in", (Object)matIdNameSet);
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{idQf});
                for (DynamicObject material : dynamicObjectCollection) {
                    matIdNameMap.put(material.getLong("id"), material.getString("number"));
                }
            }
            if (!calRangeMatErrorMap.isEmpty()) {
                for (Map.Entry entry : calRangeMatErrorMap.entrySet()) {
                    calRangeNum = (String)entry.getKey();
                    Set matIds = (Set)entry.getValue();
                    for (Long matId : matIds) {
                        errorAccountTypeList.add(new Tuple(calRangeNum, matIdNameMap.get(matId)));
                    }
                }
            }
            String groupTip = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\uff1a%1$s \u5b58\u5728\u7269\u6599\u5206\u7c7b:%2$s \u8ba1\u4ef7\u65b9\u6cd5\u5b9e\u65f6\u6cd5\uff0c\u4f1a\u5bfc\u81f4\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"ManuMatExistsMovingAvgCheckAction_4", (String)"macc-aca-algox", (Object[])new Object[0]);
            if (!calRangeMatGroupErrorMap.isEmpty()) {
                for (Map.Entry calRangeMatGroupEntry : calRangeMatGroupErrorMap.entrySet()) {
                    String calRangeNum2 = (String)calRangeMatGroupEntry.getKey();
                    Set matGroups = (Set)calRangeMatGroupEntry.getValue();
                    for (String matGroupNum : matGroups) {
                        CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                        info.setCheckDetailResult(String.format(groupTip, calRangeNum2, matGroupNum));
                        this.getSingleCheckContext().getCheckDetailResult().add(info);
                    }
                }
            }
            if (!errorAccountTypeList.isEmpty()) {
                for (Tuple calRangeMat : errorAccountTypeList) {
                    CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                    info.setCheckDetailResult(String.format(groupTip, calRangeMat.item1, calRangeMat.item2));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
            }
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u5b58\u5728\u7269\u6599\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u6cd5\uff0c\u4f1a\u5bfc\u81f4\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"ManuMatExistsMovingAvgCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), this.getSingleCheckContext().getCheckDetailResult().size());
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private void queryAccountTypeDataSet(List<ThreeTuple<Long, String, String>> calRangeList, Set<Long> matIdSet) {
        QFilter filter = new QFilter("calrange", "in", calRangeList.stream().map(threeTuple -> (Long)threeTuple.item1).collect(Collectors.toSet()));
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        String selectFields = "calrange.number as calRangeNumber,entry.material.id as matId,entry.material.number as matNumber,entry.materialgroup.number groupNum,entry.accounttype accountType";
        DataSet accountTypeDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("queryAccountTypeDataSet"), (String)"cal_bd_accounttype", (String)selectFields, (QFilter[])filter.toArray(), null);
        for (Row accountType : accountTypeDs) {
            Long matId = accountType.getLong("matId");
            String groupNum = accountType.getString("groupNum");
            String calRangeNumber = accountType.getString("calRangeNumber");
            String calType = accountType.getString("accountType");
            String matNumber = accountType.getString("matNumber");
            if (AcaAlgoxEmptyOrZeroUtils.isEmpty(matId)) {
                this.accountTypeMatGroupMap.put(calRangeNumber.concat("_").concat(groupNum), calType);
                continue;
            }
            if (matIdSet.contains(matId)) {
                this.accountTypeMatMap.put(calRangeNumber.concat("_").concat(matId.toString()), calType);
            }
            this.matIdNumMap.put(matId, matNumber);
        }
    }

    private List<ThreeTuple<Long, String, String>> queryCalRangeList() {
        QFilter filter = new QFilter("costaccount", "=", (Object)this.getContext().getCostAccountId());
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        String selectFields = "id,number,accounttype";
        DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("queryCalRangeList"), (String)"cal_bd_calrange", (String)selectFields, (QFilter[])filter.toArray(), null);
        ArrayList calRangeList = Lists.newArrayListWithExpectedSize((int)10);
        for (Row row : calRangeDataSet) {
            ThreeTuple calRange = new ThreeTuple((Object)row.getLong("id"), (Object)row.getString("number"), (Object)row.getString("accounttype"));
            calRangeList.add(calRange);
        }
        return calRangeList;
    }

    private Set<Long> getCalcMatIdSet(List<Set<ActCalcMaterial>> matLvl) {
        HashSet matIdSet = Sets.newHashSetWithExpectedSize((int)128);
        for (int i = 1; i < matLvl.size(); ++i) {
            Set<ActCalcMaterial> set = matLvl.get(i);
            for (ActCalcMaterial actCalcMaterial : set) {
                matIdSet.add(actCalcMaterial.getMaterialId());
            }
        }
        Set<Long> finishStoreMatIdSet = this.getFinishStoreMat();
        if (finishStoreMatIdSet != null && finishStoreMatIdSet.size() > 0) {
            matIdSet.addAll(finishStoreMatIdSet);
        }
        return matIdSet;
    }

    private Set<Long> getFinishStoreMat() {
        HashSet matIdSet = null;
        CalcCheckContext inputArgs = this.getContext();
        Long orgId = inputArgs.getOrgId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        Long manuOrgId = inputArgs.getManuOrgId();
        if (manuOrgId != null && manuOrgId.compareTo(0L) > 0) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        QFilter bookDateQf = new QFilter("bookdate", ">=", (Object)inputArgs.getPeriodStartDate());
        bookDateQf.and(new QFilter("bookdate", "<", (Object)inputArgs.getPeriodEndDate()));
        qFilters.add(bookDateQf);
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection finishStoreCollection = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)"material", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (!CollectionUtils.isEmpty((Collection)finishStoreCollection)) {
            matIdSet = Sets.newHashSet();
            for (DynamicObject finishStore : finishStoreCollection) {
                matIdSet.add(finishStore.getLong("material"));
            }
        }
        return matIdSet;
    }
}

