/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.check.Material;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class NestMatCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(NestMatCheckAction.class);

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        int maxErrorSize = 2000;
        if (context.getParams().get("Nestmatcheck") != null) {
            maxErrorSize = Integer.parseInt(context.getParams().get("Nestmatcheck").toString());
        }
        if (context.getParams().get("CacheMatallocDataSet") == null) {
            return;
        }
        DataSet cacheMatallocDataSet = (DataSet)context.getParams().get("CacheMatallocDataSet");
        HashMap materialInfo = Maps.newHashMapWithExpectedSize((int)1000);
        HashMap materialsMap = Maps.newHashMapWithExpectedSize((int)1600);
        Set<Material> materials = this.getMaterialNode(cacheMatallocDataSet, materialInfo, materialsMap);
        logger.info("\u5d4c\u5957\u68c0\u67e5\u751f\u6210\u7684\u8282\u70b9\u6570\uff1a{}", (Object)materials.size());
        HashSet errorMatList = Sets.newHashSetWithExpectedSize((int)10);
        HashSet nestMatIds = null;
        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"nestMatDealPerform", (String)"1"))) {
            nestMatIds = Sets.newHashSetWithExpectedSize((int)1024);
        }
        for (Material mat : materials) {
            if (mat.getMaterialId() == mat.getParentId()) {
                errorMatList.add(String.format("@%s@%s@", mat.getParentId(), mat.getMaterialId()));
                continue;
            }
            if (mat.getParentId() != 0L) {
                mat.setPath(String.format("@%s@%s@", mat.getParentId(), mat.getMaterialId()));
            } else {
                mat.setPath(String.format("@%s@", mat.getMaterialId()));
            }
            this.concatPath(mat, materialsMap, errorMatList, maxErrorSize, nestMatIds);
            if (nestMatIds == null) continue;
            nestMatIds.add(mat.getMaterialId());
        }
        if (errorMatList.isEmpty()) {
            return;
        }
        logger.info("\u5d4c\u5957\u8282\u70b9\u6570\uff1a{}", (Object)errorMatList.size());
        List<String> errorMats = new ArrayList<String>(errorMatList);
        errorMats = this.clearDubMatInfo(errorMats);
        Map<String, Set<String>> matAllocToBillNosMap = this.pathToBillNos(errorMats);
        List<String> errorMsgs = this.getNestPath(errorMats, materialInfo, matAllocToBillNosMap);
        for (String nest : errorMsgs) {
            String detailMsg = nest.length() > 255 ? nest.substring(0, 255) : nest;
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(Long.valueOf(0L));
            info.setCheckDetailResult(detailMsg);
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6761\u9886\u6599\u5173\u7cfb\u5b58\u5728\u5faa\u73af\u9886\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"NestMatCheckAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), errorMats.size());
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private List<String> clearDubMatInfo(List<String> errorMats) {
        HashMap errorMatPath = Maps.newHashMapWithExpectedSize((int)10);
        for (String path : errorMats) {
            String[] ss;
            TreeSet treeSet = Sets.newTreeSet();
            for (String str : ss = path.split("@")) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                treeSet.add(str);
            }
            errorMatPath.put(((Object)treeSet).toString(), path);
        }
        return new ArrayList<String>(errorMatPath.values());
    }

    private Map<String, Set<String>> pathToBillNos(List<String> errorMats) {
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)10);
        for (String path : errorMats) {
            String[] ss;
            for (String str : ss = path.split("@")) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                materialIds.add(Long.valueOf(str));
            }
        }
        DataSet matAllocDs = this.getMatAllocDs(this.getContext(), materialIds);
        HashMap matAllocToBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : matAllocDs) {
            String key = String.format("%s@%s", row.getLong("material"), row.getString("submaterial"));
            matAllocToBillNosMap.computeIfAbsent(key, t -> Sets.newHashSetWithExpectedSize((int)10)).add(row.getString("billno"));
        }
        return matAllocToBillNosMap;
    }

    private DataSet getMatAllocDs(CalcCheckContext context, Set<Long> materialIds) {
        QFilter filter = new QFilter("allocstatus", "=", (Object)"2");
        filter.and("appnum", "=", (Object)"aca");
        filter.and("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        if (materialIds.size() < 2000) {
            filter.and("material", "in", materialIds);
        }
        filter.and("isreturnitem", "=", (Object)false);
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("material.id AS submaterial");
        selectFields.append(",entryentity.costobejctentry.material AS material");
        selectFields.append(",billno");
        return QueryServiceHelper.queryDataSet((String)"aca_matalloc", (String)"aca_matalloc", (String)selectFields.toString(), (QFilter[])filter.toArray(), null);
    }

    private Set<Material> getMaterialNode(DataSet cacheMatallocDataSet, Map<String, String> materialInfo, Map<Long, Set<Material>> materialsMap) {
        HashSet materials = Sets.newHashSetWithExpectedSize((int)1000);
        for (Row row : cacheMatallocDataSet) {
            materialInfo.put(row.getString("material"), row.getString("materialnumber"));
            materialInfo.put(row.getString("submaterial"), row.getString("submaterialnumber"));
            Material subMaterial = new Material();
            subMaterial.setParentId(row.getLong("material"));
            subMaterial.setMaterialId(row.getLong("submaterial"));
            subMaterial.setCostCenterId(0L);
            subMaterial.setPath(String.format("@%s@%s@", subMaterial.getParentId(), subMaterial.getMaterialId()));
            materials.add(subMaterial);
            Set subSet = materialsMap.computeIfAbsent(subMaterial.getParentId(), p -> Sets.newHashSetWithExpectedSize((int)16));
            subSet.add(subMaterial);
        }
        return materials;
    }

    private void concatPath(Material mat, Map<Long, Set<Material>> materialsMap, Set<String> errorMatList, int maxErrorSize, Set<Long> nestMatIds) {
        Set<Material> subMatList = materialsMap.get(mat.getMaterialId());
        if (subMatList == null) {
            return;
        }
        for (Material curMat : subMatList) {
            curMat.setPath(mat.getPath() + curMat.getMaterialId() + "@");
            int index = mat.getPath().indexOf("@" + curMat.getMaterialId() + "@");
            if (index > -1) {
                String epath = "@" + curMat.getPath().substring(index);
                errorMatList.add(epath);
                continue;
            }
            if (errorMatList.size() > maxErrorSize) {
                return;
            }
            if (curMat.getMaterialId() == mat.getParentId() && mat.getMaterialId() == curMat.getParentId() || nestMatIds != null && nestMatIds.contains(curMat.getMaterialId())) continue;
            this.concatPath(curMat, materialsMap, errorMatList, maxErrorSize, nestMatIds);
        }
    }

    private List<String> getNestPath(List<String> errorMatList, Map<String, String> materialInfo, Map<String, Set<String>> matAllocToBillNosMap) {
        String tipMsg = ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5b58\u5728\u5faa\u73af\u9886\u7528\u3002", (String)"NestMatCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]);
        String pathMsg = ResManager.loadKDString((String)"\u9886\u6599\u5173\u7cfb\u3010%1$s->%2$s\u3011\u5bf9\u5e94\u7684\u5355\u636e\u6570\u4e3a\u3010%3$s\u3011\u5f20\uff0c\u5355\u636e\u53f7\u3010%4$s\u3011\u3002", (String)"NestMatCheckAction_4", (String)"macc-aca-algox", (Object[])new Object[0]);
        ArrayList errorMsgs = Lists.newArrayListWithExpectedSize((int)16);
        for (String path : errorMatList) {
            String[] ss = path.split("@");
            StringBuilder tip = new StringBuilder();
            int i = 0;
            String preMat = null;
            String nextMat = null;
            String preMatNo = null;
            String nextMatNo = null;
            ArrayList<String> pathMsgs = new ArrayList<String>(10);
            for (String str : ss) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                if (i > 0) {
                    tip.append("->");
                }
                preMat = nextMat;
                nextMat = str;
                preMatNo = nextMatNo;
                nextMatNo = materialInfo.get(str);
                Set<String> billNos = matAllocToBillNosMap.get(String.format("%s@%s", preMat, nextMat));
                if (billNos != null) {
                    pathMsgs.add(String.format(pathMsg, preMatNo, nextMatNo, billNos.size(), this.getCollectionStr(billNos)));
                }
                tip.append(nextMatNo);
                ++i;
            }
            errorMsgs.add(String.format(tipMsg, tip.toString()));
            errorMsgs.addAll(pathMsgs);
        }
        return errorMsgs;
    }

    private String getCollectionStr(Set<String> billNos) {
        StringBuilder sb = new StringBuilder();
        if (billNos == null || billNos.isEmpty()) {
            return "";
        }
        for (String billNo : billNos) {
            sb.append(",").append(billNo);
        }
        return sb.substring(1);
    }

    private static DataSet getExampleDs() {
        ArrayList lists = Lists.newArrayList();
        return Algo.create((String)"macc.sca.CostCalcResultQueryPlugin").createDataSet(lists.iterator(), new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("auxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("submaterial", (DataType)DataType.LongType), new Field("submaterialnumber", (DataType)DataType.StringType), new Field("subauxpty", (DataType)DataType.LongType), new Field("submatversion", (DataType)DataType.LongType)}));
    }
}

