/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxElementHelper;
import kd.macc.aca.algox.utils.AcaCalcRangeHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.BomSettingHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class ProductStdCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        List checkCostCenterIds;
        CalcCheckContext context = this.getContext();
        String appNum = context.getAppNum();
        List costCenterIds = context.getCostCenterIds();
        boolean checkFlag = true;
        QFilter qfOrg = new QFilter("org", "=", (Object)context.getOrgId());
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)context.getCostAccountId());
        QFilter effectStatus = new QFilter("effectstatus", "=", (Object)"1");
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        boolean isStd = false;
        DynamicObjectCollection proAllocStds = null;
        if ("aca".equals(appNum)) {
            proAllocStds = QueryServiceHelper.query((String)"aca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfBillStatus, effectStatus});
        } else if ("sca".equals(appNum)) {
            proAllocStds = QueryServiceHelper.query((String)"sca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfBillStatus, effectStatus});
        }
        String costCenterNames = "";
        HashMap<String, String> proAllocStdMap = new HashMap<String, String>(8);
        if (proAllocStds != null) {
            for (DynamicObject proAllocStd : proAllocStds) {
                String costCenter = proAllocStd.getString("costcenter");
                String costAccount = proAllocStd.getString("costaccount");
                String costDriver = proAllocStd.getString("costdriver");
                if (CadEmptyUtils.isEmpty((String)costCenter)) {
                    proAllocStdMap.put(String.format("%s", costAccount), costDriver);
                    continue;
                }
                proAllocStdMap.put(String.format("%s@%s", costAccount, costCenter), costDriver);
            }
        }
        if (!CadEmptyUtils.isEmpty((List)(checkCostCenterIds = CadEmptyUtils.isEmpty((List)costCenterIds) ? CostCenterHelper.getCostCenterByOrg((Long)context.getOrgId(), (Long[])new Long[]{4L}) : Lists.newArrayList((Iterable)costCenterIds)))) {
            Iterator iterator = checkCostCenterIds.iterator();
            while (iterator.hasNext()) {
                Long costCenterId = (Long)iterator.next();
                String proAllocStd = (String)proAllocStdMap.get(String.format("%s@%s", context.getCostAccountId(), costCenterId));
                if (StringUtils.isEmpty((CharSequence)proAllocStd)) {
                    proAllocStd = (String)proAllocStdMap.get(String.format("%s", context.getCostAccountId()));
                }
                if (StringUtils.isEmpty((CharSequence)proAllocStd)) continue;
                iterator.remove();
            }
        }
        if (checkCostCenterIds != null && checkCostCenterIds.isEmpty()) {
            isStd = true;
        } else {
            DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)checkCostCenterIds)});
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
                for (DynamicObject costCenter : costCenters) {
                    String name = costCenter.getString("name");
                    if (costCenterNames.length() == 0) {
                        costCenterNames = costCenterNames.concat(name);
                        continue;
                    }
                    costCenterNames = costCenterNames.concat("\u3001").concat(name);
                }
            }
        }
        String checkDesc = "";
        if (!isStd) {
            checkFlag = false;
            checkDesc = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f\u4e0b\uff0c\u6210\u672c\u4e2d\u5fc3\u3010%s\u3011\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8bbe\u7f6e\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"ProductStdCheckAction_12", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterNames);
            if ("sca".equals(appNum)) {
                checkDesc = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f\u4e0b\uff0c\u6210\u672c\u4e2d\u5fc3\u3010%s\u3011\u201c\u5728\u5236\u54c1\u5206\u914d\u6807\u51c6\u201d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8bbe\u7f6e\u201c\u5728\u5236\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"ProductStdCheckAction_13", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterNames);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appNum) && "aca".equals(appNum)) {
            HashMap<Long, Set<Long>> assemblyMap = new HashMap<Long, Set<Long>>(8);
            HashMap<Long, Set<Long>> bomMap = new HashMap<Long, Set<Long>>(8);
            HashMap<Long, Set<Long>> costTypeMap = new HashMap<Long, Set<Long>>(8);
            QFilter qfAssembly = new QFilter("allocentry.productsubentry.costdriverdetail", "in", (Object)new String[]{"3", "5"});
            DynamicObjectCollection proAllocStdList = QueryServiceHelper.query((String)"aca_proallocstd", (String)"allocentry.costcenter costcenter,allocentry.productsubentry.subelement subelement,allocentry.productsubentry.costdriverdetail costdriverdetail,allocentry.productsubentry.costtype costtype", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfAssembly, qfBillStatus, effectStatus});
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)proAllocStdList)) {
                String errorMsg;
                for (DynamicObject dynamicObject : proAllocStdList) {
                    long costCenter = dynamicObject.getLong("costcenter");
                    long subElement = dynamicObject.getLong("subelement");
                    String costDriverDetail = dynamicObject.getString("costdriverdetail");
                    long costType = dynamicObject.getLong("costtype");
                    if ("3".equals(costDriverDetail)) {
                        assemblyMap.computeIfAbsent(costCenter, val -> new HashSet()).add(subElement);
                        continue;
                    }
                    if (!"5".equals(costDriverDetail)) continue;
                    if (CadEmptyUtils.isEmpty((Long)costType)) {
                        checkFlag = false;
                        checkDesc = checkDesc.concat(ResManager.loadKDString((String)"\u6709\u6210\u672c\u5b50\u8981\u7d20\u8bbe\u7f6e\u4e86\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u201d\uff0c\u4f46\u6210\u672c\u7c7b\u578b\u672a\u5f55\u5165\uff0c\u8bf7\u5b8c\u5584\u3002", (String)"ProductStdCheckAction_5", (String)"macc-aca-algox", (Object[])new Object[0]));
                        continue;
                    }
                    costTypeMap.computeIfAbsent(costCenter, val -> new HashSet()).add(costType);
                    bomMap.computeIfAbsent(costCenter, val -> new HashSet()).add(subElement);
                }
                Map<Long, String> matSubElement = AcaAlgoxElementHelper.getMatSubElements();
                String errorDesc = this.checkAllSubEleSet(assemblyMap, matSubElement, errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0b\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5df2\u8bbe\u7f6e\u4e86\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u201d\uff0c\u5219\u5176\u5b83\u7269\u6599\u5c5e\u6027\u7684\u6210\u672c\u5b50\u8981\u7d20\u9700\u8981\u4f7f\u7528\u540c\u4e00\u89c4\u5219\u3002\u76ee\u524d\u68c0\u6d4b\u5230\u6210\u672c\u5b50\u8981\u7d20\u201c%3$s\u201d\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u5b8c\u5584\u3002", (String)"ProductStdCheckAction_3", (String)"macc-aca-algox", (Object[])new Object[0]));
                if (StringUtils.isNotBlank((CharSequence)errorDesc)) {
                    checkFlag = false;
                    checkDesc = checkDesc.concat(errorDesc);
                }
                if (StringUtils.isNotBlank((CharSequence)(errorDesc = this.checkAllSubEleSet(bomMap, matSubElement, errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0b\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5df2\u8bbe\u7f6e\u4e86\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u201d\uff0c\u5219\u5176\u5b83\u7269\u6599\u5c5e\u6027\u7684\u6210\u672c\u5b50\u8981\u7d20\u9700\u8981\u4f7f\u7528\u540c\u4e00\u89c4\u5219\u3002\u76ee\u524d\u68c0\u6d4b\u5230\u6210\u672c\u5b50\u8981\u7d20\u201c%3$s\u201d\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u5b8c\u5584\u3002", (String)"ProductStdCheckAction_4", (String)"macc-aca-algox", (Object[])new Object[0]))))) {
                    checkFlag = false;
                    checkDesc = checkDesc.concat(errorDesc);
                }
                errorMsg = ResManager.loadKDString((String)"\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u8bbe\u7f6e\u4e3a\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u201d\uff0c\u4f46\u5bf9\u5e94\u6210\u672c\u7c7b\u578b\u672a\u8bbe\u7f6e\u201c\u6210\u672cBOM\u8bbe\u7f6e\u201d\u3002", (String)"ProductStdCheckAction_14", (String)"macc-aca-algox", (Object[])new Object[0]);
                Map<Long, List<String>> errorMap = this.checkBomSetting(costTypeMap, this.getContext().getOrgId(), context.getCostAccountId(), context.getPeriodId(), context.getManuOrgId());
                if (!CadEmptyUtils.isEmpty(errorMap)) {
                    checkFlag = false;
                    checkDesc = checkDesc.concat(errorMsg);
                    for (Map.Entry<Long, List<String>> costCenterErrMsgEntry : errorMap.entrySet()) {
                        Long costCenter = costCenterErrMsgEntry.getKey();
                        List<String> errMsgs = costCenterErrMsgEntry.getValue();
                        for (String errMsg : errMsgs) {
                            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                            info.setCostCenter(costCenter);
                            info.setCheckDetailResult(errMsg);
                            this.getSingleCheckContext().getCheckDetailResult().add(info);
                        }
                    }
                }
            }
        }
        if (!checkFlag) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(checkDesc);
        }
    }

    private Map<Long, List<String>> checkBomSetting(Map<Long, Set<Long>> costCenterCostTypeMap, Long orgId, Long costAccountId, Long periodId, Long manuOrgId) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(8);
        if (!CadEmptyUtils.isEmpty(costCenterCostTypeMap)) {
            HashSet costTypes = new HashSet(8);
            for (Map.Entry<Long, Set<Long>> costCenterCostTypeEntry : costCenterCostTypeMap.entrySet()) {
                costTypes.addAll(costCenterCostTypeEntry.getValue());
            }
            Set<Long> costObjectIds = AcaCalcRangeHelper.getCalcCurPeriodCostobjectRange(orgId, costAccountId, periodId, manuOrgId);
            QFilter idQFilter = new QFilter("id", "in", costObjectIds);
            DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,material,name,costcenter,costcenter.name costCenterName", (QFilter[])new QFilter[]{idQFilter});
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costObjects)) {
                HashMap<Long, String> costObjectIdNameMap = new HashMap<Long, String>(8);
                HashMap<Long, String> costCenterIdNameMap = new HashMap<Long, String>(8);
                HashMap<Long, Set> materialCostObjects = new HashMap<Long, Set>(8);
                HashMap<Long, Set> ccMaterials = new HashMap<Long, Set>(8);
                HashMap<Long, Set> ccCostObjectIds = new HashMap<Long, Set>(8);
                HashSet<Long> materials = new HashSet<Long>(8);
                for (DynamicObject costObject : costObjects) {
                    long costObjectId = costObject.getLong("id");
                    String costObjectName = costObject.getString("name");
                    long material = costObject.getLong("material");
                    costObjectIdNameMap.put(costObjectId, costObjectName);
                    long costCenter = costObject.getLong("costcenter");
                    String costCenterName = costObject.getString("costCenterName");
                    costCenterIdNameMap.put(costCenter, costCenterName);
                    materialCostObjects.computeIfAbsent(material, val -> new HashSet()).add(costObjectId);
                    materials.add(material);
                    ccMaterials.computeIfAbsent(costCenter, val -> new HashSet()).add(material);
                    ccCostObjectIds.computeIfAbsent(costCenter, val -> new HashSet()).add(costObjectId);
                }
                DynamicObjectCollection bomSettings = BomSettingHelper.getCostTypeBomSettings(costTypes, materials);
                HashMap<Long, Set> costTypeMatMap = new HashMap<Long, Set>(8);
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)bomSettings)) {
                    for (DynamicObject bomSetting : bomSettings) {
                        long costType = bomSetting.getLong("costtype");
                        long material = bomSetting.getLong("material");
                        costTypeMatMap.computeIfAbsent(costType, val -> new HashSet()).add(material);
                    }
                }
                for (Map.Entry<Long, Set<Long>> ccCostTypeEntry : costCenterCostTypeMap.entrySet()) {
                    Long costCenter = ccCostTypeEntry.getKey();
                    String costCenterName = (String)costCenterIdNameMap.get(costCenter);
                    Set<Long> costTypeSet = ccCostTypeEntry.getValue();
                    HashSet currMats = (HashSet)ccMaterials.get(costCenter);
                    if (currMats == null) {
                        currMats = new HashSet(0);
                    }
                    for (Long costType : costTypeSet) {
                        if (!costTypeMatMap.containsKey(costType)) {
                            Set costObjs = (Set)ccCostObjectIds.get(costCenter);
                            if (costObjs == null) continue;
                            for (Long costObj : costObjs) {
                                String costObjName = (String)costObjectIdNameMap.get(costObj);
                                if (!StringUtils.isNotBlank((CharSequence)costObjName)) continue;
                                result.computeIfAbsent(costCenter, val -> new ArrayList()).add(String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u8bbe\u7f6e\u4e3a\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u201d\uff0c\u4f46\u5bf9\u5e94\u6210\u672c\u7c7b\u578b\u672a\u8bbe\u7f6e\u201c\u6210\u672cBOM\u8bbe\u7f6e\u201d\u3002\u8bf7\u7ef4\u62a4\u7269\u6599\u7684\u6210\u672cBOM\u8bbe\u7f6e\u3002", (String)"ProductStdCheckAction_7", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterName, costObjName));
                            }
                            continue;
                        }
                        HashSet costTypeMats = (HashSet)costTypeMatMap.get(costType);
                        if (costTypeMats == null) {
                            costTypeMats = new HashSet(0);
                        }
                        Sets.SetView diffMat = Sets.difference(currMats, (Set)costTypeMats);
                        HashSet diffCostObjectIds = new HashSet(8);
                        if (!CadEmptyUtils.isEmpty((Set)diffMat)) {
                            for (Long materialId : diffMat) {
                                Set matObjIds = (Set)materialCostObjects.get(materialId);
                                if (CadEmptyUtils.isEmpty((Set)matObjIds)) continue;
                                diffCostObjectIds.addAll(matObjIds);
                            }
                        }
                        if (CadEmptyUtils.isEmpty(diffCostObjectIds)) continue;
                        for (Long diffObjectId : diffCostObjectIds) {
                            String diffObjectName = (String)costObjectIdNameMap.get(diffObjectId);
                            if (!StringUtils.isNotBlank((CharSequence)diffObjectName)) continue;
                            result.computeIfAbsent(costCenter, val -> new ArrayList()).add(String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u8bbe\u7f6e\u4e3a\u201c\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u201d\uff0c\u4f46\u5bf9\u5e94\u6210\u672c\u7c7b\u578b\u672a\u8bbe\u7f6e\u201c\u6210\u672cBOM\u8bbe\u7f6e\u201d\u3002\u8bf7\u7ef4\u62a4\u7269\u6599\u7684\u6210\u672cBOM\u8bbe\u7f6e\u3002", (String)"ProductStdCheckAction_7", (String)"macc-aca-algox", (Object[])new Object[0]), costCenterName, diffObjectName));
                        }
                    }
                }
            }
        }
        return result;
    }

    private String checkAllSubEleSet(Map<Long, Set<Long>> costCenterItems, Map<Long, String> matSubElement, String errorMsg) {
        String errorDesc = "";
        if (!CadEmptyUtils.isEmpty(costCenterItems)) {
            Set<Long> costCenterSet = costCenterItems.keySet();
            DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", costCenterSet)});
            HashMap<Long, String> idNameMap = new HashMap<Long, String>(costCenters.size());
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
                for (DynamicObject costCenter : costCenters) {
                    idNameMap.put(costCenter.getLong("id"), costCenter.getString("name"));
                }
            }
            for (Map.Entry<Long, Set<Long>> costCenterSubEleEntry : costCenterItems.entrySet()) {
                Long costCenterId = costCenterSubEleEntry.getKey();
                Set<Long> subEleSet = costCenterSubEleEntry.getValue();
                Sets.SetView diff = Sets.difference(matSubElement.keySet(), subEleSet);
                if (diff.isEmpty()) continue;
                HashSet subEleNameSet = Sets.newHashSetWithExpectedSize((int)subEleSet.size());
                HashSet diffEleNameSet = Sets.newHashSetWithExpectedSize((int)diff.size());
                for (Long subEleId : subEleSet) {
                    subEleNameSet.add(matSubElement.get(subEleId));
                }
                for (Long diffEle : diff) {
                    diffEleNameSet.add(matSubElement.get(diffEle));
                }
                errorDesc = errorDesc.concat(String.format(errorMsg, idNameMap.get(costCenterId), StringUtils.join((Iterable)subEleNameSet, (String)","), StringUtils.join((Iterable)diffEleNameSet, (String)",")));
            }
        }
        return errorDesc;
    }
}

