/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.common;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.utils.PeriodHelper;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class ActCostCalcArgs
implements Serializable {
    private static final Log logger = LogFactory.getLog(ActCostCalcArgs.class);
    private static final long serialVersionUID = 6068067846420510043L;
    private Long orgId;
    private Long costAccountId;
    private Long prePeriodId;
    private Long periodId;
    private boolean isFirstPeriod;
    private Long nextPeriodId;
    private Date startDate;
    private Date endDate;
    private Long currencyId;
    private Long manuOrgId;
    private Long calSchemeId = 0L;
    private int amtScale;
    private int priceScale;
    private Long taskId;
    private Long checkConfigId;
    private int checkWay;
    private Long checkResultId;
    private Long calcReportId;
    private Long taskRecordId;
    private boolean calc;
    private Long costTypeId;
    private int maxMatLevel;
    private String debugKeyword;
    private Boolean allInvMatCalout;
    private Boolean calcReduct = Boolean.FALSE;
    private Boolean calccmpanal = Boolean.FALSE;
    private boolean onlycheckresult = Boolean.FALSE;
    private boolean conversionsubdetail = Boolean.TRUE;
    private boolean matlevelonecalout = Boolean.TRUE;
    private int nestmatcheck = 4000;
    private String debugColName;
    private String debugColVal;
    private Set<Long> assemblyCostCenterSet = Sets.newHashSetWithExpectedSize((int)32);
    private Set<Long> bomCostCenterSet = new HashSet<Long>(16);
    private Set<Long> costTypeSet = new HashSet<Long>(16);
    private Long levelEntryId = 0L;
    private String getLogUniqueKey;
    private Long defaultSubElementId = 0L;
    private List<Long> checkItemList = new ArrayList<Long>(10);
    private Set<Long> resultCostCenterIds = Sets.newHashSetWithExpectedSize((int)16);
    private Set<Long> resultCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
    private Map<Long, Set<Long>> matCostobjectListMap = new HashMap<Long, Set<Long>>();
    private Set<Long> cacheNotMatUseCostObjects;
    private Set<Long> cacheNestCalResultCostObjects;
    private boolean isCalbyCostElement = false;
    private boolean nestmatautorework = false;
    private boolean importfacttransfer = false;
    private String srcCalcJsonStr = null;
    private int calcsize = 1;
    private int currCalcIndex = 1;
    private boolean negaunitpricedeal = false;

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getCalSchemeId() {
        return this.calSchemeId;
    }

    public void setCalSchemeId(Long calSchemeId) {
        this.calSchemeId = calSchemeId;
    }

    public Long getCostAccountId() {
        return this.costAccountId;
    }

    public void setCostAccountId(Long costAccountId) {
        this.costAccountId = costAccountId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
        this.isFirstPeriod = PeriodHelper.isFirstPeriod(this.periodId);
    }

    public boolean isFirstPeriod() {
        return this.isFirstPeriod;
    }

    public Long getNextPeriodId() {
        return this.nextPeriodId;
    }

    public void setNextPeriodId(Long nextPeriodId) {
        this.nextPeriodId = nextPeriodId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public int getAmtScale() {
        return this.amtScale;
    }

    public void setAmtScale(int amtScale) {
        this.amtScale = amtScale;
    }

    public int getPriceScale() {
        return this.priceScale;
    }

    public void setPriceScale(int priceScale) {
        this.priceScale = priceScale;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getCheckConfigId() {
        return this.checkConfigId;
    }

    public void setCheckConfigId(Long checkConfigId) {
        this.checkConfigId = checkConfigId;
    }

    public Long getCheckResultId() {
        return this.checkResultId;
    }

    public void setCheckResultId(Long checkResultId) {
        this.checkResultId = checkResultId;
    }

    public Long getCalcReportId() {
        return this.calcReportId;
    }

    public void setCalcReportId(Long calcReportId) {
        this.calcReportId = calcReportId;
    }

    public Long getTaskRecordId() {
        return this.taskRecordId;
    }

    public void setTaskRecordId(Long taskRecordId) {
        this.taskRecordId = taskRecordId;
    }

    public int getCheckWay() {
        return this.checkWay;
    }

    public void setCheckWay(int checkWay) {
        this.checkWay = checkWay;
    }

    public boolean getCalc() {
        return this.calc;
    }

    public void setCalc(boolean calc) {
        this.calc = calc;
    }

    public Long getPrePeriodId() {
        return this.prePeriodId;
    }

    public void setPrePeriodId(Long prePeriodId) {
        this.prePeriodId = prePeriodId;
    }

    public Set<Long> getBomCostCenterSet() {
        return this.bomCostCenterSet;
    }

    public Set<Long> getCostTypeSet() {
        return this.costTypeSet;
    }

    public static String toJSONString(ActCostCalcArgs args) {
        if (args == null) {
            return null;
        }
        JSONObject params = new JSONObject();
        if (args.getOrgId() != null) {
            params.accumulate("org", (Object)args.getOrgId());
        }
        if (args.getCostAccountId() != null) {
            params.accumulate("costaccount", (Object)args.getCostAccountId());
        }
        if (args.getPeriodId() != null) {
            params.accumulate("period", (Object)args.getPeriodId());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (args.getStartDate() != null) {
            params.accumulate("startDate", (Object)simpleDateFormat.format(args.getStartDate()));
        }
        if (args.getEndDate() != null) {
            params.accumulate("endDate", (Object)simpleDateFormat.format(args.getEndDate()));
        }
        if (args.getCurrencyId() != null) {
            params.accumulate("currencyId", (Object)args.getCurrencyId());
        }
        params.accumulate("checkway", (Object)String.valueOf(args.getCheckWay()));
        if (args.getCheckConfigId() != null) {
            params.accumulate("checkConfigId", (Object)args.getCheckConfigId());
        }
        if (args.getCheckResultId() != null) {
            params.accumulate("checkResultId", (Object)args.getCheckResultId());
        }
        params.accumulate("calc", args.getCalc());
        if (args.getTaskRecordId() != null) {
            params.accumulate("taskRecordId", (Object)args.getTaskRecordId().toString());
        }
        if (args.getCalcReportId() != null) {
            params.accumulate("calcReportId", (Object)args.getCalcReportId());
        }
        if (args.getCalSchemeId() != null) {
            params.accumulate("calSchemeId", (Object)args.getCalSchemeId());
        }
        params.accumulate("allinvmatcalout", (Object)args.getAllInvMatCalout());
        params.accumulate("calcreduct", (Object)args.getCalcReduct());
        params.accumulate("nestmatautorework", args.isNestmatautorework());
        params.accumulate("matlevelonecalout", args.isMatlevelonecalout());
        params.accumulate("importfacttransfer", args.isImportfacttransfer());
        params.accumulate("negaunitpricedeal", args.isNegaunitpricedeal());
        return params.toString();
    }

    public static ActCostCalcArgs fromJSONString(String costParamString) {
        if (StringUtils.isBlank((String)costParamString)) {
            return null;
        }
        JSONObject checkParamJs = JSONObject.fromObject((Object)costParamString);
        ActCostCalcArgs args = new ActCostCalcArgs();
        args.setSrcCalcJsonStr(costParamString);
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "orgId")) {
            args.setOrgId(Long.parseLong(checkParamJs.getString("orgId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "costaccount")) {
            args.setCostAccountId(Long.parseLong(checkParamJs.getString("costaccount")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "period")) {
            args.setPeriodId(Long.parseLong(checkParamJs.getString("period")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "manuOrgId")) {
            args.setManuOrgId(Long.parseLong(checkParamJs.getString("manuOrgId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calSchemeId")) {
            args.setCalSchemeId(Long.parseLong(checkParamJs.getString("calSchemeId")));
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (ActCostCalcArgs.isNotNullValue(checkParamJs, "startDate")) {
                args.setStartDate(simpleDateFormat.parse(checkParamJs.getString("startDate")));
            }
            if (ActCostCalcArgs.isNotNullValue(checkParamJs, "endDate")) {
                args.setEndDate(simpleDateFormat.parse(checkParamJs.getString("endDate")));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "currencyId")) {
            args.setCurrencyId(Long.parseLong(checkParamJs.getString("currencyId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "checkway")) {
            args.setCheckWay(Integer.parseInt(checkParamJs.getString("checkway")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "checkConfigId")) {
            args.setCheckConfigId(Long.parseLong(checkParamJs.getString("checkConfigId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "checkResultId")) {
            args.setCheckResultId(Long.parseLong(checkParamJs.getString("checkResultId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calc")) {
            args.setCalc(Boolean.parseBoolean(checkParamJs.getString("calc")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "taskRecordId")) {
            args.setTaskRecordId(Long.parseLong(checkParamJs.getString("taskRecordId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calcReportId")) {
            args.setCalcReportId(Long.parseLong(checkParamJs.getString("calcReportId")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "allinvmatcalout")) {
            args.setAllInvMatCalout(Boolean.parseBoolean(checkParamJs.getString("allinvmatcalout")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calcreduct")) {
            args.setCalcReduct(Boolean.parseBoolean(checkParamJs.getString("calcreduct")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "conversionsubdetail")) {
            args.setConversionsubdetail(Boolean.parseBoolean(checkParamJs.getString("conversionsubdetail")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "nestmatautorework")) {
            args.setNestmatautorework(Boolean.parseBoolean(checkParamJs.getString("nestmatautorework")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "matlevelonecalout")) {
            args.setMatlevelonecalout(Boolean.parseBoolean(checkParamJs.getString("matlevelonecalout")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "importfacttransfer")) {
            args.setImportfacttransfer(Boolean.parseBoolean(checkParamJs.getString("importfacttransfer")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "nestmatcheck")) {
            args.setNestmatcheck(Integer.parseInt(checkParamJs.getString("nestmatcheck")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "negaunitpricedeal")) {
            args.setNegaunitpricedeal(Boolean.parseBoolean(checkParamJs.getString("negaunitpricedeal")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calcsize")) {
            args.setCalcsize(Integer.parseInt(checkParamJs.getString("calcsize")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "currCalcIndex")) {
            args.setCurrCalcIndex(Integer.parseInt(checkParamJs.getString("currCalcIndex")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "calccmpanal")) {
            args.setCalccmpanal(Boolean.parseBoolean(checkParamJs.getString("calccmpanal")));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "checkItemList")) {
            args.getCheckItemList().addAll((Collection<Long>)checkParamJs.getJSONArray("checkItemList"));
        }
        if (ActCostCalcArgs.isNotNullValue(checkParamJs, "onlycheckresult")) {
            args.setOnlycheckresult(Boolean.parseBoolean(checkParamJs.getString("onlycheckresult")));
        }
        return args;
    }

    private static boolean isNotNullValue(JSONObject checkParamJs, String key) {
        if (!checkParamJs.containsKey((Object)key)) {
            return false;
        }
        Object value = checkParamJs.get(key);
        if (value instanceof JSONNull) {
            return false;
        }
        return value != null;
    }

    public Long getCostTypeId() {
        return this.costTypeId;
    }

    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }

    public String getGetLogUniqueKey() {
        if (this.getCalcReportId() != null) {
            return this.getCalcReportId().toString();
        }
        return " ";
    }

    public Boolean getAllInvMatCalout() {
        return this.allInvMatCalout;
    }

    public void setAllInvMatCalout(Boolean allInvMatCalout) {
        this.allInvMatCalout = allInvMatCalout;
    }

    public int getMaxMatLevel() {
        return this.maxMatLevel;
    }

    public void setMaxMatLevel(int maxMatLevel) {
        this.maxMatLevel = maxMatLevel;
    }

    public Long getManuOrgId() {
        return this.manuOrgId;
    }

    public void setManuOrgId(Long manuOrgId) {
        this.manuOrgId = manuOrgId;
    }

    public String getDebugKeyword() {
        return this.debugKeyword;
    }

    public void setDebugKeyword(String debugKeyword) {
        if (StringUtils.isEmpty((String)this.debugKeyword)) {
            this.debugKeyword = debugKeyword;
        }
    }

    public Set<Long> getResultCostCenterIds() {
        return this.resultCostCenterIds;
    }

    public void setResultCostCenterIds(Set<Long> resultCostCenterIds) {
        this.resultCostCenterIds = resultCostCenterIds;
    }

    public Set<Long> getResultCostObjectIds() {
        return this.resultCostObjectIds;
    }

    public void setResultCostObjectIds(Set<Long> resultCostObjectIds) {
        this.resultCostObjectIds = resultCostObjectIds;
    }

    public String getDebugColName() {
        return this.debugColName;
    }

    public String getDebugColVal() {
        return this.debugColVal;
    }

    public void setDebugColName(String debugColName) {
        if (StringUtils.isEmpty((String)this.debugColName)) {
            this.debugColName = debugColName;
        }
    }

    public void setDebugColVal(String debugColVal) {
        if (StringUtils.isEmpty((String)this.debugColVal)) {
            this.debugColVal = debugColVal;
        }
    }

    public Map<Long, Set<Long>> getMatCostobjectListMap() {
        return this.matCostobjectListMap;
    }

    public Set<Long> getCacheNotMatUseCostObjects() {
        return this.cacheNotMatUseCostObjects;
    }

    public void setCacheNotMatUseCostObjects(Set<Long> cacheNotMatUseCostObjects) {
        this.cacheNotMatUseCostObjects = cacheNotMatUseCostObjects;
    }

    public Set<Long> getCacheNestCalResultCostObjects() {
        return this.cacheNestCalResultCostObjects;
    }

    public void setCacheNestCalResultCostObjects(Set<Long> cacheNestCalResultCostObjects) {
        this.cacheNestCalResultCostObjects = cacheNestCalResultCostObjects;
    }

    public Set<Long> getAssemblyCostCenterSet() {
        return this.assemblyCostCenterSet;
    }

    public Boolean getCalcReduct() {
        return this.calcReduct;
    }

    public void setCalcReduct(Boolean calcReduct) {
        this.calcReduct = calcReduct;
    }

    public Boolean getCalccmpanal() {
        return this.calccmpanal;
    }

    public void setCalccmpanal(Boolean calccmpanal) {
        this.calccmpanal = calccmpanal;
    }

    public List<Long> getCheckItemList() {
        return this.checkItemList;
    }

    public Long getLevelEntryId() {
        return this.levelEntryId;
    }

    public void setLevelEntryId(Long levelEntryId) {
        this.levelEntryId = levelEntryId;
    }

    public Long getDefaultSubElementId() {
        return this.defaultSubElementId;
    }

    public void setDefaultSubElementId(Long defaultSubElementId) {
        this.defaultSubElementId = defaultSubElementId;
    }

    public boolean getConversionsubdetail() {
        return this.conversionsubdetail;
    }

    public void setConversionsubdetail(boolean conversionsubdetail) {
        this.conversionsubdetail = conversionsubdetail;
    }

    public boolean isMatlevelonecalout() {
        return this.matlevelonecalout;
    }

    public void setMatlevelonecalout(boolean matlevelonecalout) {
        this.matlevelonecalout = matlevelonecalout;
    }

    public int getNestmatcheck() {
        return this.nestmatcheck;
    }

    public void setNestmatcheck(int nestmatcheck) {
        this.nestmatcheck = nestmatcheck;
    }

    public boolean isCalbyCostElement() {
        return this.isCalbyCostElement;
    }

    public void setCalbyCostElement(boolean isCalbyCostElement) {
        this.isCalbyCostElement = isCalbyCostElement;
    }

    public boolean isNestmatautorework() {
        return this.nestmatautorework;
    }

    public void setNestmatautorework(boolean nestmatautorework) {
        this.nestmatautorework = nestmatautorework;
    }

    public boolean isImportfacttransfer() {
        return this.importfacttransfer;
    }

    public void setImportfacttransfer(boolean importfacttransfer) {
        this.importfacttransfer = importfacttransfer;
    }

    public String getSrcCalcJsonStr() {
        return this.srcCalcJsonStr;
    }

    public void setSrcCalcJsonStr(String srcCalcJsonStr) {
        this.srcCalcJsonStr = srcCalcJsonStr;
    }

    public int getCalcsize() {
        return this.calcsize;
    }

    public void setCalcsize(int calcsize) {
        if (calcsize > 10) {
            calcsize = 10;
        }
        this.calcsize = calcsize;
    }

    public int getCurrCalcIndex() {
        return this.currCalcIndex;
    }

    public void setCurrCalcIndex(int currCalcIndex) {
        this.currCalcIndex = currCalcIndex;
    }

    public boolean isNegaunitpricedeal() {
        return this.negaunitpricedeal;
    }

    public void setNegaunitpricedeal(boolean negaunitpricedeal) {
        this.negaunitpricedeal = negaunitpricedeal;
    }

    public boolean isOnlycheckresult() {
        return this.onlycheckresult;
    }

    public void setOnlycheckresult(boolean onlycheckresult) {
        this.onlycheckresult = onlycheckresult;
    }
}

