/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class ActCalcAdjuctSubDataDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = new RowMeta(new Field[]{new Field("costObjectId", (DataType)DataType.LongType), new Field("relaCostObjectId", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("subMatId", (DataType)DataType.LongType), new Field("subMatVerId", (DataType)DataType.LongType), new Field("subMatAuxId", (DataType)DataType.LongType), new Field("calckeycol", (DataType)DataType.LongType), new Field("selement", (DataType)DataType.LongType), new Field("ssubelement", (DataType)DataType.LongType), new Field("spdstartamt", (DataType)DataType.BigDecimalType), new Field("spdstartadjamt", (DataType)DataType.BigDecimalType), new Field("spdcurramt", (DataType)DataType.BigDecimalType), new Field("spdcomamt", (DataType)DataType.BigDecimalType), new Field("spdendamt", (DataType)DataType.BigDecimalType), new Field("spdendadjamt", (DataType)DataType.BigDecimalType), new Field("spdyearsumamt", (DataType)DataType.BigDecimalType), new Field("spdsumamt", (DataType)DataType.BigDecimalType), new Field("spdyearcomamt", (DataType)DataType.BigDecimalType), new Field("spdsumcomamt", (DataType)DataType.BigDecimalType)});

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        ArrayList collectRows = Lists.newArrayList();
        for (RowX row : rows) {
            List<Object[]> params;
            String adjusttype = row.getString(this.sourceRowMeta.getFieldIndex("adjusttype"));
            String subitemjson = row.getString(this.sourceRowMeta.getFieldIndex("subitemjson_tag"));
            if (StringUtils.isEmpty((CharSequence)subitemjson) || (params = this.analysisJson(subitemjson)).isEmpty()) continue;
            RowX baseRow = this.getResultBaseRow(row);
            for (Object[] param : params) {
                RowX newRow = baseRow.copy();
                newRow.set(this.rowMeta.getFieldIndex("selement"), param[0]);
                newRow.set(this.rowMeta.getFieldIndex("ssubelement"), param[1]);
                if ("START".equals(adjusttype)) {
                    newRow.set(this.rowMeta.getFieldIndex("spdstartadjamt"), param[2]);
                } else {
                    newRow.set(this.rowMeta.getFieldIndex("spdendadjamt"), param[2]);
                }
                collectRows.add(newRow);
            }
        }
        for (RowX row : collectRows) {
            collector.collect(row);
        }
    }

    private RowX getResultBaseRow(RowX row) {
        RowX baseRow = new RowX(this.rowMeta.getFieldCount());
        baseRow.set(this.rowMeta.getFieldIndex("costObjectId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId")));
        baseRow.set(this.rowMeta.getFieldIndex("relaCostObjectId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("relaCostObjectId")));
        baseRow.set(this.rowMeta.getFieldIndex("subelement"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("subelement")));
        baseRow.set(this.rowMeta.getFieldIndex("subMatId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("subMatId")));
        baseRow.set(this.rowMeta.getFieldIndex("subMatVerId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("subMatVerId")));
        baseRow.set(this.rowMeta.getFieldIndex("subMatAuxId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("subMatAuxId")));
        baseRow.set(this.rowMeta.getFieldIndex("calckeycol"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("calckeycol")));
        return baseRow;
    }

    private List<Object[]> analysisJson(String json) {
        JSONArray arr = JSONArray.fromObject((Object)json);
        ArrayList<Object[]> params = new ArrayList<Object[]>(arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            Long selement = obj.getLong("selement");
            Long ssubelement = obj.getLong("ssubelement");
            if (CadEmptyUtils.isEmpty((Long)selement) || CadEmptyUtils.isEmpty((Long)ssubelement)) continue;
            Object[] param = new Object[]{selement, ssubelement, new BigDecimal(obj.getString("sadjustamt"))};
            params.add(param);
        }
        return params;
    }
}

