/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;

public class ActCalcInvResultSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Map<Long, Long> calcResultMap = null;
    private static final String INSERT_INVENTRY_ENTRY_SQL = "insert into t_aca_calcresultinventry (fid, fentryid, fsourcebillentryid, fsourcebillid, finventoryamount, finventoryqty, finventorysubeleid, finvcostobjectid, finvproducttype, finvoutsourcetype, fgroupfield, fgroupcategoryid, fcarrytype) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public ActCalcInvResultSaveFunction(Map<Long, Long> calcResultMap) {
        this.calcResultMap = calcResultMap;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<Object[]> addResultEntryIds = new ArrayList<Object[]>(128);
        for (RowX row : iterable) {
            collector.collect(row);
            String carrytype = row.getString(this.sourceRowMeta.getFieldIndex("carrytype"));
            Long srcBillId = row.getLong(this.sourceRowMeta.getFieldIndex("srcBillId"));
            Long srcEntryId = row.getLong(this.sourceRowMeta.getFieldIndex("srcEntryId"));
            Long subElementId = row.getLong(this.sourceRowMeta.getFieldIndex("subElementId"));
            String outSourceType = row.getString(this.sourceRowMeta.getFieldIndex("outsourcetype"));
            Long costObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
            Long mainCostObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("mainCostObjectId"));
            String productType = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
            BigDecimal finQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("proFinQty"));
            BigDecimal cost = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost"));
            String groupField = row.getString(this.sourceRowMeta.getFieldIndex("groupfield"));
            Long groupCategoryid = row.getLong(this.sourceRowMeta.getFieldIndex("groupcategoryid"));
            Long calcResultId = this.calcResultMap.get(mainCostObjectId);
            if (calcResultId == null) continue;
            addResultEntryIds.add(new Object[]{calcResultId, ID.genLongId(), srcEntryId, srcBillId, cost, finQty, subElementId, costObjectId, productType, outSourceType, groupField, groupCategoryid, carrytype});
            if (addResultEntryIds.size() <= 2000) continue;
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_INVENTRY_ENTRY_SQL, addResultEntryIds);
            addResultEntryIds.clear();
        }
        if (!addResultEntryIds.isEmpty()) {
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_INVENTRY_ENTRY_SQL, addResultEntryIds);
            addResultEntryIds.clear();
        }
    }

    private void executeBatch(DBRoute route, String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)route, (String)sql, entrys);
    }
}

