/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ActSubItemRow;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ActCalcResultSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8750794000883579691L;
    private static final Log logger = LogFactory.getLog(ActCalcResultSaveFunction.class);
    private RowMeta srcMeta;
    private ActCostCalcArgs args;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;

    public ActCalcResultSaveFunction(RowMeta rowMeta, ActCostCalcArgs args, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList iterRows = Lists.newArrayList();
        for (RowX row : iterable) {
            iterRows.add(row);
        }
        if (iterRows.isEmpty()) {
            return;
        }
        Long mainCostObjectId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long costCenterId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("costCenterId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(mainCostObjectId)) {
            return;
        }
        Map<Long, AcaResultFinalResultVO> resultVoMaps = this.calcCostobjectFinalResultMap.get(mainCostObjectId);
        HashMap costObjectRowsMap = Maps.newHashMapWithExpectedSize((int)resultVoMaps.size());
        for (RowX row : iterRows) {
            Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
            costObjectRowsMap.computeIfAbsent(costObjectId, t -> Lists.newArrayList()).add(row);
        }
        DynamicObject calcResult = this.createCalcResultBill(costCenterId, mainCostObjectId);
        DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Map.Entry<Long, AcaResultFinalResultVO> entry : resultVoMaps.entrySet()) {
            seq = this.generateEntryEntityRow(entryEntity, (List)costObjectRowsMap.get(entry.getKey()), entry.getKey(), entry.getValue(), seq);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcResult});
    }

    private int generateEntryEntityRow(DynamicObjectCollection entryEntity, List<RowX> costobjectRows, Long costobjectId, AcaResultFinalResultVO resultVo, int seq) {
        Long matId = 0L;
        Long matVerId = 0L;
        Long matAuxId = 0L;
        int matUnitPrecision = 0;
        BigDecimal proFinQty = BigDecimal.ZERO;
        BigDecimal proPlanQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalFinAmt = BigDecimal.ZERO;
        BigDecimal totalInAmt = BigDecimal.ZERO;
        BigDecimal totalPdStartAmt = BigDecimal.ZERO;
        BigDecimal totalPdStartAdjAmt = BigDecimal.ZERO;
        BigDecimal totalPdEndAdjAmt = BigDecimal.ZERO;
        BigDecimal totalPdSumAmt = BigDecimal.ZERO;
        BigDecimal totalSumComAmt = BigDecimal.ZERO;
        BigDecimal totalYearPdSumAmt = BigDecimal.ZERO;
        BigDecimal totalYearSumComAmt = BigDecimal.ZERO;
        BigDecimal proPdStartQty = BigDecimal.ZERO;
        BigDecimal proStartAdjQty = BigDecimal.ZERO;
        BigDecimal proEndAdjQty = BigDecimal.ZERO;
        BigDecimal proPdSumQty = BigDecimal.ZERO;
        BigDecimal proSumComQty = BigDecimal.ZERO;
        BigDecimal proYearSumInputQty = BigDecimal.ZERO;
        BigDecimal proYearSumFinishQty = BigDecimal.ZERO;
        BigDecimal totalCurrComQty = BigDecimal.ZERO;
        if (resultVo.getMatUnitPrecision() != null) {
            matUnitPrecision = resultVo.getMatUnitPrecision();
        }
        proFinQty = resultVo.getProFinQty();
        proPlanQty = resultVo.getProPlanQty();
        proPdStartQty = resultVo.getPdStartQty();
        proStartAdjQty = resultVo.getStartAdjQty();
        proEndAdjQty = resultVo.getEndAdjQty();
        proPdSumQty = resultVo.getPdSumQty();
        proSumComQty = resultVo.getSumComQty();
        proYearSumInputQty = resultVo.getYearSumInputQty();
        proYearSumFinishQty = resultVo.getYearSumFinishQty();
        totalCurrComQty = proSumComQty.add(proFinQty).subtract(proEndAdjQty);
        if (!this.args.isFirstPeriod()) {
            proYearSumInputQty = proYearSumInputQty.add(proPlanQty);
            proYearSumFinishQty = proYearSumFinishQty.add(proFinQty);
        } else {
            proYearSumInputQty = proPlanQty;
            proYearSumFinishQty = proFinQty;
        }
        proYearSumFinishQty = proYearSumFinishQty.subtract(proEndAdjQty);
        int i = 0;
        if (!CollectionUtils.isEmpty(costobjectRows)) {
            for (RowX row : costobjectRows) {
                if (i == 0) {
                    matId = row.getLong(this.srcMeta.getFieldIndex("matId"));
                    matVerId = row.getLong(this.srcMeta.getFieldIndex("matVerId"));
                    matAuxId = row.getLong(this.srcMeta.getFieldIndex("matAuxId"));
                }
                Long subMatId = row.getLong(this.srcMeta.getFieldIndex("subMatId"));
                Long subMatVerId = row.getLong(this.srcMeta.getFieldIndex("subMatVerId"));
                Long subMatAuxId = row.getLong(this.srcMeta.getFieldIndex("subMatAuxId"));
                Long calckeycol = row.getLong(this.srcMeta.getFieldIndex("calckeycol"));
                Integer subMatUnitPrecision = row.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                Long elementId = row.getLong(this.srcMeta.getFieldIndex("elementId"));
                Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
                int isMfg = row.getInteger(this.srcMeta.getFieldIndex("isMfg"));
                if (CadEmptyUtils.isEmpty((Long)subMatId) && isMfg == 0) {
                    isMfg = 1;
                }
                BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
                qty = qty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("amount")));
                totalAmount = totalAmount.add(amount);
                BigDecimal finQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
                finQty = finQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal finAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
                totalFinAmt = totalFinAmt.add(finAmt);
                BigDecimal inQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("inQty")));
                BigDecimal inAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("inAmt")));
                totalInAmt = totalInAmt.add(inAmt);
                BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
                BigDecimal startadjqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("startadjqty")));
                BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
                totalPdStartAmt = totalPdStartAmt.add(pdStartAmt);
                BigDecimal startadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("startadjamt")));
                totalPdStartAdjAmt = totalPdStartAdjAmt.add(startadjamt);
                BigDecimal endadjqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("endadjqty")));
                BigDecimal endadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("endadjamt")));
                totalPdEndAdjAmt = totalPdEndAdjAmt.add(endadjamt);
                BigDecimal pdSumQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdSumQty")));
                BigDecimal pdSumAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdSumAmt")));
                totalPdSumAmt = totalPdSumAmt.add(pdSumAmt);
                BigDecimal yearPdSumQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumInputQty")));
                yearPdSumQty = this.args.isFirstPeriod() ? qty : yearPdSumQty.add(qty);
                BigDecimal yearPdSumAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumInputAmt")));
                yearPdSumAmt = this.args.isFirstPeriod() ? amount : yearPdSumAmt.add(amount);
                totalYearPdSumAmt = totalYearPdSumAmt.add(yearPdSumAmt);
                BigDecimal sumComQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("sumComQty")));
                BigDecimal sumComAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("sumComAmt")));
                totalSumComAmt = totalSumComAmt.add(sumComAmt);
                BigDecimal yearSumComQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumFinishQty")));
                yearSumComQty = this.args.isFirstPeriod() ? finQty : yearSumComQty.add(finQty);
                yearSumComQty = yearSumComQty.subtract(endadjqty);
                BigDecimal yearSumComAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("yearSumFinishAmt")));
                yearSumComAmt = this.args.isFirstPeriod() ? finAmt : yearSumComAmt.add(finAmt);
                yearSumComAmt = yearSumComAmt.subtract(endadjamt);
                totalYearSumComAmt = totalYearSumComAmt.add(yearSumComAmt);
                DynamicObject entry = entryEntity.addNew();
                entry.set("seq", (Object)seq++);
                entry.set("type", (Object)"detail");
                entry.set("feetype", (Object)(isMfg == 1 ? "mfgFee" : "materialFee"));
                entry.set("relacostobject", (Object)costobjectId);
                entry.set("relaproducttype", (Object)resultVo.getProductType());
                if (Boolean.TRUE.equals(resultVo.getOutsource())) {
                    String outSourceType = row.getString(this.srcMeta.getFieldIndex("outsourcetype"));
                    entry.set("outsourcetype", (Object)outSourceType);
                }
                entry.set("material", (Object)matId);
                entry.set("matversion", (Object)matVerId);
                entry.set("auxpty", (Object)matAuxId);
                entry.set("calckeycol", (Object)calckeycol);
                entry.set("element", (Object)elementId);
                entry.set("subelement", (Object)subElementId);
                entry.set("submaterial", (Object)subMatId);
                entry.set("submatversion", (Object)subMatVerId);
                entry.set("subauxpty", (Object)subMatAuxId);
                entry.set("pdstartqty", (Object)pdStartQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("pdstartamount", (Object)pdStartAmt);
                entry.set("startadjqty", (Object)startadjqty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("startadjamt", (Object)startadjamt);
                entry.set("pdcurrqty", (Object)qty);
                entry.set("pdcurramount", (Object)amount);
                BigDecimal pdSumAmount = amount.add(pdSumAmt);
                if (!BigDecimalUtil.isOutOfRange(pdSumAmount)) {
                    entry.set("pdsumqty", (Object)qty.add(pdSumQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                    entry.set("pdsumamount", (Object)pdSumAmount);
                } else {
                    entry.set("pdsumqty", (Object)BigDecimal.ZERO);
                    entry.set("pdsumamount", (Object)BigDecimal.ZERO);
                }
                entry.set("yearpdsumqty", (Object)yearPdSumQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("yearpdsumamount", (Object)yearPdSumAmt);
                entry.set("currcomqty", (Object)finQty);
                entry.set("currcomamount", (Object)finAmt);
                BigDecimal currentCompletedUnitCost = BigDecimal.ZERO;
                if (finQty.compareTo(BigDecimal.ZERO) != 0) {
                    currentCompletedUnitCost = finAmt.divide(finQty, this.args.getPriceScale(), 4);
                }
                entry.set("currcomunitcost", (Object)this.setUnitCost(currentCompletedUnitCost));
                if (proFinQty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal currentCompletedUsed = finQty.divide(proFinQty, 10, 4);
                    entry.set("currcomuse", (Object)currentCompletedUsed);
                    if (isMfg == 1) {
                        BigDecimal mfgFeeSubElementUnitCost = finAmt.divide(proFinQty, this.args.getPriceScale(), 4);
                        entry.set("currcomunitcost", (Object)this.setUnitCost(mfgFeeSubElementUnitCost));
                    }
                }
                entry.set("pdendqty", (Object)inQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("pdendamount", (Object)inAmt);
                entry.set("endadjqty", (Object)endadjqty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("endadjamt", (Object)endadjamt);
                BigDecimal finSumQty = sumComQty.add(finQty).subtract(endadjqty);
                BigDecimal finSumAmt = sumComAmt.add(finAmt).subtract(endadjamt);
                if (!BigDecimalUtil.isOutOfRange(finSumAmt)) {
                    entry.set("sumcomamount", (Object)finSumAmt);
                } else {
                    entry.set("sumcomamount", (Object)BigDecimal.ZERO);
                }
                if (!BigDecimalUtil.isOutOfRange(finSumQty)) {
                    entry.set("sumcomqty", (Object)finSumQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                } else {
                    entry.set("sumcomqty", (Object)BigDecimal.ZERO);
                }
                if (finSumQty.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("sumcomunitcost", (Object)this.setUnitCost(finSumAmt.divide(finSumQty, this.args.getPriceScale(), 4)));
                }
                if (totalCurrComQty.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("sumcomuse", (Object)finSumQty.divide(totalCurrComQty, 10, 4));
                    if (isMfg == 1) {
                        entry.set("sumcomunitcost", (Object)this.setUnitCost(finSumAmt.divide(totalCurrComQty, this.args.getPriceScale(), 4)));
                    }
                }
                entry.set("yearsumcomqty", (Object)yearSumComQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("yearsumcomamount", (Object)yearSumComAmt);
                if (yearSumComQty.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("yearsumcomunitcost", (Object)this.setUnitCost(yearSumComAmt.divide(yearSumComQty, this.args.getPriceScale(), 4)));
                }
                if (proYearSumFinishQty.compareTo(BigDecimal.ZERO) != 0) {
                    entry.set("yearsumcomuse", (Object)yearSumComQty.divide(proYearSumFinishQty, 10, 4));
                    if (isMfg == 1) {
                        entry.set("yearsumcomunitcost", (Object)this.setUnitCost(yearSumComAmt.divide(proYearSumFinishQty, this.args.getPriceScale(), 4)));
                    }
                }
                this.addSubItemRow(row, entry);
                ++i;
                if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(costobjectId))) continue;
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format("ActCalcResult-save-detail:FEE_TYPE %s,MATERIAL %s,MATVERSION %s,AUXPTY %s,ELEMENT %s,SUB_ELEMENT %s,SUB_MATERIAL %s,SUB_MAT_VERSION %s,SUB_AUXPTY %s,PD_START_QTY %s,PD_START_AMOUNT %s,PD_START_ADJQTY %s,PD_START_ADJAMOUNT %s,PD_CURR_QTY %s,PD_CURR_AMOUNT %s,PD_SUM_QTY %s,PD_SUM_AMOUNT %s,PD_END_QTY %s,PD_END_AMOUNT %s,PD_END_ADJQTY %s,PD_END_ADJAMOUNT %s,CURR_COM_QTY %s,CURR_COM_AMOUNT %s,CURR_COM_UNIT_COST %s,SUM_COM_QTY %s,SUM_COM_AMOUNT %s,YEAR_SUM_COM_QTY %s,YEAR_SUM_COM_AMOUNT %s", entry.get("feetype"), entry.get("material"), entry.get("matversion"), entry.get("auxpty"), entry.get("element"), entry.get("subelement"), entry.get("submaterial"), entry.get("submatversion"), entry.get("subauxpty"), entry.get("pdstartqty"), entry.get("pdstartamount"), entry.get("startadjqty"), entry.get("startadjamt"), entry.get("pdcurrqty"), entry.get("pdcurramount"), entry.get("pdsumqty"), entry.get("pdsumamount"), entry.get("pdendqty"), entry.get("pdendamount"), entry.get("endadjqty"), entry.get("endadjamt"), entry.get("currcomqty"), entry.get("currcomamount"), entry.get("currcomunitcost"), entry.get("sumcomqty"), entry.get("sumcomamount"), entry.get("yearsumcomqty"), entry.get("yearsumcomamount")));
            }
        }
        BigDecimal totalCurrComAmt = totalSumComAmt.add(totalFinAmt).subtract(totalPdEndAdjAmt);
        DynamicObject sumEntry = entryEntity.addNew();
        sumEntry.set("seq", (Object)seq++);
        sumEntry.set("type", (Object)"finalResult");
        sumEntry.set("relacostobject", (Object)costobjectId);
        sumEntry.set("relaproducttype", (Object)resultVo.getProductType());
        sumEntry.set("pdstartqty", (Object)proPdStartQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("pdstartamount", (Object)totalPdStartAmt);
        sumEntry.set("startadjqty", (Object)proStartAdjQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("startadjamt", (Object)totalPdStartAdjAmt);
        sumEntry.set("pdcurrqty", (Object)proPlanQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("pdcurramount", (Object)totalAmount);
        BigDecimal pdSumAmount = totalAmount.add(totalPdSumAmt);
        BigDecimal pdSumQty = proPlanQty.add(proPdSumQty).setScale(matUnitPrecision, RoundingMode.HALF_UP);
        if (!BigDecimalUtil.isOutOfRange(pdSumAmount)) {
            sumEntry.set("pdsumamount", (Object)pdSumAmount);
        } else {
            sumEntry.set("pdsumamount", (Object)BigDecimal.ZERO);
        }
        if (!BigDecimalUtil.isOutOfRange(pdSumQty)) {
            sumEntry.set("pdsumqty", (Object)pdSumQty);
        } else {
            sumEntry.set("pdsumqty", (Object)BigDecimal.ZERO);
        }
        sumEntry.set("yearpdsumqty", (Object)proYearSumInputQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("yearpdsumamount", (Object)totalYearPdSumAmt);
        sumEntry.set("currcomqty", (Object)proFinQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("currcomamount", (Object)totalFinAmt);
        if (proFinQty.compareTo(BigDecimal.ZERO) != 0) {
            sumEntry.set("currcomunitcost", (Object)this.setUnitCost(totalFinAmt.divide(proFinQty, this.args.getPriceScale(), 4)));
        }
        BigDecimal proIntryQty = resultVo.getPdEndQty().setScale(matUnitPrecision, RoundingMode.HALF_UP);
        sumEntry.set("pdendqty", (Object)proIntryQty);
        if ("C".equals(resultVo.getProductType())) {
            sumEntry.set("pdendamount", (Object)totalInAmt.setScale(this.args.getAmtScale(), 4));
        }
        sumEntry.set("endadjqty", (Object)proEndAdjQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("endadjamt", (Object)totalPdEndAdjAmt);
        if (!BigDecimalUtil.isOutOfRange(totalCurrComAmt)) {
            sumEntry.set("sumcomamount", (Object)totalCurrComAmt);
        } else {
            sumEntry.set("sumcomamount", (Object)BigDecimal.ZERO);
        }
        if (!BigDecimalUtil.isOutOfRange(totalCurrComQty)) {
            sumEntry.set("sumcomqty", (Object)totalCurrComQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        } else {
            sumEntry.set("sumcomqty", (Object)BigDecimal.ZERO);
        }
        if (totalCurrComQty.compareTo(BigDecimal.ZERO) != 0) {
            sumEntry.set("sumcomunitcost", (Object)this.setUnitCost(totalCurrComAmt.divide(totalCurrComQty, this.args.getPriceScale(), 4)));
        }
        sumEntry.set("yearsumcomqty", (Object)proYearSumFinishQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("yearsumcomamount", (Object)totalYearSumComAmt);
        if (proYearSumFinishQty.compareTo(BigDecimal.ZERO) != 0) {
            sumEntry.set("yearsumcomunitcost", (Object)this.setUnitCost(totalYearSumComAmt.divide(proYearSumFinishQty, this.args.getPriceScale(), 4)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costobjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format("ActCalcResult-svae-final:PD_START_QTY %s,PD_START_AMOUNT %s,PD_START_ADJQTY %s,PD_START_ADJAMOUNT %s,PD_CURR_QTY %s,PD_CURR_AMOUNT %s,PD_SUM_QTY %s,PD_SUM_AMOUNT %s,CURR_COM_QTY %s,CURR_COM_AMOUNT %s,PD_END_QTY %s,PD_END_AMOUNT %s,PD_END_ADJQTY %s,PD_END_ADJAMOUNT %s,SUM_COM_QTY %s,SUM_COM_AMOUNT %s,YEAR_SUM_COM_QTY %s,YEAR_SUM_COM_AMOUNT %s", sumEntry.get("pdstartqty"), sumEntry.get("pdstartamount"), sumEntry.get("startadjqty"), sumEntry.get("startadjamt"), sumEntry.get("pdcurrqty"), sumEntry.get("pdcurramount"), sumEntry.get("pdsumqty"), sumEntry.get("pdsumamount"), sumEntry.get("currcomqty"), sumEntry.get("currcomamount"), sumEntry.get("pdendqty"), sumEntry.get("pdendamount"), sumEntry.get("endadjqty"), sumEntry.get("endadjamt"), sumEntry.get("sumcomqty"), sumEntry.get("sumcomamount"), sumEntry.get("yearsumcomqty"), sumEntry.get("yearsumcomamount")));
        }
        return seq;
    }

    private BigDecimal setUnitCost(BigDecimal unitcost) {
        if (unitcost == null || unitcost.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return unitcost;
    }

    private void addSubItemRow(RowX row, DynamicObject entryRow) {
        int subjsonIndex = this.sourceRowMeta.getFieldIndex("subjson", false);
        if (subjsonIndex < 0) {
            return;
        }
        String subjson = row.getString(subjsonIndex);
        if (CadEmptyUtils.isEmpty((String)subjson)) {
            return;
        }
        List subItemRows = JSON.parseArray((String)subjson, ActSubItemRow.class);
        DynamicObjectCollection subdetail = entryRow.getDynamicObjectCollection("subdetail");
        for (ActSubItemRow subItemRow : subItemRows) {
            DynamicObject subRow = subdetail.addNew();
            subRow.set("selement", (Object)subItemRow.getSelement());
            subRow.set("ssubelement", (Object)subItemRow.getSsubelement());
            subRow.set("spdstartamt", (Object)subItemRow.getSpdstartamt());
            subRow.set("spdstartadjamt", (Object)subItemRow.getSpdstartadjamt());
            subRow.set("spdcurramt", (Object)subItemRow.getSpdcurramt());
            subRow.set("spdcomamt", (Object)subItemRow.getSpdcomamt());
            subRow.set("spdendamt", (Object)subItemRow.getSpdendamt());
            subRow.set("spdendadjamt", (Object)subItemRow.getSpdendadjamt());
            subRow.set("spdyearsumamt", (Object)subItemRow.getSpdyearsumamt());
            subRow.set("spdsumamt", (Object)subItemRow.getSpdsumamt());
            subRow.set("spdsumcomamt", (Object)subItemRow.getSpdsumcomamt());
            subRow.set("spdyearcomamt", (Object)subItemRow.getSpdyearcomamt());
        }
    }

    private DynamicObject createCalcResultBill(Long costCenterId, Long mainCostObjectId) {
        DynamicObject calcResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcresult");
        calcResult.set("calcreport", (Object)this.args.getCalcReportId());
        calcResult.set("billno", (Object)ID.genStringId());
        calcResult.set("billstatus", (Object)"A");
        calcResult.set("org", (Object)this.args.getOrgId());
        calcResult.set("costaccount", (Object)this.args.getCostAccountId());
        calcResult.set("currency", (Object)this.args.getCurrencyId());
        calcResult.set("bizdate", (Object)TimeServiceHelper.now());
        calcResult.set("period", (Object)this.args.getPeriodId());
        calcResult.set("costcenter", (Object)costCenterId);
        calcResult.set("costobject", (Object)mainCostObjectId);
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        calcResult.set("billstatus", (Object)"C");
        calcResult.set("createtime", (Object)date);
        calcResult.set("auditdate", (Object)date);
        calcResult.set("modifytime", (Object)date);
        calcResult.set("creator_id", (Object)userId);
        calcResult.set("modifier_id", (Object)userId);
        calcResult.set("auditor_id", (Object)userId);
        return calcResult;
    }
}

