/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ActCalcSideFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 2232400386910032900L;
    private static final Log logger = LogFactory.getLog(ActCalcSideFunction.class);
    private ActCostCalcArgs args;
    private Map<String, List<ProextraPriceVo>> proextraPriceMap;

    public ActCalcSideFunction(ActCostCalcArgs args, Map<String, List<ProextraPriceVo>> proextraPriceMap) {
        this.args = args;
        this.proextraPriceMap = proextraPriceMap;
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX row : iterable) {
            Long sideMatId = row.getLong(this.getSourceRowMeta().getFieldIndex("matId"));
            String sideMatver = row.getString(this.getSourceRowMeta().getFieldIndex("matVerId"));
            String auxptyId = row.getString(this.getSourceRowMeta().getFieldIndex("matAuxId"));
            String key = sideMatId + "@" + sideMatver + "@" + auxptyId;
            String costCenterId = row.getString(this.getSourceRowMeta().getFieldIndex("factedCostCenterId"));
            String manuorgId = row.getString(this.getSourceRowMeta().getFieldIndex("manuorgId"));
            BigDecimal qty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("proFinQty"));
            Boolean isOutSource = row.getBoolean(this.getSourceRowMeta().getFieldIndex("isoutsource"));
            List<ProextraPriceVo> sidePriceDyo = ActCalcFunctionHelper.getsidePriceDyo(this.proextraPriceMap, key, costCenterId, manuorgId);
            if (sidePriceDyo == null || sidePriceDyo.isEmpty()) continue;
            for (ProextraPriceVo tmpEntry : sidePriceDyo) {
                BigDecimal sidePrice = BigDecimalUtil.getOrZero(tmpEntry.getPrice());
                Long elementId = tmpEntry.getElement();
                Long subElementId = tmpEntry.getSubelement();
                String subElementType = tmpEntry.getSubelementType();
                BigDecimal cost = sidePrice.multiply(qty).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
                RowX newRow = row.copy();
                newRow.set(this.getSourceRowMeta().getFieldIndex("elementId"), (Object)elementId);
                newRow.set(this.getSourceRowMeta().getFieldIndex("subElementId"), (Object)subElementId);
                newRow.set(this.getSourceRowMeta().getFieldIndex("cost"), (Object)cost);
                if (Boolean.TRUE.equals(isOutSource)) {
                    if ("001".equals(subElementType) || "002".equals(subElementType)) {
                        newRow.set(this.getSourceRowMeta().getFieldIndex("outsourcetype"), (Object)"D");
                    } else {
                        newRow.set(this.getSourceRowMeta().getFieldIndex("outsourcetype"), (Object)"A");
                    }
                } else {
                    newRow.set(this.getSourceRowMeta().getFieldIndex("outsourcetype"), (Object)"");
                }
                collector.collect(newRow);
            }
        }
    }
}

