/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ActCarryForwardCalcFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(ActCarryForwardCalcFunction.class);
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private ActCostCalcArgs args;
    private boolean isCarryNotInAmtCalc = true;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public ActCarryForwardCalcFunction(RowMeta rowMeta, ActCostCalcArgs args, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap, boolean isCarryNotInAmtCalc) {
        this.srcMeta = rowMeta;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.args = args;
        this.isCarryNotInAmtCalc = isCarryNotInAmtCalc;
    }

    public void reduce(Iterable<RowX> iter, Collector col) {
        ArrayList rows = Lists.newArrayList();
        boolean headFlag = false;
        boolean detailFlag = false;
        boolean preFlag = false;
        for (RowX row : iter) {
            rows.add(row);
        }
        int i = 0;
        Long costObjectId = 0L;
        Long costCenterId = 0L;
        boolean isHasFinQty = false;
        boolean isOnlySideFact = false;
        for (RowX row : rows) {
            if (i == 0) {
                costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
                costCenterId = row.getLong(this.srcMeta.getFieldIndex("costCenterId"));
                BigDecimal proPlanQty = BigDecimal.ZERO;
                BigDecimal pdStartQty = BigDecimal.ZERO;
                BigDecimal startAdjQty = BigDecimal.ZERO;
                BigDecimal endAdjQty = BigDecimal.ZERO;
                BigDecimal endcheckQty = null;
                Map<Long, AcaResultFinalResultVO> calcFinalResultMap = this.calcCostobjectFinalResultMap.get(costObjectId);
                if (calcFinalResultMap != null) {
                    isOnlySideFact = ActCalcFunctionHelper.isOnlySideFactned(calcFinalResultMap);
                    for (Map.Entry<Long, AcaResultFinalResultVO> entry : calcFinalResultMap.entrySet()) {
                        AcaResultFinalResultVO value = entry.getValue();
                        proPlanQty = proPlanQty.add(value.getProPlanQty());
                        if (!CollectionUtils.isEmpty(value.getCostcenterFinQtyMap())) {
                            isHasFinQty = true;
                        }
                        pdStartQty = pdStartQty.add(value.getPdStartQty());
                        startAdjQty = startAdjQty.add(value.getStartAdjQty());
                        endAdjQty = endAdjQty.add(value.getEndAdjQty());
                        if (value.getPdEndCheckQty() == null || value.getPdEndCheckQty().compareTo(BigDecimal.ZERO) == 0 && value.getPdEndQty().compareTo(BigDecimal.ZERO) == 0) continue;
                        if (endcheckQty == null) {
                            endcheckQty = value.getPdEndCheckQty();
                            continue;
                        }
                        endcheckQty = endcheckQty.add(value.getPdEndCheckQty());
                    }
                }
                if (isHasFinQty) {
                    headFlag = true;
                }
                if (pdStartQty.compareTo(BigDecimal.ZERO) > 0 || startAdjQty.compareTo(BigDecimal.ZERO) != 0 || endAdjQty.compareTo(BigDecimal.ZERO) != 0 || endcheckQty != null) {
                    headFlag = true;
                }
                if (pdStartQty.compareTo(BigDecimal.ZERO) != 0 && startAdjQty.compareTo(BigDecimal.ZERO) == 0 && endAdjQty.compareTo(BigDecimal.ZERO) == 0 && proPlanQty.compareTo(BigDecimal.ZERO) == 0 && endcheckQty == null) {
                    preFlag = true;
                }
                if (isOnlySideFact) {
                    detailFlag = true;
                }
            }
            BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
            BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("amount")));
            BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
            BigDecimal startadjqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("startadjqty")));
            BigDecimal startadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("startadjamt")));
            BigDecimal endadjqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("endadjqty")));
            BigDecimal endadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("endadjamt")));
            if (qty.compareTo(BigDecimal.ZERO) != 0 || amount.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            if (pdStartAmt.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            if (startadjqty.compareTo(BigDecimal.ZERO) != 0 || startadjamt.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            if (endadjqty.compareTo(BigDecimal.ZERO) != 0 || endadjamt.compareTo(BigDecimal.ZERO) != 0) {
                detailFlag = true;
            }
            ++i;
        }
        if (isHasFinQty && !detailFlag) {
            DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
            DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
            String errStr = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u6295\u5165\u6210\u672c\u4e3a0\uff0c\u5b58\u5728\u5b8c\u5de5\u5165\u5e93\u5355\u6570\u636e\u3002", (String)"ActCarryForwardCalcFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costCenterDyo), this.getDynName(costObjectDyo));
            ActCalcFunctionHelper.insertCalcErrorInfo(this.args.getLevelEntryId(), (Long)(costCenterDyo != null ? costCenterDyo.getLong("id") : 0L), errStr, "1");
        }
        if (!this.isCarryNotInAmtCalc && preFlag && !isHasFinQty && !detailFlag) {
            return;
        }
        if (!headFlag && !detailFlag) {
            return;
        }
        for (RowX row : rows) {
            col.collect(row);
        }
    }

    private String getDynName(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        return obj.getString("name");
    }
}

