/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.FactWarehouseVo;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.helper.TailDiffHelper;

public class ActInCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8750794000883579691L;
    private static final Log logger = LogFactory.getLog(ActInCalcFunction.class);
    private RowMeta srcMeta;
    private ActCostCalcArgs args;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;
    private Map<String, List<ProextraPriceVo>> proextraPriceMap;

    public ActInCalcFunction(RowMeta rowMeta, ActCostCalcArgs args, Map<String, List<ProextraPriceVo>> proextraPriceMap, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.proextraPriceMap = proextraPriceMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        if (listRows.isEmpty()) {
            return;
        }
        RowX row = (RowX)listRows.get(0);
        Long mainCostObjectId = row.getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(mainCostObjectId)) {
            return;
        }
        if (!this.calcCostobjectFinalResultMap.get(mainCostObjectId).containsKey(costObjectId)) {
            return;
        }
        if (listRows.size() == 1) {
            ((RowX)listRows.get(0)).set(this.sourceRowMeta.getFieldIndex("cost"), (Object)((RowX)listRows.get(0)).getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
        } else {
            AcaResultFinalResultVO resultVo = this.calcCostobjectFinalResultMap.get(mainCostObjectId).get(costObjectId);
            if (!"B".equals(resultVo.getProductType())) {
                boolean isDebugInfo = StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costObjectId));
                this.mainJoinFactedCalc(listRows, resultVo, isDebugInfo);
            } else {
                this.sideFactedCalc(listRows, resultVo);
            }
        }
        for (RowX lRow : listRows) {
            collector.collect(lRow);
        }
    }

    private void sideFactedCalc(List<RowX> listRows, AcaResultFinalResultVO resultVo) {
        int i = 0;
        BigDecimal diffFinAmt = BigDecimal.ZERO;
        RowX maxRow = null;
        for (RowX row : listRows) {
            if (i == 0) {
                diffFinAmt = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt"));
            }
            ++i;
            BigDecimal proFinQty = row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty"));
            Long costcenterId = row.getLong(this.srcMeta.getFieldIndex("factedCostCenterId"));
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            BigDecimal sideSubElementPrice = this.getSubElementPrice(resultVo, costcenterId, subElementId);
            BigDecimal cost = proFinQty.multiply(sideSubElementPrice).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            row.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
            if (maxRow == null || maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).compareTo(cost) < 0) {
                maxRow = row;
            }
            diffFinAmt = diffFinAmt.subtract(cost);
        }
        if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            maxRow.set(this.sourceRowMeta.getFieldIndex("cost"), (Object)maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("cost")).add(diffFinAmt));
        }
    }

    private BigDecimal getSubElementPrice(AcaResultFinalResultVO resultVo, Long costcenterId, Long subElementId) {
        BigDecimal sideSubElementPrice = BigDecimal.ZERO;
        String matKey = String.format("%s@%s@%s", resultVo.getMatId(), resultVo.getMatVerId(), resultVo.getMatAuxId());
        String manuOrg = "0";
        List<ProextraPriceVo> sidePriceDyo = ActCalcFunctionHelper.getsidePriceDyo(this.proextraPriceMap, matKey, String.valueOf(costcenterId), manuOrg);
        if (sidePriceDyo == null) {
            return sideSubElementPrice;
        }
        for (ProextraPriceVo tmpEntry : sidePriceDyo) {
            if (!subElementId.equals(tmpEntry.getSubelement())) continue;
            sideSubElementPrice = sideSubElementPrice.add(BigDecimalUtil.getOrZero(tmpEntry.getPrice()));
        }
        return sideSubElementPrice;
    }

    private void mainJoinFactedCalc(List<RowX> listRows, AcaResultFinalResultVO resultVo, boolean isDebugInfo) {
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal finAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        Long subElementId = 0L;
        int i = 0;
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            if (i == 0) {
                finAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
                amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("calcAmt")));
                subElementId = listRows.get(0).getLong(this.srcMeta.getFieldIndex("subElementId"));
            }
            totalQty = totalQty.add(proFinQty);
            ++i;
            if (!isDebugInfo) continue;
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup1:fields %1$s,values %2$s", (String)"ActInCalcFunction_7", (String)"macc-aca-algox", (Object[])new Object[0]), Arrays.toString(this.srcMeta.getFieldNames()), row));
        }
        if (isDebugInfo) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup2:totalQty %1$s,finAmt %2$s,amount %3$s,proPlanQty %4$s,subElementId %5$s", (String)"ActInCalcFunction_12", (String)"macc-aca-algox", (Object[])new Object[0]), totalQty, finAmt, amount, resultVo.getPdCalcQty(), subElementId));
        }
        BigDecimal unitCost = null;
        unitCost = totalQty.compareTo(BigDecimal.ZERO) == 0 ? (resultVo.getPdCalcQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(resultVo.getPdCalcQty(), 10, RoundingMode.HALF_UP)) : finAmt.divide(totalQty, 10, RoundingMode.HALF_UP);
        if (isDebugInfo) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup3:unitCost %s", (String)"ActInCalcFunction_4", (String)"macc-aca-algox", (Object[])new Object[0]), unitCost));
        }
        HashMap warehouseBillRows = Maps.newHashMapWithExpectedSize((int)10);
        for (RowX row : listRows) {
            Long factwarehouse = row.getLong(this.sourceRowMeta.getFieldIndex("factwarehouse"));
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            FactWarehouseVo warehouseVo = warehouseBillRows.computeIfAbsent(factwarehouse, t -> new FactWarehouseVo());
            warehouseVo.setFinQty(warehouseVo.getFinQty().add(proFinQty));
            warehouseVo.getRows().add(row);
        }
        BigDecimal diffAmt = finAmt;
        FactWarehouseVo maxVo = null;
        for (Map.Entry entry : warehouseBillRows.entrySet()) {
            FactWarehouseVo curVo = (FactWarehouseVo)entry.getValue();
            if (maxVo == null || curVo.getFinQty().compareTo(maxVo.getFinQty()) > 0) {
                maxVo = curVo;
            }
            BigDecimal cost = curVo.getFinQty().multiply(unitCost).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            curVo.setFinAmt(cost);
            diffAmt = diffAmt.subtract(cost);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxVo != null) {
            maxVo.setFinAmt(maxVo.getFinAmt().add(diffAmt));
        }
        for (Map.Entry entry : warehouseBillRows.entrySet()) {
            this.calcWarehouseCost((FactWarehouseVo)entry.getValue(), unitCost, isDebugInfo);
        }
    }

    private void calcWarehouseCost(FactWarehouseVo vo, BigDecimal unitCost, boolean isDebugInfo) {
        List<RowX> listRows = vo.getRows();
        BigDecimal diffAmt = vo.getFinAmt();
        HashSet finQtys = Sets.newHashSetWithExpectedSize((int)10);
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            finQtys.add(proFinQty);
        }
        List<Object> dealDiffRows = new ArrayList(listRows.size());
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proFinQty")));
            BigDecimal cost = proFinQty.multiply(unitCost).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            row.set(this.srcMeta.getFieldIndex("cost"), (Object)cost);
            diffAmt = diffAmt.subtract(cost);
            if (isDebugInfo) {
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup4:cost %1$s row %2$s", (String)"ActInCalcFunction_10", (String)"macc-aca-algox", (Object[])new Object[0]), cost, row));
            }
            if (finQtys.contains(proFinQty.negate())) continue;
            dealDiffRows.add(row);
        }
        if (isDebugInfo) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u6210\u672c\u8ba1\u7b97 setup5:diffAmt %s", (String)"ActInCalcFunction_6", (String)"macc-aca-algox", (Object[])new Object[0]), diffAmt));
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            if (dealDiffRows.isEmpty()) {
                dealDiffRows = listRows;
            }
            TailDiffHelper.tailDiff(dealDiffRows, (String)"proFinQty", (String)"cost", (BigDecimal)diffAmt, (int)this.args.getAmtScale(), (RowMeta)this.srcMeta, (boolean)true);
        }
    }
}

