/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ActInCostCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 4078799106560892878L;
    private ActCostCalcArgs args;
    private Map<String, String> proallocstdMap;
    private Map<String, BigDecimal> inProdAllocStdValMap;
    private Map<String, BigDecimal> equivalentMap;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;
    private Map<String, String> allocTypeMap;
    private Map<String, BigDecimal[]> weightMap;
    private DebugInfoMsgHandler msgHander = null;
    private boolean isWipcostinBindCustom = true;
    private String wipcostinAlloc = "0";
    private boolean isWipcostinExistOrg = false;
    private String inventoryMode;

    public ActInCostCalcFunction(ActCostCalcArgs args, Map<String, String> proallocstdMap, Map<String, BigDecimal> inProdAllocStdValMap, Map<String, BigDecimal> equivalentMap, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap, Map<String, String> allocTypeMap, Map<String, BigDecimal[]> weightMap, String inventoryMode, DebugInfoMsgHandler msgHander, boolean isWipcostinBindCustom, String wipcostinAlloc, boolean isWipcostinExistOrg) {
        this.args = args;
        this.proallocstdMap = proallocstdMap;
        this.inProdAllocStdValMap = inProdAllocStdValMap;
        this.equivalentMap = equivalentMap;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.inventoryMode = inventoryMode;
        this.allocTypeMap = allocTypeMap;
        this.weightMap = weightMap;
        this.msgHander = msgHander;
        this.isWipcostinBindCustom = isWipcostinBindCustom;
        this.wipcostinAlloc = wipcostinAlloc;
        this.isWipcostinExistOrg = isWipcostinExistOrg;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        for (RowX row : iter) {
            row.set(this.sourceRowMeta.getFieldIndex("mainCostObjectId"), (Object)row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId")));
            rows.add(row);
        }
        if (rows.isEmpty()) {
            return;
        }
        RowX row = (RowX)rows.get(0);
        Long costObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
        Long costCenterId = row.getLong(this.sourceRowMeta.getFieldIndex("costCenterId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(costObjectId)) {
            return;
        }
        if (!this.calcCostobjectFinalResultMap.get(costObjectId).containsKey(costObjectId)) {
            return;
        }
        StringBuilder debugMsg = null;
        boolean isCostobjectDebug = ActCalcFunctionHelper.isCostobjectDebug(this.args, costObjectId);
        if (isCostobjectDebug) {
            debugMsg = new StringBuilder();
            debugMsg.append(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u8ba1\u7b97\uff1a\n", (String)"ActInCostCalcFunction_17", (String)"macc-aca-algox", (Object[])new Object[0]));
        }
        Map<Long, AcaResultFinalResultVO> resultVos = this.calcCostobjectFinalResultMap.get(costObjectId);
        ArrayList colRows = Lists.newArrayList();
        boolean isCostobejctSetWip = this.isSetWipCostEntry(rows);
        boolean isFixCalc = false;
        if (!isCostobejctSetWip) {
            isFixCalc = this.prodallocStdFixAmtCalc(rows, colRows, costCenterId, costObjectId, resultVos);
        }
        HashSet errorMsgs = Sets.newHashSetWithExpectedSize((int)10);
        if (!isFixCalc) {
            HashMap groupListMap = Maps.newHashMapWithExpectedSize((int)10);
            for (RowX itRow : rows) {
                String key = String.format("%s@%s", itRow.getLong(this.sourceRowMeta.getFieldIndex("subMatId")), itRow.getLong(this.sourceRowMeta.getFieldIndex("subMatAuxId")));
                groupListMap.computeIfAbsent(key, t -> new ArrayList(5)).add(itRow);
            }
            for (List groupRows : groupListMap.values()) {
                List<RowX> mapRows = this.calcRowsFactCost(groupRows, resultVos, errorMsgs, isCostobejctSetWip, isCostobjectDebug, debugMsg);
                if (mapRows == null || mapRows.isEmpty()) continue;
                colRows.addAll(mapRows);
            }
        }
        if (!errorMsgs.isEmpty()) {
            for (String msg : errorMsgs) {
                ActCalcFunctionHelper.insertCalcErrorInfo(this.args.getLevelEntryId(), costCenterId, msg);
            }
        }
        if (isCostobjectDebug && this.msgHander != null && debugMsg != null) {
            this.msgHander.dealInfoMsg(debugMsg.toString());
        }
        for (RowX itRow : colRows) {
            collector.collect(itRow);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean prodallocStdFixAmtCalc(List<RowX> rows, List<RowX> colRows, Long costCenterId, Long costObjectId, Map<Long, AcaResultFinalResultVO> productGroupCostObjMap) {
        void var17_27;
        Tuple2 tuple;
        RowX row;
        void var14_18;
        String[] allocStdVal;
        BigDecimal proFinQty = ActCalcFunctionHelper.getMainAndJoinProFinQty(productGroupCostObjMap);
        if (proFinQty.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        String allocStdStr = ActCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, 0L);
        String[] stringArray = allocStdVal = allocStdStr != null ? this.getAllocStd(allocStdStr) : null;
        if (!"6".equals(this.getProdAllocStd(allocStdVal))) {
            return false;
        }
        if (!"1".equals(this.getProdAllocStdCalcmethod(allocStdVal))) {
            return false;
        }
        String costdriver = this.getProdAllocStdCostdriver(allocStdVal);
        BigDecimal allocVal = this.getProdAllocStdVal(costdriver, costCenterId, costObjectId);
        if (allocVal == null) {
            allocVal = BigDecimal.ZERO;
        }
        for (RowX row2 : rows) {
            colRows.add(row2);
        }
        HashMap rowCalcAmtMap = Maps.newHashMapWithExpectedSize((int)rows.size());
        BigDecimal inAdjAmt = BigDecimal.ZERO;
        for (RowX rowX : rows) {
            BigDecimal calcQty = this.getCalcQty(rowX);
            BigDecimal calcAmt = this.getCalcAmt(rowX);
            BigDecimal bigDecimal = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjQty"));
            BigDecimal bigDecimal2 = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjAmt"));
            if (bigDecimal != null || bigDecimal2 != null) {
                Integer subMatUnitPrecision = rowX.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                BigDecimal intQty = BigDecimalUtil.getOrZero(bigDecimal).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal intAmt = BigDecimalUtil.getOrZero(bigDecimal2).setScale(this.args.getAmtScale(), 4);
                BigDecimal finQty = calcQty.subtract(intQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal finAmt = calcAmt.subtract(intAmt).setScale(this.args.getAmtScale(), 4);
                inAdjAmt = inAdjAmt.add(intAmt);
                rowX.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)intQty);
                rowX.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)intAmt);
                rowX.set(this.sourceRowMeta.getFieldIndex("calcAmt"), (Object)calcAmt);
                rowX.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)finQty);
                rowX.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)finAmt);
                continue;
            }
            rowCalcAmtMap.put(rowX, new Tuple2((Object)calcQty, (Object)calcAmt));
        }
        if ((allocVal = allocVal.subtract(inAdjAmt)).compareTo(BigDecimal.ZERO) == 0) {
            for (Map.Entry entry : rowCalcAmtMap.entrySet()) {
                RowX row4 = (RowX)entry.getKey();
                Tuple2 tuple2 = (Tuple2)entry.getValue();
                row4.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)BigDecimal.ZERO);
                row4.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)BigDecimal.ZERO);
                row4.set(this.sourceRowMeta.getFieldIndex("calcAmt"), tuple2.t2);
                row4.set(this.sourceRowMeta.getFieldIndex("finQty"), tuple2.t1);
                row4.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)((BigDecimal)tuple2.t2).setScale(this.args.getAmtScale(), 4));
            }
            return true;
        }
        BigDecimal sumCalcAmt = BigDecimal.ZERO;
        Object var14_17 = null;
        RowX maxRow = null;
        for (Map.Entry entry : rowCalcAmtMap.entrySet()) {
            if (var14_18 == null || var14_18.compareTo((BigDecimal)((Tuple2)entry.getValue()).t2) < 0) {
                BigDecimal bigDecimal = ((BigDecimal)((Tuple2)entry.getValue()).t2).abs();
                maxRow = (RowX)entry.getKey();
            }
            sumCalcAmt = sumCalcAmt.add((BigDecimal)((Tuple2)entry.getValue()).t2);
        }
        if (sumCalcAmt.compareTo(BigDecimal.ZERO) == 0) {
            sumCalcAmt = var14_18;
        }
        HashMap rowRadioMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : rowCalcAmtMap.entrySet()) {
            if (sumCalcAmt == null || sumCalcAmt.compareTo(BigDecimal.ZERO) == 0) {
                rowRadioMap.put(entry.getKey(), BigDecimal.ONE.divide(new BigDecimal(rows.size()), 10, 4));
                continue;
            }
            rowRadioMap.put(entry.getKey(), ((BigDecimal)((Tuple2)entry.getValue()).t2).divide(sumCalcAmt, 10, 4));
        }
        BigDecimal bigDecimal = allocVal;
        for (Map.Entry entry : rowCalcAmtMap.entrySet()) {
            row = (RowX)entry.getKey();
            tuple = (Tuple2)entry.getValue();
            BigDecimal radio = (BigDecimal)rowRadioMap.get(row);
            if (radio == null) {
                radio = BigDecimal.ZERO;
            }
            BigDecimal inAmt = allocVal.multiply(radio).setScale(this.args.getAmtScale(), 4);
            BigDecimal bigDecimal3 = var17_27.subtract(inAmt);
            BigDecimal inQty = BigDecimal.ZERO;
            if (((BigDecimal)tuple.t1).compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal unitAmt;
                Integer subMatUnitPrecision = row.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                if ((unitAmt = ((BigDecimal)tuple.t2).divide((BigDecimal)tuple.t1, this.args.getPriceScale(), 4)).compareTo(BigDecimal.ZERO) != 0) {
                    inQty = inAmt.divide(unitAmt, (int)subMatUnitPrecision, 4);
                }
            }
            row.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)inQty);
            row.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)inAmt.setScale(this.args.getAmtScale(), 4));
            row.set(this.sourceRowMeta.getFieldIndex("calcAmt"), tuple.t2);
        }
        if (var17_27.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            BigDecimal bigDecimal4 = maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt"));
            maxRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)bigDecimal4.add((BigDecimal)var17_27).setScale(this.args.getAmtScale(), 4));
        }
        for (Map.Entry entry : rowCalcAmtMap.entrySet()) {
            row = (RowX)entry.getKey();
            tuple = (Tuple2)entry.getValue();
            BigDecimal inAmt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt"));
            BigDecimal inQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inQty"));
            row.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)((BigDecimal)tuple.t1).subtract(inQty));
            row.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)((BigDecimal)tuple.t2).subtract(inAmt).setScale(this.args.getAmtScale(), 4));
        }
        return true;
    }

    private void dealInputQtyAlloc(List<RowX> rows, String field, BigDecimal totalAllocQty) {
        totalAllocQty = totalAllocQty == null ? BigDecimal.ZERO : totalAllocQty;
        int rowIndex = this.sourceRowMeta.getFieldIndex(field);
        if (rows.size() == 1 || BigDecimal.ZERO.compareTo(totalAllocQty) == 0) {
            for (RowX row : rows) {
                row.set(rowIndex, (Object)totalAllocQty);
            }
            return;
        }
        Integer subMatUnitPrecision = rows.get(0).getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
        if (subMatUnitPrecision == null) {
            subMatUnitPrecision = 0;
        }
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal maxAbsQty = null;
        for (RowX row : rows) {
            BigDecimal calcQty = this.getCalcQty(row);
            totalQty = totalQty.add(calcQty);
            if (maxAbsQty != null && maxAbsQty.compareTo(calcQty.abs()) >= 0) continue;
            maxAbsQty = calcQty.abs();
        }
        if (totalQty.compareTo(BigDecimal.ZERO) == 0 && maxAbsQty != null) {
            totalQty = maxAbsQty;
        }
        RowX maxRow = null;
        BigDecimal diffVal = totalAllocQty;
        for (RowX row : rows) {
            BigDecimal radio = null;
            if (totalQty.compareTo(BigDecimal.ZERO) == 0) {
                radio = BigDecimal.ONE.divide(new BigDecimal(rows.size()), 10, RoundingMode.HALF_UP);
            } else {
                BigDecimal calcQty = this.getCalcQty(row);
                radio = calcQty.divide(totalQty, 10, RoundingMode.HALF_UP);
            }
            BigDecimal rowInvVal = radio.multiply(totalAllocQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            diffVal = diffVal.subtract(rowInvVal);
            row.set(rowIndex, (Object)rowInvVal);
            if (maxRow != null && maxRow.getBigDecimal(rowIndex).compareTo(rowInvVal) >= 0) continue;
            maxRow = row;
        }
        if (diffVal.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            maxRow.set(rowIndex, (Object)maxRow.getBigDecimal(rowIndex).add(diffVal));
        }
    }

    private List<RowX> calcRowsFactCost(List<RowX> groupRows, Map<Long, AcaResultFinalResultVO> productGroupCostObjMap, Set<String> errorMsg, boolean isCostobejctSetWip, boolean isCostobjectDebug, StringBuilder debugMsg) {
        RowX rowOne = groupRows.get(0);
        Long subMatId = rowOne.getLong(this.sourceRowMeta.getFieldIndex("subMatId"));
        BigDecimal proFinQty = ActCalcFunctionHelper.getMainAndJoinProFinQty(productGroupCostObjMap);
        BigDecimal proIntrQty = ActCalcFunctionHelper.getMainAndJoinProEndQty(productGroupCostObjMap);
        if (!CadEmptyUtils.isEmpty((Long)subMatId) && BigDecimal.ZERO.compareTo(proFinQty) != 0 && proIntrQty.compareTo(BigDecimal.ZERO) > 0) {
            Long costCenterId = rowOne.getLong(this.sourceRowMeta.getFieldIndex("costCenterId"));
            Long subElementId = rowOne.getLong(this.sourceRowMeta.getFieldIndex("subElementId"));
            String allocStdStr = ActCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, subElementId);
            String[] allocStdVal = allocStdStr != null ? this.getAllocStd(allocStdStr) : null;
            String allocStd = this.getProdAllocStd(allocStdVal);
            Integer subMatUnitPrecision = rowOne.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
            if (subMatUnitPrecision == null) {
                subMatUnitPrecision = 0;
            }
            if ("4".equals(allocStd)) {
                BigDecimal inventValue = rowOne.getBigDecimal(this.sourceRowMeta.getFieldIndex("inventValue"));
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append(String.format("allocStd:WipMatCheck,allocVal:%s,allocSize:%s%n", inventValue, groupRows.size()));
                }
                this.dealInputQtyAlloc(groupRows, "inventValue", inventValue);
            } else if ("3".equals(allocStd)) {
                BigDecimal stockQty = BigDecimalUtil.getOrZero(rowOne.getBigDecimal(this.sourceRowMeta.getFieldIndex("stockqty")));
                BigDecimal useQty = BigDecimalUtil.getOrZero(rowOne.getBigDecimal(this.sourceRowMeta.getFieldIndex("useqty")));
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append(String.format("allocStd:ASSEMBLY,stockQty:%s,useQty:%s%n", stockQty.toPlainString(), useQty.toPlainString()));
                }
                BigDecimal totalQty = BigDecimal.ZERO;
                if (useQty.compareTo(BigDecimal.ZERO) != 0 && stockQty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal unitFinUseRate = useQty.divide(stockQty, 10, 4);
                    totalQty = unitFinUseRate.multiply(proFinQty).setScale((int)subMatUnitPrecision, 4);
                }
                this.dealInputQtyAlloc(groupRows, "finQty", totalQty);
            } else if ("5".equals(allocStd)) {
                BigDecimal unitQty = BigDecimalUtil.getOrZero(rowOne.getBigDecimal(this.sourceRowMeta.getFieldIndex("unitQty")));
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append(String.format("allocStd:BOM,unitQty:%s%n", unitQty.toPlainString()));
                }
                BigDecimal totalQty = unitQty.multiply(proFinQty).setScale((int)subMatUnitPrecision, 4);
                this.dealInputQtyAlloc(groupRows, "finQty", totalQty);
            }
        }
        ArrayList<RowX> colRows = new ArrayList<RowX>(10);
        for (RowX row : groupRows) {
            RowX newRow = this.map(row, productGroupCostObjMap, errorMsg, isCostobejctSetWip, isCostobjectDebug, debugMsg);
            if (newRow == null) continue;
            colRows.add(newRow);
        }
        return colRows;
    }

    public RowX map(RowX row, Map<Long, AcaResultFinalResultVO> productGroupCostObjMap, Set<String> errorMsg, boolean isCostobejctSetWip, boolean isCostobjectDebug, StringBuilder debugMsg) {
        Long costCenterId = row.getLong(this.sourceRowMeta.getFieldIndex("costCenterId"));
        Long costObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
        Long materialId = row.getLong(this.sourceRowMeta.getFieldIndex("matId"));
        Long subElementId = row.getLong(this.sourceRowMeta.getFieldIndex("subElementId"));
        BigDecimal inSubAdjQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjQty"));
        BigDecimal inSubAdjAmt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjAmt"));
        BigDecimal finQty = BigDecimal.ZERO;
        BigDecimal finAmt = BigDecimal.ZERO;
        BigDecimal intQty = BigDecimal.ZERO;
        BigDecimal intAmt = BigDecimal.ZERO;
        String allocStdStr = ActCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, subElementId);
        String[] allocStdVal = allocStdStr != null ? this.getAllocStd(allocStdStr) : null;
        String allocStd = this.getProdAllocStd(allocStdVal);
        if (isCostobjectDebug && debugMsg != null) {
            debugMsg.append(String.format("costCenterId=%s,materialId=%s,subElementId=%s,allocStd=%s %n", costCenterId, materialId, subElementId, allocStd));
        }
        if (StringUtils.isEmpty((String)allocStd)) {
            errorMsg.add(this.getErrorCtElementStr(costCenterId, subElementId, ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\uff0c\u672a\u627e\u5230\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"ActInCostCalcFunction_13", (String)"macc-aca-algox", (Object[])new Object[0])));
            return null;
        }
        Integer subMatUnitPrecision = row.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
        if (subMatUnitPrecision == null) {
            subMatUnitPrecision = 0;
        }
        BigDecimal proIntrQty = ActCalcFunctionHelper.getMainAndJoinProEndQty(productGroupCostObjMap);
        BigDecimal proFinQty = ActCalcFunctionHelper.getMainAndJoinProFinQty(productGroupCostObjMap);
        BigDecimal calcQty = this.getCalcQty(row);
        BigDecimal calcAmt = this.getCalcAmt(row);
        if (proFinQty.compareTo(BigDecimal.ZERO) == 0) {
            intQty = calcQty;
            intAmt = calcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("proFinQty=0 \n");
            }
        } else if (this.isSetWipCost(isCostobejctSetWip, allocStd, inSubAdjQty, inSubAdjAmt)) {
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append(String.format("isWipcostinBindCustom=%s,wipcostinAlloc=%s,isWipcostinExistOrg=%s,allocStd=%s,inSubAdjQty=%s,inSubAdjAmt=%s", this.isWipcostinBindCustom, this.wipcostinAlloc, this.isWipcostinExistOrg, allocStd, inSubAdjQty, inSubAdjAmt)).append("\n");
            }
            intQty = BigDecimalUtil.getOrZero(inSubAdjQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            intAmt = BigDecimalUtil.getOrZero(inSubAdjAmt).setScale(this.args.getAmtScale(), 4);
            finQty = calcQty.subtract(intQty).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            finAmt = calcAmt.subtract(intAmt).setScale(this.args.getAmtScale(), 4);
        } else if ("0".equals(allocStd) || proIntrQty.compareTo(BigDecimal.ZERO) <= 0) {
            finQty = calcQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
            finAmt = calcAmt;
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("allocStd=0 or proIntrQty=").append(proIntrQty.toPlainString()).append("\n");
            }
        } else if ("1".equals(allocStd) || "2".equals(allocStd)) {
            BigDecimal tmpA;
            BigDecimal equivalent = BigDecimal.ONE;
            if ("2".equals(allocStd)) {
                equivalent = ActCalcFunctionHelper.getCostobjectEquivalent(this.equivalentMap, this.args.getCostAccountId(), costCenterId, costObjectId, subElementId);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("equivalent=").append(equivalent == null ? "null" : equivalent.toPlainString()).append("\n");
                }
                if (equivalent == null) {
                    errorMsg.add(this.getErrorCbElementStr(costCenterId, costObjectId, subElementId, ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u3001\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u3001\u5b50\u8981\u7d20\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"ActInCostCalcFunction_14", (String)"macc-aca-algox", (Object[])new Object[0])));
                    return null;
                }
            }
            if (ActCalcFunctionHelper.isContainsJoinProduct(productGroupCostObjMap)) {
                Map<Long, BigDecimal> groupCostobjWeightMap = ActCalcFunctionHelper.getGroupCostObjectWeight(productGroupCostObjMap, this.allocTypeMap, this.weightMap, subElementId);
                proFinQty = BigDecimal.ZERO;
                proIntrQty = BigDecimal.ZERO;
                for (Map.Entry<Long, AcaResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
                    if ("B".equals(entry.getValue().getProductType()) || !groupCostobjWeightMap.containsKey(entry.getKey())) continue;
                    proFinQty = proFinQty.add(entry.getValue().getProFinQty().multiply(groupCostobjWeightMap.get(entry.getKey())));
                    proIntrQty = proIntrQty.add(entry.getValue().getPdEndQty().multiply(groupCostobjWeightMap.get(entry.getKey())));
                }
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("mainJoin:proFinQty=").append(proFinQty.toPlainString()).append(",proIntrQty=").append(proIntrQty.toPlainString()).append("\n");
                }
            }
            if ((tmpA = proIntrQty.multiply(equivalent).add(proFinQty)).compareTo(BigDecimal.ZERO) == 0) {
                errorMsg.add(this.getErrorCbElementStr(costCenterId, costObjectId, subElementId, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3:%1$s ,\u5b50\u8981\u7d20: %2$s , \u6210\u672c\u6838\u7b97\u5bf9\u8c61 :%3$s , \u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002", (String)"ActInCostCalcFunction_10", (String)"macc-aca-algox", (Object[])new Object[0])));
                return null;
            }
            BigDecimal ratio = proFinQty.divide(tmpA, 10, 4);
            finQty = calcQty.multiply(ratio).setScale((int)subMatUnitPrecision, 4);
            finAmt = calcAmt.multiply(ratio).setScale(this.args.getAmtScale(), 4);
            intQty = calcQty.subtract(finQty);
            intAmt = calcAmt.subtract(finAmt);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("FinishCalc:tmpA=").append(tmpA.toPlainString()).append(",ratio=").append(ratio.toPlainString()).append(",finQty=").append(finQty.toPlainString()).append(",finAmt=").append(finAmt.toPlainString()).append("\n");
            }
        } else if ("3".equals(allocStd) || "5".equals(allocStd)) {
            finQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finQty")));
            if (calcQty.compareTo(BigDecimal.ZERO) == 0 || finQty.compareTo(BigDecimal.ZERO) == 0) {
                intQty = calcQty;
                intAmt = calcAmt;
                finQty = BigDecimal.ZERO;
                finAmt = BigDecimal.ZERO;
            } else {
                BigDecimal matPrice = calcAmt.divide(calcQty, 10, 4);
                finAmt = finQty.multiply(matPrice).setScale(this.args.getAmtScale(), 4);
                intQty = calcQty.subtract(finQty);
                intAmt = calcAmt.subtract(finAmt);
            }
        } else if ("4".equals(allocStd)) {
            if (StringUtils.isEmpty((String)this.inventoryMode)) {
                this.inventoryMode = "qty";
            }
            BigDecimal inventValue = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inventValue")));
            if ("amount".equals(this.inventoryMode)) {
                intAmt = inventValue;
                finAmt = calcAmt.subtract(intAmt);
                if (calcQty.compareTo(BigDecimal.ZERO) != 0) {
                    if (calcAmt.compareTo(BigDecimal.ZERO) == 0) {
                        DynamicObject dyCostCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                        DynamicObject dyCostObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
                        DynamicObject dyMaterial = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"name");
                        String errStr = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u3001\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u3001\u7269\u6599\u201c%3$s\u201d , \u5404\u660e\u7ec6\u6750\u6599\u7684\u6295\u5165\u7684\u603b\u91d1\u989d\u201c%4$s\u201d\u6216\u5404\u660e\u7ec6\u6750\u6599\u6295\u5165\u7684\u603b\u6570\u91cf\u201c%5$s\u201d\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"ActInCostCalcFunction_15", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(dyCostCenter), this.getDynName(dyCostObject), this.getDynName(dyMaterial), BigDecimalUtil.toString(calcAmt), BigDecimalUtil.toString(calcQty));
                        ActCalcFunctionHelper.insertCalcErrorInfo(this.args.getLevelEntryId(), (Long)(dyCostCenter != null ? dyCostCenter.getLong("id") : 0L), errStr);
                        return null;
                    }
                    intQty = intAmt.divide(calcAmt.divide(calcQty, 10, 4), (int)subMatUnitPrecision, 4);
                    finQty = calcQty.subtract(intQty);
                }
            } else if ("qty".equals(this.inventoryMode)) {
                intQty = inventValue.setScale((int)subMatUnitPrecision, 4);
                finQty = calcQty.subtract(intQty);
                if (isCostobjectDebug && debugMsg != null) {
                    debugMsg.append("WIPMATCHECK:intQty=").append(intQty.toPlainString()).append(",finQty=").append(finQty.toPlainString()).append("\n");
                }
                if (calcQty.compareTo(BigDecimal.ZERO) == 0) {
                    intAmt = calcAmt;
                } else {
                    BigDecimal price = calcAmt.divide(calcQty, 10, 4);
                    intAmt = intQty.multiply(price).setScale(this.args.getAmtScale(), 4);
                    finAmt = calcAmt.subtract(intAmt);
                }
            }
        } else if ("6".equals(allocStd)) {
            String costdriver = this.getProdAllocStdCostdriver(allocStdVal);
            String calcmethod = this.getProdAllocStdCalcmethod(allocStdVal);
            BigDecimal allocVal = this.getProdAllocStdVal(costdriver, costCenterId, costObjectId);
            if (isCostobjectDebug && debugMsg != null) {
                debugMsg.append("allocStd=6,allocStdStr=").append(allocStdStr).append(",allocVal=").append(allocVal).append("\n");
            }
            if (allocVal == null) {
                String allocCompStdStr = ActCalcFunctionHelper.getProductAllocStd(this.proallocstdMap, this.args.getCostAccountId(), costCenterId, 0L);
                String[] allocCompStdVal = allocCompStdStr != null ? this.getAllocStd(allocCompStdStr) : null;
                String compAllocStd = this.getProdAllocStd(allocCompStdVal);
                String compCostdriver = this.getProdAllocStdCostdriver(allocCompStdVal);
                String compCalcmethod = this.getProdAllocStdCalcmethod(allocCompStdVal);
                if (allocStd.equals(compAllocStd) && calcmethod.equals(compCalcmethod) && !costdriver.equals(compCostdriver)) {
                    allocVal = this.getProdAllocStdVal(compCostdriver, costCenterId, costObjectId);
                    if (isCostobjectDebug && debugMsg != null) {
                        debugMsg.append("allocStd=6,allocCompStdStr=").append(allocCompStdStr).append(",allocVal=").append(allocVal).append("\n");
                    }
                }
            }
            if (allocVal == null) {
                allocVal = BigDecimal.ZERO;
            }
            if ("1".equals(calcmethod)) {
                intAmt = allocVal.setScale(this.args.getAmtScale(), 4);
                finAmt = calcAmt.subtract(intAmt);
                BigDecimal radio = BigDecimal.ZERO;
                if (calcAmt.compareTo(BigDecimal.ZERO) != 0) {
                    radio = intAmt.divide(calcAmt, 10, 4);
                }
                intQty = calcQty.multiply(radio).setScale((int)subMatUnitPrecision, 4);
                finQty = calcQty.subtract(intQty);
            } else {
                if (allocVal.compareTo(BigDecimal.ZERO) < 0 || allocVal.compareTo(BigDecimal.ONE) > 0) {
                    errorMsg.add(this.getErrorCbElementStr(costCenterId, costObjectId, subElementId, ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u3010%1$s\u3011\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\u5b50\u8981\u7d20\u3010%3$s\u3011\u81ea\u5b9a\u4e49\u5206\u914d\u6807\u51c6\u6309\u6bd4\u4f8b\u8ba1\u7b97\u65f6\uff0c\u5206\u914d\u6807\u51c6\u503c\u4e0d\u5728[0,1]\u4e4b\u95f4\u3002", (String)"ActInCostCalcFunction_19", (String)"macc-aca-algox", (Object[])new Object[0])));
                    return null;
                }
                intAmt = calcAmt.multiply(allocVal).setScale(this.args.getAmtScale(), 4);
                intQty = calcQty.multiply(allocVal).setScale((int)subMatUnitPrecision, 4);
                finAmt = calcAmt.subtract(intAmt);
                finQty = calcQty.subtract(intQty);
            }
        }
        row.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)finQty);
        row.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)finAmt.setScale(this.args.getAmtScale(), 4));
        row.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)intQty);
        row.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)intAmt.setScale(this.args.getAmtScale(), 4));
        row.set(this.sourceRowMeta.getFieldIndex("calcAmt"), (Object)calcAmt);
        return row;
    }

    private BigDecimal getCalcQty(RowX row) {
        BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartQty")));
        BigDecimal startadjqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("startadjqty")));
        BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
        return pdStartQty.add(startadjqty).add(qty);
    }

    private BigDecimal getCalcAmt(RowX row) {
        BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartAmt")));
        BigDecimal startadjamt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("startadjamt")));
        BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount")));
        return pdStartAmt.add(startadjamt).add(amount).setScale(this.args.getAmtScale(), 4);
    }

    private String getErrorCbElementStr(Long costCenterId, Long costObjectId, Long subElementId, String errorMsg) {
        DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
        DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
        DynamicObject subElementDyo = null;
        if (subElementId != null) {
            subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
            return String.format(errorMsg, this.getDynName(costCenterDyo), this.getDynName(costObjectDyo), this.getDynName(subElementDyo));
        }
        return String.format(errorMsg, this.getDynName(costCenterDyo), this.getDynName(costObjectDyo));
    }

    private String getErrorCtElementStr(Long costCenterId, Long subElementId, String errorMsg) {
        DynamicObject costCenterDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
        DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
        return String.format(errorMsg, this.getDynName(costCenterDyo), this.getDynName(subElementDyo));
    }

    private String getDynName(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        return obj.getString("name");
    }

    private String[] getAllocStd(String allocStd) {
        return allocStd.split("@");
    }

    private String getProdAllocStd(String[] allocStdVal) {
        if (allocStdVal != null && allocStdVal.length > 0) {
            return allocStdVal[0];
        }
        return null;
    }

    private String getProdAllocStdCostdriver(String[] allocStdVal) {
        if (allocStdVal != null && allocStdVal.length > 1) {
            return allocStdVal[1];
        }
        return "0";
    }

    private String getProdAllocStdCalcmethod(String[] allocStdVal) {
        if (allocStdVal != null && allocStdVal.length > 2) {
            return allocStdVal[2];
        }
        return "0";
    }

    private BigDecimal getProdAllocStdVal(String costdriver, Long costCenterId, Long costObjectId) {
        String key = String.format("%s@%s@%s", costdriver, costCenterId, costObjectId);
        BigDecimal allocVal = this.inProdAllocStdValMap.get(key);
        if (allocVal == null) {
            key = String.format("%s@%s@%s", costdriver, costCenterId, 0L);
            allocVal = this.inProdAllocStdValMap.get(key);
        }
        return allocVal;
    }

    private boolean isSetWipCostEntry(List<RowX> rows) {
        if ("0".equals(this.wipcostinAlloc) && this.isWipcostinExistOrg) {
            return true;
        }
        if ("1".equals(this.wipcostinAlloc)) {
            for (RowX row : rows) {
                BigDecimal inSubAdjQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjQty"));
                BigDecimal inSubAdjAmt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inSubAdjAmt"));
                if (inSubAdjQty == null && inSubAdjAmt == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSetWipCost(boolean isCostobejctSetWip, String allocStd, BigDecimal inSubAdjQty, BigDecimal inSubAdjAmt) {
        if (this.isWipcostinBindCustom && !"6".equals(allocStd)) {
            return false;
        }
        if (isCostobejctSetWip) {
            return true;
        }
        return "2".equals(this.wipcostinAlloc) && (inSubAdjQty != null || inSubAdjAmt != null);
    }
}

