/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.AcaResultFinalResultVO;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ActNegaunitpriceDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap;
    private DebugInfoMsgHandler msgHander = null;
    private ActCostCalcArgs args;
    Map<String, List<ProextraPriceVo>> proextraPriceMap = null;

    public ActNegaunitpriceDealFunction(ActCostCalcArgs args, Map<Long, Map<Long, AcaResultFinalResultVO>> calcCostobjectFinalResultMap, DebugInfoMsgHandler msgHander, Map<String, List<ProextraPriceVo>> proextraPriceMap) {
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
        this.msgHander = msgHander;
        this.proextraPriceMap = proextraPriceMap;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        for (RowX row : iter) {
            rows.add(row);
        }
        if (rows.isEmpty()) {
            return;
        }
        RowX row = (RowX)rows.get(0);
        Long costObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costObjectId"));
        Long costCenterId = row.getLong(this.sourceRowMeta.getFieldIndex("costCenterId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(costObjectId)) {
            return;
        }
        if (!this.calcCostobjectFinalResultMap.get(costObjectId).containsKey(costObjectId)) {
            return;
        }
        Map<Long, AcaResultFinalResultVO> resultVos = this.calcCostobjectFinalResultMap.get(costObjectId);
        boolean hasFact = false;
        for (Map.Entry<Long, AcaResultFinalResultVO> entry : resultVos.entrySet()) {
            if ("B".equals(entry.getValue().getProductType()) || entry.getValue().getProFinQty().compareTo(BigDecimal.ZERO) == 0) continue;
            hasFact = true;
            break;
        }
        if (hasFact) {
            StringBuilder debugMsg = null;
            boolean isCostobjectDebug = ActCalcFunctionHelper.isCostobjectDebug(this.args, costObjectId);
            if (isCostobjectDebug) {
                debugMsg = new StringBuilder();
                debugMsg.append(ResManager.loadKDString((String)"\u5b8c\u5de5\u8d1f\u6210\u672c\u5904\u7406\uff1a\n", (String)"ActNegaunitpriceDealFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
            }
            this.negateUnitPriceDeal(rows, resultVos, costCenterId, costObjectId, isCostobjectDebug, debugMsg);
            if (this.msgHander != null && debugMsg != null) {
                this.msgHander.dealInfoMsg(debugMsg.toString());
            }
        }
        for (RowX itRow : rows) {
            collector.collect(itRow);
        }
    }

    private void negateUnitPriceDeal(List<RowX> rows, Map<Long, AcaResultFinalResultVO> resultVos, Long costcenterId, Long costObjectId, boolean isCostobjectDebug, StringBuilder debugMsg) {
        BigDecimal finTotalAmt = BigDecimal.ZERO;
        for (RowX itRow : rows) {
            finTotalAmt = finTotalAmt.add(BigDecimalUtil.getOrZero(itRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt"))));
        }
        if (finTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        boolean isFactPositive = false;
        BigDecimal mainFact = BigDecimal.ZERO;
        BigDecimal joinFact = BigDecimal.ZERO;
        BigDecimal sideFact = BigDecimal.ZERO;
        BigDecimal sideAmt = BigDecimal.ZERO;
        for (Map.Entry<Long, AcaResultFinalResultVO> entry : resultVos.entrySet()) {
            if ("C".equals(entry.getValue().getProductType())) {
                mainFact = mainFact.add(entry.getValue().getProFinQty());
            } else if ("A".equals(entry.getValue().getProductType())) {
                joinFact = joinFact.add(entry.getValue().getProFinQty());
            } else if ("B".equals(entry.getValue().getProductType())) {
                sideFact = sideFact.add(entry.getValue().getProFinQty());
                sideAmt = sideAmt.add(this.getSideFactAmt(entry.getValue()));
            }
            if ("B".equals(entry.getValue().getProductType()) || entry.getValue().getProFinQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            isFactPositive = true;
        }
        if (sideFact.compareTo(BigDecimal.ZERO) != 0 && sideAmt.compareTo(finTotalAmt) > 0) {
            if (debugMsg != null) {
                debugMsg.append(String.format("sideFact=%s,finTotalAmt=%s", sideFact, finTotalAmt)).append("\n");
            }
            return;
        }
        BigDecimal finMainJoinTotalAmt = finTotalAmt.subtract(sideAmt);
        if (isFactPositive && finMainJoinTotalAmt.compareTo(BigDecimal.ZERO) > 0 || !isFactPositive && finMainJoinTotalAmt.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        if (isCostobjectDebug && debugMsg != null) {
            debugMsg.append(String.format("isFactPositive=%s,finTotalAmt=%s,finMainJoinTotalAmt=%s", isFactPositive, finTotalAmt, finMainJoinTotalAmt)).append("\n");
        }
        DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
        String errStr = String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3010%1$s\u3011\u5b8c\u5de5\u6210\u672c\u5b58\u5728\u8d1f\u5355\u4ef7\uff0c\u5df2\u6309\u96f6\u6210\u672c\u5904\u7406\u3002\u8ba1\u7b97\u51fa\u7684\u603b\u5b8c\u5de5\u91d1\u989d\u4e3a\u3010%2$s\u3011\uff0c\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u6570\u91cf\u3010%3$s\u3011\u3002", (String)"ActNegaunitpriceDealFunction_6", (String)"macc-aca-algox", (Object[])new Object[0]), this.getDynName(costObjectDyo), finTotalAmt.stripTrailingZeros().toPlainString(), mainFact.stripTrailingZeros().toPlainString());
        if (sideAmt.compareTo(BigDecimal.ZERO) != 0) {
            errStr = errStr + String.format(ResManager.loadKDString((String)"\u526f\u4ea7\u54c1\u91d1\u989d\u4e3a\u3010%s\u3011\u3002", (String)"ActNegaunitpriceDealFunction_7", (String)"macc-aca-algox", (Object[])new Object[0]), sideAmt.stripTrailingZeros().toPlainString());
        }
        if (joinFact.compareTo(BigDecimal.ZERO) != 0) {
            errStr = errStr + String.format(ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5b8c\u5de5\u6570\u91cf\u5408\u8ba1\u3010%s\u3011\u3002", (String)"ActNegaunitpriceDealFunction_8", (String)"macc-aca-algox", (Object[])new Object[0]), joinFact.stripTrailingZeros().toPlainString());
        }
        if (sideFact.compareTo(BigDecimal.ZERO) != 0) {
            errStr = errStr + String.format(ResManager.loadKDString((String)"\u526f\u4ea7\u54c1\u5b8c\u5de5\u6570\u91cf\u5408\u8ba1\u3010%s\u3011\u3002", (String)"ActNegaunitpriceDealFunction_9", (String)"macc-aca-algox", (Object[])new Object[0]), sideFact.stripTrailingZeros().toPlainString());
        }
        ActCalcFunctionHelper.insertCalcErrorInfo(this.args.getLevelEntryId(), costcenterId, errStr, "1");
        for (RowX itRow : rows) {
            BigDecimal finQty = BigDecimalUtil.getOrZero(itRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finQty")));
            BigDecimal finAmt = BigDecimalUtil.getOrZero(itRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
            BigDecimal inQty = BigDecimalUtil.getOrZero(itRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inQty")));
            BigDecimal intAmt = BigDecimalUtil.getOrZero(itRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt")));
            itRow.set(this.sourceRowMeta.getFieldIndex("inQty"), (Object)inQty.add(finQty));
            itRow.set(this.sourceRowMeta.getFieldIndex("inAmt"), (Object)finAmt.add(intAmt).setScale(this.args.getAmtScale(), 4));
            itRow.set(this.sourceRowMeta.getFieldIndex("finQty"), (Object)BigDecimal.ZERO);
            itRow.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)BigDecimal.ZERO);
        }
    }

    private BigDecimal getSideFactAmt(AcaResultFinalResultVO resultVo) {
        BigDecimal sideAmt = BigDecimal.ZERO;
        if (resultVo.getCostcenterFinQtyMap() == null) {
            return sideAmt;
        }
        for (Map.Entry<Long, BigDecimal> csEntry : resultVo.getCostcenterFinQtyMap().entrySet()) {
            String matKey = String.format("%s@%s@%s", resultVo.getMatId(), resultVo.getMatVerId(), resultVo.getMatAuxId());
            String manuOrg = "0";
            Long costcenterId = csEntry.getKey();
            List<ProextraPriceVo> sidePriceDyo = ActCalcFunctionHelper.getsidePriceDyo(this.proextraPriceMap, matKey, String.valueOf(costcenterId), manuOrg);
            for (ProextraPriceVo vo : sidePriceDyo) {
                sideAmt = sideAmt.add(vo.getPrice());
            }
        }
        return sideAmt;
    }

    private String getDynName(DynamicObject obj) {
        if (obj == null) {
            return "";
        }
        return obj.getString("name");
    }
}

