/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.costcalc.action.ActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeDebugInfoMsgHandler;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeCostCalcDataInputFactory {
    private static final String ALGOKEY_PRE = "RealTimeActCostCalcInput-";
    private static final String INSERT_CONVDETAIL_ENTRY_SQL = "INSERT INTO t_aca_rtresultconventry (FId,FEntryId,fseq,fconvsrcbillid,fconvsrcbillentryid,fconvcostobjectid,fconvproducttype,fconvelementid,fconvsubelementid,fconvoutsourcetype,fconvsubmatid,fconvsubresourceid,fconvsubmatverid,fconvsubauxptyid,fconvproqty,fconvqty,fconvamt,fconvgroupfield,fconvgroupcategoryid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final Log logger = LogFactory.getLog(ActCalcAction.class);
    private static final List<String> FILTER_PROALLOCSTD = Lists.newArrayList((Object[])new String[]{"3", "4", "5", "6"});

    public DataSet getMainJoinSideCostobjDsFromMainId(Long orgId, Set<Long> mainCostobjectIds, String[] productTypes) {
        QFilter filter = new QFilter("id", "in", mainCostobjectIds);
        DataSet mainCostobjectDs = QueryServiceHelper.queryDataSet((String)"CalCadCostobject", (String)"cad_costobject", (String)"costcenter,costcenter mainCostCenterId,id mainCostObjectId,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource", (QFilter[])filter.toArray(), null);
        DataSet mainJoinSideDs = null;
        mainJoinSideDs = Arrays.asList(productTypes).contains("C") ? mainCostobjectDs.copy().filter("productgroup>0") : mainCostobjectDs.filter("productgroup>0");
        HashSet productgroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet poNos = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : mainJoinSideDs.copy()) {
            productgroupIds.add(row.getLong("productgroup"));
            poNos.add(row.getString("srcbillnumber"));
        }
        DataSet relaCostobjectDs = null;
        if (productgroupIds.isEmpty() && poNos.isEmpty()) {
            relaCostobjectDs = mainJoinSideDs;
        } else {
            ArrayList<String> productTypeList = new ArrayList<String>();
            productTypeList.addAll(Arrays.asList(productTypes));
            productTypeList.remove("C");
            QFilter relaFilter = new QFilter("org", "=", (Object)orgId);
            relaFilter.and("productgroup", "in", (Object)productgroupIds);
            relaFilter.and("srcbillnumber", "in", (Object)poNos);
            relaFilter.and("producttype", "in", productTypeList);
            relaCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"cad_costobject", (String)"biztype,costcenter,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource,mainproobj", (QFilter[])relaFilter.toArray(), null);
            DataSet notHasRelaMainDs = relaCostobjectDs.copy().filter("mainproobj=0");
            if (!notHasRelaMainDs.isEmpty()) {
                notHasRelaMainDs = mainJoinSideDs.join(notHasRelaMainDs).on("productgroup", "productgroup").on("srcbillnumber", "srcbillnumber").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource", "biztype"}).finish();
                notHasRelaMainDs = notHasRelaMainDs.filter("biztype<>'FL' or mainCostCenterId=costcenter").removeFields(new String[]{"biztype"});
            } else {
                notHasRelaMainDs = null;
            }
            relaCostobjectDs = mainJoinSideDs.join(relaCostobjectDs).on("mainCostObjectId", "mainproobj").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource"}).finish();
            if (notHasRelaMainDs != null) {
                relaCostobjectDs = relaCostobjectDs.union(notHasRelaMainDs);
            }
        }
        if (Arrays.asList(productTypes).contains("C")) {
            relaCostobjectDs = DataSetHelper.union(relaCostobjectDs, mainCostobjectDs);
        }
        return relaCostobjectDs;
    }

    public Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    public DataSet buildCloseStatus(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("accountorg", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costobject.biztype", "=", (Object)"RO");
        String selectFields = "costobject as costObjectId,closestatu as closestatus";
        DataSet planned = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-planclose", (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null).distinct();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u83b7\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5173\u95ed\u72b6\u6001\u53d6\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"RealTimeCostCalcDataInputFactory_0", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return planned;
    }

    public DataSet buildCalcResultSourceIdDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("costobject", "in", calcCostObjectSet);
        String selectFields = "costobject as costObjectId,entryentity.srcbillentryid srcbillentry,inventoryentryentity.sourcebillentry sourcebillentry,plansourceentry.plansrcbillentry plansrcbillentry";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_realtimecalcresult", (String)selectFields, (QFilter[])filter.toArray(), null).distinct();
        return resultDs;
    }

    public DataSet buildCalcResultCostObjectDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        String selectFields = "costobject as pdcostObjectId";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_realtimecalcresult", (String)selectFields, (QFilter[])filter.toArray(), null).distinct();
        return resultDs;
    }

    public DataSet buildPlannedoutputDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("accountorg", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("bizdate", ">=", (Object)args.getStartDate());
        filter.and("bizdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = "billno as planbillno,costobject.costcenter as costCenterId,costobject as costObjectId,qty as proPlanQty,0.00 as proFinQty,sourcebillentry";
        DataSet planned = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-plan", (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"RealTimeCostCalcDataInputFactory_1", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return planned;
    }

    public DataSet buildFactnedoutputDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet, Set<String> secFields) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("entryentity.costobject", "in", calcCostObjectSet);
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = "sourcebill as srcBillId,sourcebillentry as srcEntryId,entryentity.costobject.srcbillnumber as mftOrderNo,entryentity.costobject.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.costobject.producttype as productType,entryentity.costobject.productgroup.id as groupId,material as matId,entryentity.costobject.bomversion as matVerId,entryentity.costobject.auxpty as matAuxId,0.00 as proPlanQty,entryentity.qty as proFinQty,srcauxpty as auxpty,invtype,gradeprodgroup,costcenter as factedCostCenterId";
        String groupField = "srcBillId,srcEntryId,productType,groupId,mftOrderNo,costCenterId,costObjectId,matId,matVerId,matAuxId,auxpty,invtype,gradeprodgroup,factedCostCenterId";
        if (secFields != null && !secFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (String secField : secFields) {
                joiner.add(secField);
            }
            String field = joiner.toString();
            selectFields = selectFields + "," + field;
            groupField = groupField + "," + field;
        }
        DataSet factned = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        factned = factned.groupBy(groupField.split(",")).sum("proPlanQty").sum("proFinQty").finish();
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u6761\u4ef6:%s", (String)"RealTimeCostCalcDataInputFactory_2", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return factned;
    }

    public DataSet buildFactnedoutputInEntryIdDs(RealTimeCostCalcArgs args, Set<Long> factedEntryId) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("sourcebillentry", "in", factedEntryId);
        String selectFields = "sourcebill as srcBillId,sourcebillentry as srcEntryId,costcenter,entryentity.costobject as costObjectId,entryentity.costobject.name as costObjectName,entryentity.costobject.producttype as productType,entryentity.qty as proFinQty";
        return QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet buildMaterialAllocDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("bizdate", ">=", (Object)args.getStartDate());
        filter.and("bizdate", "<", (Object)args.getEndDate());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobejctentry", "in", calcCostObjectSet);
        String selectFields = "id,entryentity.id as entryId,entryentity.costobejctentry.costcenter as costCenterId,entryentity.costobejctentry as costObjectId,entryentity.costobejctentry.producttype as productType,entryentity.costobejctentry.productgroup.id as groupId,entryentity.costobejctentry.srcbillnumber as mftOrderNo,entryentity.costobejctentry.material as matId,entryentity.costobejctentry.material.baseunit.precision as matUnitPrecision,entryentity.costobejctentry.bomversion as matVerId,entryentity.costobejctentry.auxpty as matAuxId,material as subMatId,matversion as subMatVerId,auxpty as subMatAuxId,0L as subResourceId,material.baseunit.precision as subMatUnitPrecision,entryentity.elemententry as elementId,entryentity.subelemententry as subElementId,entryentity.qty as qty,entryentity.amount as amount,isreturnitem as isReturn,0 as isMfg,case when entryentity.costobejctentry.isoutsource ='1' then 'D' else ' ' end as outsourcetype,matcollect as matallocid,createtime";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u3011\u6761\u4ef6:%s", (String)"RealTimeCostCalcDataInputFactory_3", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        List partArrIds = Lists.partition(new ArrayList<Long>(args.getMatAllocIds()), (int)10000);
        if (!CadEmptyUtils.isEmpty((List)partArrIds)) {
            for (List matColIds : partArrIds) {
                DataSet matCollectDataSet = ActCalcHelper.getMatCollectDs(matColIds);
                DataSet matCollectDataSetCopy = matCollectDataSet.copy();
                HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)128);
                HashSet matUseCollectEntryIdSet = Sets.newHashSetWithExpectedSize((int)128);
                for (Row row : matCollectDataSetCopy) {
                    sourceBillEntryIds.add(row.getLong("srcEntryId"));
                    matUseCollectEntryIdSet.add(row.getLong("entryId"));
                }
                QFilter qFilter = new QFilter("costaccount", "=", (Object)args.getCostAccountId());
                qFilter.and("entry.bizbillentryid", "in", (Object)sourceBillEntryIds);
                DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)"auditdate,billno,bizbillid as srcBillId,entry.bizbillentryid as srcEntryId", (QFilter[])qFilter.toArray(), null);
                DataSet allocDs = matCollectDataSet.leftJoin(costRecordDs).on("srcBillId", "srcBillId").on("srcEntryId", "srcEntryId").select(matCollectDataSet.getRowMeta().getFieldNames(), new String[]{"auditdate", "billno"}).finish();
                dataset = dataset.leftJoin(allocDs).on("matallocid", "entryId").select(dataset.getRowMeta().getFieldNames(), new String[]{"auditdate as syncauditdate", "billno as srcbillno", "srcBillId as srcbillid", "srcEntryId as srcbillentryid", "0L as resource"}).finish();
            }
        } else {
            dataset = dataset.addField("createtime", "syncauditdate");
            dataset = dataset.addFields(new String[]{"''", "0L", "0L", "0L"}, new String[]{"srcbillno", "srcbillid", "srcbillentryid", "resource"});
        }
        dataset = dataset.removeFields(new String[]{"matallocid", "createtime"});
        return dataset;
    }

    public Set<Long> buildNestCalcResultIds(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        HashSet resultIds = Sets.newHashSetWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(calcCostObjectSet)) {
            QFilter nestFilter = new QFilter("org", "=", (Object)args.getOrgId());
            nestFilter.and("costaccount", "=", (Object)args.getCostAccountId());
            nestFilter.and("period", "<", (Object)args.getPrePeriodId());
            nestFilter.and("costobject", "in", calcCostObjectSet);
            String selectFields = "id,period,costobject as costObjectId";
            DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_mfgplanfeeresult", (String)selectFields, (QFilter[])nestFilter.toArray(), null);
            DataSet netCalcResultIdDataSet = resultDs.groupBy(new String[]{"costObjectId"}).maxP("period", "id").finish();
            for (Row row : netCalcResultIdDataSet) {
                resultIds.add(row.getLong("id"));
            }
        }
        return resultIds;
    }

    public DataSet buildMfgFeeAllocDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("costobject", "in", calcCostObjectSet);
        String selectFields = "costcenter as costCenterId,costobject as costObjectId,costobject.producttype as productType,costobject.productgroup.id as groupId,costobject.srcbillnumber as mftOrderNo,costobject.material as matId,costobject.bomversion as matVerId,costobject.auxpty as matAuxId,costobject.material.baseunit.precision as matUnitPrecision,0L as subMatId,0L as subMatVerId,0L as subMatAuxId,resource as subResourceId,0 as subMatUnitPrecision,element as elementId,subelement as subElementId,amount,1 as isMfg,'C' as outsourcetype,syncauditdate,sourcebillno as srcbillno,sourcebillid as srcbillid,sourcebillentryid as srcbillentryid,resource";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-planfeeresult", (String)"aca_mfgplanfeeresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u53d6\u5236\u9020\u8d39\u7528\u8ba1\u5212\u8d39\u7387\u8ba1\u7b97\u7ed3\u679c\u5355\u3011\u6761\u4ef6:%s", (String)"RealTimeCostCalcDataInputFactory_4", (String)"macc-aca-algox", (Object[])new Object[0]), filter.toString()));
        return dataset;
    }

    public DataSet buildDetailPreCalcResultDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"detail");
        filter.and("entryentity.relaproducttype", "=", (Object)"C");
        String selectFields = "costobject.costcenter as costCenterId,costobject as costObjectId,costobject.producttype as productType,costobject.productgroup.id as groupId,costobject.srcbillnumber as mftOrderNo,costobject.material as matId,costobject.bomversion as matVerId,costobject.auxpty as matAuxId,costobject.material.baseunit.precision as matUnitPrecision,entryentity.submaterial as subMatId,entryentity.submatversion as subMatVerId,entryentity.subauxpty as subMatAuxId,0L as subResourceId,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.element as elementId,entryentity.subelement as subElementId,entryentity.feetype feetype,entryentity.pdendqty as pdStartQty, entryentity.pdendamount as pdStartAmt,entryentity.outsourcetype as outsourcetype,'' as srcbillno,0L as srcbillid,0L as srcbillentryid";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-prertcalcresult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        fieldNames.remove("subMatUnitPrecision");
        fieldNames.remove("feetype");
        fieldNames.add("case when subMatUnitPrecision is null then 0 else subMatUnitPrecision end as subMatUnitPrecision");
        fieldNames.add("case when feetype='materialFee' or subMatId>0  then 0 else 1 end as isMfg");
        resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        return resultDs;
    }

    public Map<String, Object> buildCalcInCostParam(RealTimeCostCalcArgs args, DataSet calcInDataSet, Map<String, DynamicObject> calcResultMap, Set<Long> hasUpdateFactedEntryIds) {
        Long srcEntryId;
        HashMap result = Maps.newHashMap();
        HashMap tmpMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object row : calcInDataSet) {
            List<HashMap> list;
            String string = row.getString("carrytype");
            Long srcBillId = row.getLong("srcBillId");
            srcEntryId = row.getLong("srcEntryId");
            hasUpdateFactedEntryIds.add(srcEntryId);
            Long subElementId = row.getLong("subElementId");
            String outSourceType = row.getString("outsourcetype");
            Long costCenterId = row.getLong("costCenterId");
            Long costObjectId = row.getLong("costObjectId");
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            String productType = row.getString("productType");
            BigDecimal finQty = row.getBigDecimal("proFinQty");
            BigDecimal cost = row.getBigDecimal("cost");
            if (cost != null) {
                cost = cost.setScale(args.getAmtScale(), RoundingMode.HALF_UP);
            }
            String groupField = row.getString("groupfield");
            Long groupCategoryid = row.getLong("groupcategoryid");
            String key = costCenterId + "@" + mainCostObjectId;
            DynamicObject dyo = calcResultMap.get(key);
            if (dyo != null) {
                DynamicObjectCollection dyoColl = dyo.getDynamicObjectCollection("inventoryentryentity");
                DynamicObject entryDyo = dyoColl.addNew();
                entryDyo.set("carrytype", (Object)string);
                entryDyo.set("sourcebill", (Object)srcBillId);
                entryDyo.set("sourcebillentry", (Object)srcEntryId);
                entryDyo.set("invcostobject_id", (Object)costObjectId);
                entryDyo.set("invproducttype", (Object)productType);
                entryDyo.set("inventoryqty", (Object)finQty);
                entryDyo.set("inventoryamount", (Object)cost);
                entryDyo.set("inventorysubelement", (Object)subElementId);
                entryDyo.set("invoutsourcetype", (Object)outSourceType);
                entryDyo.set("groupfield", (Object)groupField);
                entryDyo.set("groupcategoryid", (Object)groupCategoryid);
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outsourcetype", outSourceType);
            map.put("costsubelement", subElementId);
            map.put("cost", cost);
            if (tmpMap.get(srcEntryId) == null) {
                list = Lists.newArrayList();
                tmpMap.put(srcEntryId, list);
            }
            list = (List)tmpMap.get(srcEntryId);
            list.add(map);
        }
        ArrayList saveDyos = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry entry : calcResultMap.entrySet()) {
            saveDyos.add(entry.getValue());
        }
        if (!saveDyos.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDyos.toArray(new DynamicObject[0]));
        }
        ArrayList calcParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mapEntry : tmpMap.entrySet()) {
            srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("costaccount", args.getCostAccountId());
            map.put("bizbillentryid", srcEntryId);
            map.put("costinfo", list);
            calcParamList.add(map);
        }
        result.put("calcParamList", calcParamList);
        return result;
    }

    public void buildCalcConversionDetail(DataSet calcConversionDetailDataSet, Map<String, DynamicObject> calcResultMap) {
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        for (Row row : calcConversionDetailDataSet) {
            Long costCenterId = row.getLong("costCenterId");
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            String key = costCenterId + "@" + mainCostObjectId;
            DynamicObject dyo = calcResultMap.get(key);
            if (dyo == null) continue;
            Long id = dyo.getLong("id");
            Object[] entry = new Object[]{id, ID.genLongId(), 1, row.getLong("srcBillId"), row.getLong("srcEntryId"), row.getLong("costObjectId"), row.getString("productType"), row.getLong("elementId"), row.getLong("subElementId"), row.getString("outsourcetype"), row.getLong("subMatId") == null ? Long.valueOf(0L) : row.getLong("subMatId"), row.getLong("subResourceId") == null ? Long.valueOf(0L) : row.getLong("subResourceId"), row.getLong("subMatVerId") == null ? Long.valueOf(0L) : row.getLong("subMatVerId"), row.getLong("subMatAuxId") == null ? Long.valueOf(0L) : row.getLong("subMatAuxId"), BigDecimalUtil.getOrZero(row.getBigDecimal("proFinQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finQty")), BigDecimalUtil.getOrZero(row.getBigDecimal("finAmt")), row.getString("groupfield"), row.getLong("groupcategoryid")};
            entrys.add(entry);
            if (entrys.size() < 5000) continue;
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_CONVDETAIL_ENTRY_SQL, entrys);
            entrys.clear();
        }
        if (!CollectionUtils.isEmpty(entrys)) {
            this.executeBatch(DBRoute.of((String)"cal"), INSERT_CONVDETAIL_ENTRY_SQL, entrys);
        }
    }

    private void executeBatch(DBRoute route, String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)route, (String)sql, entrys);
    }

    public DataSet buildProallocstdDataSet(RealTimeCostCalcArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("effectstatus", "=", (Object)"1");
        String selectFields = " allocentry.costcenter as costCenterId,allocentry.costdriver as costdriver,allocentry.productsubentry.element as elementId,allocentry.productsubentry.subelement as subElementId,allocentry.productsubentry.costdriverdetail as costdriverdetail,allocentry.productsubentry.costtype as costtype";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-proAllocStd", (String)"aca_proallocstd", (String)selectFields, (QFilter[])filter.toArray(), null);
        return resultDs;
    }

    public Map<String, String> buildProallocstdMap(RealTimeCostCalcArgs args) {
        DataSet proallocstdDataSet = this.buildProallocstdDataSet(args);
        HashMap proallocstdMap = Maps.newHashMapWithExpectedSize((int)50);
        for (Row row : proallocstdDataSet) {
            String costCenterId = row.getString("costCenterId");
            String costDriver = row.getString("costdriver");
            if (FILTER_PROALLOCSTD.contains(costDriver)) {
                costDriver = "1";
            }
            if (CadEmptyUtils.isEmpty((String)costCenterId)) {
                proallocstdMap.put(String.valueOf(args.getCostAccountId()), costDriver);
            } else {
                proallocstdMap.put(String.format("%s@%s", args.getCostAccountId(), costCenterId), costDriver);
            }
            String costDriverDetail = row.getString("costdriverdetail");
            if (FILTER_PROALLOCSTD.contains(costDriver)) {
                costDriverDetail = "1";
            }
            Long costType = row.getLong("costtype");
            if (costDriverDetail == null || !StringUtils.isNotEmpty((String)costDriverDetail)) continue;
            if (costDriverDetail.equals("3") && StringUtils.isNotEmpty((String)costCenterId)) {
                args.getAssemblyCostCenterSet().add(Long.parseLong(costCenterId));
            }
            if ("5".equals(costDriverDetail) && StringUtils.isNotEmpty((String)costCenterId)) {
                args.getBomCostCenterSet().add(Long.parseLong(costCenterId));
                args.getCostTypeSet().add(costType);
            }
            String subElementId = row.getString("subElementId");
            String key = args.getCostAccountId() + "@" + costCenterId + "@" + subElementId;
            proallocstdMap.put(key, costDriverDetail);
        }
        return proallocstdMap;
    }

    public DataSet buildEquivalentDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (args.getManuOrgId() != null && args.getManuOrgId() > 0L) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "billno,period as periodId,entryentity.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.totalvalen as totalvalen,entryentity.entryentitydetail.element as elementId,entryentity.entryentitydetail.subelement as subElementId,entryentity.entryentitydetail.detailvalen as detailvalen";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-equivalent", (String)"aca_equivalent", (String)selectFields, (QFilter[])filter.toArray(), (String)"period asc");
        return resultDs;
    }

    public Map<String, BigDecimal> getEquivalentMap(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet, RealTimeDebugInfoMsgHandler msgHander) {
        HashMap equivalentMap = Maps.newHashMapWithExpectedSize((int)2000);
        DataSet equDataSet = this.buildEquivalentDataSet(args, calcCostObjectSet);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(equDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u7ea6\u5f53\u7cfb\u6570\u6570\u636e\uff1a", (String)"RealTimeCostCalcDataInputFactory_5", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
        }
        Long costAccountId = args.getCostAccountId();
        for (Row row : equDataSet) {
            String costCenterId = row.getString("costCenterId");
            String costObjectId = row.getString("costObjectId");
            BigDecimal totalvalen = row.getBigDecimal("totalvalen");
            String key = "";
            key = !CadEmptyUtils.isEmpty((String)costObjectId) ? String.format("%s@%s@%s", costAccountId, costCenterId, costObjectId) : (!CadEmptyUtils.isEmpty((String)costCenterId) ? String.format("%s@%s", costAccountId, costCenterId) : String.format("%s", costAccountId));
            equivalentMap.put(key, totalvalen);
            BigDecimal detailvalen = row.getBigDecimal("detailvalen");
            if (detailvalen == null) continue;
            String subElementId = row.getString("subElementId");
            key = !CadEmptyUtils.isEmpty((String)costObjectId) ? String.format("%s@%s@%s@%s", costAccountId, costCenterId, costObjectId, subElementId) : (!CadEmptyUtils.isEmpty((String)costCenterId) ? String.format("%s@%s@%s", costAccountId, costCenterId, subElementId) : String.format("%s@%s", costAccountId, subElementId));
            equivalentMap.put(key, detailvalen);
        }
        return equivalentMap;
    }

    public DataSet buildFinalPreCalcResultDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPrePeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        String selectFields = "costcenter  as costCenterId, costobject as mainCostObjectId,entryentity.relacostobject costObjectId,entryentity.relacostobject.material as matId,entryentity.relacostobject.bomversion as matVerId,entryentity.relacostobject.auxpty.id as matAuxId,entryentity.pdendqty as pdStartQty, entryentity.pdendamount as pdStartAmt,entryentity.relaproducttype as productType";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        return resultDs;
    }

    public DataSet buildFinalCalcResultDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        String selectFields = "costcenter as costCenterId, costobject as mainCostObjectId,entryentity.relacostobject costObjectId,entryentity.relacostobject.material as matId,entryentity.relacostobject.bomversion as matVerId,entryentity.relacostobject.auxpty.id as matAuxId,entryentity.pdcurrqty as pdSumQty, entryentity.pdcurramount as pdSumAmt,entryentity.currcomqty as sumComQty, entryentity.currcomamount as sumComAmt,entryentity.pdendqty as pdEndQty, entryentity.pdendamount as pdEndAmt,entryentity.relaproducttype as productType";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_realtimecalcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        return resultDs;
    }

    public DataSet buildFinalCalcResultDetailDataSet(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"detail");
        String selectFields = "costcenter as costCenterId, costobject as mainCostObjectId,entryentity.relacostobject costObjectId,entryentity.relacostobject.productgroup.id as groupId,entryentity.relacostobject.srcbillnumber as mftOrderNo,entryentity.relacostobject.material as matId,entryentity.relacostobject.material.baseunit.precision as matUnitPrecision,entryentity.submaterial as subMatId,entryentity.submatversion as subMatVerId,entryentity.subauxpty as subMatAuxId,entryentity.resource as subResourceId,entryentity.resource as resource,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.element as elementId,entryentity.subelement as subElementId,entryentity.outsourcetype outsourcetype,case when entryentity.feetype ='mfgFee' then 1 else 0 end as isMfg,entryentity.syncauditdate as syncauditdate,entryentity.srcbillno as srcbillno,entryentity.srcbillid srcbillid,entryentity.srcbillentryid srcbillentryid,entryentity.relacostobject.bomversion as matVerId,entryentity.relacostobject.auxpty.id as matAuxId,entryentity.pdendamount as pdStartAmt,entryentity.relaproducttype as productType,'1' as rowtype,entryentity.calcdate as calcdate";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResult", (String)"aca_realtimecalcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        DataSet dateDataSet = resultDs.copy().groupBy(new String[]{"costCenterId", "costObjectId"}).max("calcdate", "maxcalcdate").finish();
        resultDs = resultDs.join(dateDataSet, JoinType.INNER).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").select(resultDs.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
        resultDs = resultDs.filter("calcdate=maxcalcdate");
        return resultDs;
    }

    public Map<Long, Long> buildCostobjectResultIdMap(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("entryentity.relacostobject", "in", calcCostObjectSet);
        filter.and("entryentity.type", "=", (Object)"finalResult");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-calcResultId", (String)"aca_realtimecalcresult", (String)"entryentity.relacostobject costobject,id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            result.put(row.getLong("costobject"), row.getLong("id"));
        }
        return result;
    }

    public Map<String, DynamicObject> buildCalcResultIdMap(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        DynamicObject[] rs;
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("period", "=", (Object)args.getPeriodId());
        filter.and("costobject", "in", calcCostObjectSet);
        for (DynamicObject dyo : rs = BusinessDataServiceHelper.load((String)"aca_realtimecalcresult", (String)"id,costcenter.id,costobject.id,inventoryentryentity.id,inventoryentryentity.carrytype,inventoryentryentity.sourcebill,inventoryentryentity.sourcebillentry,inventoryentryentity.invcostobject,inventoryentryentity.invproducttype,inventoryentryentity.inventorysubelement,inventoryentryentity.inventoryqty,inventoryentryentity.inventoryamount,inventoryentryentity.groupfield,inventoryentryentity.groupcategoryid,inventoryentryentity.invoutsourcetype", (QFilter[])filter.toArray())) {
            String costCenterId = dyo.getString("costcenter.id");
            String costObjectId = dyo.getString("costobject.id");
            String key = costCenterId + "@" + costObjectId;
            result.put(key, dyo);
        }
        return result;
    }

    public DataSet buildRelatedDataSet(RealTimeCostCalcArgs args, Set<Long> groupIds) {
        QFilter filter = new QFilter("id", "in", groupIds);
        filter.and("entryentity.producttype", "in", (Object)new String[]{"A", "C"});
        return QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-productGroup", (String)"cad_productintogroup", (String)"id as groupId,entryentity.material.id as matId,entryentity.matversion as matVerId,entryentity.auxpty as matAuxId,entryentity.producttype as productType,entryentity.alloctype as jointAllocType,entryentity.weight as jointWeight,entryentity.weightentry.element as elementId,entryentity.weightentry.subelement as subElementId,entryentity.weightentry.allocweight as allocWeight,entryentity.weightentry.fixedamt as fixedamt", (QFilter[])filter.toArray(), null);
    }

    public void buildMainJoinGroupMap(RealTimeCostCalcArgs args, Set<Long> productGroupIds, Map<String, BigDecimal[]> weightMap, Map<String, String> allocTypeMap) {
        DataSet productDataSet = this.buildRelatedDataSet(args, productGroupIds);
        for (Row row : productDataSet) {
            String key = row.getString("groupId") + "@" + row.get("matId") + "@" + row.get("matVerId") + "@" + row.get("matAuxId");
            String jointAllocType = row.getString("jointAllocType");
            BigDecimal jointWeight = row.getBigDecimal("jointWeight");
            weightMap.put(key, new BigDecimal[]{jointWeight, BigDecimal.ZERO});
            allocTypeMap.put(key, jointAllocType);
            BigDecimal allocWeight = row.getBigDecimal("allocWeight");
            BigDecimal fixedAmt = row.getBigDecimal("fixedamt");
            if (allocWeight == null) continue;
            String subElementkey = key + "@" + row.getString("subElementId");
            weightMap.put(subElementkey, new BigDecimal[]{allocWeight, BigDecimalUtil.getOrZero(fixedAmt)});
        }
    }

    public Map<String, List<ProextraPriceVo>> buildProextraPriceDataSet(RealTimeCostCalcArgs args, Set<Long> sideProductIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        filter.and("startdate", "<", (Object)args.getEndDate());
        filter.and("enddate", ">", (Object)args.getEndDate());
        filter.and("material.id", "in", sideProductIds);
        DynamicObject[] dyoColl = BusinessDataServiceHelper.load((String)"aca_proextraprice", (String)"material.id,matversion,auxpty.id,manuorg.id,costcenter.id,entryentity.id,entryentity.element,entryentity.subelement,entryentity.subelement.type,entryentity.price", (QFilter[])filter.toArray());
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyo : dyoColl) {
            String matId = dyo.getString("material.id");
            String matversion = dyo.getString("matversion");
            String auxptyId = dyo.getString("auxpty.id");
            String manuorgId = dyo.getString("manuorg.id");
            String costcenterId = dyo.getString("costcenter.id");
            matversion = matversion == null ? "0" : matversion;
            auxptyId = auxptyId == null ? "0" : auxptyId;
            manuorgId = manuorgId == null ? "0" : manuorgId;
            costcenterId = costcenterId == null ? "0" : costcenterId;
            ArrayList<ProextraPriceVo> entryValue = new ArrayList<ProextraPriceVo>(10);
            DynamicObjectCollection dynEntrys = dyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynEntry : dynEntrys) {
                ProextraPriceVo vo = new ProextraPriceVo();
                vo.setElement(dynEntry.getLong("element.id"));
                vo.setSubelement(dynEntry.getLong("subelement.id"));
                vo.setSubelementType(dynEntry.getString("subelement.type"));
                vo.setPrice(dynEntry.getBigDecimal("price"));
                entryValue.add(vo);
            }
            result.put(matId + "@" + matversion + "@" + auxptyId + "@" + manuorgId + "@" + costcenterId, entryValue);
        }
        return result;
    }

    public Map<Long, String> buildFactEntryNumberMap(RealTimeCostCalcArgs args, Set<Long> entryIds) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("sourcebillentry", "in", entryIds);
        String selectFields = "sourcebillentry as srcEntryId,billno";
        DataSet factned = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-fact", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : factned) {
            map.put(row.getLong("srcEntryId"), row.getString("billno"));
        }
        return map;
    }

    public Map<Long, String> buildCostObjectNameMap(Set<Long> costObjectIds) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-costObjectNumber", (String)"cad_costobject", (String)"id,billno,name", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : matDs) {
            map.put(row.getLong("id"), row.getString("name"));
        }
        matDs.close();
        return map;
    }

    public Map<Long, Set<String>> buildCostObjectNumberSet(Set<Long> costObjectIds) {
        DataSet matDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-costObjectNumber", (String)"cad_costobject", (String)"id,costcenter,billno,name", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Row row : matDs) {
            Long costcenterId = row.getLong("costcenter");
            Set costobjectNums = map.computeIfAbsent(costcenterId, t -> Sets.newHashSetWithExpectedSize((int)10));
            costobjectNums.add(row.getString("name"));
        }
        return map;
    }

    public DataSet buildBomSettingDataSet(RealTimeCostCalcArgs args, DataSet bomMainJoinCostObjectDs) {
        if (bomMainJoinCostObjectDs == null || bomMainJoinCostObjectDs.isEmpty()) {
            return null;
        }
        HashSet<Long> mainMatSet = new HashSet<Long>(16);
        HashSet<Long> mainAuxptySet = new HashSet<Long>(16);
        for (Row row : bomMainJoinCostObjectDs.copy()) {
            Long material = row.getLong("material");
            Long auxpty = row.getLong("auxpty");
            mainMatSet.add(material);
            mainAuxptySet.add(auxpty);
        }
        Set<Long> costTypeSet = args.getCostTypeSet();
        DataSet bomDataSet = this.buildBomDataSet(args, costTypeSet, mainMatSet, mainAuxptySet);
        if (bomDataSet != null) {
            return bomDataSet.join(bomMainJoinCostObjectDs).on("material", "material").on("auxpty", "auxpty").select(bomDataSet.getRowMeta().getFieldNames(), new String[]{"costObjectId"}).finish();
        }
        return null;
    }

    private DataSet buildBomDataSet(RealTimeCostCalcArgs args, Set<Long> costTypeSet, Set<Long> mainMatSet, Set<Long> mainAuxptySet) {
        QFilter costTypeQf = new QFilter("costtype", "in", costTypeSet);
        QFilter materialQf = new QFilter("material", "in", mainMatSet);
        QFilter auxptyQf = new QFilter("auxprop", "in", mainAuxptySet);
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        DataSet bomSettingDs = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE.concat("bomsetting"), (String)"cad_bomsetting", (String)"costtype,material,auxprop,bom,considersubmaterialloss subMatLoss,lossrateformula,considervalidperiod validPeriod", (QFilter[])new QFilter[]{costTypeQf, materialQf, auxptyQf, enableQf, statusQf}, (String)"id desc");
        if (bomSettingDs != null && !bomSettingDs.isEmpty()) {
            HashSet<Long> bomSet = new HashSet<Long>(16);
            DataSet bomSettings = bomSettingDs.copy();
            for (Row bomSetting : bomSettings) {
                long bom = bomSetting.getLong("bom");
                bomSet.add(bom);
            }
            if (!bomSet.isEmpty()) {
                QFilter idQf = new QFilter("id", "in", bomSet);
                DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE.concat("bom"), (String)"cad_costbom", (String)"id,number,material,material.name matName,auxproperty auxpty,entry.entrymaterial subMaterialId,entry.entrymaterial.name subMatName,entry.entryauxproperty subauxpty,entry.entryqtynumerator fz,entry.entryqtydenominator fm,entry.entryfixscrap gdshl,entry.entryscraprate bdshl,entry.entryvaliddate effectDate,entry.entryinvaliddate validDate,entry.entryqtytype qtytype", (QFilter[])new QFilter[]{idQf}, (String)"id desc");
                DataSet middleDs = bomSettingDs.join(bomDataSet, JoinType.INNER).on("bom", "id").select(new String[]{"costtype", "subMatLoss", "lossrateformula", "validPeriod"}, new String[]{"number", "material", "matName", "auxpty", "subMaterialId", "subMatName", "subauxpty", "fz", "fm", "gdshl", "bdshl", "effectDate", "validDate", "qtytype"}).finish();
                if (middleDs != null && !middleDs.isEmpty()) {
                    HashSet<Tuple<FourTuple<Long, Long, Long, Long>, Date>> matInformationSet = new HashSet<Tuple<FourTuple<Long, Long, Long, Long>, Date>>(64);
                    Date endDate = args.getEndDate();
                    ArrayList<Object[]> dataTable = new ArrayList<Object[]>();
                    for (Row row : middleDs) {
                        Object[] columns = new Object[8];
                        columns[0] = row.getLong("costtype");
                        columns[1] = row.getLong("material");
                        columns[2] = row.getLong("auxpty");
                        columns[3] = row.getLong("subMaterialId");
                        columns[4] = row.getLong("subauxpty");
                        matInformationSet.add((Tuple<FourTuple<Long, Long, Long, Long>, Date>)new Tuple((Object)new FourTuple((Object)row.getLong("subMaterialId"), (Object)0L, (Object)row.getLong("subauxpty"), (Object)args.getManuOrgId()), (Object)TimeServiceHelper.now()));
                        Boolean subMatLoss = row.getBoolean("subMatLoss");
                        Boolean validPeriod = row.getBoolean("validPeriod");
                        String lossRateFormula = row.getString("lossrateformula");
                        Date effectDate = row.getDate("effectDate");
                        Date validDate = row.getDate("validDate");
                        String qtyType = row.getString("qtytype");
                        BigDecimal fz = row.getBigDecimal("fz");
                        BigDecimal fm = row.getBigDecimal("fm");
                        BigDecimal gdshl = row.getBigDecimal("gdshl");
                        BigDecimal bdshl = row.getBigDecimal("bdshl");
                        if (BigDecimal.ZERO.compareTo(fm) == 0) {
                            String errStr = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b50\u7269\u6599\u5355\u4f4d\u8017\u7528\u91cf\u5931\u8d25\uff0c\u6210\u672cBOM\u201c%1$s\u201d\u7ec4\u4ef6\u7269\u6599\u201c%2$s\u201d\u5206\u6bcd\u8bbe\u7f6e\u4e3a\u96f6\u3002", (String)"RealTimeCostCalcDataInputFactory_6", (String)"macc-aca-algox", (Object[])new Object[0]), row.getString("number"), row.getString("subMatName"));
                            RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), (Long)0L, errStr);
                            continue;
                        }
                        BigDecimal unitQty = fz.divide(fm, 10, 4);
                        if (subMatLoss.booleanValue()) {
                            if ("A".equals(qtyType)) {
                                unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(bdshl), 10, 4) : unitQty.multiply(BigDecimal.ONE.add(bdshl)).setScale(10, 4);
                            } else if ("B".equals(qtyType)) {
                                unitQty = unitQty.add(gdshl);
                            } else if ("C".equals(qtyType)) {
                                unitQty = unitQty.add(gdshl);
                            }
                        }
                        columns[5] = unitQty;
                        if (validPeriod.booleanValue()) {
                            boolean afterEffect = endDate.after(effectDate);
                            boolean beforeValid = endDate.before(validDate);
                            if (!afterEffect || !beforeValid) {
                                logger.info("\u6210\u672cBOM\u7f16\u53f7{}\u7ec4\u4ef6\u7269\u6599{}\u751f\u6548\u671f\u4e0d\u5305\u542b\u6210\u672c\u8d26\u7c3f\u5f53\u671f\u671f\u95f4\u7684\u7ed3\u675f\u65f6\u95f4,\u8df3\u8fc7\u3002", (Object)row.getString("number"), (Object)row.getString("subMatName"));
                                continue;
                            }
                        }
                        columns[7] = row.getString("subMatName");
                        dataTable.add(columns);
                    }
                    Map<String, String> acaSubEleMap = this.getAcaSubElementByOrg(args.getOrgId(), matInformationSet);
                    Iterator iterator = dataTable.iterator();
                    while (iterator.hasNext()) {
                        Object[] row = (Object[])iterator.next();
                        Object subMat = row[3];
                        Object subMatAuxpty = row[4];
                        if (acaSubEleMap != null && !acaSubEleMap.isEmpty()) {
                            String strKey = args.getOrgId() + "@" + AcaMatAllocHelper.getStrKey(String.valueOf(subMat), 0L, Long.parseLong(String.valueOf(subMatAuxpty)), args.getManuOrgId(), null);
                            String matIdToPair = acaSubEleMap.get(strKey);
                            if (StringUtils.isEmpty((String)matIdToPair)) {
                                logger.info("\u83b7\u53d6\u6210\u672c\u5b50\u8981\u7d20\u7684key" + strKey);
                                String msg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b50\u9879\u7269\u6599\u201c%s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u8981\u7d20\u548c\u5b50\u8981\u7d20\u3002", (String)"RealTimeCostCalcDataInputFactory_7", (String)"macc-aca-algox", (Object[])new Object[0]), row[7]);
                                RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), (Long)0L, msg);
                                iterator.remove();
                            }
                            String[] split = matIdToPair.split("@");
                            row[6] = split[1];
                            continue;
                        }
                        String msg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b50\u9879\u7269\u6599\u201c%s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u8981\u7d20\u548c\u5b50\u8981\u7d20\u3002", (String)"RealTimeCostCalcDataInputFactory_7", (String)"macc-aca-algox", (Object[])new Object[0]), row[7]);
                        RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), (Long)0L, msg);
                        iterator.remove();
                    }
                    return this.createBomRsDs(dataTable);
                }
            }
        }
        return null;
    }

    private Map<String, String> getAcaSubElementByOrg(Long orgId, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>> matInformationSet) {
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getAcaSubElementByOrg", (Object[])new Object[]{orgId, matInformationSet, "0"});
        return matIdToPairMap;
    }

    private DataSet createBomRsDs(List<Object[]> dataTable) {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(new Field("costtype", (DataType)DataType.LongType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        fields.add(new Field("auxpty", (DataType)DataType.LongType));
        fields.add(new Field("subMaterialId", (DataType)DataType.LongType));
        fields.add(new Field("subauxpty", (DataType)DataType.LongType));
        fields.add(new Field("unitQty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("subelement", (DataType)DataType.LongType));
        fields.add(new Field("subMatName", (DataType)DataType.StringType));
        return Algo.create((String)ALGOKEY_PRE.concat("bomRs")).createDataSet(dataTable.iterator(), new RowMeta(fields.toArray(new Field[0]))).groupBy(new String[]{"costtype", "material", "auxpty", "subMaterialId", "subauxpty", "subelement", "subMatName"}).sum("unitQty").finish();
    }

    public DataSet buildAssemblyDataSet(RealTimeCostCalcArgs args, DataSet mainJoinSideCostobjectCopyDs) {
        if (mainJoinSideCostobjectCopyDs == null || mainJoinSideCostobjectCopyDs.isEmpty()) {
            return null;
        }
        HashSet proBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proOmBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proMainAndJoinBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet proOmMainAndJoinBillEntrySet = Sets.newHashSetWithExpectedSize((int)16);
        DataSet costobjectProIdCopyDs = mainJoinSideCostobjectCopyDs.copy();
        for (Row row : costobjectProIdCopyDs) {
            Long probill = row.getLong("probill");
            if (Boolean.FALSE.equals(row.getBoolean("isoutsource"))) {
                if ("C".equals(row.getString("producttype"))) {
                    proBillEntrySet.add(probill);
                }
                proMainAndJoinBillEntrySet.add(probill);
                continue;
            }
            if ("C".equals(row.getString("producttype"))) {
                proOmBillEntrySet.add(probill);
            }
            proOmMainAndJoinBillEntrySet.add(probill);
        }
        DataSet proComDataSet = this.buildComAssemblyDataSet(proMainAndJoinBillEntrySet, proOmMainAndJoinBillEntrySet);
        DataSet proDetailDataSet = this.buildDetailAssemblyDataSet(proBillEntrySet, proOmBillEntrySet);
        if (proDetailDataSet == null || proComDataSet == null) {
            return null;
        }
        DataSet mainCostobjectDs = mainJoinSideCostobjectCopyDs.copy().filter("producttype='C'");
        DataSet mftOrderStockDs = mainJoinSideCostobjectCopyDs.leftJoin(proComDataSet).on("probill", "entryid").select(mainJoinSideCostobjectCopyDs.getRowMeta().getFieldNames(), new String[]{"stockqty"}).finish().groupBy(new String[]{"mainCostobjectId"}).sum("stockqty").finish();
        DataSet mainJoinSideCostobjectStockDs = mainCostobjectDs.leftJoin(mftOrderStockDs).on("mainCostobjectId", "mainCostobjectId").select(new String[]{"mainCostobjectId", "probill"}, new String[]{"stockqty"}).finish();
        Set materialIds = Sets.newConcurrentHashSet();
        DataSet proCopyDataSet = proDetailDataSet.copy();
        for (Row row : proCopyDataSet) {
            Long subMaterialId = row.getLong("subMaterialId");
            if (CadEmptyUtils.isEmpty((Long)subMaterialId)) continue;
            materialIds.add(subMaterialId);
        }
        DataSet auxAffectMatDs = this.getAffectPriceDs(materialIds);
        proDetailDataSet = proDetailDataSet.leftJoin(auxAffectMatDs).on("subMaterialId", "effectpricemat").select(new String[]{"orderentryid", "subMaterialId", "useqty", "case when effectpricemat>0 then subauxpty else 0L end subauxpty"}).finish().groupBy(new String[]{"orderentryid", "subMaterialId", "subauxpty"}).sum("useqty").finish();
        return mainJoinSideCostobjectStockDs.join(proDetailDataSet).on("probill", "orderentryid").select(new String[]{"mainCostobjectId costObjectId", "stockqty", "subMaterialId", "subauxpty", "useqty"}).finish();
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-mat", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    public DataSet buildComAssemblyDataSet(Set<Long> proBillEntrySet, Set<Long> proOmBillEntrySet) {
        QFilter entryIdQf;
        DataSet mftStockDs = null;
        DataSet mftOmStockDs = null;
        if (!proBillEntrySet.isEmpty()) {
            entryIdQf = new QFilter("treeentryentity.id", "in", proBillEntrySet);
            mftStockDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-mftOrder", (String)"pom_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty", (QFilter[])new QFilter[]{entryIdQf}, null);
        }
        if (!proOmBillEntrySet.isEmpty()) {
            entryIdQf = new QFilter("treeentryentity.id", "in", proOmBillEntrySet);
            mftOmStockDs = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-mftOrder", (String)"om_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty", (QFilter[])new QFilter[]{entryIdQf}, null);
        }
        if (mftStockDs == null || mftOmStockDs == null) {
            if (mftStockDs != null) {
                return mftStockDs;
            }
            if (mftOmStockDs != null) {
                return mftOmStockDs;
            }
            return null;
        }
        return DataSetHelper.union(mftStockDs, mftOmStockDs);
    }

    public DataSet buildDetailAssemblyDataSet(Set<Long> proBillEntrySet, Set<Long> proOmBillEntrySet) {
        DataSet assemblyDataSet = null;
        DataSet omAssemblyDataSet = null;
        if (!proBillEntrySet.isEmpty()) {
            QFilter orderEntryQf = new QFilter("orderentryid", "in", proBillEntrySet);
            String selectSql = "orderentryid,stockentry.materielmasterid AS subMaterialId,stockentry.childauxpropertyid subauxpty,stockentry.demandqty AS useqty";
            boolean ne = this.isContainsProperty("pom_mftstock", "iscannegative");
            if (ne) {
                selectSql = selectSql + ",stockentry.iscannegative iscannegative";
            }
            assemblyDataSet = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-mftStock", (String)"pom_mftstock", (String)selectSql, (QFilter[])new QFilter[]{orderEntryQf}, null);
            if (ne) {
                assemblyDataSet = this.dealNegativeQty(assemblyDataSet);
            }
        }
        if (!proOmBillEntrySet.isEmpty()) {
            String selectSql = "orderentryid,stockentry.materielmasterid AS subMaterialId,stockentry.childauxpropertyid subauxpty,stockentry.demandqty AS useqty";
            boolean ne = this.isContainsProperty("om_mftstock", "iscannegative");
            if (ne) {
                selectSql = selectSql + ",stockentry.iscannegative iscannegative";
            }
            QFilter orderEntryQf = new QFilter("orderentryid", "in", proOmBillEntrySet);
            omAssemblyDataSet = QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-mftStock", (String)"om_mftstock", (String)selectSql, (QFilter[])new QFilter[]{orderEntryQf}, null);
            if (ne) {
                omAssemblyDataSet = this.dealNegativeQty(omAssemblyDataSet);
            }
        }
        if (assemblyDataSet == null || omAssemblyDataSet == null) {
            if (assemblyDataSet != null) {
                return assemblyDataSet;
            }
            if (omAssemblyDataSet != null) {
                return omAssemblyDataSet;
            }
            return null;
        }
        return DataSetHelper.union(assemblyDataSet, omAssemblyDataSet);
    }

    private boolean isContainsProperty(String meta, String property) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)meta);
        IDataEntityProperty per = mainEntityType.findProperty(property);
        return per != null;
    }

    private DataSet dealNegativeQty(DataSet ds) {
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        fieldNames.remove("useqty");
        fieldNames.remove("iscannegative");
        fieldNames.add("case when iscannegative=true then -useqty else useqty end as useqty");
        return ds.select(fieldNames.toArray(new String[0]));
    }

    public DataSet buildSubElementTypeDataSet() {
        QFilter qfType = new QFilter("type", "in", (Object)new String[]{"001", "002"});
        return QueryServiceHelper.queryDataSet((String)"RealTimeActCostCalcInput-SubElementTypeDataSet", (String)"cad_subelement", (String)"id,type as subElementType", (QFilter[])new QFilter[]{qfType}, null);
    }

    public DynamicObjectCollection getGradeProductsByIds(Set<Long> gradeGroupIds) {
        Date nowTime = new Date();
        QFilter filter = new QFilter("id", "in", gradeGroupIds);
        filter.and("grouptype", "=", (Object)"2");
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)true);
        filter.and("effectdate", "<=", (Object)nowTime);
        filter.and("expdate", ">", (Object)nowTime);
        return QueryServiceHelper.query((String)"cad_productintogroup", (String)"id,groupfield,srcfield,entryentity.material as matid,entryentity.groupcategory as groupcategory,entryentity.auxpty as auxpty,entryentity.weight as weight", (QFilter[])new QFilter[]{filter});
    }

    public void buildGradeProductByGroupIds(Set<Long> gradeGroupIds, Map<Long, String> matGroFieMap, Map<String, BigDecimal> matCateMap, Map<String, String> srcFieldMap) {
        DynamicObjectCollection dynamicObjects = this.getGradeProductsByIds(gradeGroupIds);
        if (!dynamicObjects.isEmpty()) {
            srcFieldMap.put("bd_auxproperty", "auxpty");
            srcFieldMap.put("bd_invtype", "invtype");
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long matId = dynamicObject.getLong("matid");
                String groupField = dynamicObject.getString("groupfield");
                String srcField = dynamicObject.getString("srcfield");
                long groupCategoryId = dynamicObject.getLong("groupcategory");
                long auxId = dynamicObject.getLong("auxpty");
                BigDecimal weight = dynamicObject.getBigDecimal("weight");
                if (!srcFieldMap.containsKey(groupField) && !CadEmptyUtils.isEmpty((String)srcField)) {
                    srcFieldMap.put(groupField, srcField);
                }
                matGroFieMap.put(matId, groupField);
                if (groupField.equals("bd_auxproperty")) {
                    matCateMap.put(matId + "@" + auxId, weight);
                    continue;
                }
                matCateMap.put(matId + "@" + groupCategoryId, weight);
            }
        }
    }

    public String getInventoryMode(RealTimeCostCalcArgs args) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)args.getOrgId())};
        DynamicObject dyCheckSetting = QueryServiceHelper.queryOne((String)"aca_checksetting", (String)"checktype", (QFilter[])filters);
        return dyCheckSetting != null ? dyCheckSetting.getString("checktype") : "qty";
    }

    public DataSet buildInventoryAllocData(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)args.getOrgId()), new QFilter("costaccount", "=", (Object)args.getCostAccountId()), new QFilter("period", "=", (Object)args.getPeriodId()), new QFilter("costobject", "in", calcCostObjectSet)};
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY_PRE, (String)"aca_terminalwipmatallco", (String)"costobject.costcenter costCenterId,costobject costObjectId,material matId,auxpty,calqty inventValue", (QFilter[])filters, null);
        ds = ds.groupBy(new String[]{"costCenterId", "costObjectId", "matId", "auxpty"}).sum("inventValue").finish();
        return ds;
    }

    public Set<String> getSecondDevGradeField(RealTimeCostCalcArgs args) {
        HashSet<String> set = new HashSet<String>(3);
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("grouptype", "=", (Object)"2");
        filter.and("groupfield", "not in", (Object)Sets.newHashSet((Object[])new String[]{"bd_invtype", "bd_auxproperty"}));
        filter.and("effectdate", "<", (Object)new Date());
        filter.and("expdate", ">=", (Object)new Date());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_productintogroup", (String)"srcfield", (QFilter[])new QFilter[]{filter});
        if (!dynamicObjects.isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill");
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicProperty property;
                String srcField = dynamicObject.getString("srcfield");
                if (CadEmptyUtils.isEmpty((String)srcField) || (property = mainEntityType.getProperty(srcField)) == null) continue;
                set.add(srcField);
            }
        }
        return set;
    }
}

