/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.macc.aca.algox.costcalc.ActCalcTaskType;
import kd.macc.aca.algox.costcalc.ActCostCalcContext;
import kd.macc.aca.algox.costcalc.ActCostCalcResultManager;
import kd.macc.aca.algox.costcalc.action.ActCalcCallCalOutException;
import kd.macc.aca.algox.costcalc.action.IActCalcAction;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeCostCalcResult;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class RealTimeCostCalcEngine {
    private static final Log logger = LogFactory.getLog(RealTimeCostCalcEngine.class);
    private RealTimeCostCalcResult realTimeCostCalcResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealTimeCostCalcResult actRealTimeCalc(RealTimeCostCalcArgs costCalcArgs) {
        ActCostCalcContext context = new ActCostCalcContext();
        context.setRealTimeInputArgs(costCalcArgs);
        context.setTaskType(ActCalcTaskType.RealTimeCalc);
        ActCostCalcResultManager resultManager = new ActCostCalcResultManager();
        long start = System.currentTimeMillis();
        String errorMsg = "";
        String stackTraceErrInfo = "";
        try {
            logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u5f00\u59cb\uff1a");
            RealTimeCostCalcResult result = this.doCalculate(context, resultManager);
            logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u603b\u8017\u65f6\uff1a", (Object)(System.currentTimeMillis() - start));
            RealTimeCostCalcResult realTimeCostCalcResult = result;
            return realTimeCostCalcResult;
        }
        catch (ActCalcCallCalOutException e) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97-\u51fa\u5e93\u6838\u7b97\u63a5\u53e3\u62a5\u9519\uff1a%s", (String)"RealTimeCostCalcEngine_2", (String)"macc-aca-algox", (Object[])new Object[0]), e.getMessage());
            logger.error(errorMsg, (Throwable)((Object)e));
            stackTraceErrInfo = this.wrapExceptionErrorInfo((Exception)((Object)e));
            this.realTimeCostCalcResult = resultManager.getRealTimeResult();
            this.realTimeCostCalcResult.setAllSuccess(false);
            this.realTimeCostCalcResult.setErrorTip(errorMsg);
            RealTimeCostCalcResult realTimeCostCalcResult = this.realTimeCostCalcResult;
            return realTimeCostCalcResult;
        }
        catch (Exception e) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u62a5\u9519\uff1a%s", (String)"RealTimeCostCalcEngine_3", (String)"macc-aca-algox", (Object[])new Object[0]), e.getMessage());
            logger.error(errorMsg, (Throwable)e);
            stackTraceErrInfo = this.wrapExceptionErrorInfo(e);
            this.realTimeCostCalcResult = resultManager.getRealTimeResult();
            this.realTimeCostCalcResult.setAllSuccess(false);
            this.realTimeCostCalcResult.setErrorTip(errorMsg);
            RealTimeCostCalcResult realTimeCostCalcResult = this.realTimeCostCalcResult;
            return realTimeCostCalcResult;
        }
        finally {
            ThreadPools.executeOnce((String)"RealTimeCostCalcEngine.deleteCalcResult", () -> this.deleteCalcResult());
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.REALTIME_CALCULATE, (long)costCalcArgs.getCostAccountId());
            RealTimeCostCalcResult realTimeCostCalcResult = resultManager.getRealTimeResult();
            logger.info("actRealTimeCalc-\u91ca\u653e\u7f51\u63a7");
            this.updateCalcLog(realTimeCostCalcResult, errorMsg, stackTraceErrInfo, costCalcArgs.getType(), System.currentTimeMillis() - start, costCalcArgs.getCalcCostObjectSet());
        }
    }

    private void deleteCalcResult() {
        QFilter filter = new QFilter("org", "=", (Object)999999);
        int x = DeleteServiceHelper.delete((String)"aca_realtimecalcresult", (QFilter[])filter.toArray());
        int r = DeleteServiceHelper.delete((String)"aca_mfgplanfeeresult", (QFilter[])filter.toArray());
        logger.info("\u3010\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u3011\u5df2\u5220\u9664 {} \u6761\u8ba1\u7b97\u7ed3\u679c\u5355\u6807\u8bc6\u7684\u8bb0\u5f55\uff0c{} \u6761\u5236\u9020\u8d39\u7528\u8ba1\u5212\u8d39\u7387\u8ba1\u7b97\u7ed3\u679c\u5355\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)x, (Object)r);
    }

    private void updateCalcLog(RealTimeCostCalcResult realTimeCostCalcResult, String errorMsg, String stackTraceErrInfo, String type, long costTime, Set<Long> costObjectIds) {
        long calLogId = realTimeCostCalcResult.getCalcLogId();
        if (CadEmptyUtils.isEmpty((Long)calLogId)) {
            return;
        }
        DynamicObject calLog = BusinessDataServiceHelper.loadSingle((Object)calLogId, (String)"aca_realtimecalclog", (String)"id,billstatus,calctype,sourceid,sourcebillno,checkdesc,cnsmtime,errorinfo,errorinfo_tag");
        QFilter idQFilter = new QFilter("id", "=", (Object)calLogId);
        idQFilter.and("entryentity.status", "=", (Object)"2");
        boolean isExistsErr = QueryServiceHelper.exists((String)"aca_realtimecalclog", (QFilter[])idQFilter.toArray());
        if (isExistsErr || !CadEmptyUtils.isEmpty((String)errorMsg)) {
            calLog.set("billstatus", (Object)"A");
        } else {
            calLog.set("billstatus", (Object)"B");
        }
        if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
            calLog.set("checkdesc", (Object)StringUtils.substring((String)errorMsg, (int)0, (int)1999));
        }
        if (!CadEmptyUtils.isEmpty((String)stackTraceErrInfo)) {
            calLog.set("errorinfo_tag", (Object)StringUtils.substring((String)stackTraceErrInfo, (int)0, (int)2000000));
        }
        calLog.set("calctype", (Object)type);
        calLog.set("cnsmtime", (Object)(CadEmptyUtils.isEmpty((Long)costTime) ? 0L : costTime / 1000L));
        SaveServiceHelper.update((DynamicObject)calLog);
    }

    private RealTimeCostCalcResult doCalculate(ActCostCalcContext context, ActCostCalcResultManager resultManager) {
        logger.info("context.getTaskType() " + (Object)((Object)context.getTaskType()));
        List<IActCalcAction> actions = IActCalcAction.create(context.getTaskType(), false);
        logger.info("context.getTaskType() " + actions.size());
        for (IActCalcAction action : actions) {
            action.setContext(context);
            action.setResultManager(resultManager);
            logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97doAction\uff1a{}\uff0c\u5f00\u59cb", action.getClass());
            long start = System.currentTimeMillis();
            action.execute();
            logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97doAction\u7ed3\u675f\uff1a{}\uff0c\u7ed3\u675f\uff1a\u8017\u65f6\uff1a{}" + action.getClass(), (Object)(System.currentTimeMillis() - start));
            if (!resultManager.isSkipNextAction()) continue;
            break;
        }
        return resultManager.getRealTimeResult();
    }

    public String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        erroStr.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        return erroStr.toString();
    }
}

