/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeCostCalcDataInputFactory;
import kd.macc.aca.algox.realtime.RealTimeDebugInfoMsgHandler;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.realtime.function.RealTimeCalcGradeFunction;
import kd.macc.aca.algox.realtime.function.RealTimeCalcJoinSideAllocFunction;
import kd.macc.aca.algox.realtime.function.RealTimeCalcJoinSideDetailFunction;
import kd.macc.aca.algox.realtime.function.RealTimeCalcResultSaveFunction;
import kd.macc.aca.algox.realtime.function.RealTimeCarryForwardCalcFunction;
import kd.macc.aca.algox.realtime.function.RealTimeCarryNoMainDetailCalcFunction;
import kd.macc.aca.algox.realtime.function.RealTimeInCalcFunction;
import kd.macc.aca.algox.realtime.function.RealTimeInCostCalcFunction;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.AcaDataSetXLogUtil;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeActCalcAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(RealTimeActCalcAction.class);
    private static final String ALGOKEY_PRE = "RealTimeActCalc-";
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private static final int BATCH_MIN_SIZE = 100;
    private static final String DBPARAM_ACA_CALC_COSTOBJSIZE = "aca_calccostobjsize";
    private static String[] matAllocDataSetGroupByFields = new String[]{"costCenterId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "matUnitPrecision", "subMatId", "subMatVerId", "subMatAuxId", "subResourceId", "subMatUnitPrecision", "elementId", "subElementId", "isMfg", "outsourcetype", "syncauditdate", "srcbillno", "srcbillid", "srcbillentryid", "resource", "rowtype"};

    @Override
    protected void doExecute() {
        RealTimeCostCalcArgs args = this.getContext().getRealTimeInputArgs();
        if (!args.getCalc()) {
            return;
        }
        String logUniqueKey = args.getGetLogUniqueKey();
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
        RealTimeCostCalcDataInputFactory datainputFactory = new RealTimeCostCalcDataInputFactory();
        if (args.getReCalc().booleanValue()) {
            this.clearExpiredCalcResult(args);
        }
        long start = System.currentTimeMillis();
        String inventoryMode = datainputFactory.getInventoryMode(args);
        Map<String, String> proallocstdMap = datainputFactory.buildProallocstdMap(args);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u3011\u8017\u65f6:%s", (String)"RealTimeActCalcAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        Set<String> secFields = datainputFactory.getSecondDevGradeField(args);
        Set<Long> calcCostObjectSet = args.getCalcCostObjectSet();
        int costobjBatsize = this.getCostObjectBatSize();
        this.actLevelBatchCalc(args, calcCostObjectSet, proallocstdMap, inventoryMode, secFields, costobjBatsize);
        this.getResultManager().getRealTimeResult().setSuccessTip(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f%s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"RealTimeActCalcAction_46", (String)"macc-aca-algox", (Object[])new Object[0]), args.getCalcCostObjectSet().size()));
        this.getResultManager().getRealTimeResult().setSuccessSize(args.getCalcCostObjectSet().size());
        this.getResultManager().getRealTimeResult().setAllSuccess(true);
    }

    private void clearExpiredCalcResult(RealTimeCostCalcArgs args) {
        if (args.getOrgId() != 0L && !AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getCostAccountId())) {
            QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
            filter.and("costaccount", "=", (Object)args.getCostAccountId());
            filter.and("period", "=", (Object)args.getPeriodId());
            filter.and("costobject", "in", args.getCalcCostObjectSet());
            HashSet<Long> ids = new HashSet<Long>();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"RealTimeActCalc-calcresult", (String)"aca_realtimecalcresult", (String)"id", (QFilter[])new QFilter[]{filter}, null);
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ids.add(row.getLong(0));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            LogUtils.logInfo(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u5386\u53f2\u8ba1\u7b97\u7ed3\u679c\u5355\uff0c\u5171\u53d6\u51fa\u5355\u636e%1$s\u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a%2$s", (String)"RealTimeActCalcAction_2", (String)"macc-aca-algox", (Object[])new Object[0]), ids.size(), filter.toString()));
            if (!ids.isEmpty()) {
                ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(ids.size());
                for (Long id : ids) {
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
                    paramsList.add(params);
                }
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)"update t_aca_rtcalcresult set forgid = ? where fid = ?", paramsList);
            }
        }
    }

    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> getCalcCompResultMap(DataSet mainJoinSideCostobjectDs, Set<Long> calcCostObjectSet, boolean isReCalc) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)calcCostObjectSet.size());
        for (Row row : mainJoinSideCostobjectDs) {
            Long factcostcenter;
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            Long costobjectId = row.getLong("costObjectId");
            Map detailMap = resultMap.computeIfAbsent(mainCostObjectId, t -> Maps.newHashMapWithExpectedSize((int)10));
            BigDecimal proFinQty = BigDecimalUtil.getOrZero(row.getBigDecimal("proFinQty"));
            RealTimeResultFinalResultVO resultVo = null;
            Long sourcebillentry = row.getLong("sourcebillentry");
            String planBillNo = row.getString("planbillno");
            if (detailMap.containsKey(costobjectId)) {
                resultVo = (RealTimeResultFinalResultVO)detailMap.get(costobjectId);
                resultVo.setProFinQty(proFinQty.add(resultVo.getProFinQty()));
            } else {
                resultVo = new RealTimeResultFinalResultVO();
                detailMap.put(costobjectId, resultVo);
                resultVo.setMatUnitPrecision(row.getInteger("matunitprecision"));
                resultVo.setProductType(row.getString("producttype"));
                resultVo.setProductgroupId(row.getLong("productgroup"));
                resultVo.setOutsource(row.getBoolean("isoutsource"));
                resultVo.setMatId(row.getLong("material"));
                resultVo.setMatVerId(row.getLong("matversion"));
                resultVo.setMatAuxId(row.getLong("auxpty"));
                resultVo.setCloseStatus(row.getBoolean("closestatus"));
                resultVo.setProPlanQty(BigDecimalUtil.getOrZero(row.getBigDecimal("proPlanQty")));
                resultVo.setProFinQty(proFinQty);
                resultVo.setWeight(row.getBigDecimal("weight"));
                resultVo.setPdStartQty(BigDecimalUtil.getOrZero(row.getBigDecimal("pdStartQty")));
                resultVo.setPdStartAmt(BigDecimalUtil.getOrZero(row.getBigDecimal("pdStartAmt")));
                if (!isReCalc) {
                    resultVo.setPdEndQty(BigDecimalUtil.getOrZero(row.getBigDecimal("pdEndQty")));
                    resultVo.setPdEndAmt(BigDecimalUtil.getOrZero(row.getBigDecimal("pdEndAmt")));
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)sourcebillentry)) {
                resultVo.getPlanSourceBillEntryIds().add(sourcebillentry);
                resultVo.getPlanSourceBillMap().put(sourcebillentry, planBillNo);
            }
            if (CadEmptyUtils.isEmpty((Long)(factcostcenter = row.getLong("factedCostCenterId")))) continue;
            if (resultVo.getCostcenterFinQtyMap() == null) {
                resultVo.setCostcenterFinQtyMap(Maps.newHashMapWithExpectedSize((int)2));
            }
            BigDecimal csProFinQty = BigDecimal.ZERO;
            if (resultVo.getCostcenterFinQtyMap().containsKey(factcostcenter)) {
                csProFinQty = resultVo.getCostcenterFinQtyMap().get(factcostcenter);
            }
            resultVo.getCostcenterFinQtyMap().put(factcostcenter, csProFinQty.add(proFinQty));
        }
        for (Map.Entry mainObjIdResultVoMap : resultMap.entrySet()) {
            Long mainObjId;
            Map mainJoinSideResMap = (Map)mainObjIdResultVoMap.getValue();
            RealTimeResultFinalResultVO mainResultVo = (RealTimeResultFinalResultVO)mainJoinSideResMap.get(mainObjId = (Long)mainObjIdResultVoMap.getKey());
            if (mainResultVo == null || !mainResultVo.getCloseStatus().booleanValue() || mainResultVo.getPdEndCheckQty() != null) continue;
            for (Map.Entry objIdResMap : mainJoinSideResMap.entrySet()) {
                RealTimeResultFinalResultVO resultVo = (RealTimeResultFinalResultVO)objIdResMap.getValue();
                if (resultVo.getPdEndCheckQty() != null) continue;
                resultVo.setPdEndCheckQty(BigDecimal.ZERO);
            }
        }
        return resultMap;
    }

    private void actLevelBatchCalc(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet, Map<String, String> proallocstdMap, String inventoryMode, Set<String> secFields, int costobjBatsize) {
        LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f00\u59cb\uff0c\u6210\u672c\u5bf9\u8c61\u6570\u91cf\uff1a%s", (String)"RealTimeActCalcAction_3", (String)"macc-aca-algox", (Object[])new Object[0]), calcCostObjectSet.size()));
        if (calcCostObjectSet.size() > costobjBatsize) {
            List splitLists = Lists.partition(new ArrayList<Long>(calcCostObjectSet), (int)costobjBatsize);
            LogUtils.logInfo(args.getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f00\u59cb\uff0c\u5171%1$s\u4e2a\u6210\u672c\u5bf9\u8c61\u6570\u91cf\uff0c\u6bcf\u6279%2$s\u4e2a\uff0c\u5171%3$s\u6279\u3002", (String)"RealTimeActCalcAction_50", (String)"macc-aca-algox", (Object[])new Object[0]), calcCostObjectSet.size(), costobjBatsize, splitLists.size()));
            for (List list : splitLists) {
                this.actLevelCalc(args, new HashSet<Long>(list), proallocstdMap, inventoryMode, secFields);
            }
        } else {
            this.actLevelCalc(args, calcCostObjectSet, proallocstdMap, inventoryMode, secFields);
        }
    }

    private void actLevelCalc(RealTimeCostCalcArgs args, Set<Long> calcCostObjectSet, Map<String, String> proallocstdMap, String inventoryMode, Set<String> secFields) {
        if (CollectionUtils.isEmpty(calcCostObjectSet)) {
            return;
        }
        boolean isReCalc = args.getReCalc();
        String logUniqueKey = args.getGetLogUniqueKey();
        RealTimeDebugInfoMsgHandler msgHander = new RealTimeDebugInfoMsgHandler(this.getResultManager().buildRealTimeResult().getCalcLogId());
        RealTimeCostCalcDataInputFactory datainputFactory = new RealTimeCostCalcDataInputFactory();
        DataSet mainJoinSideCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(args.getOrgId(), calcCostObjectSet, new String[]{"C", "A", "B"});
        Set<Long> calcMainJoinSideCostObjectSet = datainputFactory.getLongIdSetFromDs(mainJoinSideCostobjectDs, "costObjectId", true);
        boolean isContainsJoinSide = false;
        if (calcCostObjectSet.size() < calcMainJoinSideCostObjectSet.size()) {
            isContainsJoinSide = true;
        }
        DataSet mainJoinCostobjectCopyDs = null;
        Set<Long> assemblyCostCenterSet = args.getAssemblyCostCenterSet();
        if (!assemblyCostCenterSet.isEmpty()) {
            if (assemblyCostCenterSet.contains(0L)) {
                mainJoinCostobjectCopyDs = mainJoinSideCostobjectDs.copy().filter("producttype in('C','A')");
            } else {
                StringBuilder sb = new StringBuilder();
                for (Long costcenter : assemblyCostCenterSet) {
                    sb.append(costcenter).append(",");
                }
                mainJoinCostobjectCopyDs = mainJoinSideCostobjectDs.copy().filter("mainCostCenterId in(" + sb.toString().substring(0, sb.length() - 1) + ") and producttype in('C','A')");
            }
        }
        DataSet bomMainJoinCostObjectDs = null;
        Set<Long> bomCostCenterSet = args.getBomCostCenterSet();
        if (!bomCostCenterSet.isEmpty()) {
            if (bomCostCenterSet.contains(0L)) {
                bomMainJoinCostObjectDs = mainJoinSideCostobjectDs.copy().filter("producttype in('C','A')");
            } else {
                StringBuilder sb = new StringBuilder();
                for (Long costcenter : bomCostCenterSet) {
                    sb.append(costcenter).append(",");
                }
                bomMainJoinCostObjectDs = mainJoinSideCostobjectDs.copy().filter("mainCostCenterId in(" + sb.substring(0, sb.length() - 1) + ") and producttype in('C','A')");
            }
        }
        DataSet calcResultSourceIdDs = datainputFactory.buildCalcResultSourceIdDataSet(args, calcMainJoinSideCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_5", (String)"macc-aca-algox", (Object[])new Object[0]));
        long start = System.currentTimeMillis();
        DataSet plannedDataSet = datainputFactory.buildPlannedoutputDataSet(args, calcMainJoinSideCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_6", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_8", (String)"macc-aca-algox", (Object[])new Object[0]));
        start = System.currentTimeMillis();
        DataSet factnedDataSet = datainputFactory.buildFactnedoutputDataSet(args, calcMainJoinSideCostObjectSet, secFields);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_9", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        if (!isReCalc) {
            plannedDataSet = plannedDataSet.leftJoin(calcResultSourceIdDs).on("costObjectId", "costObjectId").on("sourcebillentry", "plansrcbillentry").select(plannedDataSet.getRowMeta().getFieldNames(), new String[]{"plansrcbillentry"}).finish();
            plannedDataSet = plannedDataSet.filter("plansrcbillentry is null or plansrcbillentry = 0").distinct();
            factnedDataSet = factnedDataSet.leftJoin(calcResultSourceIdDs).on("costObjectId", "costObjectId").on("srcEntryId", "sourcebillentry").select(factnedDataSet.getRowMeta().getFieldNames(), new String[]{"sourcebillentry"}).finish();
            factnedDataSet = factnedDataSet.filter("sourcebillentry is null or sourcebillentry = 0").distinct();
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(factnedDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_10", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        DataSet origPlannedDataSet = plannedDataSet.copy();
        plannedDataSet = plannedDataSet.groupBy(new String[]{"costCenterId", "costObjectId"}).sum("proPlanQty").sum("proFinQty").finish();
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(plannedDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s::\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_7", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_11", (String)"macc-aca-algox", (Object[])new Object[0]), new Object[0]));
        start = System.currentTimeMillis();
        DataSet preFinalDataSet = datainputFactory.buildFinalPreCalcResultDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u8ba1\u7b97\u7ed3\u679c\u5355-\u6700\u7ec8\u7ed3\u679c\u9879\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_12", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        if (!isReCalc) {
            DataSet finalDataSet = datainputFactory.buildFinalCalcResultDataSet(args, calcCostObjectSet);
            mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(finalDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdEndQty", "pdEndAmt"}).finish();
        }
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(plannedDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"proPlanQty"}).finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(origPlannedDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"sourcebillentry", "planbillno"}).finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(preFinalDataSet).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"pdStartQty", "pdStartAmt"}).finish();
        DataSet factnedCostobjectDs = factnedDataSet.copy().groupBy(new String[]{"factedCostCenterId", "costObjectId"}).sum("proFinQty").finish();
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(factnedCostobjectDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"factedCostCenterId", "proFinQty"}).finish();
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(mainJoinSideCostobjectDs, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u671f\u672b\u5728\u4ea7\u54c1\u76d8\u70b9\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_13", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        DataSet closeStatusDs = datainputFactory.buildCloseStatus(args, calcMainJoinSideCostObjectSet);
        mainJoinSideCostobjectDs = mainJoinSideCostobjectDs.leftJoin(closeStatusDs).on("costObjectId", "costObjectId").select(mainJoinSideCostobjectDs.getRowMeta().getFieldNames(), new String[]{"closestatus"}).finish();
        Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap = this.getCalcCompResultMap(mainJoinSideCostobjectDs, calcCostObjectSet, isReCalc);
        this.printDebugCostObjectInfo(args, calcCostobjectFinalResultMap, msgHander);
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u6750\u6599\u8017\u7528\u5206\u914d\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_14", (String)"macc-aca-algox", (Object[])new Object[0]));
        start = System.currentTimeMillis();
        DataSet matAllocDataSet = datainputFactory.buildMaterialAllocDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u6750\u6599\u8017\u7528\u5206\u914d\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_15", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(matAllocDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u6750\u6599\u8017\u7528\u5f52\u96c6\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_16", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_17", (String)"macc-aca-algox", (Object[])new Object[0]));
        start = System.currentTimeMillis();
        DataSet mfgAllocDataSet = datainputFactory.buildMfgFeeAllocDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u5236\u9020\u8d39\u7528\u5206\u914d\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_18", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u660e\u7ec6\u9879\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_47", (String)"macc-aca-algox", (Object[])new Object[0]), new Object[0]));
        start = System.currentTimeMillis();
        DataSet preDetailDataSet = datainputFactory.buildDetailPreCalcResultDataSet(args, calcCostObjectSet);
        LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355-\u660e\u7ec6\u9879\u3011\u7ed3\u675f%s", (String)"RealTimeActCalcAction_48", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        if (!isReCalc) {
            DataSet costObjectDs = datainputFactory.buildCalcResultCostObjectDataSet(args, calcCostObjectSet);
            preDetailDataSet = preDetailDataSet.leftJoin(costObjectDs).on("costObjectId", "pdcostObjectId").select(preDetailDataSet.getRowMeta().getFieldNames(), new String[]{"pdcostObjectId"}).finish();
            preDetailDataSet = preDetailDataSet.filter("pdcostObjectId is null or pdcostObjectId = 0");
            preDetailDataSet = preDetailDataSet.removeFields(new String[]{"pdcostObjectId"});
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(preDetailDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u671f\u521d\u660e\u7ec6\u9879\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_49", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(mfgAllocDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u5236\u9020\u8d39\u7528\u5f52\u96c6\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_19", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        if (!isReCalc) {
            matAllocDataSet = matAllocDataSet.leftJoin(calcResultSourceIdDs).on("costObjectId", "costObjectId").on("srcbillentryid", "srcbillentry").select(matAllocDataSet.getRowMeta().getFieldNames(), new String[]{"srcbillentry"}).finish();
            matAllocDataSet = matAllocDataSet.filter("srcbillentry is null or srcbillentry = 0").distinct();
            mfgAllocDataSet = mfgAllocDataSet.leftJoin(calcResultSourceIdDs).on("costObjectId", "costObjectId").on("srcbillentryid", "srcbillentry").select(mfgAllocDataSet.getRowMeta().getFieldNames(), new String[]{"srcbillentry"}).finish();
            mfgAllocDataSet = mfgAllocDataSet.filter("srcbillentry is null or srcbillentry = 0").distinct();
        }
        HashSet sideProductIds = Sets.newHashSetWithExpectedSize((int)20);
        HashSet productGroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet gradeGroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet factnedMainJoinEntryIds = Sets.newHashSetWithExpectedSize((int)16);
        DataSet tmpFactnedDataSet = factnedDataSet.copy();
        this.getFactProductInfo(args, tmpFactnedDataSet, sideProductIds, productGroupIds, gradeGroupIds, factnedMainJoinEntryIds);
        Map<String, BigDecimal> equivalentMap = datainputFactory.getEquivalentMap(args, calcCostObjectSet, msgHander);
        HashMap weightMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap allocTypeMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!productGroupIds.isEmpty()) {
            datainputFactory.buildMainJoinGroupMap(args, productGroupIds, weightMap, allocTypeMap);
        }
        Map<Object, Object> proextraPriceMap = null;
        proextraPriceMap = !sideProductIds.isEmpty() ? datainputFactory.buildProextraPriceDataSet(args, sideProductIds) : Maps.newHashMapWithExpectedSize((int)1);
        JobSession session = AlgoX.createSession((String)"RealTimeActCalc-levelCalc");
        DataSetX preDetailDataSetX = session.fromInput((Input)new DataSetInput(preDetailDataSet));
        DataSetX matAllocDataSetX = session.fromInput((Input)new DataSetInput(matAllocDataSet));
        DataSetX mfgAllocDataSetX = session.fromInput((Input)new DataSetInput(mfgAllocDataSet));
        DataSetX detailDataSetX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(matAllocDataSetX, mfgAllocDataSetX);
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("pdStartQty", (DataType)DataType.BigDecimalType), new Field("pdStartAmt", (DataType)DataType.BigDecimalType), new Field("finQty", (DataType)DataType.BigDecimalType), new Field("finAmt", (DataType)DataType.BigDecimalType), new Field("inQty", (DataType)DataType.BigDecimalType), new Field("inAmt", (DataType)DataType.BigDecimalType), new Field("rowtype", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "0"});
        detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, preDetailDataSetX);
        if (!isReCalc) {
            DataSet finalDetailDataSet = datainputFactory.buildFinalCalcResultDetailDataSet(args, calcCostObjectSet);
            DataSetX finalDetailDataSetX = session.fromInput((Input)new DataSetInput(finalDetailDataSet));
            detailDataSetX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(detailDataSetX, finalDetailDataSetX);
        }
        detailDataSetX = detailDataSetX.groupBy(matAllocDataSetGroupByFields).sum("pdStartQty").sum("pdStartAmt").sum("qty").sum("amount").sum("finQty").sum("finAmt").sum("inQty").sum("inAmt");
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u8d39\u7528\u6570\u636edataSetX\uff1a", (String)"RealTimeActCalcAction_20", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        detailDataSetX = this.unionAddAssemblyCostDs(args, datainputFactory, mainJoinCostobjectCopyDs, session, detailDataSetX, msgHander);
        detailDataSetX = this.unionAddBomCostDs(args, datainputFactory, bomMainJoinCostObjectDs, session, detailDataSetX, msgHander);
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new RealTimeCarryForwardCalcFunction(detailDataSetX.getRowMeta(), args, calcCostobjectFinalResultMap));
        if (!StringUtils.isEmpty((String)inventoryMode)) {
            DataSet inventoryAllocDataSet = datainputFactory.buildInventoryAllocData(args, calcCostObjectSet);
            DataSetX inventoryAllocDataSetX = session.fromInput((Input)new DataSetInput(inventoryAllocDataSet));
            detailDataSetX = detailDataSetX.leftJoin(inventoryAllocDataSetX).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").on("subMatId", "matId").on("subMatAuxId", "auxpty").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"inventValue"});
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("mainCostObjectId", (DataType)DataType.LongType), new Field("calcAmt", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO});
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new RealTimeInCostCalcFunction(detailDataSetX.getRowMeta(), args, proallocstdMap, equivalentMap, calcCostobjectFinalResultMap, allocTypeMap, weightMap, inventoryMode, msgHander));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u6210\u672c\u5bf9\u8c61\u5165\u5e93\u6210\u672c\u8ba1\u7b97\u540edataSetX\uff1a", (String)"RealTimeActCalcAction_21", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("finTempQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "costObjectId"}).reduceGroup((GroupReduceFunction)new RealTimeCalcJoinSideAllocFunction(detailDataSetX.getRowMeta(), args, proextraPriceMap, calcCostobjectFinalResultMap, allocTypeMap, weightMap, msgHander));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u6210\u672c\u5bf9\u8c61\u4e3b\u8054\u526f\u5206\u644a\u540edataSetX\uff1a", (String)"RealTimeActCalcAction_22", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        if (isContainsJoinSide) {
            detailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId"}).reduceGroup((GroupReduceFunction)new RealTimeCarryNoMainDetailCalcFunction(detailDataSetX.getRowMeta(), calcCostobjectFinalResultMap));
        }
        DataSetX calcResultDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId"}).reduceGroup((GroupReduceFunction)new RealTimeCalcResultSaveFunction(detailDataSetX.getRowMeta(), args, calcCostobjectFinalResultMap));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcResultDataSetX = AcaDataSetXLogUtil.logDataSetX(calcResultDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5355\u540edataSetX\uff1a", (String)"RealTimeActCalcAction_25", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        DataSetX calcSubElementCostDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "outsourcetype"}).sum("finAmt").sum("calcAmt");
        calcSubElementCostDataSetX = calcSubElementCostDataSetX.addFields(new Field[]{new Field("carrytype", (DataType)DataType.StringType)}, new Object[]{"A"});
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcSubElementCostDataSetX = AcaDataSetXLogUtil.logDataSetX(calcSubElementCostDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u6c47\u603b\u5b50\u8981\u7d20\u6210\u672cdataSetX\uff1a", (String)"RealTimeActCalcAction_26", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        DataSetX factnedDataSetX = session.fromInput((Input)new DataSetInput(factnedDataSet));
        String selectField = "srcBillId,srcEntryId,proFinQty,factedCostCenterId,auxpty,invtype";
        if (secFields != null && !secFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (String secField : secFields) {
                joiner.add(secField);
            }
            String field = joiner.toString();
            selectField = selectField + "," + field;
        }
        JoinDataSetX calcDataSetX = calcSubElementCostDataSetX.join(factnedDataSetX).on("costObjectId", "costObjectId").select(calcSubElementCostDataSetX.getRowMeta().getFieldNames(), selectField.split(","));
        calcDataSetX = calcDataSetX.filter("srcEntryId>0");
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)calcDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u5b50\u8981\u7d20\u6210\u672c\u5173\u8054\u5b8c\u5de5\u5165\u5e93\u5355dataSetX\uff1a", (String)"RealTimeActCalcAction_27", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        calcDataSetX = calcDataSetX.addFields(new Field[]{new Field("cost", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        calcDataSetX = calcDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "outsourcetype", "carrytype"}).reduceGroup((GroupReduceFunction)new RealTimeInCalcFunction(calcDataSetX.getRowMeta(), args, proextraPriceMap, calcCostobjectFinalResultMap));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)calcDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u8ba1\u7b97\u5b8c\u5de5\u5165\u5e93\u5355\u7684\u5b50\u8981\u7d20\u6210\u672cdataSetX\uff1a", (String)"RealTimeActCalcAction_28", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        calcDataSetX = calcDataSetX.addFields(new Field[]{new Field("groupfield", (DataType)DataType.StringType), new Field("groupcategoryid", (DataType)DataType.LongType)}, new Object[]{"", 0L});
        if (!gradeGroupIds.isEmpty()) {
            calcDataSetX = this.gradeProductProcess(args, datainputFactory, gradeGroupIds, (DataSetX)calcDataSetX, factnedDataSetX, msgHander);
        }
        DataSetX convSubDetailDataSetX = null;
        if (args.getConversionsubdetail()) {
            DataSetX calcDetailDataSetX = detailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "productType", "groupId", "mftOrderNo", "matId", "matVerId", "matAuxId", "elementId", "subElementId", "subMatId", "subMatVerId", "subMatAuxId", "subResourceId", "subMatUnitPrecision", "outsourcetype"}).sum("finQty").sum("finAmt").sum("calcAmt");
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                calcDetailDataSetX = AcaDataSetXLogUtil.logDataSetX(calcDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u7f13\u5b58\u7b2c1\u9875\u7b7e\u6570\u636edataSetX\uff1a", (String)"RealTimeActCalcAction_29", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
            }
            convSubDetailDataSetX = this.conversionSubDetailProcess(args, datainputFactory, session, (DataSetX)calcDataSetX, calcDetailDataSetX, msgHander);
        }
        DataSetOutput resultSet = new DataSetOutput(calcDataSetX.getRowMeta());
        String resultId = resultSet.getId();
        calcDataSetX.output((Output)resultSet);
        DataSetOutput convSubDetailResultSet = null;
        if (args.getConversionsubdetail() && convSubDetailDataSetX != null) {
            convSubDetailResultSet = new DataSetOutput(convSubDetailDataSetX.getRowMeta());
            convSubDetailDataSetX.output((Output)convSubDetailResultSet);
        }
        calcResultDataSetX.output((Output)new IgnoreOutput());
        try {
            LogUtils.logInfo(logUniqueKey, logger, ResManager.loadKDString((String)"\u3010\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97-algox\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_30", (String)"macc-aca-algox", (Object[])new Object[0]));
            start = System.currentTimeMillis();
            session.commit(10, TimeUnit.HOURS);
            LogUtils.logInfo(logUniqueKey, logger, String.format(ResManager.loadKDString((String)"\u3010\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97-algox\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%s", (String)"RealTimeActCalcAction_31", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        DataSet calcInDataSet = session.readDataSet(resultId);
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            AcaDataSetXLogUtil.logDataSet(calcInDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u5165\u5e93\u6838\u7b97\u7684\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_32", (String)"macc-aca-algox", (Object[])new Object[0]), logUniqueKey), msgHander);
        }
        Map<String, DynamicObject> calcResultMap = datainputFactory.buildCalcResultIdMap(args, calcCostObjectSet);
        HashSet hasUpdateFactedEntryIds = Sets.newHashSetWithExpectedSize((int)10);
        Map<String, Object> paramResult = datainputFactory.buildCalcInCostParam(args, calcInDataSet.copy(), calcResultMap, hasUpdateFactedEntryIds);
        if (args.getConversionsubdetail() && convSubDetailResultSet != null) {
            datainputFactory.buildCalcConversionDetail(session.readDataSet(convSubDetailResultSet.getId()), calcResultMap);
        }
        List calcParamList = (List)paramResult.get("calcParamList");
        boolean isnegUnitPrice = this.negUnitPriceDeal(args, datainputFactory, calcInDataSet, msgHander);
        if (isnegUnitPrice) {
            return;
        }
        this.calculatCostRecordCostUpdateService(calcParamList);
        this.factedZeroCostRecordUpdateService(args, datainputFactory, factnedMainJoinEntryIds, hasUpdateFactedEntryIds);
    }

    private DataSetX unionAddAssemblyCostDs(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, DataSet mainJoinCostobjectCopyDs, JobSession session, DataSetX detailDataSetX, RealTimeDebugInfoMsgHandler msgHander) {
        DataSet assemblyDataSet;
        boolean isAddStockField = true;
        if (!args.getAssemblyCostCenterSet().isEmpty() && (assemblyDataSet = datainputFactory.buildAssemblyDataSet(args, mainJoinCostobjectCopyDs)) != null) {
            isAddStockField = false;
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(assemblyDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_33", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
            }
            DataSetX assemblyDataSetX = session.fromInput((Input)new DataSetInput(assemblyDataSet));
            detailDataSetX = detailDataSetX.leftJoin(assemblyDataSetX).on("costObjectId", "costObjectId").on("subMatId", "subMaterialId").on("subMatAuxId", "subauxpty").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"stockqty", "useqty"});
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_33", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
            }
        }
        if (isAddStockField) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("stockqty", (DataType)DataType.BigDecimalType), new Field("useqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        }
        return detailDataSetX;
    }

    private DataSetX unionAddBomCostDs(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, DataSet bomMainJoinCostObjectDs, JobSession session, DataSetX detailDataSetX, RealTimeDebugInfoMsgHandler msgHander) {
        DataSet bomDataSet;
        boolean addBomField = true;
        if (!args.getBomCostCenterSet().isEmpty() && (bomDataSet = datainputFactory.buildBomSettingDataSet(args, bomMainJoinCostObjectDs)) != null && !bomDataSet.isEmpty()) {
            addBomField = false;
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                AcaDataSetXLogUtil.logDataSet(bomDataSet, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:Bom\u8bbe\u7f6e\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_34", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
            }
            DataSetX bomDataSetX = session.fromInput((Input)new DataSetInput(bomDataSet));
            detailDataSetX = detailDataSetX.leftJoin(bomDataSetX).on("costObjectId", "costObjectId").on("subMatId", "subMaterialId").on("subMatAuxId", "subauxpty").on("subElementId", "subelement").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"unitQty"});
            if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
                detailDataSetX = AcaDataSetXLogUtil.logDataSetX(detailDataSetX, args.getDebugColName(), args.getDebugColVal(), String.format(ResManager.loadKDString((String)"%s:Bom\u8bbe\u7f6e\u6570\u636e\uff1a", (String)"RealTimeActCalcAction_34", (String)"macc-aca-algox", (Object[])new Object[0]), args.getGetLogUniqueKey()), msgHander);
            }
        }
        if (addBomField) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("unitQty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        }
        return detailDataSetX;
    }

    private void getFactProductInfo(RealTimeCostCalcArgs args, DataSet tmpFactnedDataSet, Set<Long> sideProductIds, Set<Long> productGroupIds, Set<Long> gradeGroupIds, Set<Long> factnedMainJoinEntryIds) {
        for (Row row : tmpFactnedDataSet) {
            String productType = row.getString("productType");
            Long matId = row.getLong("matId");
            if ("B".equals(productType)) {
                sideProductIds.add(matId);
            }
            factnedMainJoinEntryIds.add(row.getLong("srcEntryId"));
            productGroupIds.add(row.getLong("groupId"));
            Long gradeProdGroup = row.getLong("gradeprodgroup");
            if (CadEmptyUtils.isEmpty((Long)gradeProdGroup)) continue;
            gradeGroupIds.add(gradeProdGroup);
        }
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u526f\u4ea7\u54c1ID\u5408\u8ba1:", (String)"RealTimeActCalcAction_35", (String)"macc-aca-algox", (Object[])new Object[0]), sideProductIds);
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4ID\u5408\u8ba1:", (String)"RealTimeActCalcAction_36", (String)"macc-aca-algox", (Object[])new Object[0]), productGroupIds);
            LogUtils.logInfoIdColl(args.getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u7b49\u7ea7\u54c1\u4ea7\u54c1\u7ec4ID\u5408\u8ba1:", (String)"RealTimeActCalcAction_37", (String)"macc-aca-algox", (Object[])new Object[0]), gradeGroupIds);
        }
    }

    private void printDebugCostObjectInfo(RealTimeCostCalcArgs args, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap, RealTimeDebugInfoMsgHandler msgHander) {
        if (StringUtils.isNotEmpty((String)args.getDebugColVal()) && ("costObjectId".equals(args.getDebugColName()) || "mainCostObjectId".equals(args.getDebugColName()))) {
            try {
                Long costobjectId = Long.valueOf(args.getDebugColVal());
                Map<Long, RealTimeResultFinalResultVO> detailsMap = calcCostobjectFinalResultMap.get(costobjectId);
                if (detailsMap != null && msgHander != null) {
                    msgHander.dealInfoMsg("\r\nAcaResultFinalResult-" + detailsMap);
                }
            }
            catch (Exception ex) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25", (Throwable)ex);
                logger.info("\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97-long\u7c7b\u578b\u8f6c\u6362\u95ee\u9898\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
            }
        }
    }

    private void factedZeroCostRecordUpdateService(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, Set<Long> factnedMainJoinEntryIds, Set<Long> hasUpdateFactedEntryIds) {
        RealTimeActCalcAction.setDefaultElementId(args);
        if (args.getDefaultSubElementId() == 0L) {
            return;
        }
        factnedMainJoinEntryIds.removeAll(hasUpdateFactedEntryIds);
        if (factnedMainJoinEntryIds.isEmpty()) {
            return;
        }
        DataSet factedDs = datainputFactory.buildFactnedoutputInEntryIdDs(args, factnedMainJoinEntryIds);
        DataSet sideFactedDs = factedDs.copy().filter("productType='B'").groupBy(new String[]{"costObjectId"}).sum("proFinQty").finish().filter("proFinQty<>0");
        if (!sideFactedDs.isEmpty()) {
            HashSet errCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Object row : sideFactedDs) {
                errCostObjectIds.add(row.getLong("costObjectId"));
            }
            Map<Long, Set<String>> costcenterCostobjectMap = datainputFactory.buildCostObjectNumberSet(errCostObjectIds);
            if (!costcenterCostobjectMap.isEmpty()) {
                for (Map.Entry entry : costcenterCostobjectMap.entrySet()) {
                    ArrayList<String> errorInfos = new ArrayList<String>(10);
                    for (String costobjectNum : (Set)entry.getValue()) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u526f\u4ea7\u54c1\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%s\uff0c\u6709\u5b8c\u5de5\u5165\u5e93\u5355\uff0c\u65e0\u6295\u5165\u8d39\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u6210\u672c\u66f4\u65b0\u3002", (String)"RealTimeActCalcAction_38", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectNum);
                        errorInfos.add(errorMsg);
                    }
                    RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), (Long)entry.getKey(), errorInfos, "2");
                }
            }
            factedDs.close();
            return;
        }
        String insertSql = "insert into t_aca_rtresultinventry(fid,fentryid,fsourcebillid,fsourcebillentryid,finvcostobjectid,finvproducttype,finventorysubeleid,finventoryqty,finventoryamount) values(?,?,?,?,?,?,?,?,?)";
        String msgFormat = ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u201c%s\u201d\uff0c\u672a\u8fdb\u884c\u5165\u5e93\u6210\u672c\u66f4\u65b0\uff0c\u8fdb\u884c\u96f6\u6210\u672c\u5165\u5e93\u3002", (String)"RealTimeActCalcAction_39", (String)"macc-aca-algox", (Object[])new Object[0]);
        factedDs = factedDs.filter("productType<>'B'");
        Set<Long> calcobjectSet = datainputFactory.getLongIdSetFromDs(factedDs, "costObjectId", true);
        Map<Long, Long> map = datainputFactory.buildCostobjectResultIdMap(args, calcobjectSet);
        HashMap listMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<Object[]> entryIds = new ArrayList<Object[]>();
        HashMap errorInfos = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : factedDs) {
            Long entryId = row.getLong("srcEntryId");
            Long costObjectId = row.getLong("costObjectId");
            Long costcenter = row.getLong("costcenter");
            String costOjbectName = row.getString("costObjectName");
            HashMap map2 = Maps.newHashMapWithExpectedSize((int)16);
            map2.put("outsourcetype", "");
            map2.put("costsubelement", args.getDefaultSubElementId());
            map2.put("cost", BigDecimal.ZERO);
            ArrayList list = Lists.newArrayList();
            list.add(map2);
            listMap.put(entryId, list);
            Long calcResultId = map.get(costObjectId);
            if (calcResultId != null) {
                entryIds.add(new Object[]{calcResultId, ID.genLongId(), row.getLong("srcBillId"), entryId, costObjectId, row.getString("productType"), args.getDefaultSubElementId(), row.getBigDecimal("proFinQty"), BigDecimal.ZERO});
            }
            Set errorInfo = errorInfos.computeIfAbsent(costcenter, t -> Sets.newHashSetWithExpectedSize((int)5));
            errorInfo.add(String.format(msgFormat, costOjbectName));
        }
        ArrayList calcParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mapEntry : listMap.entrySet()) {
            Long srcEntryId = (Long)mapEntry.getKey();
            List list = (List)mapEntry.getValue();
            HashMap map3 = Maps.newHashMapWithExpectedSize((int)16);
            map3.put("costaccount", args.getCostAccountId());
            map3.put("bizbillentryid", srcEntryId);
            map3.put("costinfo", list);
            calcParamList.add(map3);
        }
        this.calculatCostRecordCostUpdateService(calcParamList);
        ActCalcHelper.doExecuteBatch(entryIds, new DBRoute("cal"), insertSql);
        for (Map.Entry entry : errorInfos.entrySet()) {
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), (Long)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), "1");
        }
    }

    public static void setDefaultElementId(RealTimeCostCalcArgs args) {
        if (CadEmptyUtils.isEmpty((Long)args.getDefaultSubElementId())) {
            QFilter eleFilter = new QFilter("type", "=", (Object)"001");
            eleFilter.and("defaultvalue", "=", (Object)Boolean.TRUE);
            DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"cad_subelement", (String)"id", (QFilter[])eleFilter.toArray());
            if (dyo != null && dyo.length > 0) {
                args.setDefaultSubElementId(dyo[0].getLong("id"));
            }
        }
    }

    private boolean negUnitPriceDeal(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, DataSet calcInDataSet, RealTimeDebugInfoMsgHandler msgHander) {
        Map<Long, Set<String>> tipInfoMap;
        DataSet calcPriceDataSet = calcInDataSet.groupBy(new String[]{"srcBillId", "srcEntryId", "costCenterId", "costObjectId", "mainCostObjectId", "groupcategoryid"}).max("proFinQty").sum("cost").finish().addField("cost/proFinQty", "unitPrice");
        DataSet calcZeroCostDataSet = calcPriceDataSet.copy().filter("cost=0 and groupcategoryid=0");
        if ((calcPriceDataSet = calcPriceDataSet.filter("unitPrice<0")).isEmpty()) {
            return false;
        }
        Map<Long, Set<String>> errorInfoMap = this.buildCalcFactTip(args, datainputFactory, calcPriceDataSet, ResManager.loadKDString((String)"\u5165\u5e93\u6210\u672c\u4e3a\u8d1f\u5355\u4ef7\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u6570\u636e\u3002", (String)"RealTimeActCalcAction_40", (String)"macc-aca-algox", (Object[])new Object[0]));
        if (!calcZeroCostDataSet.isEmpty() && !CadEmptyUtils.isEmpty(tipInfoMap = this.buildCalcFactTip(args, datainputFactory, calcZeroCostDataSet, ResManager.loadKDString((String)"\u5165\u5e93\u6210\u672c\u4e3a\u96f6\u6210\u672c\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u6570\u636e\u3002", (String)"RealTimeActCalcAction_41", (String)"macc-aca-algox", (Object[])new Object[0])))) {
            for (Map.Entry<Long, Set<String>> entry : tipInfoMap.entrySet()) {
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), "1");
            }
        }
        if (!CadEmptyUtils.isEmpty(errorInfoMap)) {
            for (Map.Entry<Long, Set<String>> entry : errorInfoMap.entrySet()) {
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(args.getCalcLogId(), entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
            }
            return true;
        }
        return false;
    }

    private Map<Long, Set<String>> buildCalcFactTip(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, DataSet ds, String tip) {
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet srcEntryIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap costobjectEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap costobjectCenterMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : ds) {
            Long costObjectId = row.getLong("costObjectId");
            Long costCenterId = row.getLong("costCenterId");
            costobjectIds.add(costObjectId);
            srcEntryIds.add(row.getLong("srcEntryId"));
            costobjectEntryIdMap.computeIfAbsent(costObjectId, t -> new HashSet(16)).add(row.getLong("srcEntryId"));
            costobjectCenterMap.put(costObjectId, costCenterId);
        }
        Map<Long, String> costobjectNumberMap = datainputFactory.buildCostObjectNameMap(costobjectIds);
        Map<Long, String> entryNumberMap = datainputFactory.buildFactEntryNumberMap(args, srcEntryIds);
        HashMap errorInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : costobjectEntryIdMap.entrySet()) {
            Set entryIdSet = (Set)entry.getValue();
            StringBuilder factSb = new StringBuilder();
            for (Long srcEntryId : entryIdSet) {
                factSb.append("\u3010").append(entryNumberMap.get(srcEntryId)).append("\u3011").append(",");
            }
            Long costcenterId = (Long)costobjectCenterMap.get(entry.getKey());
            if (costcenterId == null) {
                costcenterId = 0L;
            }
            Set errorInfos = errorInfoMap.computeIfAbsent(costcenterId, t -> Sets.newHashSetWithExpectedSize((int)10));
            errorInfos.add(tip + String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%1$s\uff0c\u5b8c\u5de5\u5165\u5e93\u5f52\u96c6\u5355\u53f7\uff1a%2$s;", (String)"RealTimeActCalcAction_42", (String)"macc-aca-algox", (Object[])new Object[0]), costobjectNumberMap.get(entry.getKey()), factSb.length() == 0 ? "" : factSb.toString().substring(0, factSb.length() - 1)));
        }
        return errorInfoMap;
    }

    private DataSetX gradeProductProcess(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory dataInputFactory, Set<Long> gradeGroupIds, DataSetX calcDataSetX, DataSetX factnedDataSetX, RealTimeDebugInfoMsgHandler msgHander) {
        HashMap<Long, String> matGroFieMap = new HashMap<Long, String>(10);
        HashMap<String, String> srcFieldMap = new HashMap<String, String>(5);
        HashMap<String, BigDecimal> matCateMap = new HashMap<String, BigDecimal>(16);
        dataInputFactory.buildGradeProductByGroupIds(gradeGroupIds, matGroFieMap, matCateMap, srcFieldMap);
        calcDataSetX = calcDataSetX.groupBy(new String[]{"mainCostObjectId", "costObjectId", "matId", "elementId", "subElementId", "outsourcetype", "carrytype"}).reduceGroup((GroupReduceFunction)new RealTimeCalcGradeFunction(args, matGroFieMap, matCateMap, srcFieldMap, msgHander));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            calcDataSetX = AcaDataSetXLogUtil.logDataSetX(calcDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":gradeProductProcess-two\uff1a", msgHander);
        }
        return calcDataSetX;
    }

    private DataSetX conversionSubDetailProcess(RealTimeCostCalcArgs args, RealTimeCostCalcDataInputFactory datainputFactory, JobSession session, DataSetX calcDataSetX, DataSetX calcDetailDataSetX, RealTimeDebugInfoMsgHandler msgHander) {
        DataSetX calcDataSetCopyX = calcDataSetX.filter("carrytype='A'");
        JoinDataSetX convSubDetailDataSetX = calcDataSetCopyX.leftJoin(calcDetailDataSetX).on("mainCostObjectId", "mainCostObjectId").on("costObjectId", "costObjectId").on("elementId", "elementId").on("subElementId", "subElementId").on("outsourcetype", "outsourcetype").select(new String[]{"srcBillId", "srcEntryId", "costCenterId", "mainCostObjectId", "costObjectId", "productType", "elementId", "subElementId", "outsourcetype", "proFinQty", "cost", "groupfield", "groupcategoryid"}, new String[]{"subMatId", "subMatVerId", "subMatAuxId", "subResourceId", "subMatUnitPrecision", "finQty", "finAmt"});
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            convSubDetailDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)convSubDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":conversionSubDetailProcess-two\uff1a", msgHander);
        }
        DataSet subElementTypeDs = datainputFactory.buildSubElementTypeDataSet();
        DataSetX subElementTypeDsX = session.fromInput((Input)new DataSetInput(subElementTypeDs));
        convSubDetailDataSetX = convSubDetailDataSetX.leftJoin(subElementTypeDsX).on("subElementId", "id").select(convSubDetailDataSetX.getRowMeta().getFieldNames(), new String[]{"subElementType"});
        convSubDetailDataSetX = convSubDetailDataSetX.groupBy(new String[]{"costCenterId", "mainCostObjectId", "costObjectId", "elementId", "subElementId", "outsourcetype"}).reduceGroup((GroupReduceFunction)new RealTimeCalcJoinSideDetailFunction(args));
        if (StringUtils.isNotEmpty((String)args.getDebugColVal())) {
            convSubDetailDataSetX = AcaDataSetXLogUtil.logDataSetX((DataSetX)convSubDetailDataSetX, args.getDebugColName(), args.getDebugColVal(), args.getGetLogUniqueKey() + ":conversionSubDetailProcess-three\uff1a", msgHander);
        }
        return convSubDetailDataSetX;
    }

    private void calculatCostRecordCostUpdateService(List<Map<String, Object>> calcParamList) {
        try {
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(calcParamList)) {
                LogUtils.logInfo(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey(), logger, ResManager.loadKDString((String)"\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u5f00\u59cb", (String)"RealTimeActCalcAction_43", (String)"macc-aca-algox", (Object[])new Object[0]));
                long start = System.currentTimeMillis();
                HashMap result = (HashMap)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostRecordCostUpdateService", (String)"updateCostByCostSubElement", (Object[])new Object[]{calcParamList});
                if (result != null && result.size() > 0) {
                    logger.error(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey() + "\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\u3002", (Throwable)new KDBizException(((Object)result).toString()));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a%s", (String)"RealTimeActCalcAction_44", (String)"macc-aca-algox", (Object[])new Object[0]), ((Object)result).toString()));
                }
                LogUtils.logInfo(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey(), logger, String.format(ResManager.loadKDString((String)"\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%s", (String)"RealTimeActCalcAction_45", (String)"macc-aca-algox", (Object[])new Object[0]), System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            logger.error(this.getContext().getRealTimeInputArgs().getGetLogUniqueKey() + "\u3010\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5165\u5e93\u6838\u7b97updateCostByCostSubElement\u3011\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
    }

    private int getCostObjectBatSize() {
        int batchSize = CadBgParamUtils.getCadParamForInt((String)DBPARAM_ACA_CALC_COSTOBJSIZE, (int)10000);
        if (batchSize < 100) {
            batchSize = 100;
        }
        return batchSize;
    }
}

