/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.action;

import java.util.ArrayList;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.action.AbstractActCalcAction;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.function.RealTimeCalcFunctionHelper;
import kd.macc.aca.algox.utils.AcaAlgoxCurrencyHelper;
import kd.macc.aca.algox.utils.AcaDebugHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeInitializeAction
extends AbstractActCalcAction {
    private static final Log logger = LogFactory.getLog(RealTimeInitializeAction.class);
    private RealTimeCostCalcArgs args;
    private DynamicObject costAcctObj;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getRealTimeInputArgs();
        if (this.args.getCostAccountId() == null || Long.compare(0L, this.args.getCostAccountId()) == 0) {
            String errStr = ResManager.loadKDString((String)"\u6267\u884c\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6210\u672c\u8d26\u7c3f\u53c2\u6570\u503c\u3002", (String)"RealTimeInitializeAction_0", (String)"macc-aca-algox", (Object[])new Object[0]);
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)0L, errStr);
            throw new IllegalArgumentException(errStr);
        }
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("calorg");
        selectFields.add("costtype");
        selectFields.add("calpolicy");
        selectFields.add("calpolicy.calbycostelement");
        MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
        this.costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.args.getCostAccountId(), (DynamicObjectType)subCostAcctType);
        this.checkAndInitOrg();
        this.checkRealTimeParam();
        this.checkAndInitPeriod();
        this.checkAndInitCurrency();
        String debugString = AcaDebugHelper.getDebugKeyword("aca_realtimecalc");
        try {
            if (StringUtils.isNotEmpty((String)debugString)) {
                this.args.setDebugKeyword(debugString);
                String[] ss = debugString.split("=");
                this.args.setDebugColName(ss[0]);
                this.args.setDebugColVal(ss[1]);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void checkRealTimeParam() {
        DynamicObject realTimeParam = this.recursionGetRealTimeParam(this.args.getOrgId(), 1);
        if (realTimeParam == null) {
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.args.getOrgId())});
            String orgName = org == null ? "" : org.getString("name");
            String errStr = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7%s\u53ca\u4e0a\u7ea7\u7ec4\u7ec7\u5747\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u5b9e\u65f6\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"RealTimeInitializeAction_1", (String)"macc-aca-algox", (Object[])new Object[0]), orgName);
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)0L, errStr);
            throw new IllegalArgumentException(errStr);
        }
        this.args.setCalcType(realTimeParam.getString("calctype"));
        this.args.setMatCostCalcType(realTimeParam.getString("matcostcalctype"));
        this.args.setCalcDealType(realTimeParam.getString("calcdealtype"));
        this.args.setMatCostType(realTimeParam.getString("matcosttype"));
        this.args.setMfgCostCalcType(realTimeParam.getString("mfgcostcalctype"));
        this.args.setReCalc("C".equals(this.args.getCalcDealType()));
        DynamicObject realTimeLog = BusinessDataServiceHelper.loadSingle((Object)this.args.getCalcLogId(), (String)"aca_realtimecalclog", (String)"id,billstatus,calctype,sourceid,rtcalctype,matcostcalctype,mfgcostcalctype,calcdealtype,matcosttype");
        realTimeLog.set("rtcalctype", (Object)this.args.getCalcType());
        realTimeLog.set("matcostcalctype", (Object)this.args.getMatCostCalcType());
        realTimeLog.set("mfgcostcalctype", (Object)this.args.getMfgCostCalcType());
        realTimeLog.set("calcdealtype", (Object)this.args.getCalcDealType());
        realTimeLog.set("matcosttype", (Object)this.args.getMatCostType());
        SaveServiceHelper.update((DynamicObject)realTimeLog);
    }

    private DynamicObject recursionGetRealTimeParam(Long upOrgId, int count) {
        if (count == 30) {
            logger.info("\u627e\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97\u53c2\u6570\u8bbe\u7f6e\u9012\u5f52\u6b21\u6570\u5df2\u8fbe\u5230\u6700\u5927\u503c ==>{}", (Object)count);
            return null;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)upOrgId);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObject realTimeParam = QueryServiceHelper.queryOne((String)"aca_realtimeparam", (String)"org,calctype,matcostcalctype,mfgcostcalctype,calcdealtype,matcosttype", (QFilter[])qFilter.toArray());
        if (realTimeParam == null) {
            Long parentOrgId = (Long)OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(upOrgId)).values().iterator().next();
            if (CadEmptyUtils.isEmpty((Long)parentOrgId)) {
                return null;
            }
            return this.recursionGetRealTimeParam(parentOrgId, count++);
        }
        return realTimeParam;
    }

    private void checkAndInitOrg() {
        logger.info("RealTimeInitializeAction");
        Long calOrgId = this.costAcctObj == null ? 0L : this.costAcctObj.getLong("calorg.id");
        if (calOrgId == null || Long.compare(0L, calOrgId) == 0) {
            if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
                String errStr = ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c\u3002", (String)"RealTimeInitializeAction_2", (String)"macc-aca-algox", (Object[])new Object[0]);
                RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)0L, errStr);
                throw new IllegalArgumentException(errStr);
            }
            return;
        }
        if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
            this.args.setOrgId(calOrgId);
        } else if (Long.compare(this.args.getOrgId(), calOrgId) != 0) {
            String errStr = String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u4f20\u5165\u7684\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c%1$s\uff0c\u548c\u8d26\u7c3f\u7684\u6838\u7b97\u7ec4\u7ec7%2$s\u4e0d\u4e00\u81f4\u3002", (String)"RealTimeInitializeAction_4", (String)"macc-aca-algox", (Object[])new Object[0]), this.args.getOrgId(), calOrgId);
            RealTimeCalcFunctionHelper.insertCalcErrorInfo(this.args.getCalcLogId(), (Long)0L, errStr);
            throw new IllegalArgumentException(errStr);
        }
    }

    private void checkAndInitPeriod() {
        QFilter qfCostAccount;
        QFilter qfOrg;
        DynamicObject sysCtrlEntity;
        if ((this.args.getPeriodId() == null || Long.compare(0L, this.args.getPeriodId()) == 0) && (sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg = new QFilter("org", "=", (Object)this.args.getOrgId()), qfCostAccount = new QFilter("entry.costaccount", "=", (Object)this.args.getCostAccountId())})) != null) {
            this.args.setPeriodId(sysCtrlEntity.getLong("currentperiod"));
        }
        this.args.setPrePeriodId(PeriodHelper.getPrePeriodId(this.args.getPeriodId()));
    }

    private void checkAndInitCurrency() {
        if (this.args.getCurrencyId() == null || Long.compare(0L, this.args.getCurrencyId()) == 0) {
            Long calpolicy = this.costAcctObj.getLong("calpolicy.id");
            if (calpolicy == null || Long.compare(0L, calpolicy) == 0) {
                return;
            }
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
            this.args.setCurrencyId(result.getLong("currency"));
        }
        if (this.args.getCurrencyId() != null) {
            DynamicObject dyo = AcaAlgoxCurrencyHelper.getCurrency(this.args.getCurrencyId());
            this.args.setAmtScale(dyo.getInt("amtprecision"));
            this.args.setPriceScale(dyo.getInt("priceprecision"));
        }
    }
}

