/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.costcalc.common.ProextraPriceVo;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeCalcFunctionHelper {
    private static final String INSERT_CHECKDETAIL_ENTRY_SQL = "INSERT INTO t_aca_rtcalclogentry (FId,FEntryId,fentrycostcenterid,fcheckdetail,fstatus) VALUES (?,?,?,?,?)";
    public static final String CALC_CHECK_STATUS_ERROR = "2";
    public static final String CALC_CHECK_STATUS_WARN = "1";

    public static void insertCalcErrorInfo(Long calcLogId, Long costcenter, String errorInfo) {
        RealTimeCalcFunctionHelper.insertCalcErrorInfo(calcLogId, costcenter, errorInfo, CALC_CHECK_STATUS_ERROR);
    }

    public static void insertCalcErrorInfo(Long calcLogId, Long costcenter, String errorInfo, String status) {
        if (CadEmptyUtils.isEmpty((Long)calcLogId)) {
            return;
        }
        if (StringUtils.isEmpty((String)errorInfo)) {
            return;
        }
        if (costcenter == null) {
            costcenter = 0L;
        }
        if (errorInfo.length() > 255) {
            errorInfo = errorInfo.substring(0, 255);
        }
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        Object[] entry = new Object[]{calcLogId, ID.genLongId(), costcenter, errorInfo, status};
        entrys.add(entry);
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CHECKDETAIL_ENTRY_SQL, entrys);
    }

    public static void insertCalcErrorInfo(Long calcLogId, Long costcenter, List<String> errorInfos) {
        RealTimeCalcFunctionHelper.insertCalcErrorInfo(calcLogId, costcenter, errorInfos, CALC_CHECK_STATUS_ERROR);
    }

    public static void insertCalcErrorInfo(Long calcLogId, Long costcenter, List<String> errorInfos, String status) {
        if (CadEmptyUtils.isEmpty((Long)calcLogId)) {
            return;
        }
        if (CadEmptyUtils.isEmpty(errorInfos)) {
            return;
        }
        if (costcenter == null) {
            costcenter = 0L;
        }
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        for (String errorInfo : errorInfos) {
            entrys.add(new Object[]{calcLogId, ID.genLongId(), costcenter, errorInfo.length() > 255 ? errorInfo.substring(0, 255) : errorInfo, status});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CHECKDETAIL_ENTRY_SQL, entrys);
    }

    public static List<ProextraPriceVo> getsidePriceDyo(Map<String, List<ProextraPriceVo>> proextraPriceMap, String key, String costCenterId, String manuorgId) {
        manuorgId = manuorgId == null ? "0" : manuorgId;
        costCenterId = costCenterId == null ? "0" : costCenterId;
        String manuorgKey = key + "@" + manuorgId;
        List<ProextraPriceVo> priceDyo = proextraPriceMap.get(manuorgKey + "@" + costCenterId);
        if (priceDyo != null) {
            return priceDyo;
        }
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenterId) && (priceDyo = proextraPriceMap.get(manuorgKey + "@0")) != null) {
            return priceDyo;
        }
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(manuorgId)) {
            manuorgKey = key + "@0";
            priceDyo = proextraPriceMap.get(manuorgKey + "@" + costCenterId);
            if (priceDyo != null) {
                return priceDyo;
            }
            if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(costCenterId) && (priceDyo = proextraPriceMap.get(manuorgKey + "@0")) != null) {
                return priceDyo;
            }
        }
        return null;
    }

    public static BigDecimal getCostobjectEquivalent(Map<String, BigDecimal> equivalentMap, Long costAccountId, Long costCenterId, Long costObjectId, Long subElementId) {
        String detailKey = String.format("%s@%s@%s@%s", costAccountId, costCenterId, costObjectId, subElementId);
        BigDecimal equivalent = equivalentMap.get(detailKey);
        if (equivalent != null) {
            return equivalent;
        }
        detailKey = String.format("%s@%s@%s", costAccountId, costCenterId, costObjectId);
        equivalent = equivalentMap.get(detailKey);
        if (equivalent != null) {
            return equivalent;
        }
        detailKey = String.format("%s@%s", costAccountId, costCenterId);
        equivalent = equivalentMap.get(detailKey);
        if (equivalent != null) {
            return equivalent;
        }
        detailKey = String.format("%s@%s", costAccountId, subElementId);
        equivalent = equivalentMap.get(detailKey);
        if (equivalent != null) {
            return equivalent;
        }
        detailKey = String.format("%s", costAccountId);
        equivalent = equivalentMap.get(detailKey);
        return equivalent;
    }

    public static String getProductAllocStd(Map<String, String> proallocstdMap, Long costAccountId, Long costCenterId, Long subElementId) {
        String key = String.format("%s@%s@%s", costAccountId, costCenterId, subElementId);
        String allocStd = proallocstdMap.get(key);
        if (StringUtils.isEmpty((String)allocStd) && StringUtils.isEmpty((String)(allocStd = proallocstdMap.get(key = String.format("%s@%s", costAccountId, costCenterId)))) && StringUtils.isEmpty((String)(allocStd = proallocstdMap.get(key = String.format("%s@%s@%s", costAccountId, 0, subElementId))))) {
            key = String.format("%s", costAccountId);
            allocStd = proallocstdMap.get(key);
        }
        return allocStd;
    }

    public static Map<Long, BigDecimal> getGroupCostObjectWeight(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap, Map<String, String> allocTypeMap, Map<String, BigDecimal[]> weightMap, Long subElementId) {
        HashMap groupCostobjWeightMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) continue;
            BigDecimal weight = BigDecimal.ZERO;
            String key = String.format("%s@%s@%s@%s", entry.getValue().getProductgroupId(), entry.getValue().getMatId(), entry.getValue().getMatVerId(), entry.getValue().getMatAuxId());
            String subElementKey = key + "@" + subElementId;
            BigDecimal[] weightArr = weightMap.get(subElementKey);
            if (weightArr == null || BigDecimalUtil.compareTo(weightArr[1], BigDecimal.ZERO) != 0 && BigDecimalUtil.compareTo(weightArr[0], BigDecimal.ZERO) == 0) {
                String allocType = allocTypeMap.get(key);
                if (CALC_CHECK_STATUS_WARN.equals(allocType)) {
                    weight = entry.getValue().getWeight();
                    if (weight == null) {
                        weight = BigDecimal.ONE;
                    }
                } else if (CALC_CHECK_STATUS_ERROR.equals(allocType)) {
                    weightArr = weightMap.get(key);
                    weight = weightArr == null ? BigDecimal.ZERO : weightArr[0];
                }
            } else {
                weight = weightArr[0];
            }
            groupCostobjWeightMap.put(entry.getKey(), weight);
        }
        return groupCostobjWeightMap;
    }

    public static Map<Long, BigDecimal[]> getGroupCostObjectFixedAmt(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap, Map<String, BigDecimal[]> weightAmtMap, Long subElementId) {
        if (CadEmptyUtils.isEmpty(weightAmtMap)) {
            return null;
        }
        HashMap groupCostobjFixedAmtMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            String key;
            String subElementKey;
            if (!"A".equals(entry.getValue().getProductType()) || !weightAmtMap.containsKey(subElementKey = (key = String.format("%s@%s@%s@%s", entry.getValue().getProductgroupId(), entry.getValue().getMatId(), entry.getValue().getMatVerId(), entry.getValue().getMatAuxId())) + "@" + subElementId) || BigDecimalUtil.compareTo(weightAmtMap.get(subElementKey)[1], BigDecimal.ZERO) == 0 || BigDecimalUtil.compareTo(weightAmtMap.get(subElementKey)[0], BigDecimal.ZERO) != 0) continue;
            groupCostobjFixedAmtMap.put(entry.getKey(), weightAmtMap.get(subElementKey));
        }
        return groupCostobjFixedAmtMap;
    }

    public static boolean isContainsJoinProduct(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap) {
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            if (!"A".equals(entry.getValue().getProductType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsProductFacted(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap, String productType) {
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            if (!productType.equals(entry.getValue().getProductType()) || CollectionUtils.isEmpty(entry.getValue().getCostcenterFinQtyMap())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsProductFactned(Map<Long, RealTimeResultFinalResultVO> detailMap) {
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : detailMap.entrySet()) {
            if (CollectionUtils.isEmpty(entry.getValue().getCostcenterFinQtyMap())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnlySideFactned(Map<Long, RealTimeResultFinalResultVO> detailMap) {
        boolean isHasSideFactned = false;
        boolean isHasOtherFactned = false;
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : detailMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) {
                if (CollectionUtils.isEmpty(entry.getValue().getCostcenterFinQtyMap())) continue;
                isHasSideFactned = true;
                continue;
            }
            if (BigDecimal.ZERO.compareTo(entry.getValue().getProFinQty()) == 0) continue;
            isHasOtherFactned = true;
        }
        return isHasSideFactned && !isHasOtherFactned;
    }

    public static BigDecimal getMainAndJoinProFinQty(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap) {
        BigDecimal proFinQty = BigDecimal.ZERO;
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) continue;
            proFinQty = proFinQty.add(entry.getValue().getProFinQty());
        }
        return proFinQty;
    }

    public static BigDecimal getMainAndJoinProEndQty(Map<Long, RealTimeResultFinalResultVO> productGroupCostObjMap) {
        BigDecimal proEndQty = BigDecimal.ZERO;
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : productGroupCostObjMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) continue;
            proEndQty = proEndQty.add(entry.getValue().getPdEndQty());
        }
        return proEndQty;
    }

    public static boolean isCostobjectDebug(RealTimeCostCalcArgs args, Long costobjectId) {
        return ("mainCostObjectId".equals(args.getDebugColName()) || "costObjectId".equals(args.getDebugColName())) && String.valueOf(costobjectId).equals(args.getDebugColVal());
    }
}

