/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.realtime.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.realtime.RealTimeCostCalcArgs;
import kd.macc.aca.algox.realtime.RealTimeResultFinalResultVO;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.LogUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeCalcResultSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8750794000883579691L;
    private static final Log logger = LogFactory.getLog(RealTimeCalcResultSaveFunction.class);
    private Date nowDate;
    private RowMeta srcMeta;
    private RealTimeCostCalcArgs args;
    private Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap;

    public RealTimeCalcResultSaveFunction(RowMeta rowMeta, RealTimeCostCalcArgs args, Map<Long, Map<Long, RealTimeResultFinalResultVO>> calcCostobjectFinalResultMap) {
        this.srcMeta = rowMeta;
        this.args = args;
        this.calcCostobjectFinalResultMap = calcCostobjectFinalResultMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        this.nowDate = TimeServiceHelper.now();
        ArrayList iterRows = Lists.newArrayList();
        for (RowX row : iterable) {
            iterRows.add(row);
        }
        if (iterRows.isEmpty()) {
            return;
        }
        Long mainCostObjectId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("mainCostObjectId"));
        Long costCenterId = ((RowX)iterRows.get(0)).getLong(this.srcMeta.getFieldIndex("costCenterId"));
        if (!this.calcCostobjectFinalResultMap.containsKey(mainCostObjectId)) {
            return;
        }
        DynamicObject calcResult = null;
        boolean isReCalc = this.args.getReCalc();
        if (!isReCalc) {
            QFilter qFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
            qFilter.and("costaccount", "=", (Object)this.args.getCostAccountId());
            qFilter.and("period", "=", (Object)this.args.getPeriodId());
            qFilter.and("costcenter", "=", (Object)costCenterId);
            qFilter.and("costobject", "=", (Object)mainCostObjectId);
            calcResult = BusinessDataServiceHelper.loadSingle((String)"aca_realtimecalcresult", (String)"id,entryentity,entryentity.seq,entryentity.type,entryentity.feetype,entryentity.relaproducttype,entryentity.outsourcetype,entryentity.relacostobject,entryentity.material,entryentity.auxpty,entryentity.matversion,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatversion,entryentity.subauxpty,entryentity.syncauditdate,entryentity.srcbillno,entryentity.srcbillid,entryentity.srcbillentryid,entryentity.pdcurrqty,entryentity.pdcurramount,entryentity.pdstartqty,entryentity.pdstartamount,entryentity.pdendqty,entryentity.pdendamount,entryentity.currcomqty,entryentity.currcomamount,entryentity.resource,entryentity.calcdate,plansourceentry.plansrcbillentry,plansourceentry.planbillno", (QFilter[])qFilter.toArray());
        }
        Map<Long, RealTimeResultFinalResultVO> resultVoMaps = this.calcCostobjectFinalResultMap.get(mainCostObjectId);
        HashMap costObjectRowsMap = Maps.newHashMapWithExpectedSize((int)resultVoMaps.size());
        for (RowX row : iterRows) {
            Long costObjectId = row.getLong(this.srcMeta.getFieldIndex("costObjectId"));
            costObjectRowsMap.computeIfAbsent(costObjectId, t -> Lists.newArrayList()).add(row);
        }
        if (calcResult == null || isReCalc) {
            calcResult = this.createCalcResultBill(costCenterId, mainCostObjectId);
        }
        DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection planEntryEntity = calcResult.getDynamicObjectCollection("plansourceentry");
        DynamicObject finalResultDy = null;
        if (!isReCalc) {
            for (DynamicObject entry : entryEntity) {
                if (!"finalResult".equals(entry.getString("type"))) continue;
                finalResultDy = entry;
                break;
            }
            if (finalResultDy != null) {
                entryEntity.remove(finalResultDy);
            }
        }
        int seq = entryEntity.size();
        for (Map.Entry<Long, RealTimeResultFinalResultVO> entry : resultVoMaps.entrySet()) {
            RealTimeResultFinalResultVO resultFinalResultVO = entry.getValue();
            seq = this.generateEntryEntityRow(entryEntity, (List)costObjectRowsMap.get(entry.getKey()), entry.getKey(), resultFinalResultVO, seq, isReCalc, finalResultDy);
            Set<Long> planSourceBillEntryIds = resultFinalResultVO.getPlanSourceBillEntryIds();
            Map<Long, String> planBillNoMap = resultFinalResultVO.getPlanSourceBillMap();
            if (CadEmptyUtils.isEmpty(planSourceBillEntryIds)) continue;
            for (Long sourceBillEntryId : planSourceBillEntryIds) {
                DynamicObject planEntry = planEntryEntity.addNew();
                planEntry.set("plansrcbillentry", (Object)sourceBillEntryId);
                planEntry.set("planbillno", (Object)planBillNoMap.get(sourceBillEntryId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcResult});
    }

    private int generateEntryEntityRow(DynamicObjectCollection entryEntity, List<RowX> costobjectRows, Long costobjectId, RealTimeResultFinalResultVO resultVo, int seq, boolean isReCalc, DynamicObject finalResultDy) {
        Long matId = 0L;
        Long matVerId = 0L;
        Long matAuxId = 0L;
        int matUnitPrecision = 0;
        BigDecimal proFinQty = BigDecimal.ZERO;
        BigDecimal proPlanQty = BigDecimal.ZERO;
        BigDecimal proPdStartQty = resultVo.getPdStartQty();
        BigDecimal proPdStartAmt = resultVo.getPdStartAmt();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalFinAmt = BigDecimal.ZERO;
        BigDecimal totalInAmt = BigDecimal.ZERO;
        if (resultVo.getMatUnitPrecision() != null) {
            matUnitPrecision = resultVo.getMatUnitPrecision();
        }
        proFinQty = resultVo.getProFinQty();
        proPlanQty = resultVo.getProPlanQty();
        int i = 0;
        if (!CollectionUtils.isEmpty(costobjectRows)) {
            for (RowX row : costobjectRows) {
                if (i == 0) {
                    matId = row.getLong(this.srcMeta.getFieldIndex("matId"));
                    matVerId = row.getLong(this.srcMeta.getFieldIndex("matVerId"));
                    matAuxId = row.getLong(this.srcMeta.getFieldIndex("matAuxId"));
                }
                Long subMatId = row.getLong(this.srcMeta.getFieldIndex("subMatId"));
                Long subMatVerId = row.getLong(this.srcMeta.getFieldIndex("subMatVerId"));
                Long subMatAuxId = row.getLong(this.srcMeta.getFieldIndex("subMatAuxId"));
                Integer subMatUnitPrecision = row.getInteger(this.srcMeta.getFieldIndex("subMatUnitPrecision"));
                if (subMatUnitPrecision == null) {
                    subMatUnitPrecision = 0;
                }
                Long elementId = row.getLong(this.srcMeta.getFieldIndex("elementId"));
                Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
                int isMfg = row.getInteger(this.srcMeta.getFieldIndex("isMfg"));
                if (CadEmptyUtils.isEmpty((Long)subMatId) && isMfg == 0) {
                    isMfg = 1;
                }
                Date syncAuditDate = row.getDate(this.srcMeta.getFieldIndex("syncauditdate"));
                String sourceBillNo = row.getString(this.srcMeta.getFieldIndex("srcbillno"));
                Long srcBillId = row.getLong(this.srcMeta.getFieldIndex("srcbillid"));
                Long srcBillEntryId = row.getLong(this.srcMeta.getFieldIndex("srcbillentryid"));
                Long resourceId = row.getLong(this.srcMeta.getFieldIndex("resource"));
                BigDecimal pdStartQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartQty")));
                BigDecimal pdStartAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pdStartAmt")));
                BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
                qty = qty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal amount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("amount")));
                totalAmount = totalAmount.add(amount);
                BigDecimal finQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
                finQty = finQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                BigDecimal finAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmt")));
                totalFinAmt = totalFinAmt.add(finAmt);
                BigDecimal inQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("inQty")));
                BigDecimal inAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("inAmt")));
                totalInAmt = totalInAmt.add(inAmt);
                DynamicObject entry = entryEntity.addNew();
                entry.set("seq", (Object)seq++);
                entry.set("type", (Object)"detail");
                entry.set("feetype", (Object)(isMfg == 1 ? "mfgFee" : "materialFee"));
                entry.set("relacostobject", (Object)costobjectId);
                entry.set("relaproducttype", (Object)resultVo.getProductType());
                if (Boolean.TRUE.equals(resultVo.getOutsource())) {
                    String outSourceType = row.getString(this.srcMeta.getFieldIndex("outsourcetype"));
                    entry.set("outsourcetype", (Object)outSourceType);
                }
                entry.set("material", (Object)matId);
                entry.set("matversion", (Object)matVerId);
                entry.set("auxpty", (Object)matAuxId);
                entry.set("calcdate", (Object)this.nowDate);
                entry.set("syncauditdate", (Object)syncAuditDate);
                entry.set("srcbillno", (Object)sourceBillNo);
                entry.set("srcbillid", (Object)srcBillId);
                if (CadEmptyUtils.isEmpty((Long)srcBillEntryId)) {
                    srcBillEntryId = srcBillId;
                }
                entry.set("srcbillentryid", (Object)srcBillEntryId);
                entry.set("resource", (Object)resourceId);
                entry.set("element", (Object)elementId);
                entry.set("subelement", (Object)subElementId);
                entry.set("submaterial", (Object)subMatId);
                entry.set("submatversion", (Object)subMatVerId);
                entry.set("subauxpty", (Object)subMatAuxId);
                entry.set("pdstartqty", (Object)pdStartQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("pdstartamount", (Object)pdStartAmt);
                entry.set("pdcurrqty", (Object)qty);
                entry.set("pdcurramount", (Object)amount);
                entry.set("pdcurrqty", (Object)qty);
                entry.set("pdcurramount", (Object)amount);
                entry.set("currcomqty", (Object)finQty);
                entry.set("currcomamount", (Object)finAmt);
                entry.set("pdendqty", (Object)inQty.setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP));
                entry.set("pdendamount", (Object)inAmt);
                ++i;
                if (!StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) || !this.args.getDebugColVal().equals(String.valueOf(costobjectId))) continue;
                LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format("ActCalcResult-save-detail:FEE_TYPE %s,MATERIAL %s,MATVERSION %s,AUXPTY %s,ELEMENT %s,SUB_ELEMENT %s,SUB_MATERIAL %s,SUB_MAT_VERSION %s,SUB_AUXPTY %s,PD_START_QTY %s,PD_START_AMOUNT %s,PD_CURR_QTY %s,PD_CURR_AMOUNT %s,PD_END_QTY %s,PD_END_AMOUNT %s,CURR_COM_QTY %s,CURR_COM_AMOUNT %s", entry.get("feetype"), entry.get("material"), entry.get("matversion"), entry.get("auxpty"), entry.get("element"), entry.get("subelement"), entry.get("submaterial"), entry.get("submatversion"), entry.get("subauxpty"), entry.get("pdstartqty"), entry.get("pdstartamount"), entry.get("pdcurrqty"), entry.get("pdcurramount"), entry.get("pdendqty"), entry.get("pdendamount"), entry.get("currcomqty"), entry.get("currcomamount")));
            }
        }
        BigDecimal totalProPlanQty = proPlanQty;
        BigDecimal totalProFinQty = proFinQty;
        if (!isReCalc && finalResultDy != null) {
            totalProPlanQty = totalProPlanQty.add(finalResultDy.getBigDecimal("pdcurrqty"));
            totalAmount = totalAmount.add(finalResultDy.getBigDecimal("pdcurramount"));
            totalProFinQty = totalProFinQty.add(finalResultDy.getBigDecimal("currcomqty"));
            totalFinAmt = totalFinAmt.add(finalResultDy.getBigDecimal("currcomamount"));
        }
        DynamicObject sumEntry = entryEntity.addNew();
        sumEntry.set("seq", (Object)seq++);
        sumEntry.set("type", (Object)"finalResult");
        sumEntry.set("relacostobject", (Object)costobjectId);
        sumEntry.set("relaproducttype", (Object)resultVo.getProductType());
        sumEntry.set("pdstartqty", (Object)proPdStartQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("pdstartamount", (Object)proPdStartAmt);
        sumEntry.set("pdcurrqty", (Object)totalProPlanQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("pdcurramount", (Object)totalAmount);
        sumEntry.set("currcomqty", (Object)totalProFinQty.setScale(matUnitPrecision, RoundingMode.HALF_UP));
        sumEntry.set("currcomamount", (Object)totalFinAmt);
        BigDecimal proIntryQty = resultVo.getPdEndQty().setScale(matUnitPrecision, RoundingMode.HALF_UP);
        sumEntry.set("pdendqty", (Object)proIntryQty);
        if ("C".equals(resultVo.getProductType())) {
            BigDecimal totalEndAmt = proPdStartAmt.add(totalAmount).subtract(totalFinAmt);
            sumEntry.set("pdendamount", (Object)totalEndAmt.setScale(this.args.getAmtScale(), 4));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.args.getDebugColVal()) && this.args.getDebugColVal().equals(String.valueOf(costobjectId))) {
            LogUtils.logDebugInfo(this.args.getGetLogUniqueKey(), this.args.getDebugKeyword(), logger, String.format("ActCalcResult-svae-final:PD_START_QTY %s,PD_START_AMOUNT %s,PD_CURR_QTY %s,PD_CURR_AMOUNT %s,CURR_COM_QTY %s,CURR_COM_AMOUNT %s,PD_END_QTY %s,PD_END_AMOUNT %s", sumEntry.get("pdstartqty"), sumEntry.get("pdstartamount"), sumEntry.get("pdcurrqty"), sumEntry.get("pdcurramount"), sumEntry.get("currcomqty"), sumEntry.get("currcomamount"), sumEntry.get("pdendqty"), sumEntry.get("pdendamount")));
        }
        return seq;
    }

    private DynamicObject createCalcResultBill(Long costCenterId, Long mainCostObjectId) {
        DynamicObject calcResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_realtimecalcresult");
        calcResult.set("billno", (Object)ID.genStringId());
        calcResult.set("billstatus", (Object)"A");
        calcResult.set("org", (Object)this.args.getOrgId());
        calcResult.set("costaccount", (Object)this.args.getCostAccountId());
        calcResult.set("currency", (Object)this.args.getCurrencyId());
        calcResult.set("bizdate", (Object)this.nowDate);
        calcResult.set("period", (Object)this.args.getPeriodId());
        calcResult.set("costcenter", (Object)costCenterId);
        calcResult.set("costobject", (Object)mainCostObjectId);
        Long userId = RequestContext.get().getCurrUserId();
        calcResult.set("billstatus", (Object)"C");
        calcResult.set("createtime", (Object)this.nowDate);
        calcResult.set("auditdate", (Object)this.nowDate);
        calcResult.set("modifytime", (Object)this.nowDate);
        calcResult.set("creator_id", (Object)userId);
        calcResult.set("modifier_id", (Object)userId);
        calcResult.set("auditor_id", (Object)userId);
        return calcResult;
    }
}

