/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.common.MatCalcParam;
import kd.macc.aca.algox.report.function.MatClacDiffDealFunction;
import kd.macc.aca.algox.utils.DataSetXHelper;

public class MatCalcAnalRptAlgoxService {
    private static final Log logger = LogFactory.getLog(MatCalcAnalRptAlgoxService.class);
    public static RowMeta targetRowMeta = new RowMeta(new Field[0]);

    public DataSet getDataSetResult(MatCalcParam matCalcParam) {
        long time = System.currentTimeMillis();
        DataSet calcDataSet = this.getCalcDataSetInfo(matCalcParam);
        DataSet matDataSet = this.getMatAllocateDataSetInfo(matCalcParam);
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Boolean showMatDetail = matCalcParam.getShowMatDetail();
        Boolean onlyShowDiff = matCalcParam.getOnlyShowDiff();
        DataSet dataSetResult = this.resultDataDeal(calcDataSet, matDataSet, showMatDetail, onlyShowDiff);
        dataSetResult = dataSetResult.filter("qty!=0 or amount!=0 or pdcurrqty!=0 or qtydiff != 0");
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetResult;
    }

    private DataSet resultDataDeal(DataSet calcDataSet, DataSet matDataSet, Boolean showMatDetail, Boolean onlyShowDiff) {
        JobSession session = AlgoX.createSession((String)"MatCalcAnal_rDD");
        DataSetX inputMatDs = session.fromInput((Input)new DataSetInput(matDataSet));
        DataSetX inputclacDs = session.fromInput((Input)new DataSetInput(calcDataSet));
        DataSetX matDs = inputMatDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "material", "matnumber", "baseunit", "precision", "matauxpty", "matversion"}).sum("qty").sum("amount").addFields(new Field[]{new Field("pdcurrqty", (DataType)DataType.BigDecimalType), new Field("pdcurramount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX clacDs = inputclacDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "material", "matnumber", "baseunit", "precision", "matauxpty", "matversion"}).sum("pdcurrqty").sum("pdcurramount").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("amount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX detailDs = DataSetXHelper.union(matDs, clacDs).groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "material", "matnumber", "precision", "baseunit", "matauxpty", "matversion"}).sum("qty").sum("amount").sum("pdcurrqty").sum("pdcurramount").addFields(new Field[]{new Field("qtydiff", (DataType)DataType.BigDecimalType), new Field("amountdiff", (DataType)DataType.BigDecimalType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, "detail", 1, 0, 0});
        detailDs = detailDs.map((MapFunction)new MatClacDiffDealFunction()).removeFields(new String[]{"precision"});
        if (onlyShowDiff.booleanValue()) {
            detailDs = detailDs.filter("qtydiff != 0 or amountdiff != 0");
        }
        DataSetX costObjectDs = detailDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname"}).sum("qty").sum("amount").sum("pdcurrqty").sum("pdcurramount").sum("qtydiff").sum("amountdiff").addFields(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("matnumber", (DataType)DataType.StringType), new Field("baseunit", (DataType)DataType.LongType), new Field("matauxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{0L, "", 0L, 0L, 0L, "sum", 0, 0, 0});
        DataSetX costCenterDs = costObjectDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum"}).sum("qty").sum("amount").sum("pdcurrqty").sum("pdcurramount").sum("qtydiff").sum("amountdiff").addFields(new Field[]{new Field("costcentername", (DataType)DataType.StringType), new Field("costobject", (DataType)DataType.LongType), new Field("costobjectnumber", (DataType)DataType.StringType), new Field("costobjectname", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("matnumber", (DataType)DataType.StringType), new Field("baseunit", (DataType)DataType.LongType), new Field("matauxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5408\u8ba1", (String)"MatCalcAnalRptAlgoxService_2", (String)"macc-aca-algox", (Object[])new Object[0]), 0L, "null", "", 0L, "", 0L, 0L, 0L, "sum", 2, 1, 0});
        DataSetX allDs = costCenterDs.groupBy(new String[]{"periodid"}).sum("qty").sum("amount").sum("pdcurrqty").sum("pdcurramount").sum("qtydiff").sum("amountdiff").addFields(new Field[]{new Field("periodname", (DataType)DataType.StringType), new Field("costcenternumber", (DataType)DataType.LongType), new Field("costcenternum", (DataType)DataType.StringType), new Field("costcentername", (DataType)DataType.StringType), new Field("costobject", (DataType)DataType.LongType), new Field("costobjectnumber", (DataType)DataType.StringType), new Field("costobjectname", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("matnumber", (DataType)DataType.StringType), new Field("baseunit", (DataType)DataType.LongType), new Field("matauxpty", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"MatCalcAnalRptAlgoxService_3", (String)"macc-aca-algox", (Object[])new Object[0]), 0L, "", "", 0L, "", "", 0L, "", 0L, 0L, 0L, "sum", 3, 2, 1});
        DataSetX resultDs = DataSetXHelper.union(costObjectDs, costCenterDs);
        if (showMatDetail.booleanValue()) {
            resultDs = DataSetXHelper.union(resultDs, detailDs);
        }
        resultDs = DataSetXHelper.union(resultDs, allDs);
        resultDs = resultDs.orderBy(new String[]{"all asc", "costcenternum asc", "ordercen asc", "costobjectnumber asc", "ordernum asc", "matnumber asc"});
        DataSetOutput resultSet = new DataSetOutput(resultDs.getRowMeta());
        String resultId = resultSet.getId();
        resultDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    private DataSet getMatAllocateDataSetInfo(MatCalcParam matCalcParam) {
        String selectFields = "period periodid,period.name periodname,entryentity.costobejctentry.costcenter costcenternumber,entryentity.costobejctentry.costcenter.number costcenternum,entryentity.costobejctentry.costcenter.name costcentername,material material,material.number matnumber,material.baseunit baseunit,material.baseunit.precision precision,matversion,auxpty matauxpty,entryentity.costobejctentry costobject,entryentity.costobejctentry.billno costobjectnumber,entryentity.costobejctentry.name costobjectname,entryentity.qty qty,entryentity.amount amount";
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.addAll(matCalcParam.getBaseFilter());
        List<Long> costObjectIds = matCalcParam.getCostObjectIds();
        if (costObjectIds != null && costObjectIds.size() > 0) {
            queryFilter.add(new QFilter("entryentity.costobejctentry", "in", costObjectIds));
        }
        queryFilter.add(new QFilter("allocstatus", "=", (Object)"2"));
        queryFilter.add(new QFilter("appnum", "=", (Object)"aca"));
        DataSet matDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getMatAllocateDataSetInfo"), (String)"aca_matalloc", (String)selectFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        return matDataSet;
    }

    private DataSet getCalcDataSetInfo(MatCalcParam matCalcParam) {
        String selectFields = "period periodid,period.name periodname,costcenter costcenternumber,costcenter.number costcenternum,costcenter.name costcentername,entryentity.submaterial material,entryentity.submaterial.number matnumber,entryentity.submaterial.baseunit baseunit,entryentity.submaterial.baseunit.precision precision,entryentity.submatversion matversion,entryentity.subauxpty matauxpty,costobject,costobject.billno costobjectnumber,costobject.name costobjectname,entryentity.pdcurrqty pdcurrqty,entryentity.pdcurramount pdcurramount";
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.addAll(matCalcParam.getBaseFilter());
        List<Long> costObjectIds = matCalcParam.getCostObjectIds();
        if (costObjectIds != null && costObjectIds.size() > 0) {
            queryFilter.add(new QFilter("costobject", "in", costObjectIds));
        }
        queryFilter.add(new QFilter("entryentity.feetype", "=", (Object)"materialFee"));
        queryFilter.add(new QFilter("entryentity.relaproducttype", "=", (Object)"C"));
        DataSet clacDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getCalcDataSetInfo"), (String)"aca_calcresult", (String)selectFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        return clacDataSet;
    }

    protected String getAlgoKey(String methodName) {
        return "MatCalcAnalRpt_" + methodName;
    }
}

