/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.common.MatCalcParam;
import kd.macc.aca.algox.report.function.MfgcoClacDiffDealFunction;
import kd.macc.aca.algox.utils.DataSetXHelper;

public class MfgcoCalcAnalRptAlgoxService {
    private static final Log logger = LogFactory.getLog(MfgcoCalcAnalRptAlgoxService.class);
    public static RowMeta targetRowMeta = new RowMeta(new Field[0]);

    public DataSet getDataSetResult(MatCalcParam matCalcParam) {
        long time = System.currentTimeMillis();
        DataSet calcDataSet = this.getCalcDataSetInfo(matCalcParam);
        DataSet mfgcoDataSet = this.getMfgcoDataSetInfo(matCalcParam);
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Boolean showSubelement = matCalcParam.getShowSubelement();
        Boolean onlyShowDiff = matCalcParam.getOnlyShowDiff();
        DataSet dataSetResult = this.resultDataDeal(calcDataSet, mfgcoDataSet, showSubelement, onlyShowDiff);
        dataSetResult = dataSetResult.filter("allocamt != 0 or pdcurramount !=0 ");
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5bf9\u8d26\u8868dataset\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetResult;
    }

    private DataSet resultDataDeal(DataSet calcDataSet, DataSet mfgcoDataSet, Boolean showSubelement, Boolean onlyShowDiff) {
        JobSession session = AlgoX.createSession((String)"MfgcoCalcAnal_rDD");
        DataSetX inputMfgcoDs = session.fromInput((Input)new DataSetInput(mfgcoDataSet));
        DataSetX inputclacDs = session.fromInput((Input)new DataSetInput(calcDataSet));
        DataSetX mfgcoDs = inputMfgcoDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "element", "elementnumber", "subelement", "subelementnumber"}).sum("allocamt").addFields(new Field[]{new Field("pdcurramount", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        DataSetX clacDs = inputclacDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "element", "elementnumber", "subelement", "subelementnumber"}).sum("pdcurramount").addFields(new Field[]{new Field("allocamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        DataSetX detailDs = DataSetXHelper.union(mfgcoDs, clacDs).groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname", "element", "elementnumber", "subelement", "subelementnumber"}).sum("allocamt").sum("pdcurramount").addFields(new Field[]{new Field("amountdiff", (DataType)DataType.BigDecimalType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{BigDecimal.ZERO, "detail", 1, 0, 0});
        detailDs = detailDs.map((MapFunction)new MfgcoClacDiffDealFunction());
        if (onlyShowDiff.booleanValue()) {
            detailDs = detailDs.filter("amountdiff != 0");
        }
        DataSetX costObjectDs = detailDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum", "costcentername", "costobject", "costobjectnumber", "costobjectname"}).sum("allocamt").sum("pdcurramount").sum("amountdiff").addFields(new Field[]{new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("subelementnumber", (DataType)DataType.StringType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{0L, "", 0L, "", "sum", 0, 0, 0});
        DataSetX costCenterDs = costObjectDs.groupBy(new String[]{"periodid", "periodname", "costcenternumber", "costcenternum"}).sum("allocamt").sum("pdcurramount").sum("amountdiff").addFields(new Field[]{new Field("costcentername", (DataType)DataType.StringType), new Field("costobject", (DataType)DataType.LongType), new Field("costobjectnumber", (DataType)DataType.StringType), new Field("costobjectname", (DataType)DataType.StringType), new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("subelementnumber", (DataType)DataType.StringType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5408\u8ba1", (String)"MfgcoCalcAnalRptAlgoxService_2", (String)"macc-aca-algox", (Object[])new Object[0]), 0L, "null", "", 0L, "", 0L, "", "sum", 2, 1, 0});
        DataSetX allDs = costCenterDs.groupBy(new String[]{"periodid"}).sum("allocamt").sum("pdcurramount").sum("amountdiff").addFields(new Field[]{new Field("periodname", (DataType)DataType.StringType), new Field("costcenternumber", (DataType)DataType.LongType), new Field("costcenternum", (DataType)DataType.StringType), new Field("costcentername", (DataType)DataType.StringType), new Field("costobject", (DataType)DataType.LongType), new Field("costobjectnumber", (DataType)DataType.StringType), new Field("costobjectname", (DataType)DataType.StringType), new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("subelementnumber", (DataType)DataType.StringType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("ordercen", (DataType)DataType.IntegerType), new Field("all", (DataType)DataType.IntegerType)}, new Object[]{ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"MfgcoCalcAnalRptAlgoxService_3", (String)"macc-aca-algox", (Object[])new Object[0]), 0L, "", "", 0L, "", "", 0L, "", 0L, "", "sum", 3, 2, 1});
        DataSetX resultDs = DataSetXHelper.union(costObjectDs, costCenterDs);
        if (showSubelement.booleanValue()) {
            resultDs = DataSetXHelper.union(resultDs, detailDs);
        }
        resultDs = DataSetXHelper.union(resultDs, allDs);
        resultDs = resultDs.orderBy(new String[]{"all asc", "costcenternum asc", "ordercen asc", "costobjectnumber asc", "elementnumber asc", "subelementnumber asc", "ordernum asc"});
        DataSetOutput resultSet = new DataSetOutput(resultDs.getRowMeta());
        String resultId = resultSet.getId();
        resultDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    private DataSet getMfgcoDataSetInfo(MatCalcParam matCalcParam) {
        List<Long> costObjectIds;
        String selectFields = "period periodid,period.name periodname,entryentity.costobject.costcenter costcenternumber,entryentity.costobject.costcenter.number costcenternum,entryentity.costobject.costcenter.name costcentername,element element,element.number elementnumber,subelement subelement,subelement.number subelementnumber,entryentity.costobject costobject,entryentity.costobject.billno costobjectnumber,entryentity.costobject.name costobjectname,entryentity.allocamt allocamt";
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.addAll(matCalcParam.getBaseFilter());
        Long costCenterId = matCalcParam.getCostCenterId();
        if (costCenterId != null && costCenterId > 0L) {
            queryFilter.add(new QFilter("benefcostcenter", "=", (Object)costCenterId));
        }
        if ((costObjectIds = matCalcParam.getCostObjectIds()) != null && costObjectIds.size() > 0) {
            queryFilter.add(new QFilter("entryentity.costobject", "in", costObjectIds));
        }
        queryFilter.add(new QFilter("allocstatus", "=", (Object)"2"));
        queryFilter.add(new QFilter("appnum", "=", (Object)"aca"));
        DataSet mfgcoDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getMfgcoDataSetInfo"), (String)"cad_mfgfeeallocco", (String)selectFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        return mfgcoDataSet;
    }

    private DataSet getCalcDataSetInfo(MatCalcParam matCalcParam) {
        List<Long> costObjectIds;
        String selectFields = "period periodid,period.name periodname,costcenter costcenternumber,costcenter.number costcenternum,costcenter.name costcentername,entryentity.element element,entryentity.element.number elementnumber,entryentity.subelement subelement,entryentity.subelement.number subelementnumber,costobject,costobject.billno costobjectnumber,costobject.name costobjectname,entryentity.pdcurramount pdcurramount";
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.addAll(matCalcParam.getBaseFilter());
        Long costCenterId = matCalcParam.getCostCenterId();
        if (costCenterId != null && costCenterId > 0L) {
            queryFilter.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if ((costObjectIds = matCalcParam.getCostObjectIds()) != null && costObjectIds.size() > 0) {
            queryFilter.add(new QFilter("costobject", "in", costObjectIds));
        }
        queryFilter.add(new QFilter("entryentity.feetype", "=", (Object)"mfgFee"));
        queryFilter.add(new QFilter("entryentity.relaproducttype", "=", (Object)"C"));
        DataSet clacDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getCalcDataSetInfo"), (String)"aca_calcresult", (String)selectFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        return clacDataSet;
    }

    protected String getAlgoKey(String methodName) {
        return this.getClass().getName() + "." + methodName;
    }
}

