/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.function.ProCostCmpAnalCalFunction;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProCostCmpAnalRptAlgoxService {
    private static final Log logger = LogFactory.getLog(ProCostCmpAnalRptAlgoxService.class);
    private Boolean SHOW_COST_OBJECT = Boolean.FALSE;
    private Boolean SHOW_SUBELEMENT = Boolean.FALSE;
    private Boolean SHOW_MAT_DETAIL = Boolean.FALSE;

    protected String getAlgoKey(String methodName) {
        return this.getClass().getName() + "." + methodName;
    }

    public DataSet getDataSetResult(List<QFilter> queryFilter, Boolean showCostObject, Boolean showSubelement, Boolean showMaterialDetail, Long cost_type_id, boolean viewSubitem, String calRecordName) {
        this.SHOW_COST_OBJECT = showCostObject;
        this.SHOW_SUBELEMENT = showSubelement;
        this.SHOW_MAT_DETAIL = showMaterialDetail;
        long time = System.currentTimeMillis();
        DataSet dataSetInfo = this.getProCostDataSetInfo(queryFilter, viewSubitem);
        DataSet dataSetCostType = this.getQueryDataSetCostType(cost_type_id, viewSubitem, calRecordName);
        logger.info("\u4ea7\u54c1\u5b9e\u9645/\u6807\u51c6\u6210\u672c\u5bf9\u6bd4\u5206\u6790\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        DataSet dataSetResult = this.resultDataDeal(dataSetInfo, dataSetCostType);
        logger.info("\u4ea7\u54c1\u5b9e\u9645/\u6807\u51c6\u6210\u672c\u5bf9\u6bd4\u5206\u6790algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetResult;
    }

    private DataSet resultDataDeal(DataSet dataSetInfo, DataSet dataSetCostType) {
        JobSession session = AlgoX.createSession((String)"ProCostCmpAnal_rDD");
        DataSetX inputProCostDs = session.fromInput((Input)new DataSetInput(dataSetInfo));
        DataSetX inputCostTypeDs = session.fromInput((Input)new DataSetInput(dataSetCostType));
        DataSetX resultDs = null;
        if (!this.SHOW_MAT_DETAIL.booleanValue()) {
            inputProCostDs = inputProCostDs.addFields(new Field[]{new Field("convqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
            inputCostTypeDs = inputCostTypeDs.addFields(new Field[]{new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        }
        DataSetX proCostDs = inputProCostDs.groupBy(new String[]{"billno", "amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "element", "elementnumber", "subelementid", "subelement", "subelementname", "submaterial", "materialnumber", "matbaseunit", "matversion", "matauxpty", "convproqty"}).sum("convamt").sum("convqty");
        DataSetX proQtyDs = proCostDs.distinct(new String[]{"billno", "amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "convproqty"}).groupBy(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber"}).sum("convproqty");
        proCostDs = proCostDs.groupBy(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "element", "elementnumber", "subelementid", "subelement", "subelementname", "submaterial", "materialnumber", "matversion", "matbaseunit", "matauxpty"}).sum("convamt").sum("convqty").addFields(new Field[]{new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpconvamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        JoinDataSetX costTypeDs = proQtyDs.join(inputCostTypeDs).on("product", "product").on("auxpty", "auxpty").on("version", "version").select(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber"}, new String[]{"element", "elementnumber", "subelementid", "subelement", "subelementname", "submaterial", "materialnumber", "matversion", "matbaseunit", "matauxpty", "cmpcomuse", "cmpprice", "cmpconvamt"});
        DataSetX costTypeDsx = costTypeDs.groupBy(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "element", "elementnumber", "subelementid", "subelement", "subelementname", "submaterial", "materialnumber", "matversion", "matbaseunit", "matauxpty"}).sum("cmpcomuse").sum("cmpprice").sum("cmpconvamt").addFields(new Field[]{new Field("convamt", (DataType)DataType.BigDecimalType), new Field("convqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        resultDs = DataSetXHelper.union(proCostDs, costTypeDsx).groupBy(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "element", "elementnumber", "subelementid", "subelement", "subelementname", "submaterial", "materialnumber", "matversion", "matbaseunit", "matauxpty"}).sum("cmpcomuse").sum("cmpprice").sum("cmpconvamt").sum("convamt").sum("convqty").addFields(new Field[]{new Field("ordernum", (DataType)DataType.IntegerType), new Field("convamtshow", (DataType)DataType.BigDecimalType), new Field("cmpconvamtshow", (DataType)DataType.BigDecimalType), new Field("alldiffshow", (DataType)DataType.BigDecimalType), new Field("matqtydiff", (DataType)DataType.BigDecimalType), new Field("matamtdiff", (DataType)DataType.BigDecimalType), new Field("alldiff", (DataType)DataType.BigDecimalType), new Field("alldiffrate", (DataType)DateType.StringType), new Field("comuse", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("cmpconvqty", (DataType)DataType.BigDecimalType)}, new Object[]{1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE});
        resultDs = resultDs.join(proQtyDs).on("product", "product").on("auxpty", "auxpty").on("version", "version").on("costobject", "costobject").select(resultDs.getRowMeta().getFieldNames(), new String[]{"convproqty"});
        Boolean isFlag = this.SHOW_SUBELEMENT != false || this.SHOW_MAT_DETAIL != false;
        String datatype = isFlag != false ? "detail" : "sum";
        resultDs = resultDs.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{datatype}).map((MapFunction)new ProCostCmpAnalCalFunction());
        if (isFlag.booleanValue()) {
            DataSetX resultSumDs = resultDs.groupBy(new String[]{"amtprecision", "priceprecision", "product", "productnumber", "auxpty", "version", "baseunit", "baseunithide", "precision", "costobject", "costobjectnumber", "convproqty"}).sum("convamt").sum("cmpconvamt").sum("matqtydiff").sum("matamtdiff").addFields(new Field[]{new Field("convqty", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelementid", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.StringType), new Field("subelementname", (DataType)DataType.StringType), new Field("submaterial", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("matversion", (DataType)DataType.LongType), new Field("matbaseunit", (DataType)DataType.LongType), new Field("matauxpty", (DataType)DataType.LongType), new Field("datatype", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType), new Field("convamtshow", (DataType)DataType.BigDecimalType), new Field("cmpconvamtshow", (DataType)DataType.BigDecimalType), new Field("alldiffshow", (DataType)DataType.BigDecimalType), new Field("alldiff", (DataType)DataType.BigDecimalType), new Field("alldiffrate", (DataType)DateType.StringType), new Field("comuse", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("cmpconvqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0L, "", 0L, "", "", 0L, "", 0L, 0L, 0L, "sum", 0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE}).map((MapFunction)new ProCostCmpAnalCalFunction());
            resultDs = DataSetXHelper.union(resultDs, resultSumDs);
        }
        resultDs = resultDs.filter("convamt!=0 or cmpconvamt!=0").orderBy(new String[]{"productnumber asc", "auxpty asc", "version asc", "costobjectnumber asc", "ordernum asc", "elementnumber asc", "subelement asc", "materialnumber asc"});
        DataSetOutput resultSet = new DataSetOutput(resultDs.getRowMeta());
        String resultId = resultSet.getId();
        resultDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    private DataSet getQueryDataSetCostType(Long cost_type_id, boolean viewSubitem, String calRecordName) {
        if (cost_type_id == 0L) {
            return null;
        }
        String selectFlelds = "material.id product, auxproperty auxpty, matvers version, entryentity.stdprice cmpconvamt, ";
        selectFlelds = this.SHOW_SUBELEMENT != false ? selectFlelds + "entryentity.element.id element, entryentity.element.number elementnumber, entryentity.subelement.id subelementid, entryentity.subelement.number subelement, entryentity.subelement.name subelementname, " : selectFlelds + "0L element, '' elementnumber, 0L subelementid, '' subelement, '' subelementname, ";
        String queryFs = "product,auxpty,version,cmpconvamt,element,elementnumber,subelementid,subelement,subelementname,case when submaterial is null then 0L else submaterial end submaterial,case when materialnumber is null then '' else materialnumber end materialnumber,case when matbaseunit is null then 0L else matbaseunit end matbaseunit,matversion,matauxpty";
        if (this.SHOW_MAT_DETAIL.booleanValue()) {
            selectFlelds = selectFlelds + "entryentity.submaterial submaterial, entryentity.submaterial.number materialnumber, entryentity.submatvers matversion, entryentity.submaterial.baseunit matbaseunit, entryentity.subauxproperty matauxpty, entryentity.qty cmpcomuse, entryentity.price cmpprice";
            queryFs = queryFs + ",cmpcomuse,cmpprice";
        } else {
            selectFlelds = selectFlelds + "0L submaterial, '' materialnumber, 0L matversion, 0L matbaseunit, 0L matauxpty";
        }
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(16);
        queryFilter.add(new QFilter("costtype", "=", (Object)cost_type_id));
        if (!CadEmptyUtils.isEmpty((String)calRecordName)) {
            queryFilter.add(new QFilter("calcrecord.name", "=", (Object)calRecordName));
        } else {
            QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            queryFilter.add(recordFilter);
        }
        if (viewSubitem) {
            queryFilter.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3"}));
        } else {
            queryFilter.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "4"}));
        }
        queryFilter.add(new QFilter("ismaindata", "=", (Object)1));
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getQueryDataSetCostType"), (String)"cad_calcsimulationresult", (String)selectFlelds, (QFilter[])queryFilter.toArray(new QFilter[0]), null).select(queryFs.split(","));
    }

    private DataSet getProCostDataSetInfo(List<QFilter> queryFilter, boolean viewSubitem) {
        String selectDetailFields = "billno,entryentity.type type,entryentity.relacostobject relacostobject,currency.amtprecision amtprecision, currency.priceprecision priceprecision, entryentity.relacostobject.material product,entryentity.relacostobject.material.number productnumber,entryentity.auxpty auxpty,entryentity.matversion version,entryentity.relacostobject.material.baseunit baseunit,entryentity.relacostobject.material.baseunit baseunithide,entryentity.relacostobject.material.baseunit.precision precision,entryentity.currcomqty currcomqty,entryentity.currcomamount convamt,";
        selectDetailFields = this.SHOW_COST_OBJECT != false ? selectDetailFields + "entryentity.relacostobject costobject, entryentity.relacostobject.billno costobjectnumber, " : selectDetailFields + "0L costobject, '' costobjectnumber, ";
        if (this.SHOW_SUBELEMENT.booleanValue()) {
            selectDetailFields = selectDetailFields + "entryentity.element element, entryentity.element.number elementnumber, entryentity.subelement subelementid, entryentity.subelement.number subelement, entryentity.subelement.name subelementname, ";
            if (viewSubitem) {
                selectDetailFields = selectDetailFields + "entryentity.subdetail.selement selement, entryentity.subdetail.selement.number selementnumber, entryentity.subdetail.ssubelement ssubelementid, entryentity.subdetail.ssubelement.number ssubelement, entryentity.subdetail.ssubelement.name ssubelementname, entryentity.subdetail.spdcomamt sconvamt, ";
            }
        } else {
            selectDetailFields = selectDetailFields + "0L element, '' elementnumber, 0L subelementid, '' subelement, '' subelementname, ";
        }
        String queryFs = "billno,type,relacostobject,amtprecision,priceprecision,product,productnumber,auxpty,version,baseunit,baseunithide,precision,currcomqty,convamt,costobject,costobjectnumber,element,elementnumber,subelementid,subelement,subelementname,case when submaterial is null then 0L else submaterial end submaterial,case when materialnumber is null then '' else materialnumber end materialnumber,case when matbaseunit is null then 0L else matbaseunit end matbaseunit,matversion,matauxpty";
        if (this.SHOW_MAT_DETAIL.booleanValue()) {
            selectDetailFields = selectDetailFields + "entryentity.submaterial submaterial, entryentity.submaterial.number materialnumber, entryentity.submaterial.baseunit matbaseunit, entryentity.submatversion matversion, entryentity.subauxpty matauxpty, entryentity.currcomqty convqty";
            queryFs = queryFs + ",convqty";
        } else {
            selectDetailFields = selectDetailFields + "0L submaterial, '' materialnumber, 0L matbaseunit, 0L matversion, 0L matauxpty";
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getProCostDataSetInfo"), (String)"aca_calcresult", (String)selectDetailFields, (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        if (viewSubitem) {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            fieldNames.removeAll(Arrays.asList("element", "elementnumber", "subelementid", "subelement", "subelementname", "selement", "selementnumber", "ssubelementid", "ssubelement", "ssubelementname", "convamt", "sconvamt"));
            fieldNames.add("case when ssubelementid>0 then selement else element end element");
            fieldNames.add("case when ssubelementid>0 then selementnumber else elementnumber end elementnumber");
            fieldNames.add("case when ssubelementid>0 then ssubelementid else subelementid end subelementid");
            fieldNames.add("case when ssubelementid>0 then ssubelement else subelement end subelement");
            fieldNames.add("case when ssubelementid>0 then ssubelementname else subelementname end subelementname");
            fieldNames.add("case when ssubelementid>0 then sconvamt else convamt end convamt");
            dataSet = dataSet.select(fieldNames.toArray(new String[0]));
        }
        dataSet = dataSet.select(queryFs.split(","));
        DataSet detailDataSet = dataSet.filter("type = 'detail'");
        DataSet finalDataSet = dataSet.filter("type = 'finalResult'").select(new String[]{"billno", "relacostobject", "product", "currcomqty convproqty"});
        DataSet result = detailDataSet.join(finalDataSet).on("billno", "billno").on("relacostobject", "relacostobject").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{"convproqty"}).finish();
        return result;
    }
}

