/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.common.ProPeriodCmpParam;
import kd.macc.aca.algox.report.function.ProDiffCalFunction;
import kd.macc.aca.algox.report.function.ProPeriodDealNullFunction;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;

public class ProPeriodCostCmpAnalRptAlgoxService {
    private static final Log logger = LogFactory.getLog(ProPeriodCostCmpAnalRptAlgoxService.class);

    public DataSet resultDataDeal(DataSet dataSetCurInfo, DataSet dataSetCmpInfo, ProPeriodCmpParam proPeriodCmpParam) {
        Boolean isElementDetail = proPeriodCmpParam.getIsElementDetail();
        Boolean isMaterialDetail = proPeriodCmpParam.getIsMaterialDetail();
        Boolean onlyMaterialType = proPeriodCmpParam.getOnlyMaterialType();
        JobSession session = AlgoX.createSession((String)"ProPeriodCostCmpAnal_rDD");
        DataSetX inputCurDs = session.fromInput((Input)new DataSetInput(dataSetCurInfo));
        DataSetX inputCmpDs = session.fromInput((Input)new DataSetInput(dataSetCmpInfo));
        DataSetX resultDs = null;
        if (onlyMaterialType.booleanValue()) {
            DataSetX matProductDs = this.getMatProductDs(inputCurDs, inputCmpDs);
            resultDs = isElementDetail != false ? this.getMatSubelementDs(inputCurDs, inputCmpDs, matProductDs) : matProductDs;
            resultDs = resultDs.groupBy(new String[]{"materialgroup"}).reduceGroup((GroupReduceFunction)new ProDiffCalFunction(resultDs.getRowMeta()));
            resultDs = isElementDetail.booleanValue() ? resultDs.orderBy(new String[]{"materialgroupnumber asc", "ordernum asc", "elementnumber asc", "subelement asc"}) : resultDs.orderBy(new String[]{"materialgroupnumber asc", "ordernum asc"});
        } else {
            DataSetX productDs = this.getProductDs(inputCurDs, inputCmpDs);
            resultDs = isElementDetail != false && isMaterialDetail != false ? this.getDetailDs(inputCurDs, inputCmpDs, productDs) : (isElementDetail != false && isMaterialDetail == false ? this.getSubelementDs(inputCurDs, inputCmpDs, productDs) : productDs);
            resultDs = resultDs.groupBy(new String[]{"product", "auxpty", "version"}).reduceGroup((GroupReduceFunction)new ProDiffCalFunction(resultDs.getRowMeta()));
            resultDs = isMaterialDetail != false ? resultDs.orderBy(new String[]{"materialgroupnumber asc", "productnumber asc", "auxpty asc", "version asc", "ordernum asc", "elementnumber asc", "subelement asc", "materialnumber asc"}) : (isElementDetail != false ? resultDs.orderBy(new String[]{"materialgroupnumber asc", "productnumber asc", "auxpty asc", "version asc", "ordernum asc", "elementnumber asc", "subelement asc"}) : resultDs.orderBy(new String[]{"materialgroupnumber asc", "productnumber asc", "auxpty asc", "version asc", "ordernum asc"}));
        }
        DataSetOutput resultSet = new DataSetOutput(resultDs.getRowMeta());
        String resultId = resultSet.getId();
        resultDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    private DataSetX getMatSubelementDs(DataSetX inputCurDs, DataSetX inputCmpDs, DataSetX matProductDs) {
        DataSetX subelementCurDs = inputCurDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("curcomcost").sum("curcomqty").addFields(new Field[]{new Field("cmpcomcost", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX subelementCmpDs = inputCmpDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("cmpcomcost").sum("cmpcomqty").addFields(new Field[]{new Field("curcomcost", (DataType)DataType.BigDecimalType), new Field("curcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX subelementDs = DataSetXHelper.union(subelementCurDs, subelementCmpDs).groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("curcomcost").sum("curcomqty").sum("cmpcomcost").sum("cmpcomqty").addFields(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("curcomuse", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curcomunitcost", (DataType)DataType.BigDecimalType), new Field("curcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcost", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpdiff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType)}, new Object[]{"detail", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", 1});
        subelementDs = subelementDs.leftJoin(matProductDs).on("materialgroup", "materialgroup").select(subelementDs.getRowMeta().getFieldNames(), new String[]{"curcalcomqty", "cmpcalcomqty"}).map((MapFunction)new ProPeriodDealNullFunction());
        return DataSetXHelper.union(subelementDs, matProductDs);
    }

    private DataSetX getSubelementDs(DataSetX inputCurDs, DataSetX inputCmpDs, DataSetX productDs) {
        DataSetX subelementCurDs = inputCurDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("curcomcost").sum("curcomqty").addFields(new Field[]{new Field("cmpcomcost", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX subelementCmpDs = inputCmpDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("cmpcomcost").sum("cmpcomqty").addFields(new Field[]{new Field("curcomcost", (DataType)DataType.BigDecimalType), new Field("curcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX subelementDs = DataSetXHelper.union(subelementCurDs, subelementCmpDs).groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname"}).sum("cmpcomcost").sum("cmpcomqty").sum("curcomcost").sum("curcomqty").addFields(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("matunit", (DataType)DataType.LongType), new Field("submatversion", (DataType)DataType.LongType), new Field("subauxpty", (DataType)DataType.LongType), new Field("matprecision", (DataType)DataType.IntegerType), new Field("curcomuse", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curcomunitcost", (DataType)DataType.BigDecimalType), new Field("curcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcost", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpdiff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType)}, new Object[]{"subelement", 0L, "", 0L, 0L, 0L, 0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", 1});
        subelementDs = subelementDs.leftJoin(productDs).on("product", "product").on("auxpty", "auxpty").on("version", "version").select(subelementDs.getRowMeta().getFieldNames(), new String[]{"curcalcomqty", "cmpcalcomqty"}).map((MapFunction)new ProPeriodDealNullFunction());
        return DataSetXHelper.union(subelementDs, productDs);
    }

    private DataSetX getDetailDs(DataSetX inputCurDs, DataSetX inputCmpDs, DataSetX productDs) {
        DataSetX detailCurDs = inputCurDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname", "material", "materialnumber", "matunit", "matprecision", "submatversion", "subauxpty"}).sum("curcomcost").sum("curcomqty").addFields(new Field[]{new Field("cmpcomcost", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX detailCmpDs = inputCmpDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname", "material", "materialnumber", "matunit", "matprecision", "submatversion", "subauxpty"}).sum("cmpcomcost").sum("cmpcomqty").addFields(new Field[]{new Field("curcomcost", (DataType)DataType.BigDecimalType), new Field("curcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX detailDs = DataSetXHelper.union(detailCurDs, detailCmpDs).groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "element", "elementnumber", "subelementid", "subelement", "subelementname", "material", "materialnumber", "matunit", "matprecision", "submatversion", "subauxpty"}).sum("curcomcost").sum("curcomqty").sum("cmpcomcost").sum("cmpcomqty").addFields(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("curcomuse", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curcomunitcost", (DataType)DataType.BigDecimalType), new Field("curcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcost", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpdiff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType)}, new Object[]{"detail", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", 1});
        detailDs = detailDs.leftJoin(productDs).on("product", "product").on("auxpty", "auxpty").on("version", "version").select(detailDs.getRowMeta().getFieldNames(), new String[]{"curcalcomqty", "cmpcalcomqty"}).map((MapFunction)new ProPeriodDealNullFunction());
        return DataSetXHelper.union(detailDs, productDs);
    }

    private DataSetX getProductDs(DataSetX inputCurDs, DataSetX inputCmpDs) {
        DataSetX productCurDs = inputCurDs.groupBy(new String[]{"billno", "relacostobject", "materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "curcalcomqty"}).sum("curcomcost");
        productCurDs = productCurDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision"}).sum("curcomcost").sum("curcalcomqty").addFields(new Field[]{new Field("curcomqty", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType), new Field("cmpcomcost", (DataType)DataType.BigDecimalType), new Field("cmpcalcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX productCmpDs = inputCmpDs.groupBy(new String[]{"billno", "relacostobject", "materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision", "cmpcalcomqty"}).sum("cmpcomcost");
        productCmpDs = productCmpDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision"}).sum("cmpcomcost").sum("cmpcalcomqty").addFields(new Field[]{new Field("curcomqty", (DataType)DataType.BigDecimalType), new Field("curcomcost", (DataType)DataType.BigDecimalType), new Field("curcalcomqty", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX productDs = DataSetXHelper.union(productCurDs, productCmpDs).groupBy(new String[]{"materialgroup", "materialgroupnumber", "product", "productnumber", "auxpty", "version", "baseunit", "unit", "amtprecision", "priceprecision"}).sum("curcomqty").sum("curcomcost").sum("curcalcomqty").sum("cmpcomqty").sum("cmpcomcost").sum("cmpcalcomqty").addFields(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelementid", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.StringType), new Field("subelementname", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("matunit", (DataType)DataType.LongType), new Field("matprecision", (DataType)DataType.IntegerType), new Field("submatversion", (DataType)DataType.LongType), new Field("subauxpty", (DataType)DataType.LongType), new Field("curcomuse", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curcomunitcost", (DataType)DataType.BigDecimalType), new Field("curcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcost", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpdiff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType)}, new Object[]{"finalResult", 0L, "", 0L, "", "", 0L, "", 0L, 0, 0L, 0L, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", 0});
        return productDs.map((MapFunction)new ProPeriodDealNullFunction());
    }

    private DataSetX getMatProductDs(DataSetX inputCurDs, DataSetX inputCmpDs) {
        DataSetX productCurDs = inputCurDs.groupBy(new String[]{"billno", "relacostobject", "materialgroup", "materialgroupnumber", "amtprecision", "priceprecision", "curcalcomqty"}).sum("curcomcost");
        productCurDs = productCurDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision"}).sum("curcomcost").sum("curcalcomqty").addFields(new Field[]{new Field("cmpcomcost", (DataType)DataType.BigDecimalType), new Field("cmpcalcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX productCmpDs = inputCmpDs.groupBy(new String[]{"billno", "relacostobject", "materialgroup", "materialgroupnumber", "amtprecision", "priceprecision", "cmpcalcomqty"}).sum("cmpcomcost");
        productCmpDs = inputCmpDs.groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision"}).sum("cmpcomcost").sum("cmpcalcomqty").addFields(new Field[]{new Field("curcomcost", (DataType)DataType.BigDecimalType), new Field("curcalcomqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX productDs = DataSetXHelper.union(productCurDs, productCmpDs).groupBy(new String[]{"materialgroup", "materialgroupnumber", "amtprecision", "priceprecision"}).sum("curcomcost").sum("curcalcomqty").sum("cmpcomcost").sum("cmpcalcomqty").addFields(new Field[]{new Field("type", (DataType)DataType.StringType), new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("subelementid", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.StringType), new Field("subelementname", (DataType)DataType.StringType), new Field("curcomqty", (DataType)DataType.BigDecimalType), new Field("cmpcomqty", (DataType)DataType.BigDecimalType), new Field("curcomuse", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curcomunitcost", (DataType)DataType.BigDecimalType), new Field("curcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpcomuse", (DataType)DataType.BigDecimalType), new Field("cmpprice", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcost", (DataType)DataType.BigDecimalType), new Field("cmpcomunitcostview", (DataType)DataType.BigDecimalType), new Field("cmpdiff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType), new Field("ordernum", (DataType)DataType.IntegerType)}, new Object[]{"finalResult", 0L, "", 0L, "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", 0});
        return productDs.map((MapFunction)new ProPeriodDealNullFunction());
    }

    public DataSet getDataSetResult(ProPeriodCmpParam proPeriodCmpParam) {
        long time = System.currentTimeMillis();
        DynamicObjectCollection mulMaterialGroup = proPeriodCmpParam.getMulMaterialGroup();
        DynamicObject materialGrpStd = proPeriodCmpParam.getMaterialGrpStd();
        DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(mulMaterialGroup, false, materialGrpStd);
        DataSet dataSetCurInfo = this.getQueryDataSetInfo(proPeriodCmpParam, Boolean.TRUE, materialDataSet);
        DataSet dataSetCmpInfo = this.getQueryDataSetInfo(proPeriodCmpParam, Boolean.FALSE, materialDataSet);
        logger.info("\u4ea7\u54c1\u671f\u95f4\u6210\u672c\u5bf9\u6bd4\u5206\u6790\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        DataSet dataSetInfo = this.resultDataDeal(dataSetCurInfo, dataSetCmpInfo, proPeriodCmpParam);
        logger.info("\u4ea7\u54c1\u671f\u95f4\u6210\u672c\u5bf9\u6bd4\u5206\u6790algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetInfo;
    }

    private DataSet getQueryDataSetInfo(ProPeriodCmpParam proPeriodCmpParam, Boolean isCur, DataSet materialDataSet) {
        String selectDetailFields = "billno,period,entryentity.type type,entryentity.relacostobject relacostobject,currency.amtprecision amtprecision,currency.priceprecision priceprecision,entryentity.relacostobject.material product,entryentity.relacostobject.material.number productnumber,entryentity.auxpty auxpty,entryentity.matversion version,entryentity.relacostobject.material.baseunit unit,entryentity.relacostobject.material.baseunit baseunit,entryentity.relacostobject.material.baseunit.precision precision,entryentity.element element,entryentity.element.number elementnumber,entryentity.subelement subelementid,entryentity.subelement.number subelement,entryentity.subelement.name subelementname,entryentity.submaterial material,entryentity.submaterial.number materialnumber,entryentity.submaterial.baseunit matunit,entryentity.submaterial.baseunit.precision matprecision,entryentity.submatversion submatversion,entryentity.subauxpty subauxpty,";
        if (proPeriodCmpParam.isViewSubitem()) {
            selectDetailFields = selectDetailFields + "entryentity.subdetail.selement selement,entryentity.subdetail.selement.number selementnumber,entryentity.subdetail.ssubelement ssubelementid,entryentity.subdetail.ssubelement.number ssubelement,entryentity.subdetail.ssubelement.name ssubelementname,";
        }
        String addSelectFieids = "";
        Long periodId = 0L;
        String resultField = "";
        String proQtyField = "";
        if (isCur.booleanValue()) {
            addSelectFieids = "entryentity.currcomqty curcomqty, entryentity.currcomamount curcomcost";
            if (proPeriodCmpParam.isViewSubitem()) {
                addSelectFieids = addSelectFieids + ",entryentity.subdetail.spdcomamt scurcomcost";
            }
            periodId = proPeriodCmpParam.getCurPeriod();
            proQtyField = "curcomqty";
            resultField = "curcalcomqty";
        } else {
            addSelectFieids = "entryentity.currcomqty cmpcomqty, entryentity.currcomamount cmpcomcost";
            if (proPeriodCmpParam.isViewSubitem()) {
                addSelectFieids = addSelectFieids + ",entryentity.subdetail.spdcomamt scmpcomcost";
            }
            periodId = proPeriodCmpParam.getCmpPeriod();
            proQtyField = "cmpcomqty";
            resultField = "cmpcalcomqty";
        }
        selectDetailFields = selectDetailFields + addSelectFieids;
        DataSet dataSet = this.getCalcResultDataSet(proPeriodCmpParam.getQueryFilter(), periodId, selectDetailFields);
        if (proPeriodCmpParam.isViewSubitem()) {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            fieldNames.removeAll(Arrays.asList("element", "elementnumber", "subelementid", "subelement", "subelementname", "selement", "selementnumber", "ssubelementid", "ssubelement", "ssubelementname"));
            fieldNames.add("case when ssubelementid>0 then selement else element end element");
            fieldNames.add("case when ssubelementid>0 then selementnumber else elementnumber end elementnumber");
            fieldNames.add("case when ssubelementid>0 then ssubelementid else subelementid end subelementid");
            fieldNames.add("case when ssubelementid>0 then ssubelement else subelement end subelement");
            fieldNames.add("case when ssubelementid>0 then ssubelementname else subelementname end subelementname");
            if (isCur.booleanValue()) {
                fieldNames.removeAll(Arrays.asList("curcomcost", "scurcomcost", "curcomqty"));
                fieldNames.add("case when ssubelementid>0 then 0 else curcomqty end as curcomqty");
                fieldNames.add("case when ssubelementid>0 then scurcomcost else curcomcost end curcomcost");
            } else {
                fieldNames.removeAll(Arrays.asList("cmpcomcost", "scmpcomcost", "cmpcomqty"));
                fieldNames.add("case when ssubelementid>0 then 0 else cmpcomqty end as cmpcomqty");
                fieldNames.add("case when ssubelementid>0 then scmpcomcost else cmpcomcost end cmpcomcost");
            }
            dataSet = dataSet.select(fieldNames.toArray(new String[0]));
        }
        dataSet = isCur != false ? dataSet.filter("curcomqty != 0 or curcomcost !=0") : dataSet.filter("cmpcomqty != 0 or cmpcomcost !=0");
        DataSet detailDataSet = dataSet.filter("type = 'detail'");
        DataSet finalDataSet = dataSet.filter("type = 'finalResult'").select(new String[]{"billno", "period", "relacostobject", "product", proQtyField + " " + resultField});
        DataSet result = detailDataSet.join(finalDataSet).on("billno", "billno").on("period", "period").on("relacostobject", "relacostobject").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{resultField}).finish();
        result = result.join(materialDataSet).on("product", "material").select(result.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber"}).finish();
        return result;
    }

    private DataSet getCalcResultDataSet(List<QFilter> queryFilter, Long periodId, String selectFields) {
        ArrayList<QFilter> queryDetailFilter = new ArrayList<QFilter>(16);
        queryDetailFilter.addAll(queryFilter);
        queryDetailFilter.add(new QFilter("period", "=", (Object)periodId));
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getQueryDataSetInfo"), (String)"aca_calcresult", (String)selectFields, (QFilter[])queryDetailFilter.toArray(new QFilter[0]), null);
    }

    protected String getAlgoKey(String methodName) {
        return this.getClass().getName() + "." + methodName;
    }
}

