/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.function.MatTypeSumDataDealFunction;
import kd.macc.aca.algox.report.function.ProSumCostFunction;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProSumCostQueryRptAlgoxService {
    private static final Log logger = LogFactory.getLog(ProSumCostQueryRptAlgoxService.class);
    private static final String DYNAMIC_PREFIX = "range";
    private static final String PRICE_DIV_VALUE = "(case when baseqty != 0 and (amount / baseqty) != null then (amount / baseqty) else 0 end) as price";

    public DataSet getDataSetResult(List<QFilter> queryFilter, DynamicObject materialGrpStd, DynamicObjectCollection mulMaterialGroup, Map<String, Object> params) {
        long time = System.currentTimeMillis();
        DataSet dataSetInfo = this.getProCostDataSetInfo(queryFilter, mulMaterialGroup, materialGrpStd, params);
        logger.info("\u4ea7\u54c1\u6c47\u603b\u6210\u672c\u67e5\u8be2\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return dataSetInfo;
    }

    private DataSet getProCostDataSetInfo(List<QFilter> queryFilter, DynamicObjectCollection mulMaterialGroup, DynamicObject materialGrpStd, Map<String, Object> params) {
        String rangeKey;
        DataSet costDataSet;
        boolean onlyMaterialType = (Boolean)params.get("onlyMaterialType");
        String reportContent = (String)params.get("reportcontent");
        String elementLevel = (String)params.get("elementlevel");
        Set rangeKeys = (Set)params.get("rangeKeys");
        Set selectElementOrSubIds = (Set)params.get("selectElementOrSubIds");
        boolean viewsubitem = (Boolean)params.get("viewsubitem");
        ORM orm = ORM.create();
        String algoKey = this.getClass().getName() + ".query";
        String selectFields = "id, billno, period AS periodid,period.name AS period,costcenter,costcenter.number costcenternum,costcenter.name costcentername, costobject,entryentity.relacostobject relacostobject,entryentity.relacostobject.material.id material, entryentity.relacostobject.auxpty auxpty, entryentity.relacostobject.bomversion matversion, entryentity.relacostobject.material.baseunit baseunit, entryentity.type AS type,entryentity.element as element,entryentity.element.number as elementnumber,entryentity.element.name as elementname,entryentity.subelement as subelement,entryentity.subelement.number as subelementnumber,entryentity.subelement.name as subelementname";
        if (viewsubitem) {
            selectFields = selectFields + ",entryentity.subdetail.selement as selement,entryentity.subdetail.selement.number as selementnumber,entryentity.subdetail.selement.name as selementname,entryentity.subdetail.ssubelement as ssubelement,entryentity.subdetail.ssubelement.number as ssubelementnumber,entryentity.subdetail.ssubelement.name as ssubelementname";
        }
        String qtyField = "";
        switch (reportContent) {
            case "A": {
                qtyField = ",entryentity.currcomqty as baseqty, entryentity.currcomamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdcomamt samount";
                break;
            }
            case "B": {
                qtyField = ",entryentity.pdstartqty as baseqty, entryentity.pdstartamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdstartamt samount";
                break;
            }
            case "C": {
                qtyField = ",entryentity.startadjqty as baseqty, entryentity.startadjamt as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdstartadjamt samount";
                break;
            }
            case "D": {
                qtyField = ",entryentity.pdcurrqty as baseqty, entryentity.pdcurramount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdcurramt samount";
                break;
            }
            case "E": {
                qtyField = ",entryentity.pdsumqty as baseqty, entryentity.pdsumamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdsumamt samount";
                break;
            }
            case "F": {
                qtyField = ",entryentity.yearpdsumqty as baseqty, entryentity.yearpdsumamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdyearsumamt samount";
                break;
            }
            case "G": {
                qtyField = ",entryentity.pdendqty as baseqty, entryentity.pdendamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdendamt samount";
                break;
            }
            case "H": {
                qtyField = ",entryentity.endadjqty as baseqty, entryentity.endadjamt as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdendadjamt samount";
                break;
            }
            case "I": {
                qtyField = ",entryentity.sumcomqty as baseqty, entryentity.sumcomamount as amount";
                if (!viewsubitem) break;
                qtyField = qtyField + ",entryentity.subdetail.spdsumcomamt samount";
                break;
            }
        }
        selectFields = selectFields + qtyField;
        DataSet dataSet = orm.queryDataSet(algoKey, "aca_calcresult", selectFields, queryFilter.toArray(new QFilter[0]));
        if (viewsubitem) {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            fieldNames.removeAll(Arrays.asList("element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "selement", "selementnumber", "selementname", "ssubelement", "ssubelementnumber", "ssubelementname", "samount", "amount"));
            fieldNames.add("case when ssubelement>0 then selement else element end element");
            fieldNames.add("case when ssubelement>0 then selementnumber else elementnumber end elementnumber");
            fieldNames.add("case when ssubelement>0 then selementname else elementname end elementname");
            fieldNames.add("case when ssubelement>0 then ssubelement else subelement end subelement");
            fieldNames.add("case when ssubelement>0 then ssubelementnumber else subelementnumber end subelementnumber");
            fieldNames.add("case when ssubelement>0 then ssubelementname else subelementname end subelementname");
            fieldNames.add("case when ssubelement>0 then samount else amount end amount");
            dataSet = dataSet.select(fieldNames.toArray(new String[0]));
        }
        if (!(costDataSet = (dataSet = dataSet.filter("baseqty!=0 or amount != 0")).copy().filter("type = 'finalResult'")).isEmpty()) {
            DataSet detailDataSet = dataSet.filter("type != 'finalResult'").filter("material is not null and material != 0");
            if (!CadEmptyUtils.isEmpty((Set)selectElementOrSubIds)) {
                StringBuilder sb = "A".equals(elementLevel) ? new StringBuilder("element in(") : new StringBuilder("subelement in(");
                boolean isFirst = true;
                for (Long selectId : selectElementOrSubIds) {
                    if (!isFirst) {
                        sb.append(",");
                    }
                    sb.append(selectId);
                    isFirst = false;
                }
                sb.append(")");
                detailDataSet = detailDataSet.filter(sb.toString());
            }
            dataSet = ProSumCostQueryRptAlgoxService.union(costDataSet, detailDataSet);
        }
        HashMap<String, String> matTypeMap = new HashMap<String, String>(16);
        Integer level = (Integer)params.get("level");
        if (level > 0) {
            Long orgId = (Long)params.get("orgId");
            DynamicObject materialGroup = null;
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulMaterialGroup)) {
                materialGroup = (DynamicObject)mulMaterialGroup.get(0);
            }
            mulMaterialGroup = this.getMaterialGroup(materialGrpStd, materialGroup, level, matTypeMap, orgId);
        }
        DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(mulMaterialGroup, false, materialGrpStd);
        DataSet dealDs = dataSet.join(materialDataSet).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber", "longnumber"}).finish().addField("0.0", "price");
        StringBuilder resultField = new StringBuilder("periodid,period,costcenter,costcenternum,costcentername,materialgroup,materialgroupnumber,material,baseunit,matversion,auxpty,baseqty,price,amount");
        for (Long range : rangeKeys) {
            rangeKey = DYNAMIC_PREFIX + range;
            dealDs = dealDs.addField("0.0", rangeKey);
            resultField.append(",").append(rangeKey);
        }
        JobSession session = AlgoX.createSession((String)"getProCostDataSetInfo");
        DataSetInput processingAllocInput = new DataSetInput(dealDs);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        if (level > 0) {
            String longNumberDLM = MaterialGroupHelper.getLongNumberDLM();
            dataSetX = dataSetX.map((MapFunction)new MatTypeSumDataDealFunction(matTypeMap, longNumberDLM));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("elementLevel", elementLevel);
        paramMap.put("reportContent", reportContent);
        paramMap.put("selectElementOrSubIds", selectElementOrSubIds);
        ProSumCostFunction function = new ProSumCostFunction(dealDs.getRowMeta(), paramMap);
        DataSetX mainDataSet = dataSetX.groupBy(new String[]{"periodid", "costcenter", "costcenternum", "costcentername", "materialgroup", "material", "matversion", "auxpty"}).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(dealDs.getRowMeta());
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = session.readDataSet(resultId);
        if (onlyMaterialType) {
            DataSet materialGroupDs = resultDs.copy();
            resultDs = resultDs.groupBy(new String[]{"periodid", "period", "costcenter", "costcenternum", "costcentername", "materialgroup", "materialgroupnumber"}).sum("baseqty").sum("amount").finish();
            resultDs = resultDs.select(new String[]{"periodid", "period", "costcenter", "costcenternum", "costcentername", "materialgroup", "materialgroupnumber", "baseqty", "amount", PRICE_DIV_VALUE}).addNullField(new String[]{"material", "baseunit", "matversion", "auxpty"});
            for (Long range : rangeKeys) {
                rangeKey = DYNAMIC_PREFIX + range;
                DataSet tempDs = materialGroupDs.groupBy(new String[]{"periodid", "costcenter", "costcenternum", "costcentername", "materialgroup"}).sum(rangeKey).finish();
                resultDs = resultDs.leftJoin(tempDs).on("periodid", "periodid").on("costcenter", "costcenter").on("materialgroup", "materialgroup").select(resultDs.getRowMeta().getFieldNames(), new String[]{rangeKey}).finish();
            }
        }
        resultDs = resultDs.select(resultField.toString());
        DataSet totalResultDs = resultDs.copy().addNullField(new String[]{"totalorder", "cenorder", "ordercm"});
        String countStr = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"ProSumCostQueryRptAlgoxService_1", (String)"macc-aca-algox", (Object[])new Object[0]);
        DataSet concneterTotal = resultDs.copy().groupBy(new String[]{"periodid", "period", "costcenter", "costcenternum", "costcentername"}).sum("baseqty").sum("amount").finish().select("periodid,period,costcenter,costcenternum,concat(costcentername, " + countStr + ") as costcentername,baseqty,amount,'1' cenorder,'1' ordercm," + PRICE_DIV_VALUE);
        concneterTotal = concneterTotal.addNullField(new String[]{"materialgroup", "materialgroupnumber", "material", "baseunit", "matversion", "auxpty", "totalorder"});
        for (Object range : rangeKeys) {
            rangeKey = DYNAMIC_PREFIX + range;
            DataSet tempDs = resultDs.copy().groupBy(new String[]{"periodid", "costcenter"}).sum(rangeKey).finish();
            concneterTotal = concneterTotal.leftJoin(tempDs).on("periodid", "periodid").on("costcenter", "costcenter").select(concneterTotal.getRowMeta().getFieldNames(), new String[]{rangeKey}).finish();
        }
        DataSet periodTotal = resultDs.groupBy(new String[]{"periodid", "period"}).sum("baseqty").sum("amount").finish().select("concat(period, " + countStr + ") as period, periodid,baseqty,amount,'1' totalorder,'1' ordercm," + PRICE_DIV_VALUE);
        periodTotal = periodTotal.addNullField(new String[]{"materialgroup", "costcenter", "costcenternum", "costcentername", "materialgroupnumber", "material", "baseunit", "matversion", "auxpty", "cenorder"});
        for (Long range : rangeKeys) {
            rangeKey = DYNAMIC_PREFIX + range;
            DataSet tempDs = resultDs.groupBy(new String[]{"periodid"}).sum(rangeKey).finish();
            periodTotal = periodTotal.leftJoin(tempDs).on("periodid", "periodid").select(periodTotal.getRowMeta().getFieldNames(), new String[]{rangeKey}).finish();
        }
        DataSet tempPeriodTotal = periodTotal.copy();
        totalResultDs = ProSumCostQueryRptAlgoxService.union(totalResultDs, concneterTotal);
        totalResultDs = ProSumCostQueryRptAlgoxService.union(totalResultDs, periodTotal);
        totalResultDs = totalResultDs.orderBy(new String[]{"periodid DESC", "totalorder ASC", "costcenternum ASC", "cenorder ASC", "materialgroupnumber ASC", "material ASC"});
        List<Object[]> totalList = this.count(tempPeriodTotal, rangeKeys);
        if (totalList != null) {
            DataSet totalDs = Algo.create((String)"macc.aca.ProSumCostQueryRptAlgoxService").createDataSet(totalList.iterator(), this.getRowMeta(rangeKeys));
            totalResultDs = ProSumCostQueryRptAlgoxService.union(totalResultDs, totalDs);
        }
        return totalResultDs;
    }

    private DynamicObjectCollection getMaterialGroup(DynamicObject materialGrpStd, DynamicObject materialGroup, Integer level, Map<String, String> matTypeMap, Long orgId) {
        ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
        createOrgIds.add(orgId);
        QFilter groupFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialGrpStd.getLong("id"), false});
        int size = level;
        String longNumberDLM = MaterialGroupHelper.getLongNumberDLM();
        if (materialGroup != null) {
            String groupLongNum = materialGroup.getString("longnumber");
            size = level + groupLongNum.split(longNumberDLM).length - 1;
            QFilter levelFilter = new QFilter("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            levelFilter.or(new QFilter("longnumber", "=", (Object)groupLongNum));
            groupFilter.and(levelFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])groupFilter.toArray(), (String)"number asc");
        HashSet<Long> ids = new HashSet<Long>(50);
        for (DynamicObject obj : dynamicObjects) {
            String longnumber = obj.getString("longnumber");
            int tempSize = longnumber.split(longNumberDLM).length;
            Boolean isLeaf = obj.getBoolean("isleaf");
            if (tempSize != size && (tempSize >= size || !isLeaf.booleanValue())) continue;
            Long id = obj.getLong("id");
            ids.add(id);
            String number = obj.getString("number");
            matTypeMap.put(longnumber, number + " / " + id);
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])idsFilter.toArray(), (String)"number asc");
    }

    protected List<Object[]> count(DataSet periodTotal, Set<Long> rangeKeys) {
        if (periodTotal == null || periodTotal.copy().isEmpty()) {
            return null;
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> rangeTotalAmount = new HashMap<String, BigDecimal>();
        for (Row row : periodTotal) {
            BigDecimal baseQty = row.getBigDecimal("baseqty");
            totalQty = totalQty.add(baseQty);
            BigDecimal amount = row.getBigDecimal("amount");
            totalAmount = totalAmount.add(amount);
            for (Long range : rangeKeys) {
                String rangeKey = DYNAMIC_PREFIX + range;
                BigDecimal rangeAmount = row.getBigDecimal(rangeKey);
                if (rangeTotalAmount.get(rangeKey) != null) {
                    rangeAmount = rangeAmount.add((BigDecimal)rangeTotalAmount.get(rangeKey));
                }
                rangeTotalAmount.put(rangeKey, rangeAmount);
            }
        }
        Object[] totalCountRowData = new Object[this.getRowMeta(rangeKeys).getFields().length];
        totalCountRowData[this.getListFieldIndex((String)"period", rangeKeys)] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ProSumCostQueryRptAlgoxService_2", (String)"macc-aca-algox", (Object[])new Object[0]);
        totalCountRowData[this.getListFieldIndex((String)"totalorder", rangeKeys)] = "2";
        totalCountRowData[this.getListFieldIndex((String)"baseqty", rangeKeys)] = totalQty;
        totalCountRowData[this.getListFieldIndex((String)"price", rangeKeys)] = totalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalAmount.divide(totalQty, 10, RoundingMode.HALF_UP);
        totalCountRowData[this.getListFieldIndex((String)"amount", rangeKeys)] = totalAmount;
        for (Map.Entry entry : rangeTotalAmount.entrySet()) {
            totalCountRowData[this.getListFieldIndex((String)((String)entry.getKey()), rangeKeys)] = entry.getValue();
        }
        dataList.add(totalCountRowData);
        return dataList;
    }

    private static DataSet union(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 == null && dataSet2 == null) {
            return null;
        }
        if (dataSet1 == null) {
            return dataSet2;
        }
        if (dataSet2 == null) {
            return dataSet1;
        }
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        DataSet result = dataSet1.union(dataSet2);
        return result;
    }

    public static boolean isEmpty(BigDecimal object) {
        return object == null || object.compareTo(BigDecimal.ZERO) == 0;
    }

    private RowMeta getRowMeta(Set<Long> rangeKeys) {
        List<Field> field = this.getRowMetaField(rangeKeys);
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField(Set<Long> rangeKeys) {
        ArrayList<Field> field = new ArrayList<Field>(16);
        field.add(new Field("periodid", (DataType)DataType.LongType));
        field.add(new Field("period", (DataType)DataType.StringType));
        field.add(new Field("costcenter", (DataType)DataType.LongType));
        field.add(new Field("costcenternum", (DataType)DataType.StringType));
        field.add(new Field("costcentername", (DataType)DataType.StringType));
        field.add(new Field("materialgroup", (DataType)DataType.LongType));
        field.add(new Field("materialgroupnumber", (DataType)DataType.StringType));
        field.add(new Field("material", (DataType)DataType.LongType));
        field.add(new Field("baseunit", (DataType)DataType.LongType));
        field.add(new Field("matversion", (DataType)DataType.LongType));
        field.add(new Field("auxpty", (DataType)DataType.LongType));
        field.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("price", (DataType)DataType.BigDecimalType));
        field.add(new Field("amount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalorder", (DataType)DataType.StringType));
        field.add(new Field("cenorder", (DataType)DataType.StringType));
        field.add(new Field("ordercm", (DataType)DataType.StringType));
        for (Long range : rangeKeys) {
            String rangeKey = DYNAMIC_PREFIX + range;
            field.add(new Field(rangeKey, (DataType)DataType.BigDecimalType));
        }
        return field;
    }

    private int getListFieldIndex(String field, Set<Long> rangeKeys) {
        Field[] fields = this.getRowMeta(rangeKeys).getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }
}

