/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ProBehaviorSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;
    private Boolean isProductSum = Boolean.FALSE;

    public ProBehaviorSumFunction(RowMeta rowMeta, Boolean isProductSum) {
        this.rowMeta = rowMeta;
        this.isProductSum = isProductSum;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        Iterator<RowX> it = rows.iterator();
        BigDecimal totalStorageCost = BigDecimal.ZERO;
        int sumcol = this.rowMeta.getFieldIndex("storagecost");
        BigDecimal totalStdPriceCost = BigDecimal.ZERO;
        int sumstd = this.rowMeta.getFieldIndex("standardprice");
        RowX targetRow = null;
        while (it.hasNext()) {
            RowX row = it.next();
            if (targetRow == null) {
                targetRow = new RowX(row.size());
                for (int i = 0; i < row.size(); ++i) {
                    targetRow.set(i, row.get(i));
                }
            }
            BigDecimal storageCost = BigDecimalUtil.getOrZero(row.getBigDecimal(sumcol));
            totalStorageCost = totalStorageCost.add(storageCost);
            BigDecimal stdPrice = BigDecimalUtil.getOrZero(row.getBigDecimal(sumstd));
            totalStdPriceCost = totalStdPriceCost.add(stdPrice);
        }
        if (targetRow != null) {
            targetRow.set(this.rowMeta.getFieldIndex("element"), (Object)0L);
            targetRow.set(this.rowMeta.getFieldIndex("subelementid"), (Object)0L);
            targetRow.set(this.rowMeta.getFieldIndex("subelement"), (Object)"");
            targetRow.set(this.rowMeta.getFieldIndex("subelementname"), (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ProBehaviorSumFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]));
            targetRow.set(this.rowMeta.getFieldIndex("datatype"), (Object)"behavior");
            if (this.isProductSum.booleanValue()) {
                targetRow.set(this.rowMeta.getFieldIndex("costbehavior"), (Object)"");
                targetRow.set(this.rowMeta.getFieldIndex("datatype"), (Object)"product");
            }
            targetRow.set(sumcol, (Object)totalStorageCost);
            targetRow.set(sumstd, (Object)totalStdPriceCost);
            collector.collect(targetRow);
        }
    }
}

