/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ProCostCmpAnalCalFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX rowx) {
        int convProQtyIndex = this.getSourceRowMeta().getFieldIndex("convproqty");
        int convQtyIndex = this.getSourceRowMeta().getFieldIndex("convqty");
        int convAmtIndex = this.getSourceRowMeta().getFieldIndex("convamt");
        int convAmtShowIndex = this.getSourceRowMeta().getFieldIndex("convamtshow");
        int priceIndex = this.getSourceRowMeta().getFieldIndex("price");
        int comuseIndex = this.getSourceRowMeta().getFieldIndex("comuse");
        int cmpComuseIndex = this.getSourceRowMeta().getFieldIndex("cmpcomuse");
        int cmpPriceIndex = this.getSourceRowMeta().getFieldIndex("cmpprice");
        int cmpConvQtyIndex = this.getSourceRowMeta().getFieldIndex("cmpconvqty");
        int cmpConvAmtIndex = this.getSourceRowMeta().getFieldIndex("cmpconvamt");
        int cmpConvAmtShowIndex = this.getSourceRowMeta().getFieldIndex("cmpconvamtshow");
        int matQtyDiffIndex = this.getSourceRowMeta().getFieldIndex("matqtydiff");
        int matAmtDiffIndex = this.getSourceRowMeta().getFieldIndex("matamtdiff");
        int allDiffIndex = this.getSourceRowMeta().getFieldIndex("alldiff");
        int allDiffRateIndex = this.getSourceRowMeta().getFieldIndex("alldiffrate");
        int allDiffShowIndex = this.getSourceRowMeta().getFieldIndex("alldiffshow");
        int dataTypeIndex = this.getSourceRowMeta().getFieldIndex("datatype");
        BigDecimal cmpConvAmt = BigDecimalUtil.getOrZero(rowx.get(cmpConvAmtIndex));
        BigDecimal convProQty = BigDecimalUtil.getOrZero(rowx.get(convProQtyIndex));
        BigDecimal convAmt = BigDecimalUtil.getOrZero(rowx.get(convAmtIndex));
        rowx.set(convAmtShowIndex, (Object)convAmt);
        BigDecimal cmpConvAmtCal = cmpConvAmt.multiply(convProQty).setScale(10, 4);
        if ("sum".equals(rowx.get(dataTypeIndex))) {
            int ordernum = (Integer)rowx.get(this.getSourceRowMeta().getFieldIndex("ordernum"));
            if (ordernum == 0) {
                cmpConvAmtCal = cmpConvAmt;
            }
            rowx.set(cmpConvAmtIndex, (Object)cmpConvAmtCal);
            rowx.set(cmpConvAmtShowIndex, (Object)cmpConvAmtCal);
            BigDecimal allDiff = convAmt.subtract(cmpConvAmtCal);
            String allDiffRate = this.getDiffRate(allDiff, cmpConvAmtCal);
            rowx.set(allDiffIndex, (Object)allDiff);
            rowx.set(allDiffRateIndex, (Object)allDiffRate);
            rowx.set(allDiffShowIndex, (Object)allDiff);
            rowx.set(convQtyIndex, (Object)convProQty);
            BigDecimal price = BigDecimalUtil.getDevideCal(convAmt, convProQty, 10);
            rowx.set(priceIndex, (Object)price);
            if (cmpConvAmtCal.compareTo(BigDecimal.ZERO) == 0) {
                rowx.set(cmpPriceIndex, (Object)BigDecimal.ZERO);
                rowx.set(cmpConvQtyIndex, (Object)BigDecimal.ZERO);
            } else {
                rowx.set(cmpPriceIndex, (Object)BigDecimalUtil.getDevideCal(cmpConvAmtCal, convProQty, 10));
                rowx.set(cmpConvQtyIndex, (Object)convProQty);
            }
        } else {
            rowx.set(cmpConvAmtIndex, (Object)cmpConvAmtCal);
            rowx.set(cmpConvAmtShowIndex, (Object)cmpConvAmtCal);
            BigDecimal allDiff = convAmt.subtract(cmpConvAmtCal);
            String allDiffRate = this.getDiffRate(allDiff, cmpConvAmtCal);
            rowx.set(allDiffIndex, (Object)allDiff);
            rowx.set(allDiffRateIndex, (Object)allDiffRate);
            rowx.set(allDiffShowIndex, (Object)allDiff);
            BigDecimal convQty = BigDecimalUtil.getOrZero(rowx.get(convQtyIndex));
            BigDecimal comuse = BigDecimalUtil.getDevideCal(convQty, convProQty, 10);
            rowx.set(comuseIndex, (Object)comuse);
            BigDecimal price = BigDecimalUtil.getDevideCal(convAmt, convQty, 10);
            rowx.set(priceIndex, (Object)price);
            BigDecimal cmpComuse = BigDecimalUtil.getOrZero(rowx.get(cmpComuseIndex));
            BigDecimal cmpPrice = BigDecimalUtil.getOrZero(rowx.get(cmpPriceIndex));
            BigDecimal cmpConvQty = cmpComuse.multiply(convProQty).setScale(10, 4);
            rowx.set(cmpConvQtyIndex, (Object)cmpConvQty);
            Long submaterial = (Long)rowx.get(this.getSourceRowMeta().getFieldIndex("submaterial"));
            if (submaterial != null && submaterial > 0L) {
                BigDecimal matQtyDiff = convQty.subtract(cmpConvQty).multiply(cmpPrice).setScale(10, 4);
                BigDecimal matAmtDiff = price.subtract(cmpPrice).multiply(convQty).setScale(10, 4);
                rowx.set(matQtyDiffIndex, (Object)matQtyDiff);
                rowx.set(matAmtDiffIndex, (Object)matAmtDiff);
            }
        }
        return rowx;
    }

    private String getDiffRate(BigDecimal numerator, BigDecimal denominator) {
        String ratioStr = "";
        if (numerator != null && denominator != null && denominator.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal ratio = numerator.multiply(BigDecimal.valueOf(100L)).divide(denominator, 2, 4);
            ratioStr = ratio + "%";
        }
        return ratioStr;
    }
}

