/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ProDiffCalFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;

    public ProDiffCalFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        Iterator<RowX> it = rows.iterator();
        BigDecimal curCalComQty = BigDecimal.ZERO;
        BigDecimal cmpCalComQty = BigDecimal.ZERO;
        BigDecimal curComqty = BigDecimal.ZERO;
        BigDecimal cmpComqty = BigDecimal.ZERO;
        BigDecimal curComCost = BigDecimal.ZERO;
        BigDecimal cmpComCost = BigDecimal.ZERO;
        BigDecimal curComUnitCost = BigDecimal.ZERO;
        BigDecimal cmpComUnitCost = BigDecimal.ZERO;
        BigDecimal curPrice = BigDecimal.ZERO;
        BigDecimal cmpPrice = BigDecimal.ZERO;
        BigDecimal curComUse = BigDecimal.ZERO;
        BigDecimal cmpComUse = BigDecimal.ZERO;
        BigDecimal cmpDiff = BigDecimal.ZERO;
        String diffRate = "";
        int amtPrecision = 0;
        int pricePrecision = 0;
        ArrayList targetRows = Lists.newArrayList();
        while (it.hasNext()) {
            RowX row = it.next();
            curCalComQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("curcalcomqty")));
            curComCost = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("curcomcost")));
            cmpCalComQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("cmpcalcomqty")));
            cmpComCost = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("cmpcomcost")));
            amtPrecision = row.getInteger(this.rowMeta.getFieldIndex("amtprecision"));
            pricePrecision = row.getInteger(this.rowMeta.getFieldIndex("priceprecision"));
            curComUnitCost = BigDecimalUtil.getDevideCal(curComCost, curCalComQty, amtPrecision);
            cmpComUnitCost = BigDecimalUtil.getDevideCal(cmpComCost, cmpCalComQty, amtPrecision);
            row.set(this.rowMeta.getFieldIndex("curcomunitcost"), (Object)curComUnitCost);
            row.set(this.rowMeta.getFieldIndex("curcomunitcostview"), (Object)curComUnitCost);
            row.set(this.rowMeta.getFieldIndex("cmpcomunitcost"), (Object)cmpComUnitCost);
            row.set(this.rowMeta.getFieldIndex("cmpcomunitcostview"), (Object)cmpComUnitCost);
            cmpDiff = cmpComUnitCost.subtract(curComUnitCost).abs();
            diffRate = this.getDiffRate(cmpDiff, cmpComUnitCost);
            row.set(this.rowMeta.getFieldIndex("cmpdiff"), (Object)cmpDiff);
            row.set(this.rowMeta.getFieldIndex("diffRate"), (Object)diffRate);
            if (row.getInteger(this.rowMeta.getFieldIndex("ordernum")) != 0) {
                curComqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("curcomqty")));
                cmpComqty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("cmpcomqty")));
                curComUse = BigDecimalUtil.getDevideCal(curComqty, curCalComQty, 10);
                cmpComUse = BigDecimalUtil.getDevideCal(cmpComqty, cmpCalComQty, 10);
                curPrice = BigDecimalUtil.getDevideCal(curComUnitCost, curComUse, pricePrecision);
                cmpPrice = BigDecimalUtil.getDevideCal(cmpComUnitCost, cmpComUse, pricePrecision);
                row.set(this.rowMeta.getFieldIndex("curcomuse"), (Object)curComUse);
                row.set(this.rowMeta.getFieldIndex("cmpcomuse"), (Object)cmpComUse);
                row.set(this.rowMeta.getFieldIndex("curprice"), (Object)curPrice);
                row.set(this.rowMeta.getFieldIndex("cmpprice"), (Object)cmpPrice);
            }
            targetRows.add(row);
        }
        for (RowX row : targetRows) {
            collector.collect(row);
        }
    }

    private String getDiffRate(BigDecimal cmpDiff, BigDecimal cmpComUnitCost) {
        String diffRate = "0.00%";
        if (cmpDiff.compareTo(BigDecimal.ZERO) != 0 && cmpComUnitCost.compareTo(BigDecimal.ZERO) == 0) {
            diffRate = "100.00%";
        } else if (cmpComUnitCost.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal ratio = cmpDiff.multiply(BigDecimal.valueOf(100L)).divide(cmpComUnitCost, 2, 4);
            diffRate = ratio + "%";
        }
        return diffRate;
    }
}

