/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ProSumCostFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String DYNAMIC_PREFIX = "range";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;

    public ProSumCostFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        String elementLevel = (String)this.paramMap.get("elementLevel");
        Iterator<RowX> it = rows.iterator();
        ArrayList targetRows = Lists.newArrayList();
        HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        while (it.hasNext()) {
            RowX row = it.next();
            long elementOrSubElementId = "A".equals(elementLevel) ? row.getLong(this.rowMeta.getFieldIndex("element")).longValue() : row.getLong(this.rowMeta.getFieldIndex("subelement")).longValue();
            BigDecimal elementOrSubElementAmount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
            if (targetRows.size() < 1) {
                targetRows.add(row);
            }
            if ("finalResult".equals(row.getString(this.rowMeta.getFieldIndex("type")))) {
                totalQty = totalQty.add(row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty")));
                continue;
            }
            totalAmount = totalAmount.add(row.getBigDecimal(this.rowMeta.getFieldIndex("amount")));
            if (amountMap.get(elementOrSubElementId) != null) {
                BigDecimal amount = (BigDecimal)amountMap.get(elementOrSubElementId);
                elementOrSubElementAmount = elementOrSubElementAmount.add(amount);
            }
            amountMap.put(elementOrSubElementId, elementOrSubElementAmount);
        }
        for (RowX row : targetRows) {
            for (Map.Entry entrySet : amountMap.entrySet()) {
                long elementOrSubElementId = (Long)entrySet.getKey();
                row.set(this.rowMeta.getFieldIndex(DYNAMIC_PREFIX + elementOrSubElementId), entrySet.getValue());
            }
            row.set(this.rowMeta.getFieldIndex("baseqty"), (Object)totalQty);
            row.set(this.rowMeta.getFieldIndex("amount"), (Object)totalAmount);
            if (totalQty != null && BigDecimal.ZERO.compareTo(totalQty) != 0) {
                row.set(this.rowMeta.getFieldIndex("price"), (Object)totalAmount.divide(totalQty, 23, 4));
            }
            collector.collect(row);
        }
    }
}

