/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.report.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class ProUnitCostComFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private BigDecimal totalConvProQty = BigDecimal.ZERO;
    private BigDecimal totalCmpConvProQty = BigDecimal.ZERO;
    private String groupField = "";

    public ProUnitCostComFunction(RowMeta rowMeta, BigDecimal totalConvProQty, BigDecimal totalCmpConvProQty, String groupField) {
        this.rowMeta = rowMeta;
        this.totalConvProQty = totalConvProQty;
        this.totalCmpConvProQty = totalCmpConvProQty;
        this.groupField = groupField;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>(16);
        HashMap<String, List> roxMap = new HashMap<String, List>(16);
        for (RowX row : iterable) {
            Long element = row.getLong(this.rowMeta.getFieldIndex("element"));
            Long subElement = row.getLong(this.rowMeta.getFieldIndex("subelement"));
            Long subMaterial = row.getLong(this.rowMeta.getFieldIndex("material"));
            Long convSubMatver = row.getLong(this.rowMeta.getFieldIndex("convsubmatver"));
            Long convSubAuxpty = row.getLong(this.rowMeta.getFieldIndex("convsubauxpty"));
            String key = element + "@" + subElement + "@" + subMaterial + "@" + convSubMatver + "@" + convSubAuxpty;
            roxMap.computeIfAbsent(key, s -> new ArrayList()).add(row);
        }
        for (Map.Entry entry : roxMap.entrySet()) {
            RowX row = (RowX)((List)entry.getValue()).get(0);
            if (((List)entry.getValue()).size() == 1) {
                String groupValue = row.getString(this.rowMeta.getFieldIndex(this.groupField));
                BigDecimal convQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("convqty")));
                BigDecimal cmpConvQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmpconvqty")));
                BigDecimal convAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("convamt")));
                BigDecimal cmpConvAmt = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("cmpconvamt")));
                BigDecimal convProQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("convproqty")));
                BigDecimal cmpConvProQty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.rowMeta.getFieldIndex("cmpconvproqty")));
                row.set(this.getSourceRowMeta().getFieldIndex("count" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(convQty, convProQty, 10));
                row.set(this.getSourceRowMeta().getFieldIndex("cost" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(convAmt, convProQty, 10));
                row.set(this.getSourceRowMeta().getFieldIndex("cmpcount" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(cmpConvQty, cmpConvProQty, 10));
                row.set(this.getSourceRowMeta().getFieldIndex("cmpcost" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(cmpConvAmt, cmpConvProQty, 10));
            } else {
                List rowXList = (List)entry.getValue();
                int state = 0;
                for (RowX rowX : rowXList) {
                    String groupValue = rowX.getString(this.rowMeta.getFieldIndex(this.groupField));
                    BigDecimal convQty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("convqty")));
                    BigDecimal cmpConvQty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmpconvqty")));
                    BigDecimal convAmt = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.rowMeta.getFieldIndex("convamt")));
                    BigDecimal cmpConvAmt = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.rowMeta.getFieldIndex("cmpconvamt")));
                    BigDecimal convProQty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.rowMeta.getFieldIndex("convproqty")));
                    BigDecimal cmpConvProQty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(this.rowMeta.getFieldIndex("cmpconvproqty")));
                    row.set(this.getSourceRowMeta().getFieldIndex("count" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(convQty, convProQty, 10));
                    row.set(this.getSourceRowMeta().getFieldIndex("cost" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(convAmt, convProQty, 10));
                    row.set(this.getSourceRowMeta().getFieldIndex("cmpcount" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(cmpConvQty, cmpConvProQty, 10));
                    row.set(this.getSourceRowMeta().getFieldIndex("cmpcost" + groupValue.replaceAll("[^A-Za-z0-9 ]", "0")), (Object)BigDecimalUtil.getDevideCal(cmpConvAmt, cmpConvProQty, 10));
                    if (state > 0) {
                        row.set(this.getSourceRowMeta().getFieldIndex("totalcount"), (Object)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcount")).add(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcount"))));
                        row.set(this.getSourceRowMeta().getFieldIndex("cmptotalcount"), (Object)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcount")).add(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcount"))));
                        row.set(this.getSourceRowMeta().getFieldIndex("totalcost"), (Object)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcost")).add(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcost"))));
                        row.set(this.getSourceRowMeta().getFieldIndex("cmptotalcost"), (Object)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcost")).add(rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcost"))));
                    }
                    ++state;
                }
            }
            BigDecimal totalCost = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcost"));
            BigDecimal cmpTotalCost = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcost"));
            BigDecimal totalCount = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalcount"));
            BigDecimal cmpTotalCount = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("cmptotalcount"));
            row.set(this.getSourceRowMeta().getFieldIndex("unitprice"), (Object)BigDecimalUtil.getDevideCal(totalCost, totalCount, 10));
            row.set(this.getSourceRowMeta().getFieldIndex("cmpunitprice"), (Object)BigDecimalUtil.getDevideCal(cmpTotalCost, cmpTotalCount, 10));
            row.set(this.getSourceRowMeta().getFieldIndex("unitcost"), (Object)BigDecimalUtil.getDevideCal(totalCost, this.totalConvProQty, 10));
            row.set(this.getSourceRowMeta().getFieldIndex("unitcount"), (Object)BigDecimalUtil.getDevideCal(totalCount, this.totalConvProQty, 10));
            row.set(this.getSourceRowMeta().getFieldIndex("cmpunitcost"), (Object)BigDecimalUtil.getDevideCal(cmpTotalCost, this.totalCmpConvProQty, 10));
            row.set(this.getSourceRowMeta().getFieldIndex("cmpunitcount"), (Object)BigDecimalUtil.getDevideCal(cmpTotalCount, this.totalCmpConvProQty, 10));
            targetRows.add(row);
        }
        for (RowX row : targetRows) {
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

