/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.enums.CalcReportResultEnum;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import net.sf.json.JSONObject;

public class AcaAlgoxCheckHelper {
    private static final Log logger = LogFactory.getLog(AcaAlgoxCheckHelper.class);

    public static QFilter getCommonFilter(String checkParam) {
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParam);
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getLong("org"));
        filter.and(new QFilter("costaccount", "=", (Object)checkParamJs.getLong("costaccount")));
        filter.and(new QFilter("period", "=", (Object)checkParamJs.getLong("period")));
        if (checkParamJs.getJSONArray("costcenters") != null && checkParamJs.getJSONArray("costcenters").size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getJSONArray("costcenters")));
        }
        return filter;
    }

    public static QFilter getOrgAndCostCenterFilter(String checkParam) {
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParam);
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getLong("org"));
        if (checkParamJs.getJSONArray("costcenters") != null && checkParamJs.getJSONArray("costcenters").size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getJSONArray("costcenters")));
        }
        return filter;
    }

    public static DynamicObject getCheckResultNewEntry(String checkParam) {
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParam);
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)checkParamJs.getLong("checkResultId"), (String)"aca_calcreport");
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)checkParamJs.getString("itemDesc"));
        return entry;
    }

    public static int getCheckFailCount(Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue()));
        DynamicObjectCollection checkFailRs = QueryServiceHelper.query((String)"aca_calcreport", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return AcaAlgoxEmptyOrZeroUtils.isEmpty(checkFailRs) ? 0 : checkFailRs.size();
    }

    public static Boolean getCheckResult(Long checkResultId, Long[] checkItemId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue()));
        filter.and(new QFilter("entryentity.id", "in", (Object)checkItemId));
        DynamicObjectCollection chekcResult = QueryServiceHelper.query((String)"aca_calcreport", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return chekcResult.size() == 0;
    }
}

