/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.macc.aca.algox.costcalc.action.ActMaterialLvlCalcAction;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.utils.PeriodHelper;

public class AcaCalcRangeHelper {
    public static Set<Long> getCalcCurPeriodCostobjectRange(Long orgId, Long costaccountId, Long periodId, Long manuOrgId) {
        ActCostCalcArgs args = AcaCalcRangeHelper.getCostCalcArgs(orgId, costaccountId, periodId, manuOrgId);
        if (args == null) {
            return Sets.newHashSetWithExpectedSize((int)8);
        }
        ActMaterialLvlCalcAction action = new ActMaterialLvlCalcAction();
        HashSet notRoCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
        Set<Long> costObjectFilterIds = action.buildPlanCostObject(args, notRoCostObjectIds);
        Set<Long> preCostObjectFilterIds = action.buildLastCalcResultCostObject(args);
        costObjectFilterIds.addAll(preCostObjectFilterIds);
        Set<Long> adjCostObjectFilterIds = action.buildAdjustCostobject(args);
        costObjectFilterIds.addAll(adjCostObjectFilterIds);
        return costObjectFilterIds;
    }

    public static Set<Long> getCalResultAndPlanCostObject(Long orgId, Long costaccountId, Long periodId, Long manuOrgId) {
        ActCostCalcArgs args = AcaCalcRangeHelper.getCostCalcArgs(orgId, costaccountId, periodId, manuOrgId);
        if (args == null) {
            return Sets.newHashSetWithExpectedSize((int)8);
        }
        ActMaterialLvlCalcAction action = new ActMaterialLvlCalcAction();
        HashSet notRoCostObjectIds = Sets.newHashSetWithExpectedSize((int)16);
        Set<Long> costObjectFilterIds = action.buildPlanCostObject(args, notRoCostObjectIds);
        Set<Long> preCostObjectFilterIds = action.buildLastCalcResultCostObject(args);
        costObjectFilterIds.addAll(preCostObjectFilterIds);
        return costObjectFilterIds;
    }

    public static List<Set<Long>> buildCostReductCalcLvl(Long orgId, Long costaccountId, Long periodId, Long manuOrgId) {
        ActCostCalcArgs args = AcaCalcRangeHelper.getCostCalcArgs(orgId, costaccountId, periodId, manuOrgId);
        if (args == null) {
            return null;
        }
        ActMaterialLvlCalcAction action = new ActMaterialLvlCalcAction();
        return action.costRecGetMatLvlV1(args);
    }

    private static ActCostCalcArgs getCostCalcArgs(Long orgId, Long costaccountId, Long periodId, Long manuOrgId) {
        ActCostCalcArgs args = new ActCostCalcArgs();
        args.setOrgId(orgId);
        args.setCostAccountId(costaccountId);
        args.setPeriodId(periodId);
        args.setManuOrgId(manuOrgId);
        DynamicObject periodDyn = PeriodHelper.getPeriod(periodId);
        if (periodDyn == null) {
            return null;
        }
        Map<String, Date> resultPeriod = PeriodHelper.getPeriodBeginDateAndEndDate(periodDyn);
        args.setStartDate(resultPeriod.get("begindate"));
        args.setEndDate(resultPeriod.get("enddate"));
        return args;
    }
}

