/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.enums.CalcReportResultEnum;
import kd.macc.aca.algox.utils.AcaAlgoxCheckHelper;
import kd.macc.aca.algox.utils.AcaAlgoxTimeUtils;
import net.sf.json.JSONObject;

public class CalcReportHelper {
    public static Long initCalcReport(Long taskId, IDataModel model, String taskType) {
        if (model == null) {
            return null;
        }
        DynamicObject newCalcReport = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreport");
        Long id = ID.genLongId();
        newCalcReport.set("id", (Object)id);
        newCalcReport.set("billtype", (Object)taskType);
        newCalcReport.set("org", (Object)((DynamicObject)model.getValue("org")));
        newCalcReport.set("costaccount", (Object)((DynamicObject)model.getValue("costaccount")));
        newCalcReport.set("period", (Object)((DynamicObject)model.getValue("period")));
        newCalcReport.set("executor", (Object)RequestContext.get().getCurrUserId());
        newCalcReport.set("calcdate", (Object)TimeServiceHelper.now());
        newCalcReport.set("calscheme", (Object)((DynamicObject)model.getValue("calscheme")));
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"aca_calcreport", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreport"), (String)"", (int)1);
        if (numberArr.length > 0) {
            newCalcReport.set("billno", (Object)numberArr[0]);
        }
        newCalcReport.set("billstatus", (Object)"C");
        newCalcReport.set("progress", (Object)0);
        newCalcReport.set("usetime", (Object)0L);
        newCalcReport.set("type", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCalcReport});
        return id;
    }

    public static Long initCostReductReport(Long taskId, JSONObject paramObj) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        calcReport.set("taskname", (Object)taskConfig.getString("name"));
        calcReport.set("starttime", (Object)TimeServiceHelper.now());
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("billtype", (Object)"2");
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("currency", (Object)paramObj.getLong("currency"));
        calcReport.set("org", (Object)paramObj.getLong("calOrgId"));
        calcReport.set("costaccount", (Object)paramObj.getLong("costAccountId"));
        if (paramObj.containsKey((Object)"manuOrgId")) {
            calcReport.set("prdorg", (Object)paramObj.getLong("manuOrgId"));
        } else {
            calcReport.set("prdorg", (Object)0);
        }
        calcReport.set("period", (Object)paramObj.getLong("periodId"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    public static void updateCalcRreport(Long calcReportId, DynamicObject taskRecord) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport");
        calcReport.set("usetime", taskRecord.get("time"));
        calcReport.set("progress", taskRecord.get("progress"));
        calcReport.set("type", taskRecord.get("status"));
        DynamicObjectCollection calcReportEntry = calcReport.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection taskRecordEntry = taskRecord.getDynamicObjectCollection("entryentity");
        calcReportEntry.clear();
        int seq = 1;
        for (DynamicObject recordEntry : taskRecordEntry) {
            DynamicObject report = calcReportEntry.addNew();
            report.set("id", (Object)recordEntry.getLong("id"));
            report.set("item", (Object)recordEntry.getString("subname"));
            report.set("result", (Object)recordEntry.getString("substatus"));
            report.set("cnsmtime", (Object)recordEntry.getString("subtime"));
            report.set("checkdesc", (Object)recordEntry.getString("detail"));
            report.set("subnextentity", (Object)recordEntry.getString("subnextentity"));
            report.set("subparam", recordEntry.getString("subparam_tag") == null ? Character.valueOf(' ') : StringUtils.substring((String)recordEntry.getString("subparam_tag"), (int)0, (int)2000));
            report.set("seq", (Object)seq);
            report.set("bigtext", (Object)recordEntry.getString("subparam"));
            report.set("bigtext_tag", (Object)recordEntry.getString("subparam_tag"));
            ++seq;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static void updateCheckResult(Long calcReportId, int seq, String item, Date startTime, Long checkResultId) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport");
        DynamicObjectCollection entrys = calcReport.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)ID.genLongId());
        entry.set("seq", (Object)seq);
        entry.set("item", (Object)item);
        entry.set("cnsmtime", (Object)AcaAlgoxTimeUtils.getMilliSecond(startTime, TimeServiceHelper.now()));
        int failCount = AcaAlgoxCheckHelper.getCheckFailCount(checkResultId);
        if (failCount == 0) {
            entry.set("result", (Object)CalcReportResultEnum.CALCREPORT_PASS.getValue());
        } else {
            entry.set("result", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue());
            entry.set("checkdesc", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"CalcReportHelper_0", (String)"macc-aca-algox", (Object[])new Object[0]));
            JSONObject pagePara = new JSONObject();
            pagePara.accumulate("checkResultId", (Object)String.valueOf(checkResultId));
            entry.set("param", (Object)pagePara.toString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static void updateCalcReport(Long calcReportId, int seq, String item, Date startTime, CalcReportResultEnum result, Exception e) {
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"aca_calcreport");
        DynamicObjectCollection entrys = calcReport.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)ID.genLongId());
        entry.set("seq", (Object)(seq != 0 ? seq : entrys.size()));
        entry.set("item", (Object)item);
        entry.set("cnsmtime", (Object)AcaAlgoxTimeUtils.getMilliSecond(startTime, TimeServiceHelper.now()));
        entry.set("result", (Object)result.getValue());
        if (e != null && e.getStackTrace() != null && e.getStackTrace().length > 0) {
            StringBuilder erroStr = new StringBuilder();
            erroStr.append(e.getCause()).append('\n');
            for (StackTraceElement traceElement : e.getStackTrace()) {
                erroStr.append(traceElement).append('\n');
            }
            entry.set("checkdesc", (Object)(erroStr.length() > 255 ? erroStr.substring(0, 255) : erroStr.toString()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
    }

    public static Map<String, Integer> getSucByCalcReportId(Long calcReportId) {
        String algoKey = "kd.macc.aca.algox.utils.getSucByCalcReportId";
        QFilter qfCalcReport = new QFilter("calcreport", "=", (Object)calcReportId);
        String selectFields = "costobject,costcenter";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])new QFilter[]{qfCalcReport}, null);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Long> costObjectIds = new HashSet<Long>();
        HashSet<Long> costCenterIds = new HashSet<Long>();
        for (Row row : calcResult) {
            costObjectIds.add(row.getLong("costobject"));
            costCenterIds.add(row.getLong("costcenter"));
        }
        result.put("costobject", costObjectIds.size());
        result.put("costcenter", costCenterIds.size());
        return result;
    }
}

