/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.alloc.input.CalcDataArgs;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;

public class FinishCalcHelper {
    public static QFilter getCommonFilter(CalcDataArgs args) {
        return FinishCalcHelper.getCommonFilter(args, true);
    }

    public static QFilter getCommonFilter(CalcDataArgs args, boolean isPeriod) {
        return FinishCalcHelper.getCommonFilter(args, isPeriod, true, true);
    }

    public static QFilter getCommonFilter(CalcDataArgs args, boolean isPeriod, boolean isCostoBject, boolean isCostAcct) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (args.getCostAcctId() != null && isCostAcct) {
            filter.and(new QFilter("costaccount", "=", args.getCostAcctId()));
        }
        if (args.getPeriodId() != null && isPeriod) {
            filter.and(new QFilter("period", "=", args.getPeriodId()));
        }
        if (args.getCostObjects() != null && isCostoBject) {
            filter.and(new QFilter("costobject", "in", args.getCostObjects()));
        }
        return filter;
    }

    public static QFilter getOrgAndCostCenterFilter(CalcDataArgs args) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        return filter;
    }

    public static QFilter getCostCenterFilter(CalcDataArgs args) {
        QFilter filter = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getCostCenterIds())) {
            filter = new QFilter("costcenter", "in", args.getCostCenterIds());
        }
        return filter;
    }

    public static CalcDataArgs getCalcDataArgs(String calcParam) {
        calcParam = calcParam.replaceAll("org", "orgId");
        calcParam = calcParam.replaceAll("costaccount", "costAcctId");
        calcParam = calcParam.replaceAll("period", "periodId");
        calcParam = calcParam.replaceAll("costcenters", "costCenterIds");
        calcParam = calcParam.replaceAll("costobjects", "costObjects");
        calcParam = calcParam.replaceAll("costtypeid", "costTypeId");
        CalcDataArgs args = (CalcDataArgs)SerializationUtils.fromJsonString((String)calcParam, CalcDataArgs.class);
        return args;
    }

    public static Set<Long> getFinishedCostObject(CalcDataArgs args) {
        String algoKey = "kd.macc.sca.algox.utils.FinishCalcHelper.getFinishedCostObject";
        QFilter orgFilter = new QFilter("org", "=", args.getOrgId());
        QFilter costCenterFilter = null;
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(args.getCostCenterIds())) {
            costCenterFilter = new QFilter("costcenter", "in", args.getCostCenterIds());
        }
        QFilter plannedoutputFilter = new QFilter("billstatus", "=", (Object)"C");
        plannedoutputFilter.and(new QFilter("accountorg", "=", args.getOrgId()));
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)args.getPeriodId(), (String)"bd_period");
        if (AcaAlgoxEmptyOrZeroUtils.isEmpty(period)) {
            return null;
        }
        plannedoutputFilter.and(new QFilter("closedatetime", "<=", (Object)period.getDate("enddate")));
        plannedoutputFilter.and(new QFilter("closedatetime", ">=", (Object)period.getDate("begindate")));
        DataSet plannedoutputData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"costobject.id costobjectid", (QFilter[])new QFilter[]{plannedoutputFilter, costCenterFilter}, null);
        HashSet<Long> allcostObject = new HashSet<Long>();
        for (Row row : plannedoutputData) {
            if (allcostObject.contains(row.getLong("costobjectid"))) continue;
            allcostObject.add(row.getLong("costobjectid"));
        }
        QFilter wipFilter = new QFilter("closestatu", "=", (Object)"0");
        wipFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        wipFilter.and(new QFilter("accountorg", "=", args.getOrgId()));
        DataSet wipPlannedOutData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"costobject.id costobjectid", (QFilter[])new QFilter[]{wipFilter, costCenterFilter}, null);
        QFilter closeFilter = new QFilter("closestatu", "=", (Object)"1");
        closeFilter.and(new QFilter("accountorg", "=", args.getOrgId()));
        Date endDate = period.getDate("enddate");
        QFilter closeDateFilter = new QFilter("closedatetime", ">=", (Object)endDate);
        DataSet futureCloseData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"costobject.id costobjectid", (QFilter[])new QFilter[]{closeFilter, closeDateFilter, costCenterFilter}, null);
        QFilter coFilter = new QFilter("bizstatus", "=", (Object)"B");
        DataSet costObjectData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costobject", (String)"id costobjectid", (QFilter[])new QFilter[]{orgFilter, coFilter, costCenterFilter}, null);
        DataSet noFinshCostObject = wipPlannedOutData.union(futureCloseData).union(costObjectData);
        for (Row row : noFinshCostObject) {
            allcostObject.remove(row.getLong("costobjectid"));
        }
        return allcostObject;
    }
}

