/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;

public class MaterialGroupHelper {
    public static final String MATERIALGROUP = "mulmaterialgroup";
    public static final String MATERIALGROUPSTANDARD = "materialgrpstd";

    public static QFilter getClassifiedMaterialIdFilter(DynamicObjectCollection mulmaterialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        Set<Long> materialIds = MaterialGroupHelper.getClassifiedMaterialId(mulmaterialgroup, notShowMaterialGroup, materialgroupstandard);
        QFilter classifiedMaterialIdFilter = null;
        classifiedMaterialIdFilter = materialIds == null || materialIds.size() < 200000 ? new QFilter("id", "in", materialIds) : InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList<Long>(materialIds), (String)"in", (int)200000);
        return classifiedMaterialIdFilter;
    }

    public static Set<Long> getClassifiedMaterialId(DynamicObjectCollection mulmaterialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        DataSet materialDataSet;
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)1024);
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (mulmaterialgroup != null && mulmaterialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(mulmaterialgroup, false, "group.longnumber"));
        }
        if ((materialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc")) == null) {
            return materialIds;
        }
        for (Row row : materialDataSet) {
            materialIds.add(row.getLong("material"));
        }
        return materialIds;
    }

    public static QFilter getClassifiedMaterialIdFilter(DynamicObjectCollection mulmaterialgroup, DynamicObject materialgroupstandard) {
        Set<Long> materialIds = MaterialGroupHelper.getClassifiedMaterialId(mulmaterialgroup, materialgroupstandard);
        QFilter classifiedMaterialIdFilter = null;
        classifiedMaterialIdFilter = materialIds == null || materialIds.size() < 200000 ? new QFilter("id", "in", materialIds) : InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList<Long>(materialIds), (String)"in", (int)200000);
        return classifiedMaterialIdFilter;
    }

    public static Set<Long> getClassifiedMaterialId(DynamicObjectCollection mulmaterialgroup, DynamicObject materialgroupstandard) {
        DataSet materialDataSet;
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)1024);
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (mulmaterialgroup != null && mulmaterialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(mulmaterialgroup, true, "group.longnumber"));
        }
        if ((materialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material", (QFilter[])filter.toArray(), null)) == null) {
            return materialIds;
        }
        materialDataSet.forEach(s -> materialIds.add(s.getLong("material")));
        return materialIds;
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObjectCollection materialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.name materialgroupname,group.number as materialgroupnumber,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
        return classifiedMaterialDataSet;
    }

    public static QFilter getGroupFilter(DynamicObjectCollection materialgroupColl, boolean isFromFilteInfo, String fieldName) {
        if (materialgroupColl != null && materialgroupColl.size() > 0) {
            String longNumberDLM = MaterialGroupHelper.getLongNumberDLM();
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            for (DynamicObject matgroup : materialgroupColl) {
                String longnumber = isFromFilteInfo ? matgroup.getString("longnumber") : matgroup.getDynamicObject("fbasedataid").getString("longnumber");
                groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
                groupNumSet.add(longnumber);
            }
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static String getLongNumberDLM() {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
        GroupProp group = (GroupProp)property;
        String longNumberDLM = "";
        if (group instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
        }
        return longNumberDLM;
    }
}

