/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class MfgFeeAllocStdValueHelper {
    public static DataSet getCustomizedCostDiverAllocStdValue(Long orgId, Long costCenterId, String costDriverNumber, Map<String, Date> period, Set<Long> benefitCostCenterIds, boolean isExcludeAssistCostCenter) {
        String algoKey = "kd.macc.aca.algox.alloc.CostCenterMfgFeeAllocHelper.getCustomizedCostDiverAllocStdValue";
        QFilter qFilter = new QFilter("number", "=", (Object)costDriverNumber);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)"aca");
        DynamicObject costDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"isrelatedwork", (QFilter[])new QFilter[]{qFilter, appNumFilter});
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "=", (Object)orgId));
        if (costCenterId != 0L) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (isExcludeAssistCostCenter) {
            filters.add(new QFilter("entryentity.benefcostcenter.orgduty", "!=", (Object)"5"));
        }
        filters.add(new QFilter("costdriver.number", "=", (Object)costDriverNumber));
        filters.add(new QFilter("appnum", "=", (Object)"aca"));
        if (costDriver != null && costDriver.getBoolean("isrelatedwork")) {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(new QFilter("bizdate", ">=", (Object)period.get("begindate")));
            filters.add(new QFilter("bizdate", "<=", (Object)period.get("enddate")));
            String fields = "costdriver.number number,org,entryentity.benefcostcenter costcenter,entryentity.entryqty value";
            DataSet workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"sca_workqtycollec", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
            workQtyDs = workQtyDs.executeSql("select org,costcenter,sum(value) value group by number,org,costcenter");
            if (benefitCostCenterIds != null && benefitCostCenterIds.size() > 0) {
                return workQtyDs.filter("costcenter in(" + StringUtils.join(benefitCostCenterIds, (String)",") + ")");
            }
            return workQtyDs;
        }
        filters.add(new QFilter("effectperiod", "!=", (Object)0L));
        Date queryDate = period.get("enddate") == null ? new Date() : period.get("enddate");
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)queryDate);
        dateFilter.and("expdate", ">", (Object)queryDate);
        filters.add(dateFilter);
        String fields = "costdriver.number number,org,entryentity.benefcostcenter costcenter,entryentity.entryqty value";
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)(algoKey + "3"), (String)"sca_diycostdriver", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select org,costcenter,sum(value) value group by number,org,costcenter");
        if (benefitCostCenterIds != null && benefitCostCenterIds.size() > 0) {
            return diyCostDriverDs.filter("costcenter in(" + StringUtils.join(benefitCostCenterIds, (String)",") + ")");
        }
        return diyCostDriverDs;
    }

    public static DataSet getWorkColStdValueForInteractAlloc(Long orgId, String costDriverNumber, Map<String, Date> period) {
        String algoKey = "kd.macc.aca.algox.utils.MfgFeeAllocStdValueHelper.getWorkColStdValueForInteractAlloc";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("costdriver.number", "=", (Object)costDriverNumber));
        filters.add(new QFilter("appnum", "=", (Object)"aca"));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("entryentity.benefcostcenter.orgduty", "!=", (Object)"5"));
        filters.add(new QFilter("bizdate", ">=", (Object)period.get("begindate")));
        filters.add(new QFilter("bizdate", "<=", (Object)period.get("enddate")));
        String fields = "costdriver.number number,org,entryentity.benefcostcenter costcenter,entryentity.entryqty value";
        DataSet workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"sca_workqtycollec", (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
        workQtyDs = workQtyDs.executeSql("select org,costcenter,sum(value) value group by number,org,costcenter");
        return workQtyDs;
    }

    public static DynamicObject getMfgAllocStdSetting(Long orgId, Long costCenterId, Long expenseItem) {
        DynamicObject mfgAllocStdSetting = null;
        DynamicObject feeAllocStd = MfgFeeAllocStdValueHelper.getMfgAllocStd(orgId, costCenterId);
        if (feeAllocStd == null) {
            return mfgAllocStdSetting;
        }
        DynamicObjectCollection stdSettings = feeAllocStd.getDynamicObjectCollection("entryentity");
        for (DynamicObject stdSetting : stdSettings) {
            if (expenseItem.longValue() != stdSetting.getLong("expenseitem.id")) continue;
            mfgAllocStdSetting = stdSetting;
            break;
        }
        return mfgAllocStdSetting;
    }

    public static DynamicObject getMfgAllocStd(Long orgId, Long costCenterId) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costCenterIdFilter = new QFilter("costcenter", "=", (Object)costCenterId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"aca_mfgfeeallocstd", (QFilter[])new QFilter[]{orgIdFilter, costCenterIdFilter, billStatusFilter}, null, (int)1);
        if (primaryKeys.size() > 0) {
            return BusinessDataServiceHelper.loadSingle(primaryKeys.get(0), (String)"aca_mfgfeeallocstd");
        }
        return null;
    }
}

