/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TimeUtils {
    private static final Log logger = LogFactory.getLog(TimeUtils.class);
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Date getDefaultEffectDate() {
        return TimeUtils.parseDate("2000-01-01 00:00:00");
    }

    public static Date getDeFaultExpDate() {
        return TimeUtils.parseDate("2999-12-31 23:59:59");
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        return date;
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = pattern != null && pattern.length() > 0 ? new SimpleDateFormat(pattern) : new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static Date getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long getSecond(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return (endTime.getTime() - startTime.getTime()) / 1000L;
    }
}

