/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation;

import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.business.invocation.executor.FactnedOutputOperExecutor;
import kd.macc.aca.business.invocation.executor.MatAllocOperExecutor;
import kd.macc.aca.business.invocation.executor.MatUseCollectOperExecutor;
import kd.macc.aca.business.invocation.executor.MfgFeeAllocCCExecutor;
import kd.macc.aca.business.invocation.executor.MfgFeeAllocCOExecutor;
import kd.macc.aca.business.invocation.executor.MfgFeeCollectOperExecutor;
import kd.macc.aca.business.invocation.executor.PlannedOutputOperExecutor;
import kd.macc.aca.business.invocation.executor.ResourceUseOperExecutor;

public class InvocationDispatcher {
    private String entityName;
    private String oper;

    public InvocationDispatcher(String entityName, String oper) {
        this.entityName = entityName;
        this.oper = oper;
    }

    public Executor getExecutor() {
        Executor executor = null;
        switch (this.entityName) {
            case "cad_costobject": {
                executor = new CostObjectOperExecutor(this.oper);
                break;
            }
            case "sca_resourceuse": {
                executor = new ResourceUseOperExecutor(this.oper);
                break;
            }
            case "cad_plannedoutputbill": {
                executor = new PlannedOutputOperExecutor(this.oper);
                break;
            }
            case "cad_factnedoutputbill": {
                executor = new FactnedOutputOperExecutor(this.oper);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                executor = new MatUseCollectOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_mfgfeebill": 
            case "aca_mfgfeebill": {
                executor = new MfgFeeCollectOperExecutor(this.entityName, this.oper);
                break;
            }
            case "aca_matalloc": {
                executor = new MatAllocOperExecutor(this.oper);
                break;
            }
            case "aca_mfgfeealloccc": {
                executor = new MfgFeeAllocCCExecutor(this.oper);
                break;
            }
            case "aca_mfgfeeallocco": {
                executor = new MfgFeeAllocCOExecutor(this.oper);
            }
        }
        return executor;
    }
}

