/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;

public class CostObjectOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public CostObjectOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            int sum = 0;
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costobject", this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_costobject", (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_costobject", this.operKey, NO_PERM);
                return false;
            }
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            Map<Long, List<Object>> orgCostCenterMap = AcaAutoExecShemeEntrance.getOrgCostCenterMap(orgList);
            for (Map.Entry<Long, List<Object>> orgCostCenter : orgCostCenterMap.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)orgCostCenter.getValue())) continue;
                for (Object costCenterid : orgCostCenter.getValue()) {
                    try {
                        Map<String, String> resultInfo = this.doInvokeBizService(orgCostCenter, costCenterid, autoExecSchemeDTO);
                        if (resultInfo == null || Integer.parseInt(resultInfo.get("successQty")) <= 0) continue;
                        sum += Integer.parseInt(resultInfo.get("successQty"));
                        schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostCenter.getKey(), Long.valueOf(costCenterid == null ? "0" : costCenterid.toString()), Long.valueOf(0L), Integer.parseInt(resultInfo.get("successQty"))));
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_costobject", this.operKey, String.format(SUCCESSIMPORTER, sum), schemeLogSubDetail);
        }
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Object>> orgCostCenter, Object costCenterid, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{null, null, orgCostCenter.getKey(), Collections.singletonList(Long.parseLong(costCenterid.toString())), null, autoExecSchemeDTO.getAppnum(), null});
        return resultInfo;
    }
}

