/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.helper.MfgfeeBillHelper;
import kd.macc.cad.common.output.ExecuteResult;

public class MfgFeeCollectOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String entityName;
    private String operKey;

    public MfgFeeCollectOperExecutor(String entityName, String operKey) {
        this.entityName = entityName;
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)this.entityName, (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, NO_PERM);
                return false;
            }
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            List<Long> costAccountList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 1);
            for (Long orgId : orgList) {
                try {
                    ExecuteResult executeResult = MfgfeeBillHelper.importMfgFeeBillBySys((Long)orgId, (Set)Sets.newHashSet(costAccountList), (String)autoExecSchemeDTO.getAppnum(), (AutoExecSchemeDTO)autoExecSchemeDTO);
                    String detail = AcaAutoExecShemeEntrance.getMsgFromExecuteResult(executeResult);
                    AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, this.entityName, this.operKey, detail);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, SUCCESS);
        return true;
    }
}

