/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.wipcostcheck;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.aca.algox.utils.AcaCalcRangeHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.aca.business.wipcostcheck.WipCostCheckService;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class TerminalWipMatAllocService {
    private Log logger = LogFactory.getLog(TerminalWipMatAllocService.class);
    private static final String alGoKey = "TerminalWipMatAllocService";
    private static final String[] rightFieldNames = new String[]{"costCenterId as costCenterIdr", "costObjectId as costObjectIdr", "qty as qtyr"};
    private Boolean existHasCostData = false;
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public String doTerminalWipMatAlloc(List<Object> ids, Long orgId, Long costaccountId, Long costcenterId, DynamicObject currPeriodAndDate, Set<Long> entryIdSet) {
        StringBuilder logBuilder;
        int count;
        if (CadEmptyUtils.isEmpty(ids)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"TerminalWipMatAllocService_0", (String)"macc-aca-business", (Object[])new Object[0]);
        }
        Long currentperiod = currPeriodAndDate.getLong("currentperiod");
        QFilter idQf = new QFilter("id", "in", ids);
        QFilter entryIdQf = null;
        if (!CadEmptyUtils.isEmpty(entryIdSet)) {
            entryIdQf = new QFilter("entryentity.id", "in", entryIdSet);
        }
        DataSet terminalWipMatDataSet = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"aca_terminalwipmatcheck", (String)this.getSelectFileName(), (QFilter[])new QFilter[]{idQf, entryIdQf}, null);
        DataSet copyCheck = terminalWipMatDataSet.copy();
        terminalWipMatDataSet = terminalWipMatDataSet.filter("billstatus ='C'");
        terminalWipMatDataSet = terminalWipMatDataSet.filter("period = " + currentperiod);
        DynamicObject checkSetting = this.getOrgCheckSetting(orgId);
        String checktype = TerminalWipMatEnum.CHECKTYPE_QTY.getValue();
        String checkcal = TerminalWipMatEnum.CHECKCAL_EQUIVALENT.getValue();
        if (checkSetting != null) {
            checktype = checkSetting.getString("checktype");
            checkcal = checkSetting.getString("checkcal");
        }
        terminalWipMatDataSet = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? terminalWipMatDataSet.filter("amount != 0") : terminalWipMatDataSet.filter("qty != 0");
        StringBuilder tipsBillNoStr = this.getTipsBillNoStr(copyCheck, checktype, currentperiod);
        DataSet allocCostObjectDataSet = null;
        if (this.existHasCostData.booleanValue()) {
            allocCostObjectDataSet = terminalWipMatDataSet.filter("costObjectId != 0");
            terminalWipMatDataSet = terminalWipMatDataSet.filter("costObjectId = 0");
        }
        Set calcCurPeriodCostobjectRange = AcaCalcRangeHelper.getCalcCurPeriodCostobjectRange((Long)orgId, (Long)costaccountId, (Long)currentperiod, (Long)0L);
        HashSet<Long> costCenterIds = new HashSet<Long>();
        if (CadEmptyUtils.isEmpty((Long)costcenterId)) {
            costCenterIds = this.getCostCentersByOrg(orgId);
        } else {
            costCenterIds.add(costcenterId);
        }
        if (TerminalWipMatEnum.CHECKCAL_EQUIVALENT.getValue().equals(checkcal)) {
            StringBuilder logBuilder2;
            int count2;
            DataSet equivalentDataSet = this.getEquivalentDataSet(orgId, costaccountId, currentperiod, calcCurPeriodCostobjectRange);
            DataSet wipCostDataSet = new WipCostCheckService().loadWipCostCheckDataSet(orgId, 0L, costaccountId, costCenterIds, currPeriodAndDate).filter("producttype = 'C'").select("costcenter as costCenterId, costobject as costObjectId,endproducting as qty").filter("qty!=0");
            DataSet wipCostCheckUserDataSet = this.getWipCostCheckUserDataSet(orgId, costaccountId, costcenterId, currPeriodAndDate);
            wipCostDataSet = wipCostDataSet.leftJoin(wipCostCheckUserDataSet).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").select(wipCostDataSet.getRowMeta().getFieldNames(), new String[]{"checknum"}).finish().filter("checknum is null").select(wipCostDataSet.getRowMeta().getFieldNames()).union(wipCostCheckUserDataSet.select("costCenterId, costObjectId,checknum as qty"));
            if (!this.existHasCostData.booleanValue() && wipCostDataSet.isEmpty()) {
                String conterName = CadEmptyUtils.isEmpty((Long)costcenterId) ? ResManager.loadKDString((String)"\u6240\u6709", (String)"TerminalWipMatAllocService_1", (String)"macc-aca-business", (Object[])new Object[0]) : this.getConterName(costcenterId);
                return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a%s\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf\u53ca\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u6570\u91cf\u3002", (String)"TerminalWipMatAllocService_2", (String)"macc-aca-business", (Object[])new Object[0]), conterName);
            }
            wipCostDataSet = wipCostDataSet.leftJoin(equivalentDataSet).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").select(wipCostDataSet.getRowMeta().getFieldNames(), new String[]{"totalvalen"}).finish();
            DataSet equivalentTotalDataSet = wipCostDataSet.copy().filter("totalvalen is not null");
            if (!this.existHasCostData.booleanValue() && equivalentTotalDataSet.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6ca1\u6709\u7ef4\u62a4\u7efc\u5408\u7ea6\u5f53\u7cfb\u6570\u3002%s", (String)"TerminalWipMatAllocService_3", (String)"macc-aca-business", (Object[])new Object[0]), tipsBillNoStr.toString());
            }
            wipCostDataSet = wipCostDataSet.select("costCenterId,costObjectId, case when totalvalen is null then 0 else qty *totalvalen end qty ").filter("qty is not null and qty!=0");
            terminalWipMatDataSet = this.calDataSet(terminalWipMatDataSet, wipCostDataSet, checktype);
            if (this.existHasCostData.booleanValue() && allocCostObjectDataSet != null) {
                String calFileName = TerminalWipMatEnum.CHECKTYPE_QTY.getValue().equals(checktype) ? "qty" : "amount";
                String[] fieldNames = allocCostObjectDataSet.getRowMeta().getFieldNames();
                StringBuilder sqlBuilder = new StringBuilder();
                for (String fieldName : fieldNames) {
                    sqlBuilder.append(fieldName).append(',');
                }
                sqlBuilder.append("costObjectId as allocCostObjectId,").append(calFileName).append(" as allocQty,").append(calFileName).append(" as allocSumQty,").append(calFileName).append(" as calQty");
                allocCostObjectDataSet = allocCostObjectDataSet.select(sqlBuilder.toString());
                terminalWipMatDataSet = terminalWipMatDataSet.union(allocCostObjectDataSet.select(terminalWipMatDataSet.getRowMeta().getFieldNames()));
            }
            if ((count2 = this.saveData(terminalWipMatDataSet, checktype, logBuilder2 = new StringBuilder())) > 0) {
                String tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f%s\u6761\u6570\u636e\u3002", (String)"TerminalWipMatAllocService_4", (String)"macc-aca-business", (Object[])new Object[0]), count2);
                String opType = ResManager.loadKDString((String)"\u5206\u914d", (String)"TerminalWipMatAllocService_12", (String)"macc-aca-business", (Object[])new Object[0]);
                logBuilder2.setLength(logBuilder2.length() - 1);
                WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)(tips + logBuilder2), (String)"aca_terminalwipmatcheck", (String)"aca");
                return tips;
            }
            if (tipsBillNoStr.length() > 0) {
                return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002%s ", (String)"TerminalWipMatAllocService_6", (String)"macc-aca-business", (Object[])new Object[0]), tipsBillNoStr);
            }
            return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a\u201c%s\u201d\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf\u53ca\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u6570\u91cf\u3002", (String)"TerminalWipMatAllocService_7", (String)"macc-aca-business", (Object[])new Object[0]), this.getConterName(costCenterIds));
        }
        DataSet factnedCostObject = this.getFactnedCostObject(orgId, costcenterId, currPeriodAndDate);
        DataSet costObjectInput = this.getCostObjectInput(orgId, costaccountId, costcenterId, currPeriodAndDate);
        costObjectInput = costObjectInput.leftJoin(factnedCostObject).on("costObjectId", "removecostobject").select(costObjectInput.getRowMeta().getFieldNames(), new String[]{"removecostobject"}).finish().filter("removecostobject is null").removeFields(new String[]{"removecostobject"});
        terminalWipMatDataSet = this.calDataSet(terminalWipMatDataSet, costObjectInput, checktype);
        if (this.existHasCostData.booleanValue() && allocCostObjectDataSet != null) {
            String calFileName = TerminalWipMatEnum.CHECKTYPE_QTY.getValue().equals(checktype) ? "qty" : "amount";
            String[] fieldNames = allocCostObjectDataSet.getRowMeta().getFieldNames();
            StringBuilder sqlBuilder = new StringBuilder();
            for (String fieldName : fieldNames) {
                sqlBuilder.append(fieldName).append(',');
            }
            sqlBuilder.append("costObjectId as allocCostObjectId,").append(calFileName).append(" as allocQty,").append(calFileName).append(" as allocSumQty,").append(calFileName).append(" as calQty");
            allocCostObjectDataSet = allocCostObjectDataSet.select(sqlBuilder.toString());
            terminalWipMatDataSet = terminalWipMatDataSet.union(allocCostObjectDataSet.select(terminalWipMatDataSet.getRowMeta().getFieldNames()));
        }
        if ((count = this.saveData(terminalWipMatDataSet, checktype, logBuilder = new StringBuilder())) > 0) {
            String tips = String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f%s\u6761\u6570\u636e\u3002", (String)"TerminalWipMatAllocService_4", (String)"macc-aca-business", (Object[])new Object[0]), count);
            String opType = ResManager.loadKDString((String)"\u5206\u914d", (String)"TerminalWipMatAllocService_12", (String)"macc-aca-business", (Object[])new Object[0]);
            logBuilder.setLength(logBuilder.length() - 1);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)(tips + logBuilder), (String)"aca_terminalwipmatcheck", (String)"aca");
            return tips;
        }
        if (tipsBillNoStr.length() > 0) {
            return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002%s ", (String)"TerminalWipMatAllocService_6", (String)"macc-aca-business", (Object[])new Object[0]), tipsBillNoStr);
        }
        return String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a\u201c%s\u201d\u6210\u672c\u4e2d\u5fc3\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u672c\u671f\u5747\u6709\u5b8c\u5de5\u5355\uff0c\u5efa\u8bae\u4fee\u6539\u76d8\u70b9\u5206\u914d\u7b97\u6cd5\u3002", (String)"TerminalWipMatAllocService_8", (String)"macc-aca-business", (Object[])new Object[0]), this.getConterName(costCenterIds));
    }

    private String getConterName(Set<Long> costCenterIds) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", costCenterIds)});
        StringBuilder nameBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : load) {
            String name = dynamicObject.getString("name");
            nameBuilder.append(name).append(',');
        }
        if (nameBuilder.length() > 0) {
            nameBuilder.setLength(nameBuilder.length() - 1);
        }
        return nameBuilder.toString();
    }

    private String getConterName(Long costCenterId) {
        DynamicObject load = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costCenterId)});
        if (load != null) {
            return load.getString("name");
        }
        return String.valueOf(costCenterId);
    }

    private StringBuilder getTipsBillNoStr(DataSet copy, String checktype, Long currentperiod) {
        StringBuilder tipsBuilder = new StringBuilder();
        HashSet<String> tipsSet = new HashSet<String>();
        HashSet<String> tipsBillNOSet = new HashSet<String>();
        HashSet<String> tipsAmountSet = new HashSet<String>();
        String fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? "amount" : "qty";
        this.existHasCostData = false;
        while (copy.hasNext()) {
            Row row = copy.next();
            String billstatus = row.getString("billstatus");
            Long costObjectId = row.getLong("costObjectId");
            Long period = row.getLong("period");
            BigDecimal bigDecimal = row.getBigDecimal(fileName);
            if (!"C".equals(billstatus)) {
                tipsSet.add(row.getString("billno"));
                continue;
            }
            if (CadEmptyUtils.isEmpty((BigDecimal)bigDecimal)) {
                tipsAmountSet.add(row.getString("billno"));
                continue;
            }
            if (Long.compare(period, currentperiod) != 0) {
                tipsBillNOSet.add(row.getString("billno"));
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)costObjectId)) continue;
            this.existHasCostData = true;
        }
        if (tipsSet.size() > 0) {
            tipsBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"TerminalWipMatAllocService_9", (String)"macc-aca-business", (Object[])new Object[0]));
            tipsSet.stream().forEach(o -> tipsBuilder.append((String)o).append(','));
            tipsBuilder.setLength(tipsBuilder.length() - 1);
            tipsBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u3002", (String)"TerminalWipMatAllocService_10", (String)"macc-aca-business", (Object[])new Object[0]));
        }
        if (tipsBillNOSet.size() > 0) {
            tipsBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"TerminalWipMatAllocService_9", (String)"macc-aca-business", (Object[])new Object[0]));
            tipsBillNOSet.stream().forEach(o -> tipsBuilder.append((String)o).append(','));
            tipsBuilder.setLength(tipsBuilder.length() - 1);
            tipsBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\uff0c\u975e\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u3002", (String)"TerminalWipMatAllocService_11", (String)"macc-aca-business", (Object[])new Object[0]));
        }
        if (tipsAmountSet.size() > 0) {
            tipsBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"TerminalWipMatAllocService_9", (String)"macc-aca-business", (Object[])new Object[0]));
            tipsAmountSet.stream().forEach(o -> tipsBuilder.append((String)o).append(','));
            tipsBuilder.setLength(tipsBuilder.length() - 1);
            tipsBuilder.append(ResManager.loadKDString((String)"\u5206\u914d", (String)"TerminalWipMatAllocService_12", (String)"macc-aca-business", (Object[])new Object[0]));
            String name = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? TerminalWipMatEnum.CHECKTYPE_AMOUNT.getName() : TerminalWipMatEnum.CHECKTYPE_QTY.getName();
            tipsBuilder.append(name).append(ResManager.loadKDString((String)"\u4e3a0\u65e0\u6cd5\u8fdb\u884c\u5206\u914d\u3002", (String)"TerminalWipMatAllocService_13", (String)"macc-aca-business", (Object[])new Object[0]));
        }
        return tipsBuilder;
    }

    private int saveData(DataSet terminalWipMatDataSet, String checktype, StringBuilder logBuilder) {
        logBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a:", (String)"TerminalWipMatAllocService_14", (String)"macc-aca-business", (Object[])new Object[0]));
        Long preCostCenterId = 0L;
        Long preEntryId = 0L;
        int allcoNum = 0;
        DynamicObject adjDiffDy = null;
        BigDecimal diffNum = BigDecimal.ZERO;
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>(10);
        String calFileName = TerminalWipMatEnum.CHECKTYPE_QTY.getValue().equals(checktype) ? "qty" : "amount";
        StringBuilder entryIdBuilder = new StringBuilder("update  t_aca_wipmatcheck_entry set fallocstatus ='1'  where fentryid in (");
        HashSet<Long> deleteAllocEntryIdSet = new HashSet<Long>();
        Boolean hasUnAllocData = false;
        while (terminalWipMatDataSet.hasNext()) {
            DynamicObject saveData = BusinessDataServiceHelper.newDynamicObject((String)"aca_terminalwipmatallco");
            Row row = terminalWipMatDataSet.next();
            Long entryid = row.getLong("entryid");
            Long costCenterId = row.getLong("costCenterId");
            Integer precision = row.getInteger("precision");
            BigDecimal calQty = row.getBigDecimal("calQty");
            String allocstatus = row.getString("allocstatus");
            if (CadEmptyUtils.isEmpty((BigDecimal)calQty)) {
                this.logger.error("\u5b58\u5728\u5206\u914d\u4e3a0 \u7684\u6570\u636e \u8bf7\u68c0\u67e5\u3002\u53ef\u80fd\u662f\u5f15\u5165\u7684\u6570\u636e\u5df2\u7ecf\u6709\u5b8c\u5de5\u8bb0\u5f55\u5bfc\u81f4\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u88ab\u5254\u9664");
                continue;
            }
            if (precision == null) {
                precision = 10;
            }
            calQty = calQty.setScale((int)precision, RoundingMode.HALF_UP);
            saveDataList.add(saveData);
            saveData.set("calqty", (Object)calQty);
            if (Long.compare(preCostCenterId, costCenterId) != 0) {
                logBuilder.append(row.getString("billno")).append(',');
                ++allcoNum;
                preCostCenterId = costCenterId;
            }
            if (Long.compare(preEntryId, entryid) != 0) {
                preEntryId = entryid;
                this.adjDiff(adjDiffDy, diffNum);
                adjDiffDy = saveData;
                diffNum = row.getBigDecimal(calFileName);
            } else {
                if (adjDiffDy == null) {
                    this.logger.error("\u51fa\u73b0\u5f02\u5e38adjDiffDy \u7b49\u4e8enull");
                    continue;
                }
                BigDecimal preCalQty = adjDiffDy.getBigDecimal("calQty");
                DynamicObject dynamicObject = adjDiffDy = preCalQty.compareTo(calQty) > 0 ? adjDiffDy : saveData;
            }
            if (TerminalWipMatEnum.ALLOCSTATUS_ALLOC.getValue().equals(allocstatus)) {
                deleteAllocEntryIdSet.add(entryid);
            } else {
                hasUnAllocData = true;
                entryIdBuilder.append(row.getLong("entryid")).append(',');
            }
            diffNum = diffNum.subtract(calQty);
            saveData.set("costcenter", (Object)costCenterId);
            this.setSavDataValue(saveData, row);
            saveData.set("checktype", (Object)checktype);
        }
        this.adjDiff(adjDiffDy, diffNum);
        try (TXHandle handle = TX.requiresNew();){
            try {
                if (saveDataList.size() > 0) {
                    if (deleteAllocEntryIdSet.size() > 0) {
                        DeleteServiceHelper.delete((String)"aca_terminalwipmatallco", (QFilter[])new QFilter[]{new QFilter("entryid", "in", deleteAllocEntryIdSet)});
                    }
                    SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
                    if (hasUnAllocData.booleanValue()) {
                        entryIdBuilder.setLength(entryIdBuilder.length() - 1);
                        entryIdBuilder.append(')');
                        String sql = entryIdBuilder.toString();
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
                    }
                }
            }
            catch (Exception e) {
                handle.markRollback();
                this.logger.error("{}\u5f15\u5165\u5931\u8d25 {}", (Object)alGoKey, (Object)e);
                throw e;
            }
        }
        return allcoNum;
    }

    private DataSet calDataSet(DataSet terminalWipMatDataSet, DataSet costObjectInput, String checktype) {
        costObjectInput = costObjectInput.groupBy(new String[]{"costCenterId", "costObjectId"}).sum("qty").finish().filter("qty !=0");
        DataSet sumQtyCostObjectInput = costObjectInput.copy().groupBy(new String[]{"costCenterId"}).sum("qty").finish().filter("qty!=0");
        costObjectInput = costObjectInput.leftJoin(sumQtyCostObjectInput).on("costCenterId", "costCenterId").select(costObjectInput.getRowMeta().getFieldNames(), new String[]{"qty as allocSumQty"}).finish();
        terminalWipMatDataSet = terminalWipMatDataSet.leftJoin(costObjectInput).on("costCenterId", "costCenterId").select(terminalWipMatDataSet.getRowMeta().getFieldNames(), new String[]{"costObjectId as allocCostObjectId", "qty as allocQty", "allocSumQty"}).finish();
        StringBuilder sqlBuilder = new StringBuilder();
        for (String fieldName : terminalWipMatDataSet.getRowMeta().getFieldNames()) {
            sqlBuilder.append(fieldName).append(',');
        }
        String calFileName = TerminalWipMatEnum.CHECKTYPE_QTY.getValue().equals(checktype) ? "qty" : "amount";
        sqlBuilder.append("allocQty/allocSumQty * ").append(calFileName).append(" as calQty");
        terminalWipMatDataSet = terminalWipMatDataSet.select(sqlBuilder.toString()).orderBy(new String[]{"costCenterId", "entryid"});
        return terminalWipMatDataSet;
    }

    private DataSet getWipCostCheckUserDataSet(Long orgId, Long costaccountId, Long costCenterId, DynamicObject currPeriodAndDate) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)costCenterId)) {
            orgQf.and(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)currPeriodAndDate.getLong("currentperiod"));
        return QueryServiceHelper.queryDataSet((String)alGoKey, (String)"aca_wipcostchecksave", (String)"costcenter as costCenterId,costobject as costObjectId ,checknum", (QFilter[])new QFilter[]{orgQf, costAccountQf, periodQf}, null);
    }

    private Set<Long> getCostCentersByOrg(long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("orgduty", "=", (Object)4L));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (costCenters.isEmpty()) {
            return Collections.emptySet();
        }
        return costCenters.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
    }

    private void setSavDataValue(DynamicObject saveData, Row row) {
        saveData.set("entryid", (Object)row.getLong("entryid"));
        saveData.set("srcbillnumber", row.get("billno"));
        saveData.set("org", (Object)row.getLong("org"));
        saveData.set("costaccount", (Object)row.getLong("costaccount"));
        saveData.set("period", (Object)row.getLong("period"));
        saveData.set("srcbillrow", row.get("seq"));
        saveData.set("material", (Object)row.getLong("matId"));
        saveData.set("matversion", (Object)row.getLong("matVerId"));
        saveData.set("auxpty", (Object)row.getLong("matAuxId"));
        saveData.set("costobject", (Object)row.getLong("allocCostObjectId"));
        saveData.set("source", row.get("source"));
        saveData.set("qty", row.get("qty"));
        saveData.set("amount", row.get("amount"));
        saveData.set("unit", (Object)row.getLong("unit"));
        saveData.set("currency", (Object)row.getLong("currency"));
        saveData.set("modifytime", (Object)new Date());
        saveData.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    private void adjDiff(DynamicObject adjDiffDy, BigDecimal diffNum) {
        if (adjDiffDy != null && diffNum.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal qtyAddDiff = adjDiffDy.getBigDecimal("calQty").add(diffNum);
            adjDiffDy.set("calqty", (Object)qtyAddDiff);
        }
    }

    private DataSet getCostObjectInput(Long orgId, Long costaccountId, Long costcenterId, DynamicObject currPeriodAndDate) {
        DataSet planDatSet = this.buildPlanDatSet(orgId, costcenterId, currPeriodAndDate);
        DataSet preCalcResultDataSet = this.buildPreCalcResultDataSet(orgId, costaccountId, costcenterId, currPeriodAndDate);
        DataSet adjustCalcResultDataSet = this.buildAdjustCalcResultDataSet(orgId, costaccountId, costcenterId, currPeriodAndDate);
        String[] fieldNames = planDatSet.getRowMeta().getFieldNames();
        String sql = "case when costObjectId is null then costObjectIdr else costObjectId end costObjectId , case when costCenterId is null then costCenterIdr else costCenterId end costCenterId,case when qty is null then qtyr when qtyr is null then qty else qty+qtyr end qty";
        DataSet costObjectInputDateSet = planDatSet.fullJoin(preCalcResultDataSet).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").select(fieldNames, rightFieldNames).finish().select(sql).fullJoin(adjustCalcResultDataSet).on("costCenterId", "costCenterId").on("costObjectId", "costObjectId").select(fieldNames, rightFieldNames).finish().select(sql);
        return costObjectInputDateSet;
    }

    private DataSet buildPlanDatSet(Long orgId, Long costcenterId, DynamicObject currPeriodAndDate) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)currPeriodAndDate.getDate("begindate"));
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)currPeriodAndDate.getDate("enddate"));
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter accountorg = new QFilter("accountorg", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)costcenterId)) {
            accountorg.and("costcenter", "=", (Object)costcenterId);
        }
        accountorg.and("costobject.producttype", "=", (Object)"C");
        DataSet ds = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"cad_plannedoutputbill", (String)"costcenter  as costCenterId, costobject as costObjectId,qty", (QFilter[])new QFilter[]{accountorg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum}, null);
        return ds;
    }

    public DataSet buildPreCalcResultDataSet(Long orgId, Long costaccountId, Long costcenterId, DynamicObject currPeriodAndDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        if (!CadEmptyUtils.isEmpty((Long)costcenterId)) {
            filter.and("costcenter", "=", (Object)costcenterId);
        }
        filter.and("period", "=", (Object)PeriodHelper.getPrePeriodId((Object)currPeriodAndDate.getLong("currentperiod")));
        filter.and("entryentity.type", "=", (Object)"finalResult");
        filter.and("costobject.producttype", "=", (Object)"C");
        String selectFields = "costcenter  as costCenterId, costobject as costObjectId,entryentity.pdendqty + entryentity.endadjqty as qty";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        return resultDs;
    }

    public DataSet buildAdjustCalcResultDataSet(Long orgId, Long costaccountId, Long costcenterId, DynamicObject currPeriodAndDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)costcenterId)) {
            filter.and("costcenter", "=", (Object)costcenterId);
        }
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)currPeriodAndDate.getLong("currentperiod"));
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.id", ">", (Object)0L);
        filter.and("costobject.producttype", "=", (Object)"C");
        filter.and("adjusttype", "=", (Object)"START");
        String selectFields = "costcenter as costCenterId, costobject as costObjectId,entryentity.subentryentity.submatadjqty as qty";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"aca_wipadjustbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        return resultDataSet;
    }

    private Set<Long> getFactnedCostObjectSet(Long orgId, Long costcenterId, DynamicObject currPeriodAndDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)costcenterId)) {
            filter.and("costcenter", "=", (Object)costcenterId);
        }
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)currPeriodAndDate.getDate("begindate"));
        filter.and("bookdate", "<=", (Object)currPeriodAndDate.getDate("enddate"));
        filter.and("billstatus", "=", (Object)"C");
        DataSet rows = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"cad_factnedoutputbill", (String)"entryentity.costobject as costobject", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> costObjectIdSet = new HashSet<Long>();
        while (rows.hasNext()) {
            costObjectIdSet.add(rows.next().getLong("costobject"));
        }
        return costObjectIdSet;
    }

    private DataSet getFactnedCostObject(Long orgId, Long costcenterId, DynamicObject currPeriodAndDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)costcenterId)) {
            filter.and("costcenter", "=", (Object)costcenterId);
        }
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)currPeriodAndDate.getDate("begindate"));
        filter.and("bookdate", "<=", (Object)currPeriodAndDate.getDate("enddate"));
        filter.and("billstatus", "=", (Object)"C");
        DataSet rows = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"cad_factnedoutputbill", (String)"entryentity.costobject as removecostobject", (QFilter[])new QFilter[]{filter}, null);
        return rows;
    }

    private DataSet getEquivalentDataSet(Long orgId, Long costaccountId, Long currentperiod, Set<Long> calcCurPeriodCostobjectRange) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)currentperiod);
        filter.and("entryentity.costobject", "in", calcCurPeriodCostobjectRange);
        String selectFields = "entryentity.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity.totalvalen as totalvalen";
        return QueryServiceHelper.queryDataSet((String)alGoKey, (String)"aca_equivalent", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private DynamicObject getOrgCheckSetting(Long orgId) {
        return BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype,checkcal", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
    }

    private String getSelectFileName() {
        return "id,billno,org,costcenter as costCenterId,costaccount,currency,currency.amtprecision as amtprecision,period,billstatus,entryentity.id as entryid,entryentity.seq as seq,entryentity.allocstatus as allocstatus,entryentity.material as matId,entryentity.matversion as matVerId,entryentity.auxpty as matAuxId,entryentity.unit as unit,entryentity.unit.precision as precision,entryentity.qty as qty,entryentity.amount as amount,entryentity.costobject as costObjectId,entryentity.source as source";
    }
}

