/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.wipcostcheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.PeriodHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipCostCheckService {
    private static final Log logger = LogFactory.getLog(WipCostCheckService.class);
    private static final String[] valueArr = new String[]{"0", "0", "0", "0"};

    public DataSet loadDataByCondition(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId)) {
            logger.info("WipCostCheckService \u4f20\u5165\u53c2\u6570\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a");
            return null;
        }
        if (sysCtrlPeriod == null) {
            logger.info("WipCostCheckService \u672a\u627e\u5230\u5f53\u524d\u671f\u95f4");
            return null;
        }
        Date begindate = sysCtrlPeriod.getDate("begindate");
        Date enddate = sysCtrlPeriod.getDate("enddate");
        if (begindate == null || enddate == null) {
            logger.info("WipCostCheckService \u5f53\u524d\u671f\u95f4\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u672a\u7ef4\u62a4");
            return null;
        }
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!orgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            manuorgfId = 0L;
            logger.error("\u6570\u636e\u9519\u8bef\uff0c{}\u672a\u5f00\u542f\u591a\u5de5\u5382\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (Object)orgId);
        }
        DataSet calcResult = this.getCalcResult(orgId, costaccountId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startchangenum", "endproductchange", "currentinput", "currentfinish"});
        DataSet wipAdjustBill = this.getWipAdjustBill(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory);
        DataSet startDataSet = wipAdjustBill.filter("adjustType = 'START'").select("manuorg ,costcenter,costobject,producttype,adjustqty as startchangenum,material,auxpty").addFields(valueArr, new String[]{"startnum", "endproductchange", "currentinput", "currentfinish"});
        DataSet endDataSet = wipAdjustBill.filter("adjustType = 'END'").select("manuorg ,costcenter,costobject,producttype,adjustqty as endproductchange,material,auxpty").addFields(valueArr, new String[]{"startnum", "startchangenum", "currentinput", "currentfinish"});
        DataSet plannedOutPutBill = this.getPlannedOutPutBill(orgId, manuorgfId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentfinish"});
        DataSet factnedoutputbill = this.getFactnedOutputBill(orgId, manuorgfId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentinput"});
        String[] fieldNames = calcResult.getRowMeta().getFieldNames();
        return calcResult.union(startDataSet.select(fieldNames)).union(endDataSet.select(fieldNames)).union(plannedOutPutBill.select(fieldNames)).union(factnedoutputbill.select(fieldNames)).groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("startnum").sum("startchangenum").sum("endproductchange").sum("currentinput").sum("currentfinish").finish().filter("producttype in('C','A')");
    }

    public DataSet loadWipCostCheckDataSet(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId)) {
            logger.info("WipCostCheckService \u4f20\u5165\u53c2\u6570\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a");
            return null;
        }
        if (sysCtrlPeriod == null) {
            logger.info("WipCostCheckService \u672a\u627e\u5230\u5f53\u524d\u671f\u95f4");
            return null;
        }
        Date begindate = sysCtrlPeriod.getDate("begindate");
        Date enddate = sysCtrlPeriod.getDate("enddate");
        if (begindate == null || enddate == null) {
            logger.info("WipCostCheckService \u5f53\u524d\u671f\u95f4\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u672a\u7ef4\u62a4");
            return null;
        }
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!orgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            manuorgfId = 0L;
            logger.error("\u6570\u636e\u9519\u8bef,{}\u672a\u5f00\u542f\u591a\u5de5\u5382\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (Object)orgId);
        }
        DataSet calcResult = this.getCalcResult(orgId, costaccountId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startchangenum", "endproductchange", "currentinput", "currentfinish"});
        DataSet wipAdjustBill = this.getWipAdjustBill(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory);
        DataSet startDataSet = wipAdjustBill.filter("adjustType = 'START'").select("manuorg ,costcenter,costobject,producttype,adjustqty as startchangenum,material,auxpty").addFields(valueArr, new String[]{"startnum", "endproductchange", "currentinput", "currentfinish"});
        DataSet endDataSet = wipAdjustBill.filter("adjustType = 'END'").select("manuorg ,costcenter,costobject,producttype,adjustqty as endproductchange,material,auxpty").addFields(valueArr, new String[]{"startnum", "startchangenum", "currentinput", "currentfinish"});
        DataSet plannedOutPutBill = this.getPlannedOutPutBill(orgId, manuorgfId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentfinish"});
        DataSet factnedoutputbill = this.getFactnedOutputBill(orgId, manuorgfId, costcenterfId, sysCtrlPeriod, orgEnableMultiFactory).addFields(valueArr, new String[]{"startnum", "startchangenum", "endproductchange", "currentinput"});
        String[] fieldNames = calcResult.getRowMeta().getFieldNames();
        String sql = "manuorg, costcenter, costobject,producttype,startnum,startchangenum,endproductchange,currentinput, currentfinish,startnum+startchangenum+currentinput-currentfinish as endproducting";
        return calcResult.union(startDataSet.select(fieldNames)).union(endDataSet.select(fieldNames)).union(plannedOutPutBill.select(fieldNames)).union(factnedoutputbill.select(fieldNames)).groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("startnum").sum("startchangenum").sum("endproductchange").sum("currentinput").sum("currentfinish").finish().select(sql);
    }

    public Map<String, BigDecimal> loadDataDataSetConvertMap(DataSet fullDataSet) {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        if (fullDataSet == null) {
            return returnMap;
        }
        for (Row row : fullDataSet) {
            BigDecimal startnum = this.getBigDecimalValue(row.getBigDecimal("startnum"));
            BigDecimal endproductchange = this.getBigDecimalValue(row.getBigDecimal("endproductchange"));
            BigDecimal currentinput = this.getBigDecimalValue(row.getBigDecimal("currentinput"));
            BigDecimal currentfinish = this.getBigDecimalValue(row.getBigDecimal("currentfinish"));
            BigDecimal endproducting = startnum.add(endproductchange).add(currentinput).subtract(currentfinish);
            BigDecimal checknum = endproducting.add(endproductchange);
            String key = row.getLong("manuorg") + "@" + row.getLong("costcenter") + "@" + row.getLong("costobject");
            returnMap.put(key, checknum);
        }
        return returnMap;
    }

    private BigDecimal getBigDecimalValue(BigDecimal startnum) {
        return CadEmptyUtils.isEmpty((BigDecimal)startnum) ? BigDecimal.ZERO : startnum;
    }

    private DataSet getCalcResult(Long orgId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod, Boolean orgEnableMultiFactory) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        long currentperiod = sysCtrlPeriod.getLong("currentperiod");
        QFilter periodQf = new QFilter("period", "=", (Object)PeriodHelper.getPrePeriodId((Object)currentperiod));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        QFilter typeQf = new QFilter("entryentity.type", "=", (Object)"finalResult");
        String selectFile = orgEnableMultiFactory != false ? "costobject.manuorg as manuorg ,costcenter,costobject,costobject.producttype as producttype,entryentity.pdendqty + entryentity.endadjqty as startnum, costobject.material as material,costobject.auxpty as auxpty" : "0 as manuorg ,costcenter,costobject,costobject.producttype as producttype,entryentity.pdendqty + entryentity.endadjqty as startnum, costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getCalcResult", (String)"aca_calcresult", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, typeQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("startnum").finish();
        return qtyDataSet;
    }

    private DataSet getFactnedOutputBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod, Boolean orgEnableMultiFactory) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("bookdate", ">=", (Object)sysCtrlPeriod.getDate("begindate")));
        qFilters.add(new QFilter("bookdate", "<=", (Object)sysCtrlPeriod.getDate("enddate")));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("entryentity.costobject.costcenter", "in", costcenterfId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "manuorg,entryentity.costobject.costcenter costcenter,entryentity.costobject as costobject,entryentity.costobject.producttype as producttype,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty" : "0 manuorg,entryentity.costobject.costcenter costcenter,entryentity.costobject as costobject,entryentity.costobject.producttype as producttype,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"", (String)"cad_factnedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("currentfinish").finish();
        return qtyDataSet;
    }

    private DataSet getWipAdjustBill(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod, Boolean orgEnableMultiFactory) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)sysCtrlPeriod.getLong("currentperiod"));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        String selectFile = orgEnableMultiFactory != false ? "manuorg ,costcenter,costobject,costobject.producttype as producttype,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty" : "0 manuorg ,costcenter,costobject,costobject.producttype as producttype,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getWipAdjustBill", (String)"aca_wipadjustbill", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, statusQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "adjustType", "material", "auxpty"}).sum("adjustqty").finish();
        return qtyDataSet;
    }

    private DataSet getPlannedOutPutBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod, Boolean orgEnableMultiFactory) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("accountorg", "=", (Object)orgId));
        qFilters.add(new QFilter("bizdate", ">=", (Object)sysCtrlPeriod.getDate("begindate")));
        qFilters.add(new QFilter("bizdate", "<=", (Object)sysCtrlPeriod.getDate("enddate")));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("costcenter", "in", costcenterfId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "manuorg,costcenter,costobject,costobject.producttype as producttype,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty" : "0 manuorg,costcenter,costobject,costobject.producttype as producttype,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getPlannedOutPutBill", (String)"cad_plannedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "producttype", "material", "auxpty"}).sum("currentinput").finish();
        logger.info("cad_plannedoutputbill\u53d6\u503c\u6761\u4ef6" + qFilters);
        return qtyDataSet;
    }
}

